/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.mvel2.MVEL;
import org.thingsboard.common.util.ExpressionFunctionsUtil;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.cf.configuration.SimpleCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldScriptEngine;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldTbelScriptEngine;

public class CalculatedFieldCtx {
    private CalculatedField calculatedField;
    private CalculatedFieldId cfId;
    private TenantId tenantId;
    private EntityId entityId;
    private CalculatedFieldType cfType;
    private final Map<String, Argument> arguments;
    private final Map<ReferencedEntityKey, Set<String>> mainEntityArguments;
    private final Map<EntityId, Map<ReferencedEntityKey, Set<String>>> linkedEntityArguments;
    private final List<String> argNames;
    private Output output;
    private String expression;
    private boolean useLatestTs;
    private TbelInvokeService tbelInvokeService;
    private CalculatedFieldScriptEngine calculatedFieldScriptEngine;
    private ThreadLocal<Expression> customExpression;
    private boolean initialized;
    private long maxDataPointsPerRollingArg;
    private long maxStateSize;
    private long maxSingleValueArgumentSize;

    public CalculatedFieldCtx(CalculatedField calculatedField, TbelInvokeService tbelInvokeService, ApiLimitService apiLimitService) {
        this.calculatedField = calculatedField;
        this.cfId = calculatedField.getId();
        this.tenantId = calculatedField.getTenantId();
        this.entityId = calculatedField.getEntityId();
        this.cfType = calculatedField.getType();
        CalculatedFieldConfiguration configuration = calculatedField.getConfiguration();
        this.arguments = configuration.getArguments();
        this.mainEntityArguments = new HashMap<ReferencedEntityKey, Set<String>>();
        this.linkedEntityArguments = new HashMap<EntityId, Map<ReferencedEntityKey, Set<String>>>();
        for (Map.Entry<String, Argument> entry : this.arguments.entrySet()) {
            EntityId refId = entry.getValue().getRefEntityId();
            ReferencedEntityKey refKey = entry.getValue().getRefEntityKey();
            if (refId == null || refId.equals(calculatedField.getEntityId())) {
                this.mainEntityArguments.compute(refKey, (key, existingNames) -> CollectionsUtil.addToSet((Set)existingNames, (Object)((String)entry.getKey())));
                continue;
            }
            this.linkedEntityArguments.computeIfAbsent(refId, key -> new HashMap()).compute(refKey, (key, existingNames) -> CollectionsUtil.addToSet((Set)existingNames, (Object)((String)entry.getKey())));
        }
        this.argNames = new ArrayList<String>(this.arguments.keySet());
        this.output = configuration.getOutput();
        this.expression = configuration.getExpression();
        this.useLatestTs = CalculatedFieldType.SIMPLE.equals((Object)calculatedField.getType()) && ((SimpleCalculatedFieldConfiguration)configuration).isUseLatestTs();
        this.tbelInvokeService = tbelInvokeService;
        this.maxDataPointsPerRollingArg = apiLimitService.getLimit(this.tenantId, DefaultTenantProfileConfiguration::getMaxDataPointsPerRollingArg);
        this.maxStateSize = apiLimitService.getLimit(this.tenantId, DefaultTenantProfileConfiguration::getMaxStateSizeInKBytes) * 1024L;
        this.maxSingleValueArgumentSize = apiLimitService.getLimit(this.tenantId, DefaultTenantProfileConfiguration::getMaxSingleValueArgumentSizeInKBytes) * 1024L;
    }

    public void init() {
        if (CalculatedFieldType.SCRIPT.equals((Object)this.cfType)) {
            try {
                this.calculatedFieldScriptEngine = this.initEngine(this.tenantId, this.expression, this.tbelInvokeService);
                this.initialized = true;
            }
            catch (Exception e) {
                this.initialized = false;
                throw new RuntimeException("Failed to init calculated field ctx. Invalid expression syntax.", e);
            }
        } else if (this.isValidExpression(this.expression)) {
            this.customExpression = ThreadLocal.withInitial(() -> new ExpressionBuilder(this.expression).functions(ExpressionFunctionsUtil.userDefinedFunctions).implicitMultiplication(true).variables(this.arguments.keySet()).build());
            this.initialized = true;
        } else {
            this.initialized = false;
            throw new RuntimeException("Failed to init calculated field ctx. Invalid expression syntax.");
        }
    }

    public void stop() {
        if (this.calculatedFieldScriptEngine != null) {
            this.calculatedFieldScriptEngine.destroy();
        }
        if (this.customExpression != null) {
            this.customExpression.remove();
        }
    }

    private CalculatedFieldScriptEngine initEngine(TenantId tenantId, String expression, TbelInvokeService tbelInvokeService) {
        if (tbelInvokeService == null) {
            throw new IllegalArgumentException("TBEL script engine is disabled!");
        }
        ArrayList<String> ctxAndArgNames = new ArrayList<String>(this.argNames.size() + 1);
        ctxAndArgNames.add("ctx");
        ctxAndArgNames.addAll(this.argNames);
        return new CalculatedFieldTbelScriptEngine(tenantId, tbelInvokeService, expression, (String[])ctxAndArgNames.toArray(String[]::new));
    }

    private boolean isValidExpression(String expression) {
        try {
            MVEL.compileExpression((String)expression);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean matches(List<AttributeKvEntry> values, AttributeScope scope) {
        return this.matchesAttributes(this.mainEntityArguments, values, scope);
    }

    public boolean linkMatches(EntityId entityId, List<AttributeKvEntry> values, AttributeScope scope) {
        Map<ReferencedEntityKey, Set<String>> map = this.linkedEntityArguments.get(entityId);
        return map != null && this.matchesAttributes(map, values, scope);
    }

    public boolean matches(List<TsKvEntry> values) {
        return this.matchesTimeSeries(this.mainEntityArguments, values);
    }

    public boolean linkMatches(EntityId entityId, List<TsKvEntry> values) {
        Map<ReferencedEntityKey, Set<String>> map = this.linkedEntityArguments.get(entityId);
        return map != null && this.matchesTimeSeries(map, values);
    }

    private boolean matchesAttributes(Map<ReferencedEntityKey, Set<String>> argMap, List<AttributeKvEntry> values, AttributeScope scope) {
        if (argMap.isEmpty() || values.isEmpty()) {
            return false;
        }
        for (AttributeKvEntry attrKv : values) {
            if (!argMap.containsKey(new ReferencedEntityKey(attrKv.getKey(), ArgumentType.ATTRIBUTE, scope))) continue;
            return true;
        }
        return false;
    }

    private boolean matchesTimeSeries(Map<ReferencedEntityKey, Set<String>> argMap, List<TsKvEntry> values) {
        if (argMap.isEmpty() || values.isEmpty()) {
            return false;
        }
        for (TsKvEntry tsKv : values) {
            ReferencedEntityKey latestKey = new ReferencedEntityKey(tsKv.getKey(), ArgumentType.TS_LATEST, null);
            if (argMap.containsKey(latestKey)) {
                return true;
            }
            ReferencedEntityKey rollingKey = new ReferencedEntityKey(tsKv.getKey(), ArgumentType.TS_ROLLING, null);
            if (!argMap.containsKey(rollingKey)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesKeys(List<String> keys, AttributeScope scope) {
        return this.matchesAttributesKeys(this.mainEntityArguments, keys, scope);
    }

    public boolean matchesKeys(List<String> keys) {
        return this.matchesTimeSeriesKeys(this.mainEntityArguments, keys);
    }

    private boolean matchesAttributesKeys(Map<ReferencedEntityKey, Set<String>> argMap, List<String> keys, AttributeScope scope) {
        if (argMap.isEmpty() || keys.isEmpty()) {
            return false;
        }
        for (String key : keys) {
            ReferencedEntityKey attrKey = new ReferencedEntityKey(key, ArgumentType.ATTRIBUTE, scope);
            if (!argMap.containsKey(attrKey)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesTimeSeriesKeys(Map<ReferencedEntityKey, Set<String>> argMap, List<String> keys) {
        if (argMap.isEmpty() || keys.isEmpty()) {
            return false;
        }
        for (String key : keys) {
            ReferencedEntityKey latestKey = new ReferencedEntityKey(key, ArgumentType.TS_LATEST, null);
            if (argMap.containsKey(latestKey)) {
                return true;
            }
            ReferencedEntityKey rollingKey = new ReferencedEntityKey(key, ArgumentType.TS_ROLLING, null);
            if (!argMap.containsKey(rollingKey)) continue;
            return true;
        }
        return false;
    }

    public boolean linkMatchesAttrKeys(EntityId entityId, List<String> keys, AttributeScope scope) {
        Map<ReferencedEntityKey, Set<String>> map = this.linkedEntityArguments.get(entityId);
        return map != null && this.matchesAttributesKeys(map, keys, scope);
    }

    public boolean linkMatchesTsKeys(EntityId entityId, List<String> keys) {
        Map<ReferencedEntityKey, Set<String>> map = this.linkedEntityArguments.get(entityId);
        return map != null && this.matchesTimeSeriesKeys(map, keys);
    }

    public boolean linkMatches(EntityId entityId, TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        if (!proto.getTsDataList().isEmpty()) {
            List<TsKvEntry> updatedTelemetry = proto.getTsDataList().stream().map(ProtoUtils::fromProto).toList();
            return this.linkMatches(entityId, updatedTelemetry);
        }
        if (!proto.getAttrDataList().isEmpty()) {
            AttributeScope scope = AttributeScope.valueOf((String)proto.getScope().name());
            List<AttributeKvEntry> updatedTelemetry = proto.getAttrDataList().stream().map(ProtoUtils::fromProto).toList();
            return this.linkMatches(entityId, updatedTelemetry, scope);
        }
        if (!proto.getRemovedTsKeysList().isEmpty()) {
            return this.linkMatchesTsKeys(entityId, (List<String>)proto.getRemovedTsKeysList());
        }
        return this.linkMatchesAttrKeys(entityId, (List<String>)proto.getRemovedAttrKeysList(), AttributeScope.valueOf((String)proto.getScope().name()));
    }

    public CalculatedFieldEntityCtxId toCalculatedFieldEntityCtxId() {
        return new CalculatedFieldEntityCtxId(this.tenantId, this.cfId, this.entityId);
    }

    public boolean hasOtherSignificantChanges(CalculatedFieldCtx other) {
        boolean expressionChanged = !this.expression.equals(other.expression);
        boolean outputChanged = !this.output.equals((Object)other.output);
        return expressionChanged || outputChanged;
    }

    public boolean hasStateChanges(CalculatedFieldCtx other) {
        boolean typeChanged = !this.cfType.equals((Object)other.cfType);
        boolean argumentsChanged = !this.arguments.equals(other.arguments);
        return typeChanged || argumentsChanged;
    }

    public String getSizeExceedsLimitMessage() {
        return "Failed to init CF state. State size exceeds limit of " + this.maxStateSize / 1024L + "Kb!";
    }

    @Generated
    public CalculatedField getCalculatedField() {
        return this.calculatedField;
    }

    @Generated
    public CalculatedFieldId getCfId() {
        return this.cfId;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public CalculatedFieldType getCfType() {
        return this.cfType;
    }

    @Generated
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @Generated
    public Map<ReferencedEntityKey, Set<String>> getMainEntityArguments() {
        return this.mainEntityArguments;
    }

    @Generated
    public Map<EntityId, Map<ReferencedEntityKey, Set<String>>> getLinkedEntityArguments() {
        return this.linkedEntityArguments;
    }

    @Generated
    public List<String> getArgNames() {
        return this.argNames;
    }

    @Generated
    public Output getOutput() {
        return this.output;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public boolean isUseLatestTs() {
        return this.useLatestTs;
    }

    @Generated
    public TbelInvokeService getTbelInvokeService() {
        return this.tbelInvokeService;
    }

    @Generated
    public CalculatedFieldScriptEngine getCalculatedFieldScriptEngine() {
        return this.calculatedFieldScriptEngine;
    }

    @Generated
    public ThreadLocal<Expression> getCustomExpression() {
        return this.customExpression;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public long getMaxDataPointsPerRollingArg() {
        return this.maxDataPointsPerRollingArg;
    }

    @Generated
    public long getMaxStateSize() {
        return this.maxStateSize;
    }

    @Generated
    public long getMaxSingleValueArgumentSize() {
        return this.maxSingleValueArgumentSize;
    }

    @Generated
    public void setCalculatedField(CalculatedField calculatedField) {
        this.calculatedField = calculatedField;
    }

    @Generated
    public void setCfId(CalculatedFieldId cfId) {
        this.cfId = cfId;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setCfType(CalculatedFieldType cfType) {
        this.cfType = cfType;
    }

    @Generated
    public void setOutput(Output output) {
        this.output = output;
    }

    @Generated
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Generated
    public void setUseLatestTs(boolean useLatestTs) {
        this.useLatestTs = useLatestTs;
    }

    @Generated
    public void setTbelInvokeService(TbelInvokeService tbelInvokeService) {
        this.tbelInvokeService = tbelInvokeService;
    }

    @Generated
    public void setCalculatedFieldScriptEngine(CalculatedFieldScriptEngine calculatedFieldScriptEngine) {
        this.calculatedFieldScriptEngine = calculatedFieldScriptEngine;
    }

    @Generated
    public void setCustomExpression(ThreadLocal<Expression> customExpression) {
        this.customExpression = customExpression;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Generated
    public void setMaxDataPointsPerRollingArg(long maxDataPointsPerRollingArg) {
        this.maxDataPointsPerRollingArg = maxDataPointsPerRollingArg;
    }

    @Generated
    public void setMaxStateSize(long maxStateSize) {
        this.maxStateSize = maxStateSize;
    }

    @Generated
    public void setMaxSingleValueArgumentSize(long maxSingleValueArgumentSize) {
        this.maxSingleValueArgumentSize = maxSingleValueArgumentSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculatedFieldCtx)) {
            return false;
        }
        CalculatedFieldCtx other = (CalculatedFieldCtx)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseLatestTs() != other.isUseLatestTs()) {
            return false;
        }
        if (this.isInitialized() != other.isInitialized()) {
            return false;
        }
        if (this.getMaxDataPointsPerRollingArg() != other.getMaxDataPointsPerRollingArg()) {
            return false;
        }
        if (this.getMaxStateSize() != other.getMaxStateSize()) {
            return false;
        }
        if (this.getMaxSingleValueArgumentSize() != other.getMaxSingleValueArgumentSize()) {
            return false;
        }
        CalculatedField this$calculatedField = this.getCalculatedField();
        CalculatedField other$calculatedField = other.getCalculatedField();
        if (this$calculatedField == null ? other$calculatedField != null : !this$calculatedField.equals(other$calculatedField)) {
            return false;
        }
        CalculatedFieldId this$cfId = this.getCfId();
        CalculatedFieldId other$cfId = other.getCfId();
        if (this$cfId == null ? other$cfId != null : !this$cfId.equals(other$cfId)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        CalculatedFieldType this$cfType = this.getCfType();
        CalculatedFieldType other$cfType = other.getCfType();
        if (this$cfType == null ? other$cfType != null : !this$cfType.equals(other$cfType)) {
            return false;
        }
        Map<String, Argument> this$arguments = this.getArguments();
        Map<String, Argument> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Map<ReferencedEntityKey, Set<String>> this$mainEntityArguments = this.getMainEntityArguments();
        Map<ReferencedEntityKey, Set<String>> other$mainEntityArguments = other.getMainEntityArguments();
        if (this$mainEntityArguments == null ? other$mainEntityArguments != null : !((Object)this$mainEntityArguments).equals(other$mainEntityArguments)) {
            return false;
        }
        Map<EntityId, Map<ReferencedEntityKey, Set<String>>> this$linkedEntityArguments = this.getLinkedEntityArguments();
        Map<EntityId, Map<ReferencedEntityKey, Set<String>>> other$linkedEntityArguments = other.getLinkedEntityArguments();
        if (this$linkedEntityArguments == null ? other$linkedEntityArguments != null : !((Object)this$linkedEntityArguments).equals(other$linkedEntityArguments)) {
            return false;
        }
        List<String> this$argNames = this.getArgNames();
        List<String> other$argNames = other.getArgNames();
        if (this$argNames == null ? other$argNames != null : !((Object)this$argNames).equals(other$argNames)) {
            return false;
        }
        Output this$output = this.getOutput();
        Output other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        TbelInvokeService this$tbelInvokeService = this.getTbelInvokeService();
        TbelInvokeService other$tbelInvokeService = other.getTbelInvokeService();
        if (this$tbelInvokeService == null ? other$tbelInvokeService != null : !this$tbelInvokeService.equals(other$tbelInvokeService)) {
            return false;
        }
        CalculatedFieldScriptEngine this$calculatedFieldScriptEngine = this.getCalculatedFieldScriptEngine();
        CalculatedFieldScriptEngine other$calculatedFieldScriptEngine = other.getCalculatedFieldScriptEngine();
        if (this$calculatedFieldScriptEngine == null ? other$calculatedFieldScriptEngine != null : !this$calculatedFieldScriptEngine.equals(other$calculatedFieldScriptEngine)) {
            return false;
        }
        ThreadLocal<Expression> this$customExpression = this.getCustomExpression();
        ThreadLocal<Expression> other$customExpression = other.getCustomExpression();
        return !(this$customExpression == null ? other$customExpression != null : !this$customExpression.equals(other$customExpression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculatedFieldCtx;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseLatestTs() ? 79 : 97);
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        long $maxDataPointsPerRollingArg = this.getMaxDataPointsPerRollingArg();
        result = result * 59 + (int)($maxDataPointsPerRollingArg >>> 32 ^ $maxDataPointsPerRollingArg);
        long $maxStateSize = this.getMaxStateSize();
        result = result * 59 + (int)($maxStateSize >>> 32 ^ $maxStateSize);
        long $maxSingleValueArgumentSize = this.getMaxSingleValueArgumentSize();
        result = result * 59 + (int)($maxSingleValueArgumentSize >>> 32 ^ $maxSingleValueArgumentSize);
        CalculatedField $calculatedField = this.getCalculatedField();
        result = result * 59 + ($calculatedField == null ? 43 : $calculatedField.hashCode());
        CalculatedFieldId $cfId = this.getCfId();
        result = result * 59 + ($cfId == null ? 43 : $cfId.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        CalculatedFieldType $cfType = this.getCfType();
        result = result * 59 + ($cfType == null ? 43 : $cfType.hashCode());
        Map<String, Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Map<ReferencedEntityKey, Set<String>> $mainEntityArguments = this.getMainEntityArguments();
        result = result * 59 + ($mainEntityArguments == null ? 43 : ((Object)$mainEntityArguments).hashCode());
        Map<EntityId, Map<ReferencedEntityKey, Set<String>>> $linkedEntityArguments = this.getLinkedEntityArguments();
        result = result * 59 + ($linkedEntityArguments == null ? 43 : ((Object)$linkedEntityArguments).hashCode());
        List<String> $argNames = this.getArgNames();
        result = result * 59 + ($argNames == null ? 43 : ((Object)$argNames).hashCode());
        Output $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        TbelInvokeService $tbelInvokeService = this.getTbelInvokeService();
        result = result * 59 + ($tbelInvokeService == null ? 43 : $tbelInvokeService.hashCode());
        CalculatedFieldScriptEngine $calculatedFieldScriptEngine = this.getCalculatedFieldScriptEngine();
        result = result * 59 + ($calculatedFieldScriptEngine == null ? 43 : $calculatedFieldScriptEngine.hashCode());
        ThreadLocal<Expression> $customExpression = this.getCustomExpression();
        result = result * 59 + ($customExpression == null ? 43 : $customExpression.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculatedFieldCtx(calculatedField=" + String.valueOf(this.getCalculatedField()) + ", cfId=" + String.valueOf(this.getCfId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", cfType=" + String.valueOf(this.getCfType()) + ", arguments=" + String.valueOf(this.getArguments()) + ", mainEntityArguments=" + String.valueOf(this.getMainEntityArguments()) + ", linkedEntityArguments=" + String.valueOf(this.getLinkedEntityArguments()) + ", argNames=" + String.valueOf(this.getArgNames()) + ", output=" + String.valueOf(this.getOutput()) + ", expression=" + this.getExpression() + ", useLatestTs=" + this.isUseLatestTs() + ", tbelInvokeService=" + String.valueOf(this.getTbelInvokeService()) + ", calculatedFieldScriptEngine=" + String.valueOf(this.getCalculatedFieldScriptEngine()) + ", customExpression=" + String.valueOf(this.getCustomExpression()) + ", initialized=" + this.isInitialized() + ", maxDataPointsPerRollingArg=" + this.getMaxDataPointsPerRollingArg() + ", maxStateSize=" + this.getMaxStateSize() + ", maxSingleValueArgumentSize=" + this.getMaxSingleValueArgumentSize() + ")";
    }
}

