/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;
import org.thingsboard.server.utils.CalculatedFieldUtils;

public abstract class BaseCalculatedFieldState
implements CalculatedFieldState {
    static final long DEFAULT_LAST_UPDATE_TS = -1L;
    protected List<String> requiredArguments;
    protected Map<String, ArgumentEntry> arguments;
    protected boolean sizeExceedsLimit;

    public BaseCalculatedFieldState(List<String> requiredArguments) {
        this.requiredArguments = requiredArguments;
        this.arguments = new HashMap<String, ArgumentEntry>();
    }

    public BaseCalculatedFieldState() {
        this(new ArrayList<String>(), new HashMap<String, ArgumentEntry>(), false);
    }

    @Override
    public boolean updateState(CalculatedFieldCtx ctx, Map<String, ArgumentEntry> argumentValues) {
        if (this.arguments == null) {
            this.arguments = new HashMap<String, ArgumentEntry>();
        }
        boolean stateUpdated = false;
        for (Map.Entry<String, ArgumentEntry> entry : argumentValues.entrySet()) {
            boolean entryUpdated;
            String key = entry.getKey();
            ArgumentEntry newEntry = entry.getValue();
            this.checkArgumentSize(key, newEntry, ctx);
            ArgumentEntry existingEntry = this.arguments.get(key);
            if (existingEntry == null || newEntry.isForceResetPrevious()) {
                this.validateNewEntry(newEntry);
                this.arguments.put(key, newEntry);
                entryUpdated = true;
            } else {
                entryUpdated = existingEntry.updateEntry(newEntry);
            }
            if (!entryUpdated) continue;
            stateUpdated = true;
        }
        return stateUpdated;
    }

    @Override
    public boolean isReady() {
        return this.arguments.keySet().containsAll(this.requiredArguments) && this.arguments.values().stream().noneMatch(ArgumentEntry::isEmpty);
    }

    @Override
    public void checkStateSize(CalculatedFieldEntityCtxId ctxId, long maxStateSize) {
        if (!this.sizeExceedsLimit && maxStateSize > 0L && (long)CalculatedFieldUtils.toProto(ctxId, this).getSerializedSize() > maxStateSize) {
            this.arguments.clear();
            this.sizeExceedsLimit = true;
        }
    }

    @Override
    public void checkArgumentSize(String name, ArgumentEntry entry, CalculatedFieldCtx ctx) {
        if (entry instanceof TsRollingArgumentEntry) {
            return;
        }
        if (entry instanceof SingleValueArgumentEntry) {
            SingleValueArgumentEntry singleValueArgumentEntry = (SingleValueArgumentEntry)entry;
            if (ctx.getMaxSingleValueArgumentSize() > 0L && (long)CalculatedFieldUtils.toSingleValueArgumentProto(name, singleValueArgumentEntry).getSerializedSize() > ctx.getMaxSingleValueArgumentSize()) {
                throw new IllegalArgumentException("Single value size exceeds the maximum allowed limit. The argument will not be used for calculation.");
            }
        }
    }

    protected abstract void validateNewEntry(ArgumentEntry var1);

    @Override
    public long getLatestTimestamp() {
        long latestTs = -1L;
        boolean allDefault = this.arguments.values().stream().allMatch(entry -> {
            if (entry instanceof SingleValueArgumentEntry) {
                SingleValueArgumentEntry single = (SingleValueArgumentEntry)entry;
                return single.isDefaultValue();
            }
            return false;
        });
        for (ArgumentEntry entry2 : this.arguments.values()) {
            if (entry2 instanceof SingleValueArgumentEntry) {
                SingleValueArgumentEntry single = (SingleValueArgumentEntry)entry2;
                if (allDefault) {
                    latestTs = Math.max(latestTs, single.getTs());
                    continue;
                }
                if (single.isDefaultValue()) continue;
                latestTs = Math.max(latestTs, single.getTs());
                continue;
            }
            if (!(entry2 instanceof TsRollingArgumentEntry)) continue;
            TsRollingArgumentEntry rolling = (TsRollingArgumentEntry)entry2;
            latestTs = Math.max(latestTs, rolling.getLatestTs());
        }
        return latestTs;
    }

    @Generated
    public List<String> getRequiredArguments() {
        return this.requiredArguments;
    }

    @Override
    @Generated
    public Map<String, ArgumentEntry> getArguments() {
        return this.arguments;
    }

    @Override
    @Generated
    public boolean isSizeExceedsLimit() {
        return this.sizeExceedsLimit;
    }

    @Override
    @Generated
    public void setRequiredArguments(List<String> requiredArguments) {
        this.requiredArguments = requiredArguments;
    }

    @Generated
    public void setArguments(Map<String, ArgumentEntry> arguments) {
        this.arguments = arguments;
    }

    @Generated
    public void setSizeExceedsLimit(boolean sizeExceedsLimit) {
        this.sizeExceedsLimit = sizeExceedsLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCalculatedFieldState)) {
            return false;
        }
        BaseCalculatedFieldState other = (BaseCalculatedFieldState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSizeExceedsLimit() != other.isSizeExceedsLimit()) {
            return false;
        }
        List<String> this$requiredArguments = this.getRequiredArguments();
        List<String> other$requiredArguments = other.getRequiredArguments();
        if (this$requiredArguments == null ? other$requiredArguments != null : !((Object)this$requiredArguments).equals(other$requiredArguments)) {
            return false;
        }
        Map<String, ArgumentEntry> this$arguments = this.getArguments();
        Map<String, ArgumentEntry> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseCalculatedFieldState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSizeExceedsLimit() ? 79 : 97);
        List<String> $requiredArguments = this.getRequiredArguments();
        result = result * 59 + ($requiredArguments == null ? 43 : ((Object)$requiredArguments).hashCode());
        Map<String, ArgumentEntry> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseCalculatedFieldState(requiredArguments=" + String.valueOf(this.getRequiredArguments()) + ", arguments=" + String.valueOf(this.getArguments()) + ", sizeExceedsLimit=" + this.isSizeExceedsLimit() + ")";
    }

    @ConstructorProperties(value={"requiredArguments", "arguments", "sizeExceedsLimit"})
    @Generated
    public BaseCalculatedFieldState(List<String> requiredArguments, Map<String, ArgumentEntry> arguments, boolean sizeExceedsLimit) {
        this.requiredArguments = requiredArguments;
        this.arguments = arguments;
        this.sizeExceedsLimit = sizeExceedsLimit;
    }
}

