/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldLink;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;

@Service
public class DefaultCalculatedFieldCache
implements CalculatedFieldCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCalculatedFieldCache.class);
    private final ConcurrentReferenceHashMap<CalculatedFieldId, Lock> calculatedFieldFetchLocks = new ConcurrentReferenceHashMap();
    private final CalculatedFieldService calculatedFieldService;
    private final TbelInvokeService tbelInvokeService;
    private final ApiLimitService apiLimitService;
    private final ConcurrentMap<CalculatedFieldId, CalculatedField> calculatedFields = new ConcurrentHashMap<CalculatedFieldId, CalculatedField>();
    private final ConcurrentMap<EntityId, List<CalculatedField>> entityIdCalculatedFields = new ConcurrentHashMap<EntityId, List<CalculatedField>>();
    private final ConcurrentMap<CalculatedFieldId, List<CalculatedFieldLink>> calculatedFieldLinks = new ConcurrentHashMap<CalculatedFieldId, List<CalculatedFieldLink>>();
    private final ConcurrentMap<EntityId, List<CalculatedFieldLink>> entityIdCalculatedFieldLinks = new ConcurrentHashMap<EntityId, List<CalculatedFieldLink>>();
    private final ConcurrentMap<CalculatedFieldId, CalculatedFieldCtx> calculatedFieldsCtx = new ConcurrentHashMap<CalculatedFieldId, CalculatedFieldCtx>();
    @Value(value="${queue.calculated_fields.init_fetch_pack_size:50000}")
    private int initFetchPackSize;

    @AfterStartUp(order=10)
    public void init() {
        PageDataIterable cfs = new PageDataIterable(arg_0 -> ((CalculatedFieldService)this.calculatedFieldService).findAllCalculatedFields(arg_0), this.initFetchPackSize);
        cfs.forEach(cf -> {
            if (cf != null) {
                this.calculatedFields.putIfAbsent(cf.getId(), (CalculatedField)cf);
            }
        });
        this.calculatedFields.values().forEach(cf -> this.entityIdCalculatedFields.computeIfAbsent(cf.getEntityId(), id -> new CopyOnWriteArrayList()).add(cf));
        PageDataIterable cfls = new PageDataIterable(arg_0 -> ((CalculatedFieldService)this.calculatedFieldService).findAllCalculatedFieldLinks(arg_0), this.initFetchPackSize);
        cfls.forEach(link -> this.calculatedFieldLinks.computeIfAbsent(link.getCalculatedFieldId(), id -> new CopyOnWriteArrayList()).add(link));
        this.calculatedFieldLinks.values().stream().flatMap(Collection::stream).forEach(link -> this.entityIdCalculatedFieldLinks.computeIfAbsent(link.getEntityId(), id -> new CopyOnWriteArrayList()).add(link));
    }

    @Override
    public CalculatedField getCalculatedField(CalculatedFieldId calculatedFieldId) {
        return (CalculatedField)this.calculatedFields.get(calculatedFieldId);
    }

    @Override
    public List<CalculatedField> getCalculatedFieldsByEntityId(EntityId entityId) {
        return this.entityIdCalculatedFields.getOrDefault(entityId, Collections.emptyList());
    }

    @Override
    public List<CalculatedFieldLink> getCalculatedFieldLinksByEntityId(EntityId entityId) {
        return this.entityIdCalculatedFieldLinks.getOrDefault(entityId, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalculatedFieldCtx getCalculatedFieldCtx(CalculatedFieldId calculatedFieldId) {
        CalculatedFieldCtx ctx = (CalculatedFieldCtx)this.calculatedFieldsCtx.get(calculatedFieldId);
        if (ctx == null) {
            Lock lock = this.getFetchLock(calculatedFieldId);
            lock.lock();
            try {
                CalculatedField calculatedField;
                ctx = (CalculatedFieldCtx)this.calculatedFieldsCtx.get(calculatedFieldId);
                if (ctx == null && (calculatedField = this.getCalculatedField(calculatedFieldId)) != null) {
                    ctx = new CalculatedFieldCtx(calculatedField, this.tbelInvokeService, this.apiLimitService);
                    this.calculatedFieldsCtx.put(calculatedFieldId, ctx);
                    log.debug("[{}] Put calculated field ctx into cache: {}", (Object)calculatedFieldId, (Object)ctx);
                }
            }
            finally {
                lock.unlock();
            }
        }
        log.trace("[{}] Found calculated field ctx in cache: {}", (Object)calculatedFieldId, (Object)ctx);
        return ctx;
    }

    @Override
    public List<CalculatedFieldCtx> getCalculatedFieldCtxsByEntityId(EntityId entityId) {
        if (entityId == null) {
            return Collections.emptyList();
        }
        return this.getCalculatedFieldsByEntityId(entityId).stream().map(cf -> this.getCalculatedFieldCtx(cf.getId())).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCalculatedField(TenantId tenantId, CalculatedFieldId calculatedFieldId) {
        Lock lock = this.getFetchLock(calculatedFieldId);
        lock.lock();
        try {
            CalculatedField calculatedField = this.calculatedFieldService.findById(tenantId, calculatedFieldId);
            if (calculatedField == null) {
                return;
            }
            EntityId cfEntityId = calculatedField.getEntityId();
            this.calculatedFields.put(calculatedFieldId, calculatedField);
            this.entityIdCalculatedFields.computeIfAbsent(cfEntityId, entityId -> new CopyOnWriteArrayList()).add(calculatedField);
            CalculatedFieldConfiguration configuration = calculatedField.getConfiguration();
            this.calculatedFieldLinks.put(calculatedFieldId, configuration.buildCalculatedFieldLinks(tenantId, cfEntityId, calculatedFieldId));
            configuration.getReferencedEntities().stream().filter(referencedEntityId -> !referencedEntityId.equals(cfEntityId)).forEach(referencedEntityId -> this.entityIdCalculatedFieldLinks.computeIfAbsent((EntityId)referencedEntityId, entityId -> new CopyOnWriteArrayList()).add(configuration.buildCalculatedFieldLink(tenantId, referencedEntityId, calculatedFieldId)));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void updateCalculatedField(TenantId tenantId, CalculatedFieldId calculatedFieldId) {
        this.evict(calculatedFieldId);
        this.addCalculatedField(tenantId, calculatedFieldId);
    }

    @Override
    public void evict(CalculatedFieldId calculatedFieldId) {
        CalculatedField oldCalculatedField = (CalculatedField)this.calculatedFields.remove(calculatedFieldId);
        log.debug("[{}] evict calculated field from cache: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
        this.calculatedFieldLinks.remove(calculatedFieldId);
        log.debug("[{}] evict calculated field from cached calculated fields by entity id: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
        this.entityIdCalculatedFields.forEach((entityId, calculatedFields) -> calculatedFields.removeIf(cf -> cf.getId().equals((Object)calculatedFieldId)));
        log.debug("[{}] evict calculated field links from cache: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
        this.calculatedFieldsCtx.remove(calculatedFieldId);
        log.debug("[{}] evict calculated field ctx from cache: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
        this.entityIdCalculatedFieldLinks.forEach((entityId, calculatedFieldLinks) -> calculatedFieldLinks.removeIf(link -> link.getCalculatedFieldId().equals((Object)calculatedFieldId)));
        log.debug("[{}] evict calculated field links from cached links by entity id: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
    }

    private Lock getFetchLock(CalculatedFieldId id) {
        return (Lock)this.calculatedFieldFetchLocks.computeIfAbsent((Object)id, __ -> new ReentrantLock());
    }

    @ConstructorProperties(value={"calculatedFieldService", "tbelInvokeService", "apiLimitService"})
    @Generated
    public DefaultCalculatedFieldCache(CalculatedFieldService calculatedFieldService, TbelInvokeService tbelInvokeService, ApiLimitService apiLimitService) {
        this.calculatedFieldService = calculatedFieldService;
        this.tbelInvokeService = tbelInvokeService;
        this.apiLimitService = apiLimitService;
    }

    @Generated
    public int getInitFetchPackSize() {
        return this.initFetchPackSize;
    }
}

