/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ai;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.google.common.util.concurrent.FluentFuture;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.service.ai.AiChatModelService;
import org.thingsboard.server.service.ai.AiRequestsExecutor;

@Service
class AiChatModelServiceImpl
implements AiChatModelService {
    private final Langchain4jChatModelConfigurer chatModelConfigurer;
    private final AiRequestsExecutor aiRequestsExecutor;

    public <C extends AiChatModelConfig<C>> FluentFuture<ChatResponse> sendChatRequestAsync(AiChatModelConfig<C> chatModelConfig, ChatRequest chatRequest) {
        ChatModel langChainChatModel = chatModelConfig.configure(this.chatModelConfigurer);
        if (langChainChatModel.provider() == ModelProvider.GITHUB_MODELS) {
            chatRequest = this.prepareGithubChatRequest(chatRequest);
        }
        return this.aiRequestsExecutor.sendChatRequestAsync(langChainChatModel, chatRequest);
    }

    private ChatRequest prepareGithubChatRequest(ChatRequest chatRequest) {
        List messages = chatRequest.messages().stream().map(this::prepareUserMessage).collect(Collectors.toList());
        return ChatRequest.builder().messages(messages).responseFormat(chatRequest.responseFormat()).build();
    }

    private ChatMessage prepareUserMessage(ChatMessage message) {
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            List newContents = userMessage.contents().stream().map(this::prepareContent).collect(Collectors.toList());
            return UserMessage.from(newContents);
        }
        return message;
    }

    private Content prepareContent(Content content) {
        if (content instanceof TextContent) {
            TextContent txt = (TextContent)content;
            return new TextContent(new String(JsonStringEncoder.getInstance().quoteAsString(txt.text())));
        }
        return content;
    }

    @ConstructorProperties(value={"chatModelConfigurer", "aiRequestsExecutor"})
    @Generated
    public AiChatModelServiceImpl(Langchain4jChatModelConfigurer chatModelConfigurer, AiRequestsExecutor aiRequestsExecutor) {
        this.chatModelConfigurer = chatModelConfigurer;
        this.aiRequestsExecutor = aiRequestsExecutor;
    }
}

