/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.notification.rule.trigger.AlarmAssignmentTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.AlarmCommentTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.EntitiesLimitTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.EntityActionTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.dao.audit.AuditLogService;

@Service
public class EntityActionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityActionService.class);
    private final TbClusterService tbClusterService;
    private final AuditLogService auditLogService;
    private final NotificationRuleProcessor notificationRuleProcessor;

    public void pushEntityActionToRuleEngine(EntityId entityId, HasName entity, TenantId tenantId, CustomerId customerId, ActionType actionType, User user, Object ... additionalInfo) {
        Optional msgType = actionType.getRuleEngineMsgType();
        if (msgType.isPresent()) {
            try {
                ObjectNode entityNode;
                TbMsgMetaData metaData = new TbMsgMetaData();
                if (user != null) {
                    metaData.putValue("userId", user.getId().toString());
                    metaData.putValue("userName", user.getName());
                    metaData.putValue("userEmail", user.getEmail());
                    if (user.getFirstName() != null) {
                        metaData.putValue("userFirstName", user.getFirstName());
                    }
                    if (user.getLastName() != null) {
                        metaData.putValue("userLastName", user.getLastName());
                    }
                }
                if (customerId != null && !customerId.isNullUid()) {
                    metaData.putValue("customerId", customerId.toString());
                }
                if (actionType == ActionType.ASSIGNED_TO_CUSTOMER) {
                    strCustomerId = this.extractParameter(String.class, 1, additionalInfo);
                    strCustomerName = this.extractParameter(String.class, 2, additionalInfo);
                    metaData.putValue("assignedCustomerId", strCustomerId);
                    metaData.putValue("assignedCustomerName", strCustomerName);
                } else if (actionType == ActionType.UNASSIGNED_FROM_CUSTOMER) {
                    strCustomerId = this.extractParameter(String.class, 1, additionalInfo);
                    strCustomerName = this.extractParameter(String.class, 2, additionalInfo);
                    metaData.putValue("unassignedCustomerId", strCustomerId);
                    metaData.putValue("unassignedCustomerName", strCustomerName);
                } else if (actionType == ActionType.ASSIGNED_FROM_TENANT) {
                    strTenantId = this.extractParameter(String.class, 0, additionalInfo);
                    strTenantName = this.extractParameter(String.class, 1, additionalInfo);
                    metaData.putValue("assignedFromTenantId", strTenantId);
                    metaData.putValue("assignedFromTenantName", strTenantName);
                } else if (actionType == ActionType.ASSIGNED_TO_TENANT) {
                    strTenantId = this.extractParameter(String.class, 0, additionalInfo);
                    strTenantName = this.extractParameter(String.class, 1, additionalInfo);
                    metaData.putValue("assignedToTenantId", strTenantId);
                    metaData.putValue("assignedToTenantName", strTenantName);
                } else if (actionType == ActionType.ASSIGNED_TO_EDGE) {
                    strEdgeId = this.extractParameter(String.class, 1, additionalInfo);
                    strEdgeName = this.extractParameter(String.class, 2, additionalInfo);
                    metaData.putValue("assignedEdgeId", strEdgeId);
                    metaData.putValue("assignedEdgeName", strEdgeName);
                } else if (actionType == ActionType.UNASSIGNED_FROM_EDGE) {
                    strEdgeId = this.extractParameter(String.class, 1, additionalInfo);
                    strEdgeName = this.extractParameter(String.class, 2, additionalInfo);
                    metaData.putValue("unassignedEdgeId", strEdgeId);
                    metaData.putValue("unassignedEdgeName", strEdgeName);
                } else if (actionType == ActionType.ADDED_COMMENT || actionType == ActionType.UPDATED_COMMENT) {
                    AlarmComment comment = this.extractParameter(AlarmComment.class, 0, additionalInfo);
                    metaData.putValue("comment", JacksonUtil.toString((Object)comment));
                }
                if (entity != null) {
                    entityNode = (ObjectNode)JacksonUtil.OBJECT_MAPPER.valueToTree((Object)entity);
                    if (entityId.getEntityType() == EntityType.DASHBOARD) {
                        entityNode.put("configuration", "");
                    }
                    metaData.putValue("entityName", entity.getName());
                    metaData.putValue("entityType", entityId.getEntityType().toString());
                } else {
                    entityNode = JacksonUtil.newObjectNode();
                    if (actionType == ActionType.ATTRIBUTES_UPDATED) {
                        scope = this.extractParameter(AttributeScope.class, 0, additionalInfo);
                        List attributes = this.extractParameter(List.class, 1, additionalInfo);
                        metaData.putValue("scope", scope.name());
                        if (attributes != null) {
                            for (AttributeKvEntry attr : attributes) {
                                JacksonUtil.addKvEntry((ObjectNode)entityNode, (KvEntry)attr);
                            }
                        }
                    } else if (actionType == ActionType.ATTRIBUTES_DELETED) {
                        scope = this.extractParameter(AttributeScope.class, 0, additionalInfo);
                        List keys = this.extractParameter(List.class, 1, additionalInfo);
                        metaData.putValue("scope", scope.name());
                        ArrayNode attrsArrayNode = entityNode.putArray("attributes");
                        if (keys != null) {
                            keys.forEach(arg_0 -> ((ArrayNode)attrsArrayNode).add(arg_0));
                        }
                    } else if (actionType == ActionType.TIMESERIES_UPDATED) {
                        List timeseries = this.extractParameter(List.class, 0, additionalInfo);
                        this.addTimeseries(entityNode, timeseries);
                    } else if (actionType == ActionType.TIMESERIES_DELETED) {
                        List keys = this.extractParameter(List.class, 0, additionalInfo);
                        if (keys != null) {
                            ArrayNode timeseriesArrayNode = entityNode.putArray("timeseries");
                            keys.forEach(arg_0 -> ((ArrayNode)timeseriesArrayNode).add(arg_0));
                        }
                        entityNode.put("startTs", this.extractParameter(Long.class, 1, additionalInfo));
                        entityNode.put("endTs", this.extractParameter(Long.class, 2, additionalInfo));
                    } else if (ActionType.RELATION_ADD_OR_UPDATE.equals((Object)actionType) || ActionType.RELATION_DELETED.equals((Object)actionType)) {
                        entityNode = (ObjectNode)JacksonUtil.OBJECT_MAPPER.valueToTree((Object)this.extractParameter(EntityRelation.class, 0, additionalInfo));
                    }
                }
                if ((tenantId == null || tenantId.isNullUid()) && entity instanceof HasTenantId) {
                    tenantId = ((HasTenantId)entity).getTenantId();
                }
                if (tenantId != null && !tenantId.isSysTenantId()) {
                    this.processNotificationRules(tenantId, entityId, entity, actionType, user, additionalInfo);
                }
                TbMsg tbMsg = TbMsg.newMsg().type((TbMsgType)msgType.get()).originator(entityId).customerId(customerId).copyMetaData(metaData).dataType(TbMsgDataType.JSON).data(JacksonUtil.toString((Object)entityNode)).build();
                this.tbClusterService.pushMsgToRuleEngine(tenantId, entityId, tbMsg, null);
            }
            catch (Exception e) {
                log.warn("[{}] Failed to push entity action to rule engine: {}", new Object[]{entityId, actionType, e});
            }
        }
    }

    private void processNotificationRules(TenantId tenantId, EntityId originatorId, HasName entity, ActionType actionType, User user, Object ... additionalInfo) {
        EntityId entityId = entity instanceof HasId ? (EntityId)((HasId)entity).getId() : originatorId;
        switch (actionType) {
            case ADDED: {
                this.notificationRuleProcessor.process((NotificationRuleTrigger)EntitiesLimitTrigger.builder().tenantId(tenantId).entityType(entityId.getEntityType()).build());
            }
            case UPDATED: 
            case DELETED: {
                this.notificationRuleProcessor.process((NotificationRuleTrigger)EntityActionTrigger.builder().tenantId(tenantId).entityId(entityId).entity(entity).actionType(actionType).user(user).build());
                break;
            }
            case ALARM_ASSIGNED: 
            case ALARM_UNASSIGNED: {
                if (!(entity instanceof AlarmInfo)) {
                    log.warn("Invalid alarm assignment event: entity is not instance of AlarmInfo");
                    break;
                }
                this.notificationRuleProcessor.process((NotificationRuleTrigger)AlarmAssignmentTrigger.builder().tenantId(tenantId).alarmInfo((AlarmInfo)entity).actionType(actionType).user(user).build());
                break;
            }
            case ADDED_COMMENT: 
            case UPDATED_COMMENT: {
                if (!(entity instanceof Alarm)) {
                    log.warn("Invalid alarm comment event: entity is not instance of Alarm");
                    break;
                }
                this.notificationRuleProcessor.process((NotificationRuleTrigger)AlarmCommentTrigger.builder().tenantId(tenantId).comment(this.extractParameter(AlarmComment.class, 0, additionalInfo)).alarm((Alarm)entity).actionType(actionType).user(user).build());
            }
        }
    }

    public <E extends HasName, I extends EntityId> void logEntityAction(User user, I entityId, E entity, CustomerId customerId, ActionType actionType, Exception e, Object ... additionalInfo) {
        if (customerId == null || customerId.isNullUid()) {
            customerId = user.getCustomerId();
        }
        if (e == null) {
            this.pushEntityActionToRuleEngine(entityId, entity, user.getTenantId(), customerId, actionType, user, additionalInfo);
        }
        this.auditLogService.logEntityAction(user.getTenantId(), customerId, user.getId(), user.getName(), entityId, entity, actionType, e, additionalInfo);
    }

    private <T> T extractParameter(Class<T> clazz, int index, Object ... additionalInfo) {
        Object paramObject;
        T result = null;
        if (additionalInfo != null && additionalInfo.length > index && clazz.isInstance(paramObject = additionalInfo[index])) {
            result = clazz.cast(paramObject);
        }
        return result;
    }

    private void addTimeseries(ObjectNode entityNode, List<TsKvEntry> timeseries) {
        if (timeseries != null && !timeseries.isEmpty()) {
            ArrayNode result = entityNode.putArray("timeseries");
            Map<Long, List<TsKvEntry>> groupedTelemetry = timeseries.stream().collect(Collectors.groupingBy(TsKvEntry::getTs));
            for (Map.Entry<Long, List<TsKvEntry>> entry : groupedTelemetry.entrySet()) {
                ObjectNode element = JacksonUtil.newObjectNode();
                element.put("ts", entry.getKey());
                ObjectNode values = element.putObject("values");
                for (TsKvEntry tsKvEntry : entry.getValue()) {
                    JacksonUtil.addKvEntry((ObjectNode)values, (KvEntry)tsKvEntry);
                }
                result.add((JsonNode)element);
            }
        }
    }

    @ConstructorProperties(value={"tbClusterService", "auditLogService", "notificationRuleProcessor"})
    @Generated
    public EntityActionService(TbClusterService tbClusterService, AuditLogService auditLogService, NotificationRuleProcessor notificationRuleProcessor) {
        this.tbClusterService = tbClusterService;
        this.auditLogService = auditLogService;
        this.notificationRuleProcessor = notificationRuleProcessor;
    }
}

