/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller.plugin;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.NativeWebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.controller.plugin.TbWebSocketMsg;
import org.thingsboard.server.controller.plugin.TbWebSocketMsgType;
import org.thingsboard.server.controller.plugin.TbWebSocketPingMsg;
import org.thingsboard.server.controller.plugin.TbWebSocketTextMsg;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.jwt.JwtAuthenticationProvider;
import org.thingsboard.server.service.security.exception.JwtExpiredTokenException;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.subscription.SubscriptionErrorCode;
import org.thingsboard.server.service.ws.AuthCmd;
import org.thingsboard.server.service.ws.SessionEvent;
import org.thingsboard.server.service.ws.WebSocketMsgEndpoint;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.WebSocketSessionType;
import org.thingsboard.server.service.ws.WsCommandsWrapper;
import org.thingsboard.server.service.ws.notification.cmd.NotificationCmdsWrapper;
import org.thingsboard.server.service.ws.telemetry.cmd.TelemetryCmdsWrapper;

@Service
@TbCoreComponent
public class TbWebSocketHandler
extends TextWebSocketHandler
implements WebSocketMsgEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbWebSocketHandler.class);
    private final ConcurrentMap<String, SessionMetaData> internalSessionMap = new ConcurrentHashMap<String, SessionMetaData>();
    private final ConcurrentMap<String, String> externalSessionMap = new ConcurrentHashMap<String, String>();
    @Autowired
    @Lazy
    private WebSocketService webSocketService;
    @Autowired
    private TbTenantProfileCache tenantProfileCache;
    @Autowired
    private RateLimitService rateLimitService;
    @Autowired
    private JwtAuthenticationProvider authenticationProvider;
    @Value(value="${server.ws.send_timeout:5000}")
    private long sendTimeout;
    @Value(value="${server.ws.ping_timeout:30000}")
    private long pingTimeout;
    @Value(value="${server.ws.max_queue_messages_per_session:1000}")
    private int wsMaxQueueMessagesPerSession;
    @Value(value="${server.ws.auth_timeout_ms:10000}")
    private int authTimeoutMs;
    private final ConcurrentMap<String, WebSocketSessionRef> blacklistedSessions = new ConcurrentHashMap<String, WebSocketSessionRef>();
    private final ConcurrentMap<TenantId, Set<String>> tenantSessionsMap = new ConcurrentHashMap<TenantId, Set<String>>();
    private final ConcurrentMap<CustomerId, Set<String>> customerSessionsMap = new ConcurrentHashMap<CustomerId, Set<String>>();
    private final ConcurrentMap<UserId, Set<String>> regularUserSessionsMap = new ConcurrentHashMap<UserId, Set<String>>();
    private final ConcurrentMap<UserId, Set<String>> publicUserSessionsMap = new ConcurrentHashMap<UserId, Set<String>>();
    private Cache<String, SessionMetaData> pendingSessions;

    @PostConstruct
    private void init() {
        this.pendingSessions = Caffeine.newBuilder().expireAfterWrite((long)this.authTimeoutMs, TimeUnit.MILLISECONDS).removalListener((sessionId, sessionMd, removalCause) -> {
            if (removalCause == RemovalCause.EXPIRED && sessionMd != null) {
                try {
                    this.close(sessionMd.sessionRef, CloseStatus.POLICY_VIOLATION);
                }
                catch (IOException e) {
                    log.warn("IO error", (Throwable)e);
                }
            }
        }).build();
    }

    @PreDestroy
    private void stop() {
        this.internalSessionMap.clear();
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) {
        try {
            SessionMetaData sessionMd = this.getSessionMd(session.getId());
            if (sessionMd == null) {
                log.trace("[{}] Failed to find session", (Object)session.getId());
                session.close(CloseStatus.SERVER_ERROR.withReason("Session not found!"));
                return;
            }
            sessionMd.onMsg((String)message.getPayload());
        }
        catch (IOException e) {
            log.warn("IO error", (Throwable)e);
        }
    }

    void processMsg(SessionMetaData sessionMd, String msg) throws IOException {
        WsCommandsWrapper cmdsWrapper;
        WebSocketSessionRef sessionRef = sessionMd.sessionRef;
        try {
            switch (sessionRef.getSessionType()) {
                case GENERAL: {
                    cmdsWrapper = (WsCommandsWrapper)JacksonUtil.fromString((String)msg, WsCommandsWrapper.class);
                    break;
                }
                case TELEMETRY: {
                    cmdsWrapper = ((TelemetryCmdsWrapper)JacksonUtil.fromString((String)msg, TelemetryCmdsWrapper.class)).toCommonCmdsWrapper();
                    break;
                }
                case NOTIFICATIONS: {
                    cmdsWrapper = ((NotificationCmdsWrapper)JacksonUtil.fromString((String)msg, NotificationCmdsWrapper.class)).toCommonCmdsWrapper();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            log.debug("{} Failed to decode subscription cmd: {}", new Object[]{sessionRef, e.getMessage(), e});
            if (sessionRef.getSecurityCtx() != null) {
                this.webSocketService.sendError(sessionRef, 1, SubscriptionErrorCode.BAD_REQUEST, "Failed to parse the payload");
            } else {
                this.close(sessionRef, CloseStatus.BAD_DATA.withReason(e.getMessage()));
            }
            return;
        }
        if (sessionRef.getSecurityCtx() != null) {
            log.trace("{} Processing {}", (Object)sessionRef, (Object)msg);
            this.webSocketService.handleCommands(sessionRef, cmdsWrapper);
        } else {
            SecurityUser securityCtx;
            AuthCmd authCmd = cmdsWrapper.getAuthCmd();
            if (authCmd == null) {
                this.close(sessionRef, CloseStatus.POLICY_VIOLATION.withReason("Auth cmd is missing"));
                return;
            }
            log.trace("{} Authenticating session", (Object)sessionRef);
            try {
                securityCtx = this.authenticationProvider.authenticate(authCmd.getToken());
            }
            catch (Exception e) {
                this.close(sessionRef, CloseStatus.BAD_DATA.withReason(e.getMessage()));
                return;
            }
            sessionRef.setSecurityCtx(securityCtx);
            this.pendingSessions.invalidate((Object)sessionMd.session.getId());
            this.establishSession(sessionMd.session, sessionRef, sessionMd);
            this.webSocketService.handleCommands(sessionRef, cmdsWrapper);
        }
    }

    protected void handlePongMessage(WebSocketSession session, PongMessage message) throws Exception {
        try {
            SessionMetaData sessionMd = this.getSessionMd(session.getId());
            if (sessionMd != null) {
                log.trace("{} Processing pong response {}", (Object)sessionMd.sessionRef, message.getPayload());
                sessionMd.processPongMessage(System.currentTimeMillis());
            } else {
                log.trace("[{}] Failed to find session", (Object)session.getId());
                session.close(CloseStatus.SERVER_ERROR.withReason("Session not found!"));
            }
        }
        catch (IOException e) {
            log.warn("IO error", (Throwable)e);
        }
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        super.afterConnectionEstablished(session);
        try {
            Session nativeSession;
            if (session instanceof NativeWebSocketSession && (nativeSession = (Session)((NativeWebSocketSession)session).getNativeSession(Session.class)) != null) {
                nativeSession.getAsyncRemote().setSendTimeout(this.sendTimeout);
            }
            WebSocketSessionRef sessionRef = this.toRef(session);
            log.debug("[{}][{}] Session opened from address: {}", new Object[]{sessionRef.getSessionId(), session.getId(), session.getRemoteAddress()});
            this.establishSession(session, sessionRef, null);
        }
        catch (InvalidParameterException e) {
            log.warn("[{}] Failed to start session", (Object)session.getId(), (Object)e);
            session.close(CloseStatus.BAD_DATA.withReason(e.getMessage()));
        }
        catch (JwtExpiredTokenException e) {
            log.trace("[{}] Failed to start session", (Object)session.getId(), (Object)e);
            session.close(CloseStatus.SERVER_ERROR.withReason(e.getMessage()));
        }
        catch (Exception e) {
            log.warn("[{}] Failed to start session", (Object)session.getId(), (Object)e);
            session.close(CloseStatus.SERVER_ERROR.withReason(e.getMessage()));
        }
    }

    private void establishSession(WebSocketSession session, WebSocketSessionRef sessionRef, SessionMetaData sessionMd) throws IOException {
        if (sessionRef.getSecurityCtx() != null) {
            if (!this.checkLimits(session, sessionRef)) {
                return;
            }
            int maxMsgQueueSize = Optional.ofNullable(this.getTenantProfileConfiguration(sessionRef)).map(DefaultTenantProfileConfiguration::getWsMsgQueueLimitPerSession).filter(profileLimit -> profileLimit > 0 && profileLimit < this.wsMaxQueueMessagesPerSession).orElse(this.wsMaxQueueMessagesPerSession);
            if (sessionMd == null) {
                sessionMd = new SessionMetaData(session, sessionRef);
            }
            sessionMd.setMaxMsgQueueSize(maxMsgQueueSize);
            this.internalSessionMap.put(session.getId(), sessionMd);
            this.externalSessionMap.put(sessionRef.getSessionId(), session.getId());
            this.processInWebSocketService(sessionRef, SessionEvent.onEstablished());
            log.info("[{}][{}][{}][{}] Session established from address: {}", new Object[]{sessionRef.getSecurityCtx().getTenantId(), sessionRef.getSecurityCtx().getId(), sessionRef.getSessionId(), session.getId(), session.getRemoteAddress()});
        } else {
            sessionMd = new SessionMetaData(session, sessionRef);
            this.pendingSessions.put((Object)session.getId(), (Object)sessionMd);
            this.externalSessionMap.put(sessionRef.getSessionId(), session.getId());
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable tError) throws Exception {
        super.handleTransportError(session, tError);
        SessionMetaData sessionMd = this.getSessionMd(session.getId());
        if (sessionMd != null) {
            this.processInWebSocketService(sessionMd.sessionRef, SessionEvent.onError(tError));
        } else {
            log.trace("[{}] Failed to find session", (Object)session.getId());
        }
        log.trace("[{}] Session transport error", (Object)session.getId(), (Object)tError);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        super.afterConnectionClosed(session, closeStatus);
        SessionMetaData sessionMd = (SessionMetaData)this.internalSessionMap.remove(session.getId());
        if (sessionMd == null) {
            sessionMd = (SessionMetaData)this.pendingSessions.asMap().remove(session.getId());
        }
        if (sessionMd != null) {
            this.externalSessionMap.remove(sessionMd.sessionRef.getSessionId());
            if (sessionMd.sessionRef.getSecurityCtx() != null) {
                this.cleanupLimits(session, sessionMd.sessionRef);
                this.processInWebSocketService(sessionMd.sessionRef, SessionEvent.onClosed());
            }
            log.info("{} Session is closed", (Object)sessionMd.sessionRef);
        } else {
            log.info("[{}] Session is closed", (Object)session.getId());
        }
    }

    private void processInWebSocketService(WebSocketSessionRef sessionRef, SessionEvent event) {
        if (sessionRef.getSecurityCtx() == null) {
            return;
        }
        try {
            this.webSocketService.handleSessionEvent(sessionRef, event);
        }
        catch (BeanCreationNotAllowedException e) {
            log.warn("{} Failed to close session due to possible shutdown state", (Object)sessionRef);
        }
    }

    private WebSocketSessionRef toRef(WebSocketSession session) {
        WebSocketSessionType sessionType;
        String path = session.getUri().getPath();
        if (path.equals("/api/ws")) {
            sessionType = WebSocketSessionType.GENERAL;
        } else {
            String type = StringUtils.substringAfter((String)path, (String)"/api/ws/plugins/");
            sessionType = WebSocketSessionType.forName(type).orElseThrow(() -> new InvalidParameterException("Unknown session type"));
        }
        SecurityUser securityCtx = null;
        String token = StringUtils.substringAfter((String)session.getUri().getQuery(), (String)"token=");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            securityCtx = this.authenticationProvider.authenticate(token);
        }
        return WebSocketSessionRef.builder().sessionId(UUID.randomUUID().toString()).securityCtx(securityCtx).localAddress(session.getLocalAddress()).remoteAddress(session.getRemoteAddress()).sessionType(sessionType).build();
    }

    private SessionMetaData getSessionMd(String internalSessionId) {
        SessionMetaData sessionMd = (SessionMetaData)this.internalSessionMap.get(internalSessionId);
        if (sessionMd == null) {
            sessionMd = (SessionMetaData)this.pendingSessions.getIfPresent((Object)internalSessionId);
        }
        return sessionMd;
    }

    @Override
    public void send(WebSocketSessionRef sessionRef, int subscriptionId, String msg) throws IOException {
        log.debug("{} Sending {}", (Object)sessionRef, (Object)msg);
        String externalId = sessionRef.getSessionId();
        String internalId = (String)this.externalSessionMap.get(externalId);
        if (internalId != null) {
            SessionMetaData sessionMd = (SessionMetaData)this.internalSessionMap.get(internalId);
            if (sessionMd != null) {
                TenantId tenantId = sessionRef.getSecurityCtx().getTenantId();
                if (!this.rateLimitService.checkRateLimit(LimitedApi.WS_UPDATES_PER_SESSION, tenantId, (Object)sessionRef.getSessionId())) {
                    if (this.blacklistedSessions.putIfAbsent(externalId, sessionRef) == null) {
                        log.info("{} Failed to process session update. Max session updates limit reached", (Object)sessionRef);
                        sessionMd.sendMsg("{\"subscriptionId\":" + subscriptionId + ", \"errorCode\":" + ThingsboardErrorCode.TOO_MANY_UPDATES.getErrorCode() + ", \"errorMsg\":\"Too many updates!\"}");
                    }
                    return;
                }
                log.debug("{} Session is no longer blacklisted.", (Object)sessionRef);
                this.blacklistedSessions.remove(externalId);
                sessionMd.sendMsg(msg);
            } else {
                log.warn("[{}][{}] Failed to find session by internal id", (Object)externalId, (Object)internalId);
            }
        } else {
            log.warn("[{}] Failed to find session by external id", (Object)externalId);
        }
    }

    @Override
    public void sendPing(WebSocketSessionRef sessionRef, long currentTime) throws IOException {
        String externalId = sessionRef.getSessionId();
        String internalId = (String)this.externalSessionMap.get(externalId);
        if (internalId != null) {
            SessionMetaData sessionMd = (SessionMetaData)this.internalSessionMap.get(internalId);
            if (sessionMd != null) {
                sessionMd.sendPing(currentTime);
            } else {
                log.warn("[{}][{}] Failed to find session by internal id", (Object)externalId, (Object)internalId);
            }
        } else {
            log.warn("[{}] Failed to find session by external id", (Object)externalId);
        }
    }

    @Override
    public void close(WebSocketSessionRef sessionRef, CloseStatus reason) throws IOException {
        String externalId = sessionRef.getSessionId();
        log.debug("{} Processing close request", (Object)sessionRef.toString());
        String internalId = (String)this.externalSessionMap.get(externalId);
        if (internalId != null) {
            SessionMetaData sessionMd = this.getSessionMd(internalId);
            if (sessionMd != null) {
                sessionMd.session.close(reason);
            } else {
                log.warn("[{}][{}] Failed to find session by internal id", (Object)externalId, (Object)internalId);
            }
        } else {
            log.warn("[{}] Failed to find session by external id", (Object)externalId);
        }
    }

    @Override
    public boolean isOpen(String externalId) {
        SessionMetaData sessionMd;
        String internalId = (String)this.externalSessionMap.get(externalId);
        if (internalId != null && (sessionMd = this.getSessionMd(internalId)) != null) {
            return sessionMd.session.isOpen();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLimits(WebSocketSession session, WebSocketSessionRef sessionRef) throws IOException {
        boolean limitAllowed;
        Set set;
        DefaultTenantProfileConfiguration tenantProfileConfiguration = this.getTenantProfileConfiguration(sessionRef);
        if (tenantProfileConfiguration == null) {
            return true;
        }
        String sessionId = session.getId();
        if (tenantProfileConfiguration.getMaxWsSessionsPerTenant() > 0) {
            Set tenantSessions;
            set = tenantSessions = this.tenantSessionsMap.computeIfAbsent(sessionRef.getSecurityCtx().getTenantId(), id -> ConcurrentHashMap.newKeySet());
            synchronized (set) {
                boolean bl = limitAllowed = tenantSessions.size() < tenantProfileConfiguration.getMaxWsSessionsPerTenant();
                if (limitAllowed) {
                    tenantSessions.add(sessionId);
                }
            }
            if (!limitAllowed) {
                log.info("{} Failed to start session. Max tenant sessions limit reached", (Object)sessionRef.toString());
                session.close(CloseStatus.POLICY_VIOLATION.withReason("Max tenant sessions limit reached!"));
                return false;
            }
        }
        if (sessionRef.getSecurityCtx().isCustomerUser()) {
            if (tenantProfileConfiguration.getMaxWsSessionsPerCustomer() > 0) {
                Set customerSessions;
                set = customerSessions = this.customerSessionsMap.computeIfAbsent(sessionRef.getSecurityCtx().getCustomerId(), id -> ConcurrentHashMap.newKeySet());
                synchronized (set) {
                    boolean bl = limitAllowed = customerSessions.size() < tenantProfileConfiguration.getMaxWsSessionsPerCustomer();
                    if (limitAllowed) {
                        customerSessions.add(sessionId);
                    }
                }
                if (!limitAllowed) {
                    log.info("{} Failed to start session. Max customer sessions limit reached", (Object)sessionRef.toString());
                    session.close(CloseStatus.POLICY_VIOLATION.withReason("Max customer sessions limit reached"));
                    return false;
                }
            }
            if (tenantProfileConfiguration.getMaxWsSessionsPerRegularUser() > 0 && UserPrincipal.Type.USER_NAME.equals((Object)sessionRef.getSecurityCtx().getUserPrincipal().getType())) {
                Set regularUserSessions;
                set = regularUserSessions = this.regularUserSessionsMap.computeIfAbsent(sessionRef.getSecurityCtx().getId(), id -> ConcurrentHashMap.newKeySet());
                synchronized (set) {
                    boolean bl = limitAllowed = regularUserSessions.size() < tenantProfileConfiguration.getMaxWsSessionsPerRegularUser();
                    if (limitAllowed) {
                        regularUserSessions.add(sessionId);
                    }
                }
                if (!limitAllowed) {
                    log.info("{} Failed to start session. Max regular user sessions limit reached", (Object)sessionRef.toString());
                    session.close(CloseStatus.POLICY_VIOLATION.withReason("Max regular user sessions limit reached"));
                    return false;
                }
            }
            if (tenantProfileConfiguration.getMaxWsSessionsPerPublicUser() > 0 && UserPrincipal.Type.PUBLIC_ID.equals((Object)sessionRef.getSecurityCtx().getUserPrincipal().getType())) {
                Set publicUserSessions;
                set = publicUserSessions = this.publicUserSessionsMap.computeIfAbsent(sessionRef.getSecurityCtx().getId(), id -> ConcurrentHashMap.newKeySet());
                synchronized (set) {
                    boolean bl = limitAllowed = publicUserSessions.size() < tenantProfileConfiguration.getMaxWsSessionsPerPublicUser();
                    if (limitAllowed) {
                        publicUserSessions.add(sessionId);
                    }
                }
                if (!limitAllowed) {
                    log.info("{} Failed to start session. Max public user sessions limit reached", (Object)sessionRef.toString());
                    session.close(CloseStatus.POLICY_VIOLATION.withReason("Max public user sessions limit reached"));
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupLimits(WebSocketSession session, WebSocketSessionRef sessionRef) {
        Set set;
        DefaultTenantProfileConfiguration tenantProfileConfiguration = this.getTenantProfileConfiguration(sessionRef);
        if (tenantProfileConfiguration == null) {
            return;
        }
        String sessionId = session.getId();
        this.rateLimitService.cleanUp(LimitedApi.WS_UPDATES_PER_SESSION, (Object)sessionRef.getSessionId());
        this.blacklistedSessions.remove(sessionRef.getSessionId());
        if (tenantProfileConfiguration.getMaxWsSessionsPerTenant() > 0) {
            Set tenantSessions;
            set = tenantSessions = this.tenantSessionsMap.computeIfAbsent(sessionRef.getSecurityCtx().getTenantId(), id -> ConcurrentHashMap.newKeySet());
            synchronized (set) {
                tenantSessions.remove(sessionId);
            }
        }
        if (sessionRef.getSecurityCtx().isCustomerUser()) {
            if (tenantProfileConfiguration.getMaxWsSessionsPerCustomer() > 0) {
                Set customerSessions;
                set = customerSessions = this.customerSessionsMap.computeIfAbsent(sessionRef.getSecurityCtx().getCustomerId(), id -> ConcurrentHashMap.newKeySet());
                synchronized (set) {
                    customerSessions.remove(sessionId);
                }
            }
            if (tenantProfileConfiguration.getMaxWsSessionsPerRegularUser() > 0 && UserPrincipal.Type.USER_NAME.equals((Object)sessionRef.getSecurityCtx().getUserPrincipal().getType())) {
                Set regularUserSessions;
                set = regularUserSessions = this.regularUserSessionsMap.computeIfAbsent(sessionRef.getSecurityCtx().getId(), id -> ConcurrentHashMap.newKeySet());
                synchronized (set) {
                    regularUserSessions.remove(sessionId);
                }
            }
            if (tenantProfileConfiguration.getMaxWsSessionsPerPublicUser() > 0 && UserPrincipal.Type.PUBLIC_ID.equals((Object)sessionRef.getSecurityCtx().getUserPrincipal().getType())) {
                Set publicUserSessions;
                set = publicUserSessions = this.publicUserSessionsMap.computeIfAbsent(sessionRef.getSecurityCtx().getId(), id -> ConcurrentHashMap.newKeySet());
                synchronized (set) {
                    publicUserSessions.remove(sessionId);
                }
            }
        }
    }

    private DefaultTenantProfileConfiguration getTenantProfileConfiguration(WebSocketSessionRef sessionRef) {
        return Optional.ofNullable(this.tenantProfileCache.get(sessionRef.getSecurityCtx().getTenantId())).map(TenantProfile::getDefaultProfileConfiguration).orElse(null);
    }

    @Generated
    public TbWebSocketHandler() {
    }

    class SessionMetaData
    implements SendHandler {
        private final WebSocketSession session;
        private final RemoteEndpoint.Async asyncRemote;
        private final WebSocketSessionRef sessionRef;
        final AtomicBoolean isSending = new AtomicBoolean(false);
        private final Queue<TbWebSocketMsg<?>> outboundMsgQueue = new ConcurrentLinkedQueue();
        private final AtomicInteger outboundMsgQueueSize = new AtomicInteger();
        private int maxMsgQueueSize;
        private final Queue<String> inboundMsgQueue;
        private final Lock inboundMsgQueueProcessorLock;
        private volatile long lastActivityTime;

        SessionMetaData(WebSocketSession session, WebSocketSessionRef sessionRef) {
            this.maxMsgQueueSize = TbWebSocketHandler.this.wsMaxQueueMessagesPerSession;
            this.inboundMsgQueue = new ConcurrentLinkedQueue<String>();
            this.inboundMsgQueueProcessorLock = new ReentrantLock();
            this.session = session;
            Session nativeSession = (Session)((NativeWebSocketSession)session).getNativeSession(Session.class);
            this.asyncRemote = nativeSession.getAsyncRemote();
            this.sessionRef = sessionRef;
            this.lastActivityTime = System.currentTimeMillis();
        }

        void sendPing(long currentTime) {
            try {
                long timeSinceLastActivity = currentTime - this.lastActivityTime;
                if (timeSinceLastActivity >= TbWebSocketHandler.this.pingTimeout) {
                    log.warn("{} Closing session due to ping timeout", (Object)this.sessionRef);
                    this.closeSession(CloseStatus.SESSION_NOT_RELIABLE);
                } else if (timeSinceLastActivity >= TbWebSocketHandler.this.pingTimeout / 3L) {
                    this.sendMsg(TbWebSocketPingMsg.INSTANCE);
                }
            }
            catch (Exception e) {
                log.trace("{} Failed to send ping msg", (Object)this.sessionRef, (Object)e);
                this.closeSession(CloseStatus.SESSION_NOT_RELIABLE);
            }
        }

        void closeSession(CloseStatus reason) {
            try {
                TbWebSocketHandler.this.close(this.sessionRef, reason);
            }
            catch (IOException ioe) {
                log.trace("{} Session transport error", (Object)this.sessionRef, (Object)ioe);
            }
            finally {
                this.outboundMsgQueue.clear();
            }
        }

        void processPongMessage(long currentTime) {
            this.lastActivityTime = currentTime;
        }

        void sendMsg(String msg) {
            this.sendMsg(new TbWebSocketTextMsg(msg));
        }

        void sendMsg(TbWebSocketMsg<?> msg) {
            if (this.outboundMsgQueueSize.get() < this.maxMsgQueueSize) {
                this.outboundMsgQueue.add(msg);
                this.outboundMsgQueueSize.incrementAndGet();
                this.processNextMsg();
            } else {
                log.info("{} Session closed due to updates queue size exceeded", (Object)this.sessionRef);
                this.closeSession(CloseStatus.POLICY_VIOLATION.withReason("Max pending updates limit reached!"));
            }
        }

        private void sendMsgInternal(TbWebSocketMsg<?> msg) {
            try {
                if (TbWebSocketMsgType.TEXT.equals((Object)msg.getType())) {
                    TbWebSocketTextMsg textMsg = (TbWebSocketTextMsg)msg;
                    this.asyncRemote.sendText(textMsg.getMsg(), (SendHandler)this);
                } else {
                    TbWebSocketPingMsg pingMsg = (TbWebSocketPingMsg)msg;
                    this.asyncRemote.sendPing(pingMsg.getMsg());
                    this.isSending.set(false);
                    this.processNextMsg();
                }
            }
            catch (Exception e) {
                log.trace("{} Failed to send msg", (Object)this.sessionRef, (Object)e);
                this.closeSession(CloseStatus.SESSION_NOT_RELIABLE);
            }
        }

        public void onResult(SendResult result) {
            if (!result.isOK()) {
                log.trace("{} Failed to send msg", (Object)this.sessionRef, (Object)result.getException());
                this.closeSession(CloseStatus.SESSION_NOT_RELIABLE);
                return;
            }
            this.isSending.set(false);
            this.processNextMsg();
        }

        private void processNextMsg() {
            if (this.outboundMsgQueue.isEmpty() || !this.isSending.compareAndSet(false, true)) {
                return;
            }
            TbWebSocketMsg<?> msg = this.outboundMsgQueue.poll();
            if (msg != null) {
                this.outboundMsgQueueSize.decrementAndGet();
                this.sendMsgInternal(msg);
            } else {
                this.isSending.set(false);
            }
        }

        public void onMsg(String msg) throws IOException {
            this.inboundMsgQueue.add(msg);
            this.tryProcessInboundMsgs();
        }

        void tryProcessInboundMsgs() throws IOException {
            while (!this.inboundMsgQueue.isEmpty()) {
                if (this.inboundMsgQueueProcessorLock.tryLock()) {
                    try {
                        String msg;
                        while ((msg = this.inboundMsgQueue.poll()) != null) {
                            TbWebSocketHandler.this.processMsg(this, msg);
                        }
                        continue;
                    }
                    finally {
                        this.inboundMsgQueueProcessorLock.unlock();
                        continue;
                    }
                }
                return;
            }
        }

        @Generated
        public void setMaxMsgQueueSize(int maxMsgQueueSize) {
            this.maxMsgQueueSize = maxMsgQueueSize;
        }
    }
}

