/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.UsageInfo;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.usage.UsageInfoService;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class UsageInfoController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsageInfoController.class);
    @Autowired
    private UsageInfoService usageInfoService;

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/usage"}, method={RequestMethod.GET})
    @ResponseBody
    public UsageInfo getTenantUsageInfo() throws ThingsboardException {
        return this.checkNotNull(this.usageInfoService.getUsageInfo(this.getCurrentUser().getTenantId()));
    }
}

