/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.targets.NotificationTarget;
import org.thingsboard.server.common.data.notification.targets.NotificationTargetConfig;
import org.thingsboard.server.common.data.notification.targets.NotificationTargetType;
import org.thingsboard.server.common.data.notification.targets.platform.CustomerUsersFilter;
import org.thingsboard.server.common.data.notification.targets.platform.PlatformUsersNotificationTargetConfig;
import org.thingsboard.server.common.data.notification.targets.platform.TenantAdministratorsFilter;
import org.thingsboard.server.common.data.notification.targets.platform.UserListFilter;
import org.thingsboard.server.common.data.notification.targets.platform.UsersFilter;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/notification"})
public class NotificationTargetController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationTargetController.class);
    private final NotificationTargetService notificationTargetService;

    @ApiOperation(value="Save notification target (saveNotificationTarget)", notes="Creates or updates notification target.\n\nAvailable `configuration` types are `PLATFORM_USERS` and `SLACK`.\nFor `PLATFORM_USERS` the `usersFilter` must be specified. For tenant, there are following users filter types available: `USER_LIST`, `CUSTOMER_USERS`, `TENANT_ADMINISTRATORS`, `ALL_USERS`, `ORIGINATOR_ENTITY_OWNER_USERS`, `AFFECTED_USER`.\nFor sysadmin: `TENANT_ADMINISTRATORS`, `AFFECTED_TENANT_ADMINISTRATORS`, `SYSTEM_ADMINISTRATORS`, `ALL_USERS`.\n\nHere is an example of tenant-level notification target to send notification to customer's users:\n```json\n{\n  \"name\": \"Users of Customer A\",\n  \"configuration\": {\n    \"type\": \"PLATFORM_USERS\",\n    \"usersFilter\": {\n      \"type\": \"CUSTOMER_USERS\",\n      \"customerId\": \"32499a20-d785-11ed-a06c-21dd57dd88ca\"\n    },\n    \"description\": \"Users of Customer A\"\n  }\n}\n```\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/target"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationTarget saveNotificationTarget(@RequestBody @Valid NotificationTarget notificationTarget, @AuthenticationPrincipal SecurityUser user) throws Exception {
        notificationTarget.setTenantId(user.getTenantId());
        this.checkEntity((NotificationTargetId)notificationTarget.getId(), notificationTarget, Resource.NOTIFICATION);
        NotificationTargetConfig targetConfig = notificationTarget.getConfiguration();
        if (targetConfig.getType() == NotificationTargetType.PLATFORM_USERS) {
            this.checkTargetUsers(user, targetConfig);
        }
        return this.doSaveAndLog(EntityType.NOTIFICATION_TARGET, notificationTarget, (arg_0, arg_1) -> ((NotificationTargetService)this.notificationTargetService).saveNotificationTarget(arg_0, arg_1));
    }

    @ApiOperation(value="Get notification target by id (getNotificationTargetById)", notes="Fetches notification target by id.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/target/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationTarget getNotificationTargetById(@PathVariable UUID id) throws ThingsboardException {
        NotificationTargetId notificationTargetId = new NotificationTargetId(id);
        return this.checkNotificationTargetId(notificationTargetId, Operation.READ);
    }

    @ApiOperation(value="Get recipients for notification target config (getRecipientsForNotificationTargetConfig)", notes="Returns the page of recipients for such notification target configuration.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/target/recipients"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public PageData<User> getRecipientsForNotificationTargetConfig(@RequestBody NotificationTarget notificationTarget, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        NotificationTargetConfig targetConfig = notificationTarget.getConfiguration();
        if (targetConfig.getType() != NotificationTargetType.PLATFORM_USERS) {
            throw new IllegalArgumentException("Target type is not platform users");
        }
        this.checkTargetUsers(user, targetConfig);
        PageLink pageLink = this.createPageLink(pageSize, page, null, null, null);
        return this.notificationTargetService.findRecipientsForNotificationTargetConfig(user.getTenantId(), (PlatformUsersNotificationTargetConfig)notificationTarget.getConfiguration(), pageLink);
    }

    @ApiOperation(value="Get notification targets by ids (getNotificationTargetsByIds)", notes="Returns the list of notification targets found by provided ids.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/targets"}, params={"ids"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public List<NotificationTarget> getNotificationTargetsByIds(@Parameter(description="Comma-separated list of uuids representing targets ids", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="ids") UUID[] ids, @AuthenticationPrincipal SecurityUser user) {
        List targetsIds = Arrays.stream(ids).map(NotificationTargetId::new).collect(Collectors.toList());
        return this.notificationTargetService.findNotificationTargetsByTenantIdAndIds(user.getTenantId(), targetsIds);
    }

    @ApiOperation(value="Get notification targets (getNotificationTargets)", notes="Returns the page of notification targets owned by sysadmin or tenant.\n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/targets"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public PageData<NotificationTarget> getNotificationTargets(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filed based on the target's name") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.notificationTargetService.findNotificationTargetsByTenantId(user.getTenantId(), pageLink);
    }

    @ApiOperation(value="Get notification targets by supported notification type (getNotificationTargetsBySupportedNotificationType)", notes="Returns the page of notification targets filtered by notification type that they can be used for.\n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/targets"}, params={"notificationType"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public PageData<NotificationTarget> getNotificationTargetsBySupportedNotificationType(@RequestParam int pageSize, @RequestParam int page, @RequestParam(required=false) String textSearch, @RequestParam(required=false) String sortProperty, @RequestParam(required=false) String sortOrder, @RequestParam(required=false) NotificationType notificationType, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.notificationTargetService.findNotificationTargetsByTenantIdAndSupportedNotificationType(user.getTenantId(), notificationType, pageLink);
    }

    @ApiOperation(value="Delete notification target by id (deleteNotificationTargetById)", notes="Deletes notification target by its id.\n\nThis target cannot be referenced by existing scheduled notification requests or any notification rules.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @DeleteMapping(value={"/target/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public void deleteNotificationTargetById(@PathVariable UUID id) throws Exception {
        NotificationTargetId notificationTargetId = new NotificationTargetId(id);
        NotificationTarget notificationTarget = this.checkNotificationTargetId(notificationTargetId, Operation.DELETE);
        this.doDeleteAndLog(EntityType.NOTIFICATION_TARGET, notificationTarget, (arg_0, arg_1) -> ((NotificationTargetService)this.notificationTargetService).deleteNotificationTargetById(arg_0, arg_1));
    }

    private void checkTargetUsers(SecurityUser user, NotificationTargetConfig targetConfig) throws ThingsboardException {
        if (user.isSystemAdmin()) {
            return;
        }
        UsersFilter usersFilter = ((PlatformUsersNotificationTargetConfig)targetConfig).getUsersFilter();
        switch (usersFilter.getType()) {
            case USER_LIST: {
                for (UUID recipientId : ((UserListFilter)usersFilter).getUsersIds()) {
                    this.checkUserId(new UserId(recipientId), Operation.READ);
                }
                break;
            }
            case CUSTOMER_USERS: {
                CustomerId customerId = new CustomerId(((CustomerUsersFilter)usersFilter).getCustomerId());
                this.checkEntityId((EntityId)customerId, Operation.READ);
                break;
            }
            case TENANT_ADMINISTRATORS: {
                if (!CollectionUtils.isNotEmpty((Collection)((TenantAdministratorsFilter)usersFilter).getTenantsIds()) && !CollectionUtils.isNotEmpty((Collection)((TenantAdministratorsFilter)usersFilter).getTenantProfilesIds())) break;
                throw new AccessDeniedException("");
            }
            case SYSTEM_ADMINISTRATORS: {
                throw new AccessDeniedException("");
            }
        }
    }

    @ConstructorProperties(value={"notificationTargetService"})
    @Generated
    public NotificationTargetController(NotificationTargetService notificationTargetService) {
        this.notificationTargetService = notificationTargetService;
    }
}

