/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationInfo;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.entity.relation.TbEntityRelationService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class EntityRelationController
extends BaseController {
    private final TbEntityRelationService tbEntityRelationService;
    public static final String TO_TYPE = "toType";
    public static final String FROM_ID = "fromId";
    public static final String FROM_TYPE = "fromType";
    public static final String RELATION_TYPE = "relationType";
    public static final String TO_ID = "toId";
    private static final String SECURITY_CHECKS_ENTITIES_DESCRIPTION = "\n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.";
    private static final String SECURITY_CHECKS_ENTITY_DESCRIPTION = "\n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.";

    @ApiOperation(value="Create Relation (saveRelation)", notes="Creates or updates a relation between two entities in the platform. Relations unique key is a combination of from/to entity id and relation type group and relation type. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relation"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void saveRelation(@Parameter(description="A JSON value representing the relation.", required=true) @RequestBody EntityRelation relation) throws ThingsboardException {
        this.doSave(relation);
    }

    @ApiOperation(value="Create Relation (saveRelationV2)", notes="Creates or updates a relation between two entities in the platform. Relations unique key is a combination of from/to entity id and relation type group and relation type. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/v2/relation"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityRelation saveRelationV2(@Parameter(description="A JSON value representing the relation.", required=true) @RequestBody EntityRelation relation) throws ThingsboardException {
        return this.doSave(relation);
    }

    private EntityRelation doSave(EntityRelation relation) throws ThingsboardException {
        this.checkNotNull(relation);
        this.checkCanCreateRelation(relation.getFrom());
        this.checkCanCreateRelation(relation.getTo());
        if (relation.getTypeGroup() == null) {
            relation.setTypeGroup(RelationTypeGroup.COMMON);
        }
        return this.tbEntityRelationService.save(this.getTenantId(), this.getCurrentUser().getCustomerId(), relation, this.getCurrentUser());
    }

    @ApiOperation(value="Delete Relation (deleteRelation)", notes="Deletes a relation between two entities in the platform. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relation"}, method={RequestMethod.DELETE}, params={"fromId", "fromType", "relationType", "toId", "toType"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteRelation(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType) throws ThingsboardException {
        this.doDelete(strFromId, strFromType, strRelationType, strRelationTypeGroup, strToId, strToType);
    }

    @ApiOperation(value="Delete Relation (deleteRelationV2)", notes="Deletes a relation between two entities in the platform. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/v2/relation"}, method={RequestMethod.DELETE}, params={"fromId", "fromType", "relationType", "toId", "toType"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityRelation deleteRelationV2(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType) throws ThingsboardException {
        return this.doDelete(strFromId, strFromType, strRelationType, strRelationTypeGroup, strToId, strToType);
    }

    private EntityRelation doDelete(String strFromId, String strFromType, String strRelationType, String strRelationTypeGroup, String strToId, String strToType) throws ThingsboardException {
        this.checkParameter(FROM_ID, strFromId);
        this.checkParameter(FROM_TYPE, strFromType);
        this.checkParameter(RELATION_TYPE, strRelationType);
        this.checkParameter(TO_ID, strToId);
        this.checkParameter(TO_TYPE, strToType);
        EntityId fromId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        EntityId toId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkCanCreateRelation(fromId);
        this.checkCanCreateRelation(toId);
        RelationTypeGroup relationTypeGroup = this.parseRelationTypeGroup(strRelationTypeGroup, RelationTypeGroup.COMMON);
        EntityRelation relation = new EntityRelation(fromId, toId, strRelationType, relationTypeGroup);
        return this.tbEntityRelationService.delete(this.getTenantId(), this.getCurrentUser().getCustomerId(), relation, this.getCurrentUser());
    }

    @ApiOperation(value="Delete common relations (deleteCommonRelations)", notes="Deletes all the relations ('from' and 'to' direction) for the specified entity and relation type group: 'COMMON'. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations"}, method={RequestMethod.DELETE}, params={"entityId", "entityType"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteRelations(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="entityId") String strId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="entityType") String strType) throws ThingsboardException {
        this.checkParameter("entityId", strId);
        this.checkParameter("entityType", strType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strType, (String)strId);
        this.checkEntityId(entityId, Operation.WRITE);
        this.tbEntityRelationService.deleteCommonRelations(this.getTenantId(), this.getCurrentUser().getCustomerId(), entityId, this.getCurrentUser());
    }

    @ApiOperation(value="Get Relation (getRelation)", notes="Returns relation object between two specified entities if present. Otherwise throws exception. \n\nIf the user has the authority of 'System Administrator', the server checks that 'from' and 'to' entities are owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that 'from' and 'to' entities are owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the 'from' and 'to' entities are assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relation"}, method={RequestMethod.GET}, params={"fromId", "fromType", "relationType", "toId", "toType"})
    @ResponseBody
    public EntityRelation getRelation(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType) throws ThingsboardException {
        this.checkParameter(FROM_ID, strFromId);
        this.checkParameter(FROM_TYPE, strFromType);
        this.checkParameter(RELATION_TYPE, strRelationType);
        this.checkParameter(TO_ID, strToId);
        this.checkParameter(TO_TYPE, strToType);
        EntityId fromId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        EntityId toId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkEntityId(fromId, Operation.READ);
        this.checkEntityId(toId, Operation.READ);
        RelationTypeGroup typeGroup = this.parseRelationTypeGroup(strRelationTypeGroup, RelationTypeGroup.COMMON);
        return this.checkNotNull(this.relationService.getRelation(this.getTenantId(), fromId, toId, strRelationType, typeGroup));
    }

    @ApiOperation(value="Get List of Relations (findByFrom)", notes="Returns list of relation objects for the specified entity by the 'from' direction. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations"}, method={RequestMethod.GET}, params={"fromId", "fromType"})
    @ResponseBody
    public List<EntityRelation> findByFrom(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException {
        this.checkParameter(FROM_ID, strFromId);
        this.checkParameter(FROM_TYPE, strFromType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = this.parseRelationTypeGroup(strRelationTypeGroup, RelationTypeGroup.COMMON);
        return this.checkNotNull(this.filterRelationsByReadPermission(this.relationService.findByFrom(this.getTenantId(), entityId, typeGroup)));
    }

    @ApiOperation(value="Get List of Relation Infos (findInfoByFrom)", notes="Returns list of relation info objects for the specified entity by the 'from' direction. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer. Relation Info is an extension of the default Relation object that contains information about the 'from' and 'to' entity names. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations/info"}, method={RequestMethod.GET}, params={"fromId", "fromType"})
    @ResponseBody
    public List<EntityRelationInfo> findInfoByFrom(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkParameter(FROM_ID, strFromId);
        this.checkParameter(FROM_TYPE, strFromType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = this.parseRelationTypeGroup(strRelationTypeGroup, RelationTypeGroup.COMMON);
        return this.checkNotNull(this.filterRelationsByReadPermission((List)this.relationService.findInfoByFrom(this.getTenantId(), entityId, typeGroup).get()));
    }

    @ApiOperation(value="Get List of Relations (findByFrom)", notes="Returns list of relation objects for the specified entity by the 'from' direction and relation type. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations"}, method={RequestMethod.GET}, params={"fromId", "fromType", "relationType"})
    @ResponseBody
    public List<EntityRelation> findByFrom(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="fromId") String strFromId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="fromType") String strFromType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException {
        this.checkParameter(FROM_ID, strFromId);
        this.checkParameter(FROM_TYPE, strFromType);
        this.checkParameter(RELATION_TYPE, strRelationType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strFromType, (String)strFromId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = this.parseRelationTypeGroup(strRelationTypeGroup, RelationTypeGroup.COMMON);
        return this.checkNotNull(this.filterRelationsByReadPermission(this.relationService.findByFromAndType(this.getTenantId(), entityId, strRelationType, typeGroup)));
    }

    @ApiOperation(value="Get List of Relations (findByTo)", notes="Returns list of relation objects for the specified entity by the 'to' direction. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations"}, method={RequestMethod.GET}, params={"toId", "toType"})
    @ResponseBody
    public List<EntityRelation> findByTo(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException {
        this.checkParameter(TO_ID, strToId);
        this.checkParameter(TO_TYPE, strToType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = this.parseRelationTypeGroup(strRelationTypeGroup, RelationTypeGroup.COMMON);
        return this.checkNotNull(this.filterRelationsByReadPermission(this.relationService.findByTo(this.getTenantId(), entityId, typeGroup)));
    }

    @ApiOperation(value="Get List of Relation Infos (findInfoByTo)", notes="Returns list of relation info objects for the specified entity by the 'to' direction. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer. Relation Info is an extension of the default Relation object that contains information about the 'from' and 'to' entity names. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations/info"}, method={RequestMethod.GET}, params={"toId", "toType"})
    @ResponseBody
    public List<EntityRelationInfo> findInfoByTo(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkParameter(TO_ID, strToId);
        this.checkParameter(TO_TYPE, strToType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = this.parseRelationTypeGroup(strRelationTypeGroup, RelationTypeGroup.COMMON);
        return this.checkNotNull(this.filterRelationsByReadPermission((List)this.relationService.findInfoByTo(this.getTenantId(), entityId, typeGroup).get()));
    }

    @ApiOperation(value="Get List of Relations (findByTo)", notes="Returns list of relation objects for the specified entity by the 'to' direction and relation type. \n\nIf the user has the authority of 'System Administrator', the server checks that the entity is owned by the sysadmin. If the user has the authority of 'Tenant Administrator', the server checks that the entity is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the entity is assigned to the same customer.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations"}, method={RequestMethod.GET}, params={"toId", "toType", "relationType"})
    @ResponseBody
    public List<EntityRelation> findByTo(@Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @RequestParam(value="toId") String strToId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @RequestParam(value="toType") String strToType, @Parameter(description="A string value representing relation type between entities. For example, 'Contains', 'Manages'. It can be any string value.", required=true) @RequestParam(value="relationType") String strRelationType, @Parameter(description="A string value representing relation type group. For example, 'COMMON'") @RequestParam(value="relationTypeGroup", required=false) String strRelationTypeGroup) throws ThingsboardException {
        this.checkParameter(TO_ID, strToId);
        this.checkParameter(TO_TYPE, strToType);
        this.checkParameter(RELATION_TYPE, strRelationType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strToType, (String)strToId);
        this.checkEntityId(entityId, Operation.READ);
        RelationTypeGroup typeGroup = this.parseRelationTypeGroup(strRelationTypeGroup, RelationTypeGroup.COMMON);
        return this.checkNotNull(this.filterRelationsByReadPermission(this.relationService.findByToAndType(this.getTenantId(), entityId, strRelationType, typeGroup)));
    }

    @ApiOperation(value="Find related entities (findByQuery)", notes="Returns all entities that are related to the specific entity. The entity id, relation type, entity types, depth of the search, and other query parameters defined using complex 'EntityRelationsQuery' object. See 'Model' tab of the Parameters for more info.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations"}, method={RequestMethod.POST})
    @ResponseBody
    public List<EntityRelation> findByQuery(@Parameter(description="A JSON value representing the entity relations query object.", required=true) @RequestBody EntityRelationsQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull(query);
        this.checkNotNull(query.getParameters());
        this.checkNotNull(query.getFilters());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        return this.checkNotNull(this.filterRelationsByReadPermission((List)this.relationService.findByQuery(this.getTenantId(), query).get()));
    }

    @ApiOperation(value="Find related entity infos (findInfoByQuery)", notes="Returns all entity infos that are related to the specific entity. The entity id, relation type, entity types, depth of the search, and other query parameters defined using complex 'EntityRelationsQuery' object. See 'Model' tab of the Parameters for more info. Relation Info is an extension of the default Relation object that contains information about the 'from' and 'to' entity names. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/relations/info"}, method={RequestMethod.POST})
    @ResponseBody
    public List<EntityRelationInfo> findInfoByQuery(@Parameter(description="A JSON value representing the entity relations query object.", required=true) @RequestBody EntityRelationsQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull(query);
        this.checkNotNull(query.getParameters());
        this.checkNotNull(query.getFilters());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        return this.checkNotNull(this.filterRelationsByReadPermission((List)this.relationService.findInfoByQuery(this.getTenantId(), query).get()));
    }

    private void checkCanCreateRelation(EntityId entityId) throws ThingsboardException {
        boolean isTenantAdminAndRelateToSelf;
        SecurityUser currentUser = this.getCurrentUser();
        boolean bl = isTenantAdminAndRelateToSelf = currentUser.isTenantAdmin() && currentUser.getTenantId().equals((Object)entityId);
        if (!isTenantAdminAndRelateToSelf) {
            this.checkEntityId(entityId, Operation.WRITE);
        }
    }

    private <T extends EntityRelation> List<T> filterRelationsByReadPermission(List<T> relationsByQuery) {
        return relationsByQuery.stream().filter(relationByQuery -> {
            try {
                this.checkEntityId(relationByQuery.getTo(), Operation.READ);
            }
            catch (ThingsboardException e) {
                return false;
            }
            try {
                this.checkEntityId(relationByQuery.getFrom(), Operation.READ);
            }
            catch (ThingsboardException e) {
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private RelationTypeGroup parseRelationTypeGroup(String strRelationTypeGroup, RelationTypeGroup defaultValue) {
        RelationTypeGroup result = defaultValue;
        if (strRelationTypeGroup != null && strRelationTypeGroup.trim().length() > 0) {
            try {
                result = RelationTypeGroup.valueOf((String)strRelationTypeGroup);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    @ConstructorProperties(value={"tbEntityRelationService"})
    @Generated
    public EntityRelationController(TbEntityRelationService tbEntityRelationService) {
        this.tbEntityRelationService = tbEntityRelationService;
    }
}

