/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileInfo;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.device.profile.TbDeviceProfileService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class DeviceProfileController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceProfileController.class);
    private final TbDeviceProfileService tbDeviceProfileService;
    private final ImageService imageService;
    @Autowired
    private TimeseriesService timeseriesService;

    @ApiOperation(value="Get Device Profile (getDeviceProfileById)", notes="Fetch the Device Profile object based on the provided Device Profile Id. The server checks that the device profile is owned by the same tenant. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/deviceProfile/{deviceProfileId}"}, method={RequestMethod.GET})
    @ResponseBody
    public DeviceProfile getDeviceProfileById(@Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceProfileId") String strDeviceProfileId, @Parameter(description="Inline images as a data URL (Base64)") @RequestParam(value="inlineImages", required=false) boolean inlineImages) throws ThingsboardException {
        this.checkParameter("deviceProfileId", strDeviceProfileId);
        DeviceProfileId deviceProfileId = new DeviceProfileId(this.toUUID(strDeviceProfileId));
        DeviceProfile result = this.checkDeviceProfileId(deviceProfileId, Operation.READ);
        if (inlineImages) {
            result = (DeviceProfile)this.imageService.inlineImage((HasImage)result);
        }
        return result;
    }

    @ApiOperation(value="Get Device Profile Info (getDeviceProfileInfoById)", notes="Fetch the Device Profile Info object based on the provided Device Profile Id. Device Profile Info is a lightweight object that includes main information about Device Profile excluding the heavyweight configuration object. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/deviceProfileInfo/{deviceProfileId}"}, method={RequestMethod.GET})
    @ResponseBody
    public DeviceProfileInfo getDeviceProfileInfoById(@Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceProfileId") String strDeviceProfileId) throws ThingsboardException {
        this.checkParameter("deviceProfileId", strDeviceProfileId);
        DeviceProfileId deviceProfileId = new DeviceProfileId(this.toUUID(strDeviceProfileId));
        return new DeviceProfileInfo(this.checkDeviceProfileId(deviceProfileId, Operation.READ));
    }

    @ApiOperation(value="Get Default Device Profile (getDefaultDeviceProfileInfo)", notes="Fetch the Default Device Profile Info object. Device Profile Info is a lightweight object that includes main information about Device Profile excluding the heavyweight configuration object. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/deviceProfileInfo/default"}, method={RequestMethod.GET})
    @ResponseBody
    public DeviceProfileInfo getDefaultDeviceProfileInfo() throws ThingsboardException {
        return this.checkNotNull(this.deviceProfileService.findDefaultDeviceProfileInfo(this.getTenantId()));
    }

    @ApiOperation(value="Get time series keys (getTimeseriesKeys)", notes="Get a set of unique time series keys used by devices that belong to specified profile. If profile is not set returns a list of unique keys among all profiles. The call is used for auto-complete in the UI forms. The implementation limits the number of devices that participate in search to 100 as a trade of between accurate results and time-consuming queries. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/deviceProfile/devices/keys/timeseries"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getTimeseriesKeys(@Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(name="deviceProfileId", required=false) String deviceProfileIdStr) throws ThingsboardException {
        DeviceProfileId deviceProfileId;
        if (StringUtils.isNotEmpty((String)deviceProfileIdStr)) {
            deviceProfileId = new DeviceProfileId(UUID.fromString(deviceProfileIdStr));
            this.checkDeviceProfileId(deviceProfileId, Operation.READ);
        } else {
            deviceProfileId = null;
        }
        return this.timeseriesService.findAllKeysByDeviceProfileId(this.getTenantId(), deviceProfileId);
    }

    @ApiOperation(value="Get attribute keys (getAttributesKeys)", notes="Get a set of unique attribute keys used by devices that belong to specified profile. If profile is not set returns a list of unique keys among all profiles. The call is used for auto-complete in the UI forms. The implementation limits the number of devices that participate in search to 100 as a trade of between accurate results and time-consuming queries. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/deviceProfile/devices/keys/attributes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getAttributesKeys(@Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(name="deviceProfileId", required=false) String deviceProfileIdStr) throws ThingsboardException {
        DeviceProfileId deviceProfileId;
        if (StringUtils.isNotEmpty((String)deviceProfileIdStr)) {
            deviceProfileId = new DeviceProfileId(UUID.fromString(deviceProfileIdStr));
            this.checkDeviceProfileId(deviceProfileId, Operation.READ);
        } else {
            deviceProfileId = null;
        }
        return this.attributesService.findAllKeysByDeviceProfileId(this.getTenantId(), deviceProfileId);
    }

    @ApiOperation(value="Create Or Update Device Profile (saveDeviceProfile)", notes="Create or update the Device Profile. When creating device profile, platform generates device profile id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created device profile id will be present in the response. Specify existing device profile id to update the device profile. Referencing non-existing device profile Id will cause 'Not Found' error. \n\nDevice profile name is unique in the scope of tenant. Only one 'default' device profile may exist in scope of tenant.\n\n# Device profile data definition\n\nDevice profile data object contains alarm rules configuration, device provision strategy and transport type configuration for device connectivity. Let's review some examples. First one is the default device profile data configuration and second one - the custom one. \n\n```json\n{\n   \"alarms\":[\n   ],\n   \"configuration\":{\n      \"type\":\"DEFAULT\"\n   },\n   \"provisionConfiguration\":{\n      \"type\":\"DISABLED\",\n      \"provisionDeviceSecret\":null\n   },\n   \"transportConfiguration\":{\n      \"type\":\"DEFAULT\"\n   }\n}\n```\n\n```json\n{\n   \"alarms\":[\n      {\n         \"id\":\"2492b935-1226-59e9-8615-17d8978a4f93\",\n         \"alarmType\":\"Temperature Alarm\",\n         \"clearRule\":{\n            \"schedule\":null,\n            \"condition\":{\n               \"spec\":{\n                  \"type\":\"SIMPLE\"\n               },\n               \"condition\":[\n                  {\n                     \"key\":{\n                        \"key\":\"temperature\",\n                        \"type\":\"TIME_SERIES\"\n                     },\n                     \"value\":null,\n                     \"predicate\":{\n                        \"type\":\"NUMERIC\",\n                        \"value\":{\n                           \"userValue\":null,\n                           \"defaultValue\":30.0,\n                           \"dynamicValue\":null\n                        },\n                        \"operation\":\"LESS\"\n                     },\n                     \"valueType\":\"NUMERIC\"\n                  }\n               ]\n            },\n            \"dashboardId\":null,\n            \"alarmDetails\":null\n         },\n         \"propagate\":false,\n         \"createRules\":{\n            \"MAJOR\":{\n               \"schedule\":{\n                  \"type\":\"SPECIFIC_TIME\",\n                  \"endsOn\":64800000,\n                  \"startsOn\":43200000,\n                  \"timezone\":\"Europe/Kiev\",\n                  \"daysOfWeek\":[\n                     1,\n                     3,\n                     5\n                  ]\n               },\n               \"condition\":{\n                  \"spec\":{\n                     \"type\":\"DURATION\",\n                     \"unit\":\"MINUTES\",\n                     \"predicate\":{\n                        \"userValue\":null,\n                        \"defaultValue\":30,\n                        \"dynamicValue\":null\n                     }\n                  },\n                  \"condition\":[\n                     {\n                        \"key\":{\n                           \"key\":\"temperature\",\n                           \"type\":\"TIME_SERIES\"\n                        },\n                        \"value\":null,\n                        \"predicate\":{\n                           \"type\":\"COMPLEX\",\n                           \"operation\":\"OR\",\n                           \"predicates\":[\n                              {\n                                 \"type\":\"NUMERIC\",\n                                 \"value\":{\n                                    \"userValue\":null,\n                                    \"defaultValue\":50.0,\n                                    \"dynamicValue\":null\n                                 },\n                                 \"operation\":\"LESS_OR_EQUAL\"\n                              },\n                              {\n                                 \"type\":\"NUMERIC\",\n                                 \"value\":{\n                                    \"userValue\":null,\n                                    \"defaultValue\":30.0,\n                                    \"dynamicValue\":null\n                                 },\n                                 \"operation\":\"GREATER\"\n                              }\n                           ]\n                        },\n                        \"valueType\":\"NUMERIC\"\n                     }\n                  ]\n               },\n               \"dashboardId\":null,\n               \"alarmDetails\":null\n            },\n            \"WARNING\":{\n               \"schedule\":{\n                  \"type\":\"CUSTOM\",\n                  \"items\":[\n                     {\n                        \"endsOn\":0,\n                        \"enabled\":false,\n                        \"startsOn\":0,\n                        \"dayOfWeek\":1\n                     },\n                     {\n                        \"endsOn\":64800000,\n                        \"enabled\":true,\n                        \"startsOn\":43200000,\n                        \"dayOfWeek\":2\n                     },\n                     {\n                        \"endsOn\":0,\n                        \"enabled\":false,\n                        \"startsOn\":0,\n                        \"dayOfWeek\":3\n                     },\n                     {\n                        \"endsOn\":57600000,\n                        \"enabled\":true,\n                        \"startsOn\":36000000,\n                        \"dayOfWeek\":4\n                     },\n                     {\n                        \"endsOn\":0,\n                        \"enabled\":false,\n                        \"startsOn\":0,\n                        \"dayOfWeek\":5\n                     },\n                     {\n                        \"endsOn\":0,\n                        \"enabled\":false,\n                        \"startsOn\":0,\n                        \"dayOfWeek\":6\n                     },\n                     {\n                        \"endsOn\":0,\n                        \"enabled\":false,\n                        \"startsOn\":0,\n                        \"dayOfWeek\":7\n                     }\n                  ],\n                  \"timezone\":\"Europe/Kiev\"\n               },\n               \"condition\":{\n                  \"spec\":{\n                     \"type\":\"REPEATING\",\n                     \"predicate\":{\n                        \"userValue\":null,\n                        \"defaultValue\":5,\n                        \"dynamicValue\":null\n                     }\n                  },\n                  \"condition\":[\n                     {\n                        \"key\":{\n                           \"key\":\"tempConstant\",\n                           \"type\":\"CONSTANT\"\n                        },\n                        \"value\":30,\n                        \"predicate\":{\n                           \"type\":\"NUMERIC\",\n                           \"value\":{\n                              \"userValue\":null,\n                              \"defaultValue\":0.0,\n                              \"dynamicValue\":{\n                                 \"inherit\":false,\n                                 \"sourceType\":\"CURRENT_DEVICE\",\n                                 \"sourceAttribute\":\"tempThreshold\"\n                              }\n                           },\n                           \"operation\":\"EQUAL\"\n                        },\n                        \"valueType\":\"NUMERIC\"\n                     }\n                  ]\n               },\n               \"dashboardId\":null,\n               \"alarmDetails\":null\n            },\n            \"CRITICAL\":{\n               \"schedule\":null,\n               \"condition\":{\n                  \"spec\":{\n                     \"type\":\"SIMPLE\"\n                  },\n                  \"condition\":[\n                     {\n                        \"key\":{\n                           \"key\":\"temperature\",\n                           \"type\":\"TIME_SERIES\"\n                        },\n                        \"value\":null,\n                        \"predicate\":{\n                           \"type\":\"NUMERIC\",\n                           \"value\":{\n                              \"userValue\":null,\n                              \"defaultValue\":50.0,\n                              \"dynamicValue\":null\n                           },\n                           \"operation\":\"GREATER\"\n                        },\n                        \"valueType\":\"NUMERIC\"\n                     }\n                  ]\n               },\n               \"dashboardId\":null,\n               \"alarmDetails\":null\n            }\n         },\n         \"propagateRelationTypes\":null\n      }\n   ],\n   \"configuration\":{\n      \"type\":\"DEFAULT\"\n   },\n   \"provisionConfiguration\":{\n      \"type\":\"ALLOW_CREATE_NEW_DEVICES\",\n      \"provisionDeviceSecret\":\"vaxb9hzqdbz3oqukvomg\"\n   },\n   \"transportConfiguration\":{\n      \"type\":\"MQTT\",\n      \"deviceTelemetryTopic\":\"v1/devices/me/telemetry\",\n      \"deviceAttributesTopic\":\"v1/devices/me/attributes\",\n      \"transportPayloadTypeConfiguration\":{\n         \"transportPayloadType\":\"PROTOBUF\",\n         \"deviceTelemetryProtoSchema\":\"syntax =\\\"proto3\\\";\\npackage telemetry;\\n\\nmessage SensorDataReading {\\n\\n  optional double temperature = 1;\\n  optional double humidity = 2;\\n  InnerObject innerObject = 3;\\n\\n  message InnerObject {\\n    optional string key1 = 1;\\n    optional bool key2 = 2;\\n    optional double key3 = 3;\\n    optional int32 key4 = 4;\\n    optional string key5 = 5;\\n  }\\n}\",\n         \"deviceAttributesProtoSchema\":\"syntax =\\\"proto3\\\";\\npackage attributes;\\n\\nmessage SensorConfiguration {\\n  optional string firmwareVersion = 1;\\n  optional string serialNumber = 2;\\n}\",\n         \"deviceRpcRequestProtoSchema\":\"syntax =\\\"proto3\\\";\\npackage rpc;\\n\\nmessage RpcRequestMsg {\\n  optional string method = 1;\\n  optional int32 requestId = 2;\\n  optional string params = 3;\\n}\",\n         \"deviceRpcResponseProtoSchema\":\"syntax =\\\"proto3\\\";\\npackage rpc;\\n\\nmessage RpcResponseMsg {\\n  optional string payload = 1;\\n}\"\n      }\n   }\n}\n```\n\nLet's review some specific objects examples related to the device profile configuration:\n\n# Alarm Schedule\n\nAlarm Schedule JSON object represents the time interval during which the alarm rule is active. Note, \n\n```json\n\"schedule\": null\n```\n\nmeans alarm rule is active all the time. **'daysOfWeek'** field represents Monday as 1, Tuesday as 2 and so on. **'startsOn'** and **'endsOn'** fields represent hours in millis (e.g. 64800000 = 18:00 or 6pm). **'enabled'** flag specifies if item in a custom rule is active for specific day of the week:\n\n## Specific Time Schedule\n\n```json\n{\n   \"schedule\":{\n      \"type\":\"SPECIFIC_TIME\",\n      \"endsOn\":64800000,\n      \"startsOn\":43200000,\n      \"timezone\":\"Europe/Kiev\",\n      \"daysOfWeek\":[\n         1,\n         3,\n         5\n      ]\n   }\n}\n```\n\n## Custom Schedule\n\n```json\n{\n   \"schedule\":{\n      \"type\":\"CUSTOM\",\n      \"items\":[\n         {\n            \"endsOn\":0,\n            \"enabled\":false,\n            \"startsOn\":0,\n            \"dayOfWeek\":1\n         },\n         {\n            \"endsOn\":64800000,\n            \"enabled\":true,\n            \"startsOn\":43200000,\n            \"dayOfWeek\":2\n         },\n         {\n            \"endsOn\":0,\n            \"enabled\":false,\n            \"startsOn\":0,\n            \"dayOfWeek\":3\n         },\n         {\n            \"endsOn\":57600000,\n            \"enabled\":true,\n            \"startsOn\":36000000,\n            \"dayOfWeek\":4\n         },\n         {\n            \"endsOn\":0,\n            \"enabled\":false,\n            \"startsOn\":0,\n            \"dayOfWeek\":5\n         },\n         {\n            \"endsOn\":0,\n            \"enabled\":false,\n            \"startsOn\":0,\n            \"dayOfWeek\":6\n         },\n         {\n            \"endsOn\":0,\n            \"enabled\":false,\n            \"startsOn\":0,\n            \"dayOfWeek\":7\n         }\n      ],\n      \"timezone\":\"Europe/Kiev\"\n   }\n}\n```\n\n# Alarm condition type (**'spec'**)\n\nAlarm condition type can be either simple, duration, or repeating. For example, 5 times in a row or during 5 minutes.\n\nNote, **'userValue'** field is not used and reserved for future usage, **'dynamicValue'** is used for condition appliance by using the value of the **'sourceAttribute'** or else **'defaultValue'** is used (if **'sourceAttribute'** is absent).\n\n**'sourceType'** of the **'sourceAttribute'** can be: \n * 'CURRENT_DEVICE';\n * 'CURRENT_CUSTOMER';\n * 'CURRENT_TENANT'.\n\n**'sourceAttribute'** can be inherited from the owner if **'inherit'** is set to true (for CURRENT_DEVICE and CURRENT_CUSTOMER).\n\n## Repeating alarm condition\n\n```json\n{\n   \"spec\":{\n      \"type\":\"REPEATING\",\n      \"predicate\":{\n         \"userValue\":null,\n         \"defaultValue\":5,\n         \"dynamicValue\":{\n            \"inherit\":true,\n            \"sourceType\":\"CURRENT_DEVICE\",\n            \"sourceAttribute\":\"tempAttr\"\n         }\n      }\n   }\n}\n```\n\n## Duration alarm condition\n\n```json\n{\n   \"spec\":{\n      \"type\":\"DURATION\",\n      \"unit\":\"MINUTES\",\n      \"predicate\":{\n         \"userValue\":null,\n         \"defaultValue\":30,\n         \"dynamicValue\":null\n      }\n   }\n}\n```\n\n**'unit'** can be: \n * 'SECONDS';\n * 'MINUTES';\n * 'HOURS';\n * 'DAYS'.\n\n# Key Filters\n\nKey filter objects are created under the **'condition'** array. They allow you to define complex logical expressions over entity field, attribute, latest time series value or constant. The filter is defined using 'key', 'valueType', 'value' (refers to the value of the 'CONSTANT' alarm filter key type) and 'predicate' objects. Let's review each object:\n\n## Alarm Filter Key\n\nFilter Key defines either entity field, attribute, telemetry or constant. It is a JSON object that consists the key name and type. The following filter key types are supported:\n * 'ATTRIBUTE' - used for attributes values;\n * 'TIME_SERIES' - used for time series values;\n * 'ENTITY_FIELD' - used for accessing entity fields like 'name', 'label', etc. The list of available fields depends on the entity type;\n * 'CONSTANT' - constant value specified.\n\nLet's review the example:\n\n```json\n{\n  \"type\": \"TIME_SERIES\",\n  \"key\": \"temperature\"\n}\n```\n\n## Value Type and Operations\n\nProvides a hint about the data type of the entity field that is defined in the filter key. The value type impacts the list of possible operations that you may use in the corresponding predicate. For example, you may use 'STARTS_WITH' or 'END_WITH', but you can't use 'GREATER_OR_EQUAL' for string values.The following filter value types and corresponding predicate operations are supported: \n\n * 'STRING' - used to filter any 'String' or 'JSON' values. Operations: EQUAL, NOT_EQUAL, STARTS_WITH, ENDS_WITH, CONTAINS, NOT_CONTAINS; \n * 'NUMERIC' - used for 'Long' and 'Double' values. Operations: EQUAL, NOT_EQUAL, GREATER, LESS, GREATER_OR_EQUAL, LESS_OR_EQUAL; \n * 'BOOLEAN' - used for boolean values. Operations: EQUAL, NOT_EQUAL;\n * 'DATE_TIME' - similar to numeric, transforms value to milliseconds since epoch. Operations: EQUAL, NOT_EQUAL, GREATER, LESS, GREATER_OR_EQUAL, LESS_OR_EQUAL; \n\n\n\n\n## Filter Predicate\n\nFilter Predicate defines the logical expression to evaluate. The list of available operations depends on the filter value type, see above. Platform supports 4 predicate types: 'STRING', 'NUMERIC', 'BOOLEAN' and 'COMPLEX'. The last one allows to combine multiple operations over one filter key.\n\nSimple predicate example to check 'value < 100': \n\n```json\n{\n  \"operation\": \"LESS\",\n  \"value\": {\n    \"userValue\": null,\n    \"defaultValue\": 100,\n    \"dynamicValue\": null\n  },\n  \"type\": \"NUMERIC\"\n}\n```\n\nComplex predicate example, to check 'value < 10 or value > 20': \n\n```json\n{\n  \"type\": \"COMPLEX\",\n  \"operation\": \"OR\",\n  \"predicates\": [\n    {\n      \"operation\": \"LESS\",\n      \"value\": {\n        \"userValue\": null,\n        \"defaultValue\": 10,\n        \"dynamicValue\": null\n      },\n      \"type\": \"NUMERIC\"\n    },\n    {\n      \"operation\": \"GREATER\",\n      \"value\": {\n        \"userValue\": null,\n        \"defaultValue\": 20,\n        \"dynamicValue\": null\n      },\n      \"type\": \"NUMERIC\"\n    }\n  ]\n}\n```\n\nMore complex predicate example, to check 'value < 10 or (value > 50 && value < 60)': \n\n```json\n{\n  \"type\": \"COMPLEX\",\n  \"operation\": \"OR\",\n  \"predicates\": [\n    {\n      \"operation\": \"LESS\",\n      \"value\": {\n        \"userValue\": null,\n        \"defaultValue\": 10,\n        \"dynamicValue\": null\n      },\n      \"type\": \"NUMERIC\"\n    },\n    {\n      \"type\": \"COMPLEX\",\n      \"operation\": \"AND\",\n      \"predicates\": [\n        {\n          \"operation\": \"GREATER\",\n          \"value\": {\n            \"userValue\": null,\n            \"defaultValue\": 50,\n            \"dynamicValue\": null\n          },\n          \"type\": \"NUMERIC\"\n        },\n        {\n          \"operation\": \"LESS\",\n          \"value\": {\n            \"userValue\": null,\n            \"defaultValue\": 60,\n            \"dynamicValue\": null\n          },\n          \"type\": \"NUMERIC\"\n        }\n      ]\n    }\n  ]\n}\n```\n\nYou may also want to replace hardcoded values (for example, temperature > 20) with the more dynamic expression (for example, temperature > value of the tenant attribute with key 'temperatureThreshold'). It is possible to use 'dynamicValue' to define attribute of the tenant, customer or device. See example below:\n\n```json\n{\n  \"operation\": \"GREATER\",\n  \"value\": {\n    \"userValue\": null,\n    \"defaultValue\": 0,\n    \"dynamicValue\": {\n      \"inherit\": false,\n      \"sourceType\": \"CURRENT_TENANT\",\n      \"sourceAttribute\": \"temperatureThreshold\"\n    }\n  },\n  \"type\": \"NUMERIC\"\n}\n```\n\nNote that you may use 'CURRENT_DEVICE', 'CURRENT_CUSTOMER' and 'CURRENT_TENANT' as a 'sourceType'. The 'defaultValue' is used when the attribute with such a name is not defined for the chosen source. The 'sourceAttribute' can be inherited from the owner of the specified 'sourceType' if 'inherit' is set to true.\n\n# Provision Configuration\n\nThere are 3 types of device provision configuration for the device profile: \n * 'DISABLED';\n * 'ALLOW_CREATE_NEW_DEVICES';\n * 'CHECK_PRE_PROVISIONED_DEVICES'.\n\nPlease refer to the [docs](https://thingsboard.io/docs/user-guide/device-provisioning/) for more details.\n\n# Transport Configuration\n\n5 transport configuration types are available:\n * 'DEFAULT';\n * 'MQTT';\n * 'LWM2M';\n * 'COAP';\n * 'SNMP'.\n\nDefault type supports basic MQTT, HTTP, CoAP and LwM2M transports. Please refer to the [docs](https://thingsboard.io/docs/user-guide/device-profiles/#transport-configuration) for more details about other types.\n\nSee another example of COAP transport configuration below:\n\n```json\n{\n   \"type\":\"COAP\",\n   \"clientSettings\":{\n      \"edrxCycle\":null,\n      \"powerMode\":\"DRX\",\n      \"psmActivityTimer\":null,\n      \"pagingTransmissionWindow\":null\n   },\n   \"coapDeviceTypeConfiguration\":{\n      \"coapDeviceType\":\"DEFAULT\",\n      \"transportPayloadTypeConfiguration\":{\n         \"transportPayloadType\":\"JSON\"\n      }\n   }\n}\n```Remove 'id', 'tenantId' from the request body example (below) to create new Device Profile entity. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/deviceProfile"}, method={RequestMethod.POST})
    @ResponseBody
    public DeviceProfile saveDeviceProfile(@Parameter(description="A JSON value representing the device profile.") @RequestBody DeviceProfile deviceProfile) throws Exception {
        deviceProfile.setTenantId(this.getTenantId());
        this.checkEntity(deviceProfile.getId(), deviceProfile, Resource.DEVICE_PROFILE);
        return this.tbDeviceProfileService.save(deviceProfile, this.getCurrentUser());
    }

    @ApiOperation(value="Delete device profile (deleteDeviceProfile)", notes="Deletes the device profile. Referencing non-existing device profile Id will cause an error. Can't delete the device profile if it is referenced by existing devices.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/deviceProfile/{deviceProfileId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteDeviceProfile(@Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceProfileId") String strDeviceProfileId) throws ThingsboardException {
        this.checkParameter("deviceProfileId", strDeviceProfileId);
        DeviceProfileId deviceProfileId = new DeviceProfileId(this.toUUID(strDeviceProfileId));
        DeviceProfile deviceProfile = this.checkDeviceProfileId(deviceProfileId, Operation.DELETE);
        this.tbDeviceProfileService.delete(deviceProfile, this.getCurrentUser());
    }

    @ApiOperation(value="Make Device Profile Default (setDefaultDeviceProfile)", notes="Marks device profile as default within a tenant scope.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/deviceProfile/{deviceProfileId}/default"}, method={RequestMethod.POST})
    @ResponseBody
    public DeviceProfile setDefaultDeviceProfile(@Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceProfileId") String strDeviceProfileId) throws ThingsboardException {
        this.checkParameter("deviceProfileId", strDeviceProfileId);
        DeviceProfileId deviceProfileId = new DeviceProfileId(this.toUUID(strDeviceProfileId));
        DeviceProfile deviceProfile = this.checkDeviceProfileId(deviceProfileId, Operation.WRITE);
        DeviceProfile previousDefaultDeviceProfile = this.deviceProfileService.findDefaultDeviceProfile(this.getTenantId());
        return this.tbDeviceProfileService.setDefaultDeviceProfile(deviceProfile, previousDefaultDeviceProfile, this.getCurrentUser());
    }

    @ApiOperation(value="Get Device Profiles (getDeviceProfiles)", notes="Returns a page of devices profile objects owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/deviceProfiles"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<DeviceProfile> getDeviceProfiles(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the device profile name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "transportType", "description", "isDefault"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.checkNotNull(this.deviceProfileService.findDeviceProfiles(this.getTenantId(), pageLink));
    }

    @ApiOperation(value="Get Device Profiles for transport type (getDeviceProfileInfos)", notes="Returns a page of devices profile info objects owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. Device Profile Info is a lightweight object that includes main information about Device Profile excluding the heavyweight configuration object. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/deviceProfileInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<DeviceProfileInfo> getDeviceProfileInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the device profile name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "transportType", "description", "isDefault"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Type of the transport", schema=@Schema(allowableValues={"DEFAULT", "MQTT", "COAP", "LWM2M", "SNMP"})) @RequestParam(required=false) String transportType) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.checkNotNull(this.deviceProfileService.findDeviceProfileInfos(this.getTenantId(), pageLink, transportType));
    }

    @ApiOperation(value="Get Device Profile names (getDeviceProfileNames)", notes="Returns a set of unique device profile names owned by the tenant.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/deviceProfile/names"}, method={RequestMethod.GET})
    @ResponseBody
    public List<EntityInfo> getDeviceProfileNames(@Parameter(description="Flag indicating whether to retrieve exclusively the names of device profiles that are referenced by tenant's devices.") @RequestParam(value="activeOnly", required=false, defaultValue="false") boolean activeOnly) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        return this.checkNotNull(this.deviceProfileService.findDeviceProfileNamesByTenantId(tenantId, activeOnly));
    }

    @ConstructorProperties(value={"tbDeviceProfileService", "imageService"})
    @Generated
    public DeviceProfileController(TbDeviceProfileService tbDeviceProfileService, ImageService imageService) {
        this.tbDeviceProfileService = tbDeviceProfileService;
        this.imageService = imageService;
    }
}

