/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URISyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.device.DeviceConnectivityService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class DeviceConnectivityController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceConnectivityController.class);
    private final DeviceConnectivityService deviceConnectivityService;
    private final SystemSecurityService systemSecurityService;

    @ApiOperation(value="Get commands to publish device telemetry (getDevicePublishTelemetryCommands)", notes="Fetch the list of commands to publish device telemetry based on device profile If the user has the authority of 'Tenant Administrator', the server checks that the device is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the device is assigned to the same customer. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", examples={@ExampleObject(name="http", value="curl -v -X POST http://localhost:8080/api/v1/0ySs4FTOn5WU15XLmal8/telemetry --header Content-Type:application/json --data {temperature:25}"), @ExampleObject(name="mqtt", value="mosquitto_pub -d -q 1 -h localhost -t v1/devices/me/telemetry -i myClient1 -u myUsername1 -P myPassword -m {temperature:25}"), @ExampleObject(name="coap", value="coap-client -m POST coap://localhost:5683/api/v1/0ySs4FTOn5WU15XLmal8/telemetry -t json -e {temperature:25}")})})})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device-connectivity/{deviceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonNode getDevicePublishTelemetryCommands(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String strDeviceId, HttpServletRequest request) throws ThingsboardException, URISyntaxException {
        this.checkParameter("deviceId", strDeviceId);
        DeviceId deviceId = new DeviceId(this.toUUID(strDeviceId));
        Device device = this.checkDeviceId(deviceId, Operation.READ_CREDENTIALS);
        String baseUrl = this.systemSecurityService.getBaseUrl(this.getTenantId(), this.getCurrentUser().getCustomerId(), request);
        return this.deviceConnectivityService.findDevicePublishTelemetryCommands(baseUrl, device);
    }

    @ApiOperation(value="Download server certificate using file path defined in device.connectivity properties (downloadServerCertificate)", notes="Download server certificate.")
    @RequestMapping(value={"/device-connectivity/{protocol}/certificate/download"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Resource> downloadServerCertificate(@Parameter(description="A string value representing the device connectivity protocol. Possible values: 'mqtt', 'mqtts', 'http', 'https', 'coap', 'coaps'") @PathVariable(value="protocol") String protocol) throws ThingsboardException, IOException {
        this.checkParameter("protocol", protocol);
        Resource pemCert = this.checkNotNull(this.deviceConnectivityService.getPemCertFile(protocol), protocol + " pem cert file is not found!");
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=ca-root.pem"})).header("x-filename", new String[]{"ca-root.pem"})).contentLength(pemCert.contentLength()).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)pemCert);
    }

    @ApiOperation(value="Download generated docker-compose.yml file for gateway (downloadGatewayDockerCompose)", notes="Download generated docker-compose.yml for gateway.")
    @RequestMapping(value={"/device-connectivity/gateway-launch/{deviceId}/docker-compose/download"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Resource> downloadGatewayDockerCompose(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String strDeviceId, HttpServletRequest request) throws ThingsboardException, URISyntaxException, IOException {
        this.checkParameter("deviceId", strDeviceId);
        DeviceId deviceId = new DeviceId(this.toUUID(strDeviceId));
        Device device = this.checkDeviceId(deviceId, Operation.READ_CREDENTIALS);
        if (!DeviceConnectivityController.checkIsGateway(device)) {
            throw new ThingsboardException("The device must be a gateway!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        String baseUrl = this.systemSecurityService.getBaseUrl(this.getTenantId(), this.getCurrentUser().getCustomerId(), request);
        Resource dockerCompose = this.checkNotNull(this.deviceConnectivityService.createGatewayDockerComposeFile(baseUrl, device), "Failed to create docker-compose.yml file!");
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=docker-compose.yml"})).header("x-filename", new String[]{"docker-compose.yml"})).contentLength(dockerCompose.contentLength()).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)dockerCompose);
    }

    private static boolean checkIsGateway(Device device) {
        return device.getAdditionalInfo().has("gateway") && device.getAdditionalInfo().get("gateway").asBoolean();
    }

    @ConstructorProperties(value={"deviceConnectivityService", "systemSecurityService"})
    @Generated
    public DeviceConnectivityController(DeviceConnectivityService deviceConnectivityService, SystemSecurityService systemSecurityService) {
        this.deviceConnectivityService = deviceConnectivityService;
        this.systemSecurityService = systemSecurityService;
    }
}

