/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmQueryV2;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class AlarmController
extends BaseController {
    private final TbAlarmService tbAlarmService;
    public static final String ALARM_ID = "alarmId";
    private static final String ALARM_SECURITY_CHECK = "If the user has the authority of 'Tenant Administrator', the server checks that the originator of alarm is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the originator of alarm belongs to the customer. ";
    private static final String ALARM_QUERY_SEARCH_STATUS_DESCRIPTION = "A string value representing one of the AlarmSearchStatus enumeration value";
    private static final String ALARM_QUERY_SEARCH_STATUS_ARRAY_DESCRIPTION = "A list of string values separated by comma ',' representing one of the AlarmSearchStatus enumeration value";
    private static final String ALARM_QUERY_STATUS_DESCRIPTION = "A string value representing one of the AlarmStatus enumeration value";
    private static final String ALARM_QUERY_SEVERITY_ARRAY_DESCRIPTION = "A list of string values separated by comma ',' representing one of the AlarmSeverity enumeration value";
    private static final String ALARM_QUERY_TYPE_ARRAY_DESCRIPTION = "A list of string values separated by comma ',' representing alarm types";
    private static final String ALARM_QUERY_ASSIGNEE_DESCRIPTION = "A string value representing the assignee user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'";
    private static final String ALARM_QUERY_TEXT_SEARCH_DESCRIPTION = "The case insensitive 'substring' filter based on of next alarm fields: type, severity or status";
    private static final String ALARM_QUERY_START_TIME_DESCRIPTION = "The start timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.";
    private static final String ALARM_QUERY_END_TIME_DESCRIPTION = "The end timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.";
    private static final String ALARM_QUERY_FETCH_ORIGINATOR_DESCRIPTION = "A boolean value to specify if the alarm originator name will be filled in the AlarmInfo object  field: 'originatorName' or will returns as null.";

    @ApiOperation(value="Get Alarm (getAlarmById)", notes="Fetch the Alarm object based on the provided Alarm Id. If the user has the authority of 'Tenant Administrator', the server checks that the originator of alarm is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the originator of alarm belongs to the customer. ")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/alarm/{alarmId}"})
    public Alarm getAlarmById(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId) throws ThingsboardException {
        this.checkParameter(ALARM_ID, strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        return this.checkAlarmId(alarmId, Operation.READ);
    }

    @ApiOperation(value="Get Alarm Info (getAlarmInfoById)", notes="Fetch the Alarm Info object based on the provided Alarm Id. If the user has the authority of 'Tenant Administrator', the server checks that the originator of alarm is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the originator of alarm belongs to the customer. Alarm Info is an extension of the default Alarm object that also contains name of the alarm originator.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/alarm/info/{alarmId}"})
    public AlarmInfo getAlarmInfoById(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId) throws ThingsboardException {
        this.checkParameter(ALARM_ID, strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        return this.checkAlarmInfoId(alarmId, Operation.READ);
    }

    @ApiOperation(value="Create or Update Alarm (saveAlarm)", notes="Creates or Updates the Alarm. When creating alarm, platform generates Alarm Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Alarm id will be present in the response. Specify existing Alarm id to update the alarm. Referencing non-existing Alarm Id will cause 'Not Found' error. \n\nPlatform also deduplicate the alarms based on the entity id of originator and alarm 'type'. For example, if the user or system component create the alarm with the type 'HighTemperature' for device 'Device A' the new active alarm is created. If the user tries to create 'HighTemperature' alarm for the same device again, the previous alarm will be updated (the 'end_ts' will be set to current timestamp). If the user clears the alarm (see 'Clear Alarm(clearAlarm)'), than new alarm with the same type and same device may be created. Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Alarm entity. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/alarm"})
    public Alarm saveAlarm(@RequestBody(description="A JSON value representing the alarm.") @org.springframework.web.bind.annotation.RequestBody Alarm alarm) throws ThingsboardException {
        alarm.setTenantId(this.getTenantId());
        this.checkNotNull(alarm.getOriginator());
        this.checkEntity(alarm.getId(), alarm, Resource.ALARM);
        this.checkEntityId(alarm.getOriginator(), Operation.READ);
        if (alarm.getAssigneeId() != null) {
            this.checkUserId(alarm.getAssigneeId(), Operation.READ);
        }
        return this.tbAlarmService.save(alarm, this.getCurrentUser());
    }

    @ApiOperation(value="Delete Alarm (deleteAlarm)", notes="Deletes the Alarm. Referencing non-existing Alarm Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/alarm/{alarmId}"})
    public boolean deleteAlarm(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId) throws ThingsboardException {
        this.checkParameter(ALARM_ID, strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        Alarm alarm = this.checkAlarmId(alarmId, Operation.DELETE);
        return this.tbAlarmService.delete(alarm, this.getCurrentUser());
    }

    @ApiOperation(value="Acknowledge Alarm (ackAlarm)", notes="Acknowledge the Alarm. Once acknowledged, the 'ack_ts' field will be set to current timestamp and special rule chain event 'ALARM_ACK' will be generated. Referencing non-existing Alarm Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/alarm/{alarmId}/ack"})
    @ResponseStatus(value=HttpStatus.OK)
    public AlarmInfo ackAlarm(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId) throws Exception {
        this.checkParameter(ALARM_ID, strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        Alarm alarm = this.checkAlarmId(alarmId, Operation.WRITE);
        return this.tbAlarmService.ack(alarm, this.getCurrentUser());
    }

    @ApiOperation(value="Clear Alarm (clearAlarm)", notes="Clear the Alarm. Once cleared, the 'clear_ts' field will be set to current timestamp and special rule chain event 'ALARM_CLEAR' will be generated. Referencing non-existing Alarm Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/alarm/{alarmId}/clear"})
    @ResponseStatus(value=HttpStatus.OK)
    public AlarmInfo clearAlarm(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId) throws Exception {
        this.checkParameter(ALARM_ID, strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        Alarm alarm = this.checkAlarmId(alarmId, Operation.WRITE);
        return this.tbAlarmService.clear(alarm, this.getCurrentUser());
    }

    @ApiOperation(value="Assign/Reassign Alarm (assignAlarm)", notes="Assign the Alarm. Once assigned, the 'assign_ts' field will be set to current timestamp and special rule chain event 'ALARM_ASSIGNED' (or ALARM_REASSIGNED in case of assigning already assigned alarm) will be generated. Referencing non-existing Alarm Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/alarm/{alarmId}/assign/{assigneeId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public Alarm assignAlarm(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId, @Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assigneeId") String strAssigneeId) throws Exception {
        this.checkParameter(ALARM_ID, strAlarmId);
        this.checkParameter("assigneeId", strAssigneeId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        Alarm alarm = this.checkAlarmId(alarmId, Operation.WRITE);
        UserId assigneeId = new UserId(UUID.fromString(strAssigneeId));
        this.checkUserId(assigneeId, Operation.READ);
        return this.tbAlarmService.assign(alarm, assigneeId, System.currentTimeMillis(), this.getCurrentUser());
    }

    @ApiOperation(value="Unassign Alarm (unassignAlarm)", notes="Unassign the Alarm. Once unassigned, the 'assign_ts' field will be set to current timestamp and special rule chain event 'ALARM_UNASSIGNED' will be generated. Referencing non-existing Alarm Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/alarm/{alarmId}/assign"})
    @ResponseStatus(value=HttpStatus.OK)
    public Alarm unassignAlarm(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId) throws Exception {
        this.checkParameter(ALARM_ID, strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        Alarm alarm = this.checkAlarmId(alarmId, Operation.WRITE);
        return this.tbAlarmService.unassign(alarm, System.currentTimeMillis(), this.getCurrentUser());
    }

    @ApiOperation(value="Get Alarms (getAlarms)", notes="Returns a page of alarms for the selected entity. Specifying both parameters 'searchStatus' and 'status' at the same time will cause an error. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/alarm/{entityType}/{entityId}"})
    public PageData<AlarmInfo> getAlarms(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="A string value representing one of the AlarmSearchStatus enumeration value", schema=@Schema(allowableValues={"ANY", "ACTIVE", "CLEARED", "ACK", "UNACK"})) @RequestParam(required=false) String searchStatus, @Parameter(description="A string value representing one of the AlarmStatus enumeration value", schema=@Schema(allowableValues={"ACTIVE_UNACK", "ACTIVE_ACK", "CLEARED_UNACK", "CLEARED_ACK"})) @RequestParam(required=false) String status, @Parameter(description="A string value representing the assignee user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assigneeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on of next alarm fields: type, severity or status") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "startTs", "endTs", "type", "ackTs", "clearTs", "severity", "status"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.") @RequestParam(required=false) Long endTime, @Parameter(description="A boolean value to specify if the alarm originator name will be filled in the AlarmInfo object  field: 'originatorName' or will returns as null.") @RequestParam(required=false) Boolean fetchOriginator) throws ThingsboardException {
        AlarmStatus alarmStatus;
        this.checkParameter("EntityId", strEntityId);
        this.checkParameter("EntityType", strEntityType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId);
        AlarmSearchStatus alarmSearchStatus = StringUtils.isEmpty((String)searchStatus) ? null : AlarmSearchStatus.valueOf((String)searchStatus);
        AlarmStatus alarmStatus2 = alarmStatus = StringUtils.isEmpty((String)status) ? null : AlarmStatus.valueOf((String)status);
        if (alarmSearchStatus != null && alarmStatus != null) {
            throw new ThingsboardException("Invalid alarms search query: Both parameters 'searchStatus' and 'status' can't be specified at the same time!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.checkEntityId(entityId, Operation.READ);
        UserId assigneeUserId = null;
        if (assigneeId != null) {
            assigneeUserId = new UserId(UUID.fromString(assigneeId));
        }
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        return this.checkNotNull(this.alarmService.findAlarms(this.getCurrentUser().getTenantId(), new AlarmQuery(entityId, pageLink, alarmSearchStatus, alarmStatus, assigneeUserId, fetchOriginator)));
    }

    @ApiOperation(value="Get All Alarms (getAllAlarms)", notes="Returns a page of alarms that belongs to the current user owner. If the user has the authority of 'Tenant Administrator', the server returns alarms that belongs to the tenant of current user. If the user has the authority of 'Customer User', the server returns alarms that belongs to the customer of current user. Specifying both parameters 'searchStatus' and 'status' at the same time will cause an error. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/alarms"})
    public PageData<AlarmInfo> getAllAlarms(@Parameter(description="A string value representing one of the AlarmSearchStatus enumeration value", schema=@Schema(allowableValues={"ANY", "ACTIVE", "CLEARED", "ACK", "UNACK"})) @RequestParam(required=false) String searchStatus, @Parameter(description="A string value representing one of the AlarmStatus enumeration value", schema=@Schema(allowableValues={"ACTIVE_UNACK", "ACTIVE_ACK", "CLEARED_UNACK", "CLEARED_ACK"})) @RequestParam(required=false) String status, @Parameter(description="A string value representing the assignee user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assigneeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on of next alarm fields: type, severity or status") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "startTs", "endTs", "type", "ackTs", "clearTs", "severity", "status"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.") @RequestParam(required=false) Long endTime, @Parameter(description="A boolean value to specify if the alarm originator name will be filled in the AlarmInfo object  field: 'originatorName' or will returns as null.") @RequestParam(required=false) Boolean fetchOriginator) throws ThingsboardException {
        AlarmStatus alarmStatus;
        AlarmSearchStatus alarmSearchStatus = StringUtils.isEmpty((String)searchStatus) ? null : AlarmSearchStatus.valueOf((String)searchStatus);
        AlarmStatus alarmStatus2 = alarmStatus = StringUtils.isEmpty((String)status) ? null : AlarmStatus.valueOf((String)status);
        if (alarmSearchStatus != null && alarmStatus != null) {
            throw new ThingsboardException("Invalid alarms search query: Both parameters 'searchStatus' and 'status' can't be specified at the same time!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        UserId assigneeUserId = null;
        if (assigneeId != null) {
            assigneeUserId = new UserId(UUID.fromString(assigneeId));
        }
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        if (this.getCurrentUser().isCustomerUser()) {
            return this.checkNotNull(this.alarmService.findCustomerAlarms(this.getCurrentUser().getTenantId(), this.getCurrentUser().getCustomerId(), new AlarmQuery(null, pageLink, alarmSearchStatus, alarmStatus, assigneeUserId, fetchOriginator)));
        }
        return this.checkNotNull(this.alarmService.findAlarms(this.getCurrentUser().getTenantId(), new AlarmQuery(null, pageLink, alarmSearchStatus, alarmStatus, assigneeUserId, fetchOriginator)));
    }

    @ApiOperation(value="Get Alarms (getAlarmsV2)", notes="Returns a page of alarms for the selected entity. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/v2/alarm/{entityType}/{entityId}"})
    public PageData<AlarmInfo> getAlarmsV2(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="A list of string values separated by comma ',' representing one of the AlarmSearchStatus enumeration value", array=@ArraySchema(schema=@Schema(type="string", allowableValues={"ANY", "ACTIVE", "CLEARED", "ACK", "UNACK"}))) @RequestParam(required=false) String[] statusList, @Parameter(description="A list of string values separated by comma ',' representing one of the AlarmSeverity enumeration value", array=@ArraySchema(schema=@Schema(type="string", allowableValues={"CRITICAL", "MAJOR", "MINOR", "WARNING", "INDETERMINATE"}))) @RequestParam(required=false) String[] severityList, @Parameter(description="A list of string values separated by comma ',' representing alarm types", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(required=false) String[] typeList, @Parameter(description="A string value representing the assignee user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assigneeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on of next alarm fields: type, severity or status") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "startTs", "endTs", "type", "ackTs", "clearTs", "severity", "status"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        this.checkParameter("EntityId", strEntityId);
        this.checkParameter("EntityType", strEntityType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId);
        this.checkEntityId(entityId, Operation.READ);
        ArrayList<AlarmSearchStatus> alarmStatusList = new ArrayList<AlarmSearchStatus>();
        if (statusList != null) {
            for (String strStatus : statusList) {
                if (StringUtils.isEmpty((String)strStatus)) continue;
                alarmStatusList.add(AlarmSearchStatus.valueOf((String)strStatus));
            }
        }
        ArrayList<AlarmSeverity> alarmSeverityList = new ArrayList<AlarmSeverity>();
        if (severityList != null) {
            for (String strSeverity : severityList) {
                if (StringUtils.isEmpty((String)strSeverity)) continue;
                alarmSeverityList.add(AlarmSeverity.valueOf((String)strSeverity));
            }
        }
        List<Object> alarmTypeList = typeList != null ? Arrays.asList(typeList) : Collections.emptyList();
        UserId assigneeUserId = null;
        if (assigneeId != null) {
            assigneeUserId = new UserId(UUID.fromString(assigneeId));
        }
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        return this.checkNotNull(this.alarmService.findAlarmsV2(this.getCurrentUser().getTenantId(), new AlarmQueryV2(entityId, pageLink, alarmTypeList, alarmStatusList, alarmSeverityList, assigneeUserId)));
    }

    @ApiOperation(value="Get All Alarms (getAllAlarmsV2)", notes="Returns a page of alarms that belongs to the current user owner. If the user has the authority of 'Tenant Administrator', the server returns alarms that belongs to the tenant of current user. If the user has the authority of 'Customer User', the server returns alarms that belongs to the customer of current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/v2/alarms"})
    public PageData<AlarmInfo> getAllAlarmsV2(@Parameter(description="A list of string values separated by comma ',' representing one of the AlarmSearchStatus enumeration value", array=@ArraySchema(schema=@Schema(type="string", allowableValues={"ANY", "ACTIVE", "CLEARED", "ACK", "UNACK"}))) @RequestParam(required=false) String[] statusList, @Parameter(description="A list of string values separated by comma ',' representing one of the AlarmSeverity enumeration value", array=@ArraySchema(schema=@Schema(type="string", allowableValues={"CRITICAL", "MAJOR", "MINOR", "WARNING", "INDETERMINATE"}))) @RequestParam(required=false) String[] severityList, @Parameter(description="A list of string values separated by comma ',' representing alarm types", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(required=false) String[] typeList, @Parameter(description="A string value representing the assignee user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assigneeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on of next alarm fields: type, severity or status") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "startTs", "endTs", "type", "ackTs", "clearTs", "severity", "status"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="The start timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.") @RequestParam(required=false) Long startTime, @Parameter(description="The end timestamp in milliseconds of the search time range over the Alarm class field: 'createdTime'.") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        ArrayList<AlarmSearchStatus> alarmStatusList = new ArrayList<AlarmSearchStatus>();
        if (statusList != null) {
            for (String strStatus : statusList) {
                if (StringUtils.isEmpty((String)strStatus)) continue;
                alarmStatusList.add(AlarmSearchStatus.valueOf((String)strStatus));
            }
        }
        ArrayList<AlarmSeverity> alarmSeverityList = new ArrayList<AlarmSeverity>();
        if (severityList != null) {
            for (String strSeverity : severityList) {
                if (StringUtils.isEmpty((String)strSeverity)) continue;
                alarmSeverityList.add(AlarmSeverity.valueOf((String)strSeverity));
            }
        }
        List<Object> alarmTypeList = typeList != null ? Arrays.asList(typeList) : Collections.emptyList();
        UserId assigneeUserId = null;
        if (assigneeId != null) {
            assigneeUserId = new UserId(UUID.fromString(assigneeId));
        }
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        if (this.getCurrentUser().isCustomerUser()) {
            return this.checkNotNull(this.alarmService.findCustomerAlarmsV2(this.getCurrentUser().getTenantId(), this.getCurrentUser().getCustomerId(), new AlarmQueryV2(null, pageLink, alarmTypeList, alarmStatusList, alarmSeverityList, assigneeUserId)));
        }
        return this.checkNotNull(this.alarmService.findAlarmsV2(this.getCurrentUser().getTenantId(), new AlarmQueryV2(null, pageLink, alarmTypeList, alarmStatusList, alarmSeverityList, assigneeUserId)));
    }

    @ApiOperation(value="Get Highest Alarm Severity (getHighestAlarmSeverity)", notes="Search the alarms by originator ('entityType' and entityId') and optional 'status' or 'searchStatus' filters and returns the highest AlarmSeverity(CRITICAL, MAJOR, MINOR, WARNING or INDETERMINATE). Specifying both parameters 'searchStatus' and 'status' at the same time will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/alarm/highestSeverity/{entityType}/{entityId}"})
    public AlarmSeverity getHighestAlarmSeverity(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String strEntityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="A string value representing one of the AlarmSearchStatus enumeration value", schema=@Schema(allowableValues={"ANY", "ACTIVE", "CLEARED", "ACK", "UNACK"})) @RequestParam(required=false) String searchStatus, @Parameter(description="A string value representing one of the AlarmStatus enumeration value", schema=@Schema(allowableValues={"ACTIVE_UNACK", "ACTIVE_ACK", "CLEARED_UNACK", "CLEARED_ACK"})) @RequestParam(required=false) String status, @Parameter(description="A string value representing the assignee user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assigneeId) throws ThingsboardException {
        AlarmStatus alarmStatus;
        this.checkParameter("EntityId", strEntityId);
        this.checkParameter("EntityType", strEntityType);
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)strEntityType, (String)strEntityId);
        AlarmSearchStatus alarmSearchStatus = StringUtils.isEmpty((String)searchStatus) ? null : AlarmSearchStatus.valueOf((String)searchStatus);
        AlarmStatus alarmStatus2 = alarmStatus = StringUtils.isEmpty((String)status) ? null : AlarmStatus.valueOf((String)status);
        if (alarmSearchStatus != null && alarmStatus != null) {
            throw new ThingsboardException("Invalid alarms search query: Both parameters 'searchStatus' and 'status' can't be specified at the same time!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.checkEntityId(entityId, Operation.READ);
        return this.alarmService.findHighestAlarmSeverity(this.getCurrentUser().getTenantId(), entityId, alarmSearchStatus, alarmStatus, assigneeId);
    }

    @ApiOperation(value="Get Alarm Types (getAlarmTypes)", notes="Returns a set of unique alarm types based on alarms that are either owned by the tenant or assigned to the customer which user is performing the request.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/alarm/types"})
    public PageData<EntitySubtype> getAlarmTypes(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on of next alarm fields: type, severity or status") @RequestParam(required=false) String textSearch, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, "type", sortOrder);
        return this.checkNotNull(this.alarmService.findAlarmTypesByTenantId(this.getTenantId(), pageLink));
    }

    @ConstructorProperties(value={"tbAlarmService"})
    @Generated
    public AlarmController(TbAlarmService tbAlarmService) {
        this.tbAlarmService = tbAlarmService;
    }
}

