/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.config.mqtt;

import jakarta.validation.constraints.PositiveOrZero;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="mqtt.client.retransmission")
public class MqttClientRetransmissionSettingsComponent {
    @PositiveOrZero
    private int maxAttempts;
    @PositiveOrZero
    private long initialDelayMillis;
    @PositiveOrZero
    private double jitterFactor;

    @Generated
    public MqttClientRetransmissionSettingsComponent() {
    }

    @Generated
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Generated
    public long getInitialDelayMillis() {
        return this.initialDelayMillis;
    }

    @Generated
    public double getJitterFactor() {
        return this.jitterFactor;
    }

    @Generated
    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Generated
    public void setInitialDelayMillis(long initialDelayMillis) {
        this.initialDelayMillis = initialDelayMillis;
    }

    @Generated
    public void setJitterFactor(double jitterFactor) {
        this.jitterFactor = jitterFactor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttClientRetransmissionSettingsComponent)) {
            return false;
        }
        MqttClientRetransmissionSettingsComponent other = (MqttClientRetransmissionSettingsComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxAttempts() != other.getMaxAttempts()) {
            return false;
        }
        if (this.getInitialDelayMillis() != other.getInitialDelayMillis()) {
            return false;
        }
        return Double.compare(this.getJitterFactor(), other.getJitterFactor()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MqttClientRetransmissionSettingsComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxAttempts();
        long $initialDelayMillis = this.getInitialDelayMillis();
        result = result * 59 + (int)($initialDelayMillis >>> 32 ^ $initialDelayMillis);
        long $jitterFactor = Double.doubleToLongBits(this.getJitterFactor());
        result = result * 59 + (int)($jitterFactor >>> 32 ^ $jitterFactor);
        return result;
    }

    @Generated
    public String toString() {
        return "MqttClientRetransmissionSettingsComponent(maxAttempts=" + this.getMaxAttempts() + ", initialDelayMillis=" + this.getInitialDelayMillis() + ", jitterFactor=" + this.getJitterFactor() + ")";
    }
}

