/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.config;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.customizers.RouterOperationCustomizer;
import org.springdoc.core.discoverer.SpringDocParameterNameDiscoverer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestParam;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.exception.ThingsboardCredentialsExpiredResponse;
import org.thingsboard.server.exception.ThingsboardErrorResponse;
import org.thingsboard.server.service.security.auth.rest.LoginRequest;
import org.thingsboard.server.service.security.auth.rest.LoginResponse;

@Configuration
@ConditionalOnExpression(value="('${service.type:null}'=='monolith' || '${service.type:null}'=='tb-core') && '${springdoc.api-docs.enabled:true}'=='true'")
@Profile(value={"!test"})
public class SwaggerConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfiguration.class);
    public static final String LOGIN_ENDPOINT = "/api/auth/login";
    public static final String REFRESH_TOKEN_ENDPOINT = "/api/auth/token";
    private static final ApiResponses loginResponses = SwaggerConfiguration.loginResponses();
    private static final ApiResponses defaultErrorResponses = SwaggerConfiguration.defaultErrorResponses(false);
    private static final ApiResponses defaultPostErrorResponses = SwaggerConfiguration.defaultErrorResponses(true);
    @Value(value="${swagger.api_path:/api/**}")
    private String apiPath;
    @Value(value="${swagger.security_path_regex}")
    private String securityPathRegex;
    @Value(value="${swagger.non_security_path_regex}")
    private String nonSecurityPathRegex;
    @Value(value="${swagger.title}")
    private String title;
    @Value(value="${swagger.description}")
    private String description;
    @Value(value="${swagger.contact.name}")
    private String contactName;
    @Value(value="${swagger.contact.url}")
    private String contactUrl;
    @Value(value="${swagger.contact.email}")
    private String contactEmail;
    @Value(value="${swagger.license.title}")
    private String licenseTitle;
    @Value(value="${swagger.license.url}")
    private String licenseUrl;
    @Value(value="${swagger.version}")
    private String version;
    @Value(value="${app.version:unknown}")
    private String appVersion;
    @Value(value="${swagger.group_name:thingsboard}")
    private String groupName;

    @Bean
    public OpenAPI thingsboardApi() {
        Contact contact = new Contact().name(this.contactName).url(this.contactUrl).email(this.contactEmail);
        License license = new License().name(this.licenseTitle).url(this.licenseUrl);
        String apiVersion = this.version;
        if (StringUtils.isEmpty((String)apiVersion)) {
            apiVersion = this.appVersion;
        }
        Info info = new Info().title(this.title).description(this.description).contact(contact).license(license).version(apiVersion);
        SecurityScheme securityScheme = new SecurityScheme().type(SecurityScheme.Type.HTTP).description("Enter Username / Password").scheme("loginPassword").bearerFormat("/api/auth/login|X-Authorization");
        OpenAPI openApi = new OpenAPI().components(new Components().addSecuritySchemes("HTTP login form", securityScheme)).info(info);
        this.addDefaultSchemas(openApi);
        this.addLoginOperation(openApi);
        this.addRefreshTokenOperation(openApi);
        return openApi;
    }

    @Bean
    @Primary
    public SpringDocConfigProperties springDocConfig(SpringDocConfigProperties springDocProperties) {
        springDocProperties.getApiDocs().setVersion(SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1);
        springDocProperties.setRemoveBrokenReferenceDefinitions(false);
        return springDocProperties;
    }

    @Bean
    @Primary
    public SwaggerUiConfigProperties swaggerUiConfig(SwaggerUiConfigProperties uiProperties) {
        uiProperties.setDeepLinking(Boolean.valueOf(true));
        uiProperties.setDisplayOperationId(Boolean.valueOf(false));
        uiProperties.setDefaultModelsExpandDepth(Integer.valueOf(1));
        uiProperties.setDefaultModelExpandDepth(Integer.valueOf(1));
        uiProperties.setDefaultModelRendering("example");
        uiProperties.setDisplayRequestDuration(Boolean.valueOf(false));
        uiProperties.setDocExpansion("list");
        uiProperties.setFilter("false");
        uiProperties.setMaxDisplayedTags(null);
        uiProperties.setOperationsSorter("alpha");
        uiProperties.setTagsSorter("alpha");
        uiProperties.setShowExtensions(Boolean.valueOf(false));
        uiProperties.setShowCommonExtensions(Boolean.valueOf(false));
        uiProperties.setSupportedSubmitMethods(List.of("get", "put", "post", "delete", "options", "head", "patch", "trace"));
        uiProperties.setValidatorUrl(null);
        uiProperties.setPersistAuthorization(Boolean.valueOf(true));
        SwaggerUiConfigProperties.SyntaxHighlight syntaxHighLight = new SwaggerUiConfigProperties.SyntaxHighlight();
        syntaxHighLight.setActivated(Boolean.valueOf(true));
        syntaxHighLight.setTheme("agate");
        uiProperties.setSyntaxHighlight(syntaxHighLight);
        return uiProperties;
    }

    private void addLoginOperation(OpenAPI openAPI) {
        Operation operation = new Operation();
        operation.summary("Login method to get user JWT token data");
        operation.description("Login method used to authenticate user and get JWT token data.\n\nValue of the response **token** field can be used as **X-Authorization** header value:\n\n`X-Authorization: Bearer $JWT_TOKEN_VALUE`.");
        RequestBody requestBody = new RequestBody().description("Login request").content(new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref("#/components/schemas/LoginRequest"))));
        operation.requestBody(requestBody);
        operation.responses(loginResponses);
        operation.addTagsItem("login-endpoint");
        PathItem pathItem = new PathItem().post(operation);
        openAPI.path(LOGIN_ENDPOINT, pathItem);
    }

    private void addRefreshTokenOperation(OpenAPI openAPI) {
        Operation operation = new Operation();
        operation.summary("Refresh user JWT token data");
        operation.description("Method to refresh JWT token. Provide a valid refresh token to get a new JWT token.\n\nThe response contains a new token that can be used for authorization.\n\n`X-Authorization: Bearer $JWT_TOKEN_VALUE`");
        RequestBody requestBody = new RequestBody().description("Refresh token request").content(new Content().addMediaType("application/json", new MediaType().schema(new Schema().addProperty("refreshToken", new Schema().type("string")))));
        operation.requestBody(requestBody);
        operation.responses(loginResponses);
        operation.addTagsItem("login-endpoint");
        PathItem pathItem = new PathItem().post(operation);
        openAPI.path(REFRESH_TOKEN_ENDPOINT, pathItem);
    }

    @Bean
    public GroupedOpenApi groupedApi(SpringDocParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        return GroupedOpenApi.builder().group(this.groupName).pathsToMatch(new String[]{this.apiPath}).addRouterOperationCustomizer(this.routerOperationCustomizer(localSpringDocParameterNameDiscoverer)).addOperationCustomizer(this.operationCustomizer()).addOpenApiCustomizer(this.customOpenApiCustomizer()).build();
    }

    @Bean
    @Lazy(value=false)
    ModelConverter mapAwareConverter() {
        return (type, context, chain) -> {
            if (chain.hasNext()) {
                Class cls;
                Schema schema = ((ModelConverter)chain.next()).resolve(type, context, chain);
                JavaType javaType = Json.mapper().constructType(type.getType());
                if (javaType != null && Map.class.isAssignableFrom(cls = javaType.getRawClass()) && schema != null && schema.getProperties() != null) {
                    schema.getProperties().remove("empty");
                    if (schema.getProperties().isEmpty()) {
                        schema.setProperties(null);
                    }
                }
                return schema;
            }
            return null;
        };
    }

    private void addDefaultSchemas(OpenAPI openAPI) {
        Schema jsonNodeSchema = ModelConverters.getInstance().readAllAsResolvedSchema((AnnotatedType)new AnnotatedType().type(JsonNode.class)).schema;
        jsonNodeSchema.setType("any");
        jsonNodeSchema.setExamples(List.of(JacksonUtil.newObjectNode()));
        jsonNodeSchema.setDescription("A value representing the any type (object or primitive)");
        openAPI.getComponents().addSchemas("JsonNode", jsonNodeSchema).addSchemas("LoginRequest", ModelConverters.getInstance().readAllAsResolvedSchema((AnnotatedType)new AnnotatedType().type(LoginRequest.class)).schema).addSchemas("LoginResponse", ModelConverters.getInstance().readAllAsResolvedSchema((AnnotatedType)new AnnotatedType().type(LoginResponse.class)).schema).addSchemas("ThingsboardErrorResponse", ModelConverters.getInstance().readAllAsResolvedSchema((AnnotatedType)new AnnotatedType().type(ThingsboardErrorResponse.class)).schema).addSchemas("ThingsboardCredentialsExpiredResponse", ModelConverters.getInstance().readAllAsResolvedSchema((AnnotatedType)new AnnotatedType().type(ThingsboardCredentialsExpiredResponse.class)).schema);
    }

    private RouterOperationCustomizer routerOperationCustomizer(SpringDocParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        return (routerOperation, handlerMethod) -> {
            String[] pNames = localSpringDocParameterNameDiscoverer.getParameterNames(handlerMethod.getMethod());
            String[] reflectionParametersNames = (String[])Arrays.stream(handlerMethod.getMethod().getParameters()).map(Parameter::getName).toArray(String[]::new);
            if (pNames == null || Arrays.stream(pNames).anyMatch(Objects::isNull)) {
                pNames = reflectionParametersNames;
            }
            MethodParameter[] parameters = handlerMethod.getMethodParameters();
            ArrayList<String> requestParams = new ArrayList<String>();
            for (int i = 0; i < parameters.length; ++i) {
                String pName;
                MethodParameter methodParameter = parameters[i];
                RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
                if (requestParam == null) continue;
                String string = pName = StringUtils.isNotBlank((String)requestParam.value()) ? requestParam.value() : pNames[i];
                if (!StringUtils.isNotBlank((String)pName)) continue;
                requestParams.add(pName);
            }
            if (!requestParams.isEmpty()) {
                String path = routerOperation.getPath() + "{?" + String.join((CharSequence)",", requestParams) + "}";
                routerOperation.setPath(path);
            }
            return routerOperation;
        };
    }

    private OperationCustomizer operationCustomizer() {
        return (operation, handlerMethod) -> {
            if (StringUtils.isBlank((String)operation.getSummary())) {
                operation.setSummary(operation.getOperationId());
            }
            return operation;
        };
    }

    private OpenApiCustomizer customOpenApiCustomizer() {
        SecurityRequirement loginForm = new SecurityRequirement().addList("HTTP login form", Arrays.asList(Authority.SYS_ADMIN.name(), Authority.TENANT_ADMIN.name(), Authority.CUSTOMER_USER.name()));
        return openAPI -> {
            Paths paths = openAPI.getPaths();
            paths.entrySet().stream().peek(entry -> {
                this.securityCustomization(loginForm, (Map.Entry<String, PathItem>)entry);
                if (!((String)entry.getKey()).equals(LOGIN_ENDPOINT)) {
                    this.defaultErrorResponsesCustomization((PathItem)entry.getValue());
                }
            }).map(this::tagsCustomization).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Tag::getName)).forEach(arg_0 -> ((OpenAPI)openAPI).addTagsItem(arg_0));
            TreeMap<String, Map> pathItemsByTags = new TreeMap<String, Map>();
            paths.forEach((k, v) -> {
                String tagItem = this.tagItemFromPathItem((PathItem)v);
                if (tagItem != null) {
                    Map pathItemMap = pathItemsByTags.computeIfAbsent(tagItem, k1 -> new TreeMap());
                    pathItemMap.put(k, v);
                }
            });
            Paths sortedPaths = new Paths();
            pathItemsByTags.forEach((tagItem, pathItemMap) -> pathItemMap.forEach((arg_0, arg_1) -> ((Paths)sortedPaths).addPathItem(arg_0, arg_1)));
            sortedPaths.setExtensions(paths.getExtensions());
            openAPI.setPaths(sortedPaths);
            TreeMap sortedSchemas = new TreeMap(openAPI.getComponents().getSchemas());
            openAPI.getComponents().setSchemas(new LinkedHashMap(sortedSchemas));
        };
    }

    private Tag tagsCustomization(Map.Entry<String, PathItem> entry) {
        String tagItem = this.tagItemFromPathItem(entry.getValue());
        if (tagItem != null) {
            return this.tagFromTagItem(tagItem);
        }
        return null;
    }

    private String tagItemFromPathItem(PathItem item) {
        List tags;
        Collection operations = item.readOperationsMap().values();
        Optional operation = operations.stream().findAny();
        if (operation.isPresent() && (tags = ((Operation)operation.get()).getTags()) != null && !tags.isEmpty()) {
            return (String)tags.get(0);
        }
        return null;
    }

    private Tag tagFromTagItem(String tagItem) {
        String[] words = tagItem.split("-");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            sb.append(word.substring(0, 1).toUpperCase());
            sb.append(word.substring(1).toLowerCase());
            sb.append(" ");
        }
        return new Tag().name(tagItem).description(sb.toString().trim());
    }

    private void defaultErrorResponsesCustomization(PathItem pathItem) {
        pathItem.readOperationsMap().forEach((httpMethod, operation) -> {
            ApiResponses errorResponses = httpMethod.equals((Object)PathItem.HttpMethod.POST) ? defaultPostErrorResponses : defaultErrorResponses;
            ApiResponses responses = operation.getResponses();
            if (responses == null) {
                responses = errorResponses;
            } else {
                ApiResponses updated = responses;
                errorResponses.forEach((key, apiResponse) -> {
                    if (!updated.containsKey(key)) {
                        updated.put(key, apiResponse);
                    }
                });
            }
            operation.setResponses(responses);
        });
    }

    private void securityCustomization(SecurityRequirement loginForm, Map.Entry<String, PathItem> entry) {
        String path = entry.getKey();
        if (path.matches(this.securityPathRegex) && !path.matches(this.nonSecurityPathRegex) && !path.equals(LOGIN_ENDPOINT)) {
            entry.getValue().readOperationsMap().values().forEach(operation -> operation.addSecurityItem(loginForm));
        }
    }

    private static ApiResponses loginResponses() {
        ApiResponses apiResponses = new ApiResponses();
        apiResponses.addApiResponse("200", new ApiResponse().description("OK").content(new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref("#/components/schemas/LoginResponse")))));
        apiResponses.putAll((Map)SwaggerConfiguration.loginErrorResponses());
        return apiResponses;
    }

    private static ApiResponses defaultErrorResponses(boolean isPost) {
        ApiResponses apiResponses = new ApiResponses();
        apiResponses.addApiResponse("400", SwaggerConfiguration.errorResponse("400", "Bad Request", ThingsboardErrorResponse.of(isPost ? "Invalid request body" : "Invalid UUID string: 123", ThingsboardErrorCode.BAD_REQUEST_PARAMS, HttpStatus.BAD_REQUEST)));
        apiResponses.addApiResponse("401", SwaggerConfiguration.errorResponse("401", "Unauthorized", ThingsboardErrorResponse.of("Authentication failed", ThingsboardErrorCode.AUTHENTICATION, HttpStatus.UNAUTHORIZED)));
        apiResponses.addApiResponse("403", SwaggerConfiguration.errorResponse("403", "Forbidden", ThingsboardErrorResponse.of("You don't have permission to perform this operation!", ThingsboardErrorCode.PERMISSION_DENIED, HttpStatus.FORBIDDEN)));
        apiResponses.addApiResponse("404", SwaggerConfiguration.errorResponse("404", "Not Found", ThingsboardErrorResponse.of("Requested item wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND, HttpStatus.NOT_FOUND)));
        apiResponses.addApiResponse("429", SwaggerConfiguration.errorResponse("429", "Too Many Requests", ThingsboardErrorResponse.of("Too many requests for current tenant!", ThingsboardErrorCode.TOO_MANY_REQUESTS, HttpStatus.TOO_MANY_REQUESTS)));
        return apiResponses;
    }

    private static ApiResponses loginErrorResponses() {
        ApiResponses apiResponses = new ApiResponses();
        apiResponses.addApiResponse("401", SwaggerConfiguration.errorResponse("Unauthorized", Map.of("bad-credentials", SwaggerConfiguration.errorExample("Bad credentials", ThingsboardErrorResponse.of("Invalid username or password", ThingsboardErrorCode.AUTHENTICATION, HttpStatus.UNAUTHORIZED)), "token-expired", SwaggerConfiguration.errorExample("JWT token expired", ThingsboardErrorResponse.of("Token has expired", ThingsboardErrorCode.JWT_TOKEN_EXPIRED, HttpStatus.UNAUTHORIZED)), "account-disabled", SwaggerConfiguration.errorExample("Disabled account", ThingsboardErrorResponse.of("User account is not active", ThingsboardErrorCode.AUTHENTICATION, HttpStatus.UNAUTHORIZED)), "account-locked", SwaggerConfiguration.errorExample("Locked account", ThingsboardErrorResponse.of("User account is locked due to security policy", ThingsboardErrorCode.AUTHENTICATION, HttpStatus.UNAUTHORIZED)), "authentication-failed", SwaggerConfiguration.errorExample("General authentication error", ThingsboardErrorResponse.of("Authentication failed", ThingsboardErrorCode.AUTHENTICATION, HttpStatus.UNAUTHORIZED)))));
        Schema credentialsExpiredSchema = new Schema();
        credentialsExpiredSchema.$ref("#/components/schemas/ThingsboardCredentialsExpiredResponse");
        apiResponses.addApiResponse("401 ", SwaggerConfiguration.errorResponse("Unauthorized (**Expired credentials**)", Map.of("credentials-expired", SwaggerConfiguration.errorExample("Expired credentials", ThingsboardCredentialsExpiredResponse.of("User password expired!", StringUtils.randomAlphanumeric((int)30)))), (Schema<? extends ThingsboardErrorResponse>)credentialsExpiredSchema));
        return apiResponses;
    }

    private static ApiResponse errorResponse(String code, String description, ThingsboardErrorResponse example) {
        return SwaggerConfiguration.errorResponse(description, Map.of("error-code-" + code, SwaggerConfiguration.errorExample(description, example)));
    }

    private static ApiResponse errorResponse(String description, Map<String, Example> examples) {
        Schema schema = new Schema();
        schema.$ref("#/components/schemas/ThingsboardErrorResponse");
        return SwaggerConfiguration.errorResponse(description, examples, (Schema<? extends ThingsboardErrorResponse>)schema);
    }

    private static ApiResponse errorResponse(String description, Map<String, Example> examples, Schema<? extends ThingsboardErrorResponse> errorResponseSchema) {
        MediaType mediaType = new MediaType().schema(errorResponseSchema);
        mediaType.setExamples(examples);
        Content content = new Content().addMediaType("application/json", mediaType);
        return new ApiResponse().description(description).content(content);
    }

    private static Example errorExample(String summary, ThingsboardErrorResponse example) {
        return new Example().summary(summary).value((Object)example);
    }
}

