/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.ruleChain;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActor;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbEntityActorId;
import org.thingsboard.server.actors.ruleChain.RuleChainToRuleNodeMsg;
import org.thingsboard.server.actors.ruleChain.RuleEngineComponentActor;
import org.thingsboard.server.actors.ruleChain.RuleNodeActorMessageProcessor;
import org.thingsboard.server.actors.ruleChain.RuleNodeToSelfMsg;
import org.thingsboard.server.actors.service.ContextBasedCreator;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;

public class RuleNodeActor
extends RuleEngineComponentActor<RuleNodeId, RuleNodeActorMessageProcessor> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleNodeActor.class);
    private final String ruleChainName;
    private final RuleChainId ruleChainId;
    private final RuleNodeId ruleNodeId;

    private RuleNodeActor(ActorSystemContext systemContext, TenantId tenantId, RuleChainId ruleChainId, String ruleChainName, RuleNodeId ruleNodeId) {
        super(systemContext, tenantId, ruleNodeId);
        this.ruleChainName = ruleChainName;
        this.ruleChainId = ruleChainId;
        this.ruleNodeId = ruleNodeId;
    }

    @Override
    protected RuleNodeActorMessageProcessor createProcessor(TbActorCtx ctx) {
        return new RuleNodeActorMessageProcessor(this.tenantId, this.ruleChainName, this.ruleNodeId, this.systemContext, ctx);
    }

    @Override
    protected boolean doProcess(TbActorMsg msg) {
        switch (msg.getMsgType()) {
            case COMPONENT_LIFE_CYCLE_MSG: 
            case RULE_NODE_UPDATED_MSG: {
                this.onComponentLifecycleMsg((ComponentLifecycleMsg)msg);
                break;
            }
            case RULE_CHAIN_TO_RULE_MSG: {
                this.onRuleChainToRuleNodeMsg((RuleChainToRuleNodeMsg)msg);
                break;
            }
            case RULE_TO_SELF_MSG: {
                this.onRuleNodeToSelfMsg((RuleNodeToSelfMsg)msg);
                break;
            }
            case STATS_PERSIST_TICK_MSG: {
                this.onStatsPersistTick(this.id);
                break;
            }
            case PARTITION_CHANGE_MSG: {
                this.onClusterEventMsg((PartitionChangeMsg)msg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void onRuleNodeToSelfMsg(RuleNodeToSelfMsg msg) {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}][{}] Going to process rule msg: {}", new Object[]{this.ruleChainId, this.id, ((RuleNodeActorMessageProcessor)this.processor).getComponentName(), msg.getMsg()});
        }
        try {
            ((RuleNodeActorMessageProcessor)this.processor).onRuleToSelfMsg(msg);
            this.increaseMessagesProcessedCount();
        }
        catch (Exception e) {
            this.logAndPersist("onRuleMsg", e);
        }
    }

    private void onRuleChainToRuleNodeMsg(RuleChainToRuleNodeMsg envelope) {
        TbMsg msg = envelope.getMsg();
        if (!msg.isValid()) {
            if (log.isTraceEnabled()) {
                log.trace("Skip processing of message: {} because it is no longer valid!", (Object)msg);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}][{}] Going to process rule engine msg: {}", new Object[]{this.ruleChainId, this.id, ((RuleNodeActorMessageProcessor)this.processor).getComponentName(), msg});
        }
        try {
            ((RuleNodeActorMessageProcessor)this.processor).onRuleChainToRuleNodeMsg(envelope);
            this.increaseMessagesProcessedCount();
        }
        catch (Exception e) {
            this.logAndPersist("onRuleMsg", e);
        }
    }

    @Override
    protected RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    @Override
    protected String getRuleChainName() {
        return this.ruleChainName;
    }

    @Override
    protected long getErrorPersistFrequency() {
        return this.systemContext.getRuleNodeErrorPersistFrequency();
    }

    public static class ActorCreator
    extends ContextBasedCreator {
        private final TenantId tenantId;
        private final RuleChainId ruleChainId;
        private final String ruleChainName;
        private final RuleNodeId ruleNodeId;

        public ActorCreator(ActorSystemContext context, TenantId tenantId, RuleChainId ruleChainId, String ruleChainName, RuleNodeId ruleNodeId) {
            super(context);
            this.tenantId = tenantId;
            this.ruleChainId = ruleChainId;
            this.ruleChainName = ruleChainName;
            this.ruleNodeId = ruleNodeId;
        }

        public TbActorId createActorId() {
            return new TbEntityActorId((EntityId)this.ruleNodeId);
        }

        public TbActor createActor() {
            return new RuleNodeActor(this.context, this.tenantId, this.ruleChainId, this.ruleChainName, this.ruleNodeId);
        }
    }
}

