/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.ruleChain;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.channel.EventLoopGroup;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ListeningExecutor;
import org.thingsboard.rule.engine.api.DeviceStateManager;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.MqttClientSettings;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.rule.engine.api.RuleEngineAiChatModelService;
import org.thingsboard.rule.engine.api.RuleEngineAlarmService;
import org.thingsboard.rule.engine.api.RuleEngineApiUsageStateService;
import org.thingsboard.rule.engine.api.RuleEngineAssetProfileCache;
import org.thingsboard.rule.engine.api.RuleEngineCalculatedFieldQueueService;
import org.thingsboard.rule.engine.api.RuleEngineDeviceProfileCache;
import org.thingsboard.rule.engine.api.RuleEngineRpcService;
import org.thingsboard.rule.engine.api.RuleEngineTelemetryService;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.SmsService;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.notification.SlackService;
import org.thingsboard.rule.engine.api.sms.SmsSenderFactory;
import org.thingsboard.rule.engine.util.TenantIdLoader;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.ruleChain.RuleChainOutputMsg;
import org.thingsboard.server.actors.ruleChain.RuleNodeCtx;
import org.thingsboard.server.actors.ruleChain.RuleNodeToRuleChainTellNextMsg;
import org.thingsboard.server.actors.ruleChain.RuleNodeToSelfMsg;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.HasRuleEngineProfile;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.rule.RuleNodeState;
import org.thingsboard.server.common.data.script.ScriptLanguage;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.TbMsgProcessingStackItem;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.ai.AiModelService;
import org.thingsboard.server.dao.alarm.AlarmCommentService;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.audit.AuditLogService;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.dao.job.JobService;
import org.thingsboard.server.dao.mobile.MobileAppBundleService;
import org.thingsboard.server.dao.mobile.MobileAppService;
import org.thingsboard.server.dao.nosql.CassandraStatementTask;
import org.thingsboard.server.dao.nosql.TbResultSetFuture;
import org.thingsboard.server.dao.notification.NotificationRequestService;
import org.thingsboard.server.dao.notification.NotificationRuleService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.queue.QueueStatsService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.resource.TbResourceDataCache;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.util.AsyncTask;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.common.SimpleTbQueueCallback;
import org.thingsboard.server.service.executors.PubSubRuleNodeExecutorProvider;
import org.thingsboard.server.service.script.RuleNodeJsScriptEngine;
import org.thingsboard.server.service.script.RuleNodeTbelScriptEngine;

public class DefaultTbContext
implements TbContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbContext.class);
    private final ActorSystemContext mainCtx;
    private final String ruleChainName;
    private final RuleNodeCtx nodeCtx;

    public DefaultTbContext(ActorSystemContext mainCtx, String ruleChainName, RuleNodeCtx nodeCtx) {
        this.mainCtx = mainCtx;
        this.ruleChainName = ruleChainName;
        this.nodeCtx = nodeCtx;
    }

    public void tellSuccess(TbMsg msg) {
        this.tellNext(msg, Collections.singleton("Success"));
    }

    public void tellNext(TbMsg msg, String relationType) {
        this.tellNext(msg, Collections.singleton(relationType));
    }

    public void tellNext(TbMsg msg, Set<String> relationTypes) {
        RuleNode ruleNode = this.nodeCtx.getSelf();
        this.persistDebugOutput(msg, relationTypes);
        msg.getCallback().onProcessingEnd(ruleNode.getId());
        this.nodeCtx.getChainActor().tell((TbActorMsg)new RuleNodeToRuleChainTellNextMsg(ruleNode.getRuleChainId(), ruleNode.getId(), relationTypes, msg, null));
    }

    public void tellSelf(TbMsg msg, long delayMs) {
        this.scheduleMsgWithDelay((TbActorMsg)new RuleNodeToSelfMsg(this, msg), delayMs, this.nodeCtx.getSelfActor());
    }

    public void input(TbMsg msg, RuleChainId ruleChainId) {
        if (!msg.isValid()) {
            return;
        }
        TbMsg tbMsg = msg.copy().ruleChainId(ruleChainId).resetRuleNodeId().build();
        tbMsg.pushToStack(this.nodeCtx.getSelf().getRuleChainId(), this.nodeCtx.getSelf().getId());
        TopicPartitionInfo tpi = this.resolvePartition(msg);
        this.doEnqueue(tpi, tbMsg, (TbQueueCallback)new SimpleTbQueueCallback(md -> this.ack(msg), t -> this.tellFailure(msg, (Throwable)t)));
    }

    public void output(TbMsg msg, String relationType) {
        TbMsgProcessingStackItem item = msg.popFormStack();
        if (item == null) {
            this.ack(msg);
        } else {
            this.persistDebugOutput(msg, relationType);
            this.nodeCtx.getChainActor().tell((TbActorMsg)new RuleChainOutputMsg(item.getRuleChainId(), item.getRuleNodeId(), relationType, msg));
        }
    }

    public void enqueue(TbMsg tbMsg, Runnable onSuccess, Consumer<Throwable> onFailure) {
        this.enqueue(tbMsg, tbMsg.getQueueName(), onSuccess, onFailure);
    }

    public void enqueue(TbMsg tbMsg, String queueName, Runnable onSuccess, Consumer<Throwable> onFailure) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg, queueName);
        this.enqueue(tpi, tbMsg, onFailure, onSuccess);
    }

    private void enqueue(TopicPartitionInfo tpi, TbMsg tbMsg, Consumer<Throwable> onFailure, Runnable onSuccess) {
        if (!tbMsg.isValid()) {
            log.trace("[{}] Skip invalid message: {}", (Object)this.getTenantId(), (Object)tbMsg);
            if (onFailure != null) {
                onFailure.accept(new IllegalArgumentException("Source message is no longer valid!"));
            }
            return;
        }
        this.doEnqueue(tpi, tbMsg, (TbQueueCallback)new SimpleTbQueueCallback(metadata -> {
            this.persistDebugOutput(tbMsg, "To Root Rule Chain");
            if (onSuccess != null) {
                onSuccess.run();
            }
        }, t -> {
            if (onFailure != null) {
                onFailure.accept((Throwable)t);
            } else {
                log.debug("[{}] Failed to put item into queue!", (Object)this.nodeCtx.getTenantId().getId(), t);
            }
        }));
    }

    private void doEnqueue(TopicPartitionInfo tpi, TbMsg tbMsg, TbQueueCallback callback) {
        TransportProtos.ToRuleEngineMsg msg = TransportProtos.ToRuleEngineMsg.newBuilder().setTenantIdMSB(this.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(this.getTenantId().getId().getLeastSignificantBits()).setTbMsgProto(TbMsg.toProto((TbMsg)tbMsg)).build();
        this.mainCtx.getClusterService().pushMsgToRuleEngine(tpi, tbMsg.getId(), msg, callback);
    }

    public void enqueueForTellFailure(TbMsg tbMsg, String failureMessage) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg);
        this.enqueueForTellNext(tpi, tbMsg, Collections.singleton("Failure"), failureMessage, null, null);
    }

    public void enqueueForTellFailure(TbMsg tbMsg, Throwable th) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg);
        this.enqueueForTellNext(tpi, tbMsg, Collections.singleton("Failure"), DefaultTbContext.getFailureMessage(th), null, null);
    }

    public void enqueueForTellNext(TbMsg tbMsg, String relationType) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg);
        this.enqueueForTellNext(tpi, tbMsg, Collections.singleton(relationType), null, null, null);
    }

    public void enqueueForTellNext(TbMsg tbMsg, Set<String> relationTypes) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg);
        this.enqueueForTellNext(tpi, tbMsg, relationTypes, null, null, null);
    }

    public void enqueueForTellNext(TbMsg tbMsg, String relationType, Runnable onSuccess, Consumer<Throwable> onFailure) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg);
        this.enqueueForTellNext(tpi, tbMsg, Collections.singleton(relationType), null, onSuccess, onFailure);
    }

    public void enqueueForTellNext(TbMsg tbMsg, Set<String> relationTypes, Runnable onSuccess, Consumer<Throwable> onFailure) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg);
        this.enqueueForTellNext(tpi, tbMsg, relationTypes, null, onSuccess, onFailure);
    }

    public void enqueueForTellNext(TbMsg tbMsg, String queueName, String relationType, Runnable onSuccess, Consumer<Throwable> onFailure) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg, queueName);
        this.enqueueForTellNext(tpi, queueName, tbMsg, Collections.singleton(relationType), null, onSuccess, onFailure);
    }

    public void enqueueForTellNext(TbMsg tbMsg, String queueName, Set<String> relationTypes, Runnable onSuccess, Consumer<Throwable> onFailure) {
        TopicPartitionInfo tpi = this.resolvePartition(tbMsg, queueName);
        this.enqueueForTellNext(tpi, queueName, tbMsg, relationTypes, null, onSuccess, onFailure);
    }

    private TopicPartitionInfo resolvePartition(TbMsg tbMsg, String queueName) {
        return this.mainCtx.resolve(ServiceType.TB_RULE_ENGINE, queueName, this.getTenantId(), tbMsg.getOriginator());
    }

    private TopicPartitionInfo resolvePartition(TbMsg tbMsg) {
        return this.resolvePartition(tbMsg, tbMsg.getQueueName());
    }

    private void enqueueForTellNext(TopicPartitionInfo tpi, TbMsg source, Set<String> relationTypes, String failureMessage, Runnable onSuccess, Consumer<Throwable> onFailure) {
        this.enqueueForTellNext(tpi, source.getQueueName(), source, relationTypes, failureMessage, onSuccess, onFailure);
    }

    private void enqueueForTellNext(TopicPartitionInfo tpi, String queueName, TbMsg source, Set<String> relationTypes, String failureMessage, Runnable onSuccess, Consumer<Throwable> onFailure) {
        if (!source.isValid()) {
            log.trace("[{}] Skip invalid message: {}", (Object)this.getTenantId(), (Object)source);
            if (onFailure != null) {
                onFailure.accept(new IllegalArgumentException("Source message is no longer valid!"));
            }
            return;
        }
        RuleNode ruleNode = this.nodeCtx.getSelf();
        RuleChainId ruleChainId = ruleNode.getRuleChainId();
        RuleNodeId ruleNodeId = ruleNode.getId();
        TbMsg tbMsg = TbMsg.newMsg((TbMsg)source, (String)queueName, (RuleChainId)ruleChainId, (RuleNodeId)ruleNodeId);
        TransportProtos.ToRuleEngineMsg.Builder msg = TransportProtos.ToRuleEngineMsg.newBuilder().setTenantIdMSB(this.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(this.getTenantId().getId().getLeastSignificantBits()).setTbMsgProto(TbMsg.toProto((TbMsg)tbMsg)).addAllRelationTypes(relationTypes);
        if (failureMessage != null) {
            msg.setFailureMessage(failureMessage);
        }
        this.mainCtx.getClusterService().pushMsgToRuleEngine(tpi, tbMsg.getId(), msg.build(), (TbQueueCallback)new SimpleTbQueueCallback(metadata -> {
            this.persistDebugOutput(tbMsg, relationTypes, null, failureMessage);
            if (onSuccess != null) {
                onSuccess.run();
            }
        }, t -> {
            if (onFailure != null) {
                onFailure.accept((Throwable)t);
            } else {
                log.debug("[{}] Failed to put item into queue!", (Object)this.nodeCtx.getTenantId().getId(), t);
            }
        }));
    }

    public void ack(TbMsg tbMsg) {
        RuleNode ruleNode = this.nodeCtx.getSelf();
        this.persistDebugOutput(tbMsg, "ACK");
        tbMsg.getCallback().onProcessingEnd(ruleNode.getId());
        tbMsg.getCallback().onSuccess();
    }

    public boolean isLocalEntity(EntityId entityId) {
        return this.mainCtx.resolve(ServiceType.TB_RULE_ENGINE, this.getQueueName(), this.getTenantId(), entityId).isMyPartition();
    }

    private void scheduleMsgWithDelay(TbActorMsg msg, long delayInMs, TbActorRef target) {
        this.mainCtx.scheduleMsgWithDelay(target, msg, delayInMs);
    }

    public void tellFailure(TbMsg msg, Throwable th) {
        RuleNode ruleNode = this.nodeCtx.getSelf();
        this.persistDebugOutput(msg, Set.of("Failure"), th, null);
        String failureMessage = DefaultTbContext.getFailureMessage(th);
        this.nodeCtx.getChainActor().tell((TbActorMsg)new RuleNodeToRuleChainTellNextMsg(ruleNode.getRuleChainId(), ruleNode.getId(), Collections.singleton("Failure"), msg, failureMessage));
    }

    public void updateSelf(RuleNode self) {
        this.nodeCtx.setSelf(self);
    }

    public TbMsg newMsg(String queueName, String type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, String data) {
        return TbMsg.newMsg().queueName(queueName).type(type).originator(originator).customerId(customerId).copyMetaData(metaData).data(data).ruleChainId(this.nodeCtx.getSelf().getRuleChainId()).ruleNodeId(this.nodeCtx.getSelf().getId()).build();
    }

    public TbMsg transformMsg(TbMsg origMsg, String type, EntityId originator, TbMsgMetaData metaData, String data) {
        return origMsg.transform().type(type).originator(originator).metaData(metaData).data(data).build();
    }

    public TbMsg newMsg(String queueName, TbMsgType type, EntityId originator, TbMsgMetaData metaData, String data) {
        return this.newMsg(queueName, type, originator, null, metaData, data);
    }

    public TbMsg newMsg(String queueName, TbMsgType type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, String data) {
        return TbMsg.newMsg().queueName(queueName).type(type).originator(originator).customerId(customerId).copyMetaData(metaData).data(data).ruleChainId(this.nodeCtx.getSelf().getRuleChainId()).ruleNodeId(this.nodeCtx.getSelf().getId()).build();
    }

    public TbMsg transformMsg(TbMsg origMsg, TbMsgType type, EntityId originator, TbMsgMetaData metaData, String data) {
        return origMsg.transform().type(type).originator(originator).metaData(metaData).data(data).build();
    }

    public TbMsg transformMsg(TbMsg origMsg, TbMsgMetaData metaData, String data) {
        return origMsg.transform().metaData(metaData).data(data).build();
    }

    public TbMsg transformMsgOriginator(TbMsg origMsg, EntityId originator) {
        return origMsg.transform().originator(originator).build();
    }

    public TbMsg customerCreatedMsg(Customer customer, RuleNodeId ruleNodeId) {
        return this.entityActionMsg(customer, customer.getId(), ruleNodeId, TbMsgType.ENTITY_CREATED);
    }

    public TbMsg deviceCreatedMsg(Device device, RuleNodeId ruleNodeId) {
        DeviceProfile deviceProfile = null;
        if (device.getDeviceProfileId() != null) {
            deviceProfile = this.mainCtx.getDeviceProfileCache().find(device.getDeviceProfileId());
        }
        return this.entityActionMsg(device, device.getId(), ruleNodeId, TbMsgType.ENTITY_CREATED, deviceProfile);
    }

    public TbMsg assetCreatedMsg(Asset asset, RuleNodeId ruleNodeId) {
        AssetProfile assetProfile = null;
        if (asset.getAssetProfileId() != null) {
            assetProfile = this.mainCtx.getAssetProfileCache().find(asset.getAssetProfileId());
        }
        return this.entityActionMsg(asset, asset.getId(), ruleNodeId, TbMsgType.ENTITY_CREATED, assetProfile);
    }

    public TbMsg alarmActionMsg(Alarm alarm, RuleNodeId ruleNodeId, String action) {
        EntityId originator = alarm.getOriginator();
        HasRuleEngineProfile profile = this.getRuleEngineProfile(originator);
        return this.entityActionMsg(alarm, originator, ruleNodeId, action, profile);
    }

    public TbMsg alarmActionMsg(Alarm alarm, RuleNodeId ruleNodeId, TbMsgType actionMsgType) {
        EntityId originator = alarm.getOriginator();
        HasRuleEngineProfile profile = this.getRuleEngineProfile(originator);
        return this.entityActionMsg(alarm, originator, ruleNodeId, actionMsgType, profile);
    }

    private HasRuleEngineProfile getRuleEngineProfile(EntityId originator) {
        DeviceProfile profile = null;
        if (EntityType.DEVICE.equals((Object)originator.getEntityType())) {
            DeviceId deviceId = new DeviceId(originator.getId());
            profile = this.mainCtx.getDeviceProfileCache().get(this.getTenantId(), deviceId);
        } else if (EntityType.ASSET.equals((Object)originator.getEntityType())) {
            AssetId assetId = new AssetId(originator.getId());
            profile = this.mainCtx.getAssetProfileCache().get(this.getTenantId(), assetId);
        }
        return profile;
    }

    public TbMsg attributesUpdatedActionMsg(EntityId originator, RuleNodeId ruleNodeId, String scope, List<AttributeKvEntry> attributes) {
        ObjectNode entityNode = JacksonUtil.newObjectNode();
        if (attributes != null) {
            attributes.forEach(attributeKvEntry -> JacksonUtil.addKvEntry((ObjectNode)entityNode, (KvEntry)attributeKvEntry));
        }
        return this.attributesActionMsg(originator, ruleNodeId, scope, TbMsgType.ATTRIBUTES_UPDATED, JacksonUtil.toString((Object)entityNode));
    }

    public TbMsg attributesDeletedActionMsg(EntityId originator, RuleNodeId ruleNodeId, String scope, List<String> keys) {
        ObjectNode entityNode = JacksonUtil.newObjectNode();
        ArrayNode attrsArrayNode = entityNode.putArray("attributes");
        if (keys != null) {
            keys.forEach(arg_0 -> ((ArrayNode)attrsArrayNode).add(arg_0));
        }
        return this.attributesActionMsg(originator, ruleNodeId, scope, TbMsgType.ATTRIBUTES_DELETED, JacksonUtil.toString((Object)entityNode));
    }

    private TbMsg attributesActionMsg(EntityId originator, RuleNodeId ruleNodeId, String scope, TbMsgType actionMsgType, String msgData) {
        TbMsgMetaData tbMsgMetaData = this.getActionMetaData(ruleNodeId);
        tbMsgMetaData.putValue("scope", scope);
        HasRuleEngineProfile profile = this.getRuleEngineProfile(originator);
        return this.entityActionMsg(originator, tbMsgMetaData, msgData, actionMsgType, profile);
    }

    public <E, I extends EntityId> TbMsg entityActionMsg(E entity, I id, RuleNodeId ruleNodeId, TbMsgType actionMsgType) {
        return this.entityActionMsg(entity, id, ruleNodeId, actionMsgType, null);
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public <E, I extends EntityId, K extends HasRuleEngineProfile> TbMsg entityActionMsg(E entity, I id, RuleNodeId ruleNodeId, String action, K profile) {
        try {
            return this.entityActionMsg(id, this.getActionMetaData(ruleNodeId), JacksonUtil.toString((Object)JacksonUtil.valueToTree(entity)), action, profile);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to process " + id.getEntityType().name().toLowerCase() + " " + action + " msg: " + String.valueOf(e));
        }
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    private <I extends EntityId, K extends HasRuleEngineProfile> TbMsg entityActionMsg(I id, TbMsgMetaData msgMetaData, String msgData, String action, K profile) {
        String defaultQueueName = null;
        RuleChainId defaultRuleChainId = null;
        if (profile != null) {
            defaultQueueName = profile.getDefaultQueueName();
            defaultRuleChainId = profile.getDefaultRuleChainId();
        }
        return TbMsg.newMsg().queueName(defaultQueueName).type(action).originator(id).copyMetaData(msgMetaData).data(msgData).ruleChainId(defaultRuleChainId).build();
    }

    public <E, I extends EntityId, K extends HasRuleEngineProfile> TbMsg entityActionMsg(E entity, I id, RuleNodeId ruleNodeId, TbMsgType actionMsgType, K profile) {
        try {
            return this.entityActionMsg(id, this.getActionMetaData(ruleNodeId), JacksonUtil.toString((Object)JacksonUtil.valueToTree(entity)), actionMsgType, profile);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to process " + id.getEntityType().name().toLowerCase() + " " + actionMsgType.name() + " msg: " + String.valueOf(e));
        }
    }

    private <I extends EntityId, K extends HasRuleEngineProfile> TbMsg entityActionMsg(I id, TbMsgMetaData msgMetaData, String msgData, TbMsgType actionMsgType, K profile) {
        String defaultQueueName = null;
        RuleChainId defaultRuleChainId = null;
        if (profile != null) {
            defaultQueueName = profile.getDefaultQueueName();
            defaultRuleChainId = profile.getDefaultRuleChainId();
        }
        return TbMsg.newMsg().queueName(defaultQueueName).type(actionMsgType).originator(id).copyMetaData(msgMetaData).data(msgData).ruleChainId(defaultRuleChainId).build();
    }

    public RuleNodeId getSelfId() {
        return this.nodeCtx.getSelf().getId();
    }

    public RuleNode getSelf() {
        return this.nodeCtx.getSelf();
    }

    public String getRuleChainName() {
        return this.ruleChainName;
    }

    public String getQueueName() {
        return this.getSelf().getQueueName();
    }

    public TenantId getTenantId() {
        return this.nodeCtx.getTenantId();
    }

    public ListeningExecutor getMailExecutor() {
        return this.mainCtx.getMailExecutor();
    }

    public ListeningExecutor getSmsExecutor() {
        return this.mainCtx.getSmsExecutor();
    }

    public ListeningExecutor getDbCallbackExecutor() {
        return this.mainCtx.getDbCallbackExecutor();
    }

    public ListeningExecutor getExternalCallExecutor() {
        return this.mainCtx.getExternalCallExecutorService();
    }

    public ListeningExecutor getNotificationExecutor() {
        return this.mainCtx.getNotificationExecutor();
    }

    public PubSubRuleNodeExecutorProvider getPubSubRuleNodeExecutorProvider() {
        return this.mainCtx.getPubSubRuleNodeExecutorProvider();
    }

    @Deprecated
    public ScriptEngine createJsScriptEngine(String script, String ... argNames) {
        return new RuleNodeJsScriptEngine(this.getTenantId(), this.mainCtx.getJsInvokeService(), script, argNames);
    }

    private ScriptEngine createTbelScriptEngine(String script, String ... argNames) {
        if (this.mainCtx.getTbelInvokeService() == null) {
            throw new RuntimeException("TBEL execution is disabled!");
        }
        return new RuleNodeTbelScriptEngine(this.getTenantId(), this.mainCtx.getTbelInvokeService(), script, argNames);
    }

    public ScriptEngine createScriptEngine(ScriptLanguage scriptLang, String script, String ... argNames) {
        if (scriptLang == null) {
            scriptLang = ScriptLanguage.JS;
        }
        if (StringUtils.isBlank((String)script)) {
            throw new RuntimeException(scriptLang.name() + " script is blank!");
        }
        switch (scriptLang) {
            case JS: {
                return this.createJsScriptEngine(script, argNames);
            }
            case TBEL: {
                if (Arrays.isNullOrEmpty((Object[])argNames)) {
                    return this.createTbelScriptEngine(script, "msg", "metadata", "msgType");
                }
                return this.createTbelScriptEngine(script, argNames);
            }
        }
        throw new RuntimeException("Unsupported script language: " + scriptLang.name());
    }

    public String getServiceId() {
        return this.mainCtx.getServiceInfoProvider().getServiceId();
    }

    public AttributesService getAttributesService() {
        return this.mainCtx.getAttributesService();
    }

    public CustomerService getCustomerService() {
        return this.mainCtx.getCustomerService();
    }

    public TenantService getTenantService() {
        return this.mainCtx.getTenantService();
    }

    public UserService getUserService() {
        return this.mainCtx.getUserService();
    }

    public AssetService getAssetService() {
        return this.mainCtx.getAssetService();
    }

    public DeviceService getDeviceService() {
        return this.mainCtx.getDeviceService();
    }

    public DeviceProfileService getDeviceProfileService() {
        return this.mainCtx.getDeviceProfileService();
    }

    public AssetProfileService getAssetProfileService() {
        return this.mainCtx.getAssetProfileService();
    }

    public DeviceCredentialsService getDeviceCredentialsService() {
        return this.mainCtx.getDeviceCredentialsService();
    }

    public DeviceStateManager getDeviceStateManager() {
        return this.mainCtx.getDeviceStateManager();
    }

    public String getDeviceStateNodeRateLimitConfig() {
        return this.mainCtx.getDeviceStateNodeRateLimitConfig();
    }

    public TbClusterService getClusterService() {
        return this.mainCtx.getClusterService();
    }

    public DashboardService getDashboardService() {
        return this.mainCtx.getDashboardService();
    }

    public RuleEngineAlarmService getAlarmService() {
        return this.mainCtx.getAlarmService();
    }

    public AlarmCommentService getAlarmCommentService() {
        return this.mainCtx.getAlarmCommentService();
    }

    public RuleChainService getRuleChainService() {
        return this.mainCtx.getRuleChainService();
    }

    public TimeseriesService getTimeseriesService() {
        return this.mainCtx.getTsService();
    }

    public RuleEngineTelemetryService getTelemetryService() {
        return this.mainCtx.getTsSubService();
    }

    public RelationService getRelationService() {
        return this.mainCtx.getRelationService();
    }

    public EntityViewService getEntityViewService() {
        return this.mainCtx.getEntityViewService();
    }

    public ResourceService getResourceService() {
        return this.mainCtx.getResourceService();
    }

    public TbResourceDataCache getTbResourceDataCache() {
        return this.mainCtx.getResourceDataCache();
    }

    public OtaPackageService getOtaPackageService() {
        return this.mainCtx.getOtaPackageService();
    }

    public RuleEngineDeviceProfileCache getDeviceProfileCache() {
        return this.mainCtx.getDeviceProfileCache();
    }

    public RuleEngineAssetProfileCache getAssetProfileCache() {
        return this.mainCtx.getAssetProfileCache();
    }

    public EdgeService getEdgeService() {
        return this.mainCtx.getEdgeService();
    }

    public EdgeEventService getEdgeEventService() {
        return this.mainCtx.getEdgeEventService();
    }

    public QueueService getQueueService() {
        return this.mainCtx.getQueueService();
    }

    public QueueStatsService getQueueStatsService() {
        return this.mainCtx.getQueueStatsService();
    }

    public EventLoopGroup getSharedEventLoop() {
        return this.mainCtx.getSharedEventLoopGroupService().getSharedEventLoopGroup();
    }

    public MailService getMailService(boolean isSystem) {
        if (!isSystem || this.mainCtx.isAllowSystemMailService()) {
            return this.mainCtx.getMailService();
        }
        throw new RuntimeException("Access to System Mail Service is forbidden!");
    }

    public SmsService getSmsService() {
        if (this.mainCtx.isAllowSystemSmsService()) {
            return this.mainCtx.getSmsService();
        }
        throw new RuntimeException("Access to System SMS Service is forbidden!");
    }

    public SmsSenderFactory getSmsSenderFactory() {
        return this.mainCtx.getSmsSenderFactory();
    }

    public NotificationCenter getNotificationCenter() {
        return this.mainCtx.getNotificationCenter();
    }

    public NotificationTargetService getNotificationTargetService() {
        return this.mainCtx.getNotificationTargetService();
    }

    public NotificationTemplateService getNotificationTemplateService() {
        return this.mainCtx.getNotificationTemplateService();
    }

    public NotificationRequestService getNotificationRequestService() {
        return this.mainCtx.getNotificationRequestService();
    }

    public NotificationRuleService getNotificationRuleService() {
        return this.mainCtx.getNotificationRuleService();
    }

    public OAuth2ClientService getOAuth2ClientService() {
        return this.mainCtx.getOAuth2ClientService();
    }

    public DomainService getDomainService() {
        return this.mainCtx.getDomainService();
    }

    public MobileAppService getMobileAppService() {
        return this.mainCtx.getMobileAppService();
    }

    public MobileAppBundleService getMobileAppBundleService() {
        return this.mainCtx.getMobileAppBundleService();
    }

    public SlackService getSlackService() {
        return this.mainCtx.getSlackService();
    }

    public CalculatedFieldService getCalculatedFieldService() {
        return this.mainCtx.getCalculatedFieldService();
    }

    public RuleEngineCalculatedFieldQueueService getCalculatedFieldQueueService() {
        return this.mainCtx.getCalculatedFieldQueueService();
    }

    public JobService getJobService() {
        return this.mainCtx.getJobService();
    }

    public JobManager getJobManager() {
        return this.mainCtx.getJobManager();
    }

    public boolean isExternalNodeForceAck() {
        return this.mainCtx.isExternalNodeForceAck();
    }

    public RuleEngineRpcService getRpcService() {
        return this.mainCtx.getTbRuleEngineDeviceRpcService();
    }

    public CassandraCluster getCassandraCluster() {
        return this.mainCtx.getCassandraCluster();
    }

    public TbResultSetFuture submitCassandraReadTask(CassandraStatementTask task) {
        return (TbResultSetFuture)this.mainCtx.getCassandraBufferedRateReadExecutor().submit((AsyncTask)task);
    }

    public TbResultSetFuture submitCassandraWriteTask(CassandraStatementTask task) {
        return (TbResultSetFuture)this.mainCtx.getCassandraBufferedRateWriteExecutor().submit((AsyncTask)task);
    }

    public PageData<RuleNodeState> findRuleNodeStates(PageLink pageLink) {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Fetch Rule Node States.", (Object)this.getTenantId(), (Object)this.getSelfId());
        }
        return this.mainCtx.getRuleNodeStateService().findByRuleNodeId(this.getTenantId(), this.getSelfId(), pageLink);
    }

    public RuleNodeState findRuleNodeStateForEntity(EntityId entityId) {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}][{}] Fetch Rule Node State for entity.", new Object[]{this.getTenantId(), this.getSelfId(), entityId});
        }
        return this.mainCtx.getRuleNodeStateService().findByRuleNodeIdAndEntityId(this.getTenantId(), this.getSelfId(), entityId);
    }

    public RuleNodeState saveRuleNodeState(RuleNodeState state) {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}][{}] Persist Rule Node State for entity: {}", new Object[]{this.getTenantId(), this.getSelfId(), state.getEntityId(), state.getStateData()});
        }
        state.setRuleNodeId(this.getSelfId());
        return this.mainCtx.getRuleNodeStateService().save(this.getTenantId(), state);
    }

    public void clearRuleNodeStates() {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Going to clear rule node states", (Object)this.getTenantId(), (Object)this.getSelfId());
        }
        this.mainCtx.getRuleNodeStateService().removeByRuleNodeId(this.getTenantId(), this.getSelfId());
    }

    public void removeRuleNodeStateForEntity(EntityId entityId) {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}][{}] Remove Rule Node State for entity.", new Object[]{this.getTenantId(), this.getSelfId(), entityId});
        }
        this.mainCtx.getRuleNodeStateService().removeByRuleNodeIdAndEntityId(this.getTenantId(), this.getSelfId(), entityId);
    }

    public void addTenantProfileListener(Consumer<TenantProfile> listener) {
        this.mainCtx.getTenantProfileCache().addListener(this.getTenantId(), (EntityId)this.getSelfId(), listener);
    }

    public void addDeviceProfileListeners(Consumer<DeviceProfile> profileListener, BiConsumer<DeviceId, DeviceProfile> deviceListener) {
        this.mainCtx.getDeviceProfileCache().addListener(this.getTenantId(), (EntityId)this.getSelfId(), profileListener, deviceListener);
    }

    public void addAssetProfileListeners(Consumer<AssetProfile> profileListener, BiConsumer<AssetId, AssetProfile> assetListener) {
        this.mainCtx.getAssetProfileCache().addListener(this.getTenantId(), (EntityId)this.getSelfId(), profileListener, assetListener);
    }

    public void removeListeners() {
        this.mainCtx.getDeviceProfileCache().removeListener(this.getTenantId(), (EntityId)this.getSelfId());
        this.mainCtx.getAssetProfileCache().removeListener(this.getTenantId(), (EntityId)this.getSelfId());
        this.mainCtx.getTenantProfileCache().removeListener(this.getTenantId(), (EntityId)this.getSelfId());
    }

    public TenantProfile getTenantProfile() {
        return this.mainCtx.getTenantProfileCache().get(this.getTenantId());
    }

    public WidgetsBundleService getWidgetBundleService() {
        return this.mainCtx.getWidgetsBundleService();
    }

    public WidgetTypeService getWidgetTypeService() {
        return this.mainCtx.getWidgetTypeService();
    }

    public RuleEngineApiUsageStateService getRuleEngineApiUsageStateService() {
        return this.mainCtx.getApiUsageStateService();
    }

    public EntityService getEntityService() {
        return this.mainCtx.getEntityService();
    }

    public EventService getEventService() {
        return this.mainCtx.getEventService();
    }

    public AuditLogService getAuditLogService() {
        return this.mainCtx.getAuditLogService();
    }

    public RuleEngineAiChatModelService getAiChatModelService() {
        return this.mainCtx.getAiChatModelService();
    }

    public AiModelService getAiModelService() {
        return this.mainCtx.getAiModelService();
    }

    public MqttClientSettings getMqttClientSettings() {
        return this.mainCtx.getMqttClientSettings();
    }

    private TbMsgMetaData getActionMetaData(RuleNodeId ruleNodeId) {
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("ruleNodeId", ruleNodeId.toString());
        return metaData;
    }

    public void schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.mainCtx.getScheduler().schedule(runnable, delay, timeUnit);
    }

    public void checkTenantEntity(EntityId entityId) throws TbNodeException {
        TenantId actualTenantId = TenantIdLoader.findTenantId((TbContext)this, (EntityId)entityId);
        if (!this.getTenantId().equals((Object)actualTenantId)) {
            throw new TbNodeException("Entity with id: '" + String.valueOf(entityId) + "' specified in the configuration doesn't belong to the current tenant.", true);
        }
    }

    public <E extends HasId<I> & HasTenantId, I extends EntityId> void checkTenantOrSystemEntity(E entity) throws TbNodeException {
        TenantId actualTenantId = ((HasTenantId)entity).getTenantId();
        if (!this.getTenantId().equals((Object)actualTenantId) && !actualTenantId.isSysTenantId()) {
            throw new TbNodeException("Entity with id: '" + String.valueOf(entity.getId()) + "' specified in the configuration doesn't belong to the current or system tenant.", true);
        }
    }

    private static String getFailureMessage(Throwable th) {
        String failureMessage = th != null ? (!StringUtils.isEmpty((String)th.getMessage()) ? th.getMessage() : th.getClass().getSimpleName()) : null;
        return failureMessage;
    }

    private void persistDebugOutput(TbMsg msg, String relationType) {
        this.persistDebugOutput(msg, Set.of(relationType));
    }

    private void persistDebugOutput(TbMsg msg, Set<String> relationTypes) {
        this.persistDebugOutput(msg, relationTypes, null, null);
    }

    private void persistDebugOutput(TbMsg msg, Set<String> relationTypes, Throwable error, String failureMessage) {
        RuleNode ruleNode = this.nodeCtx.getSelf();
        if (DebugModeUtil.isDebugAllAvailable((HasDebugSettings)ruleNode)) {
            relationTypes.forEach(relationType -> this.mainCtx.persistDebugOutput(this.getTenantId(), (EntityId)ruleNode.getId(), msg, (String)relationType, error, failureMessage));
        } else if (DebugModeUtil.isDebugFailuresAvailable((HasDebugSettings)ruleNode, relationTypes)) {
            this.mainCtx.persistDebugOutput(this.getTenantId(), (EntityId)ruleNode.getId(), msg, "Failure", error, failureMessage);
        }
    }
}

