/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.device;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.LinkedHashMapRemoveEldest;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.device.SessionInfo;
import org.thingsboard.server.actors.device.SessionInfoMetaData;
import org.thingsboard.server.actors.device.ToDeviceRpcRequestMetadata;
import org.thingsboard.server.actors.device.TransportSessionCloseReason;
import org.thingsboard.server.actors.shared.AbstractContextAwareMsgProcessor;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKey;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.rpc.Rpc;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.common.data.rpc.ToDeviceRpcRequestBody;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.edge.EdgeHighPriorityMsg;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponseActorMsg;
import org.thingsboard.server.common.msg.rpc.RemoveRpcActorMsg;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequest;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequestActorMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceAttributesEventNotificationMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceCredentialsUpdateNotificationMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceEdgeUpdateMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceNameOrTypeUpdateMsg;
import org.thingsboard.server.common.msg.timeout.DeviceActorServerSideRpcTimeoutMsg;
import org.thingsboard.server.common.util.KvProtoUtil;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.rpc.RpcSubmitStrategy;
import org.thingsboard.server.service.transport.msg.TransportToDeviceActorMsgWrapper;

public class DeviceActorMessageProcessor
extends AbstractContextAwareMsgProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceActorMessageProcessor.class);
    final TenantId tenantId;
    final DeviceId deviceId;
    final LinkedHashMapRemoveEldest<UUID, SessionInfoMetaData> sessions;
    final Map<UUID, SessionInfo> attributeSubscriptions;
    final Map<UUID, SessionInfo> rpcSubscriptions;
    private final Map<Integer, ToDeviceRpcRequestMetadata> toDeviceRpcPendingMap;
    private final boolean rpcSequential;
    private final RpcSubmitStrategy rpcSubmitStrategy;
    private final ScheduledExecutorService scheduler;
    private final boolean closeTransportSessionOnRpcDeliveryTimeout;
    private int rpcSeq = 0;
    private String deviceName;
    private String deviceType;
    private TbMsgMetaData defaultMetaData;
    private EdgeId edgeId;
    private ScheduledFuture<?> awaitRpcResponseFuture;

    DeviceActorMessageProcessor(ActorSystemContext systemContext, TenantId tenantId, DeviceId deviceId) {
        super(systemContext);
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.rpcSubmitStrategy = RpcSubmitStrategy.parse(systemContext.getRpcSubmitStrategy());
        this.closeTransportSessionOnRpcDeliveryTimeout = systemContext.isCloseTransportSessionOnRpcDeliveryTimeout();
        this.rpcSequential = !this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.BURST);
        this.attributeSubscriptions = new HashMap<UUID, SessionInfo>();
        this.rpcSubscriptions = new HashMap<UUID, SessionInfo>();
        this.toDeviceRpcPendingMap = new LinkedHashMap<Integer, ToDeviceRpcRequestMetadata>();
        this.sessions = new LinkedHashMapRemoveEldest(systemContext.getMaxConcurrentSessionsPerDevice(), this::notifyTransportAboutClosedSessionMaxSessionsLimit);
        this.scheduler = systemContext.getScheduler();
        if (this.initAttributes()) {
            this.restoreSessions();
        }
    }

    boolean initAttributes() {
        Device device = this.systemContext.getDeviceService().findDeviceById(this.tenantId, this.deviceId);
        if (device != null) {
            this.deviceName = device.getName();
            this.deviceType = device.getType();
            this.defaultMetaData = new TbMsgMetaData();
            this.defaultMetaData.putValue("deviceName", this.deviceName);
            this.defaultMetaData.putValue("deviceType", this.deviceType);
            if (this.systemContext.isEdgesEnabled()) {
                this.edgeId = this.findRelatedEdgeId();
            }
            return true;
        }
        return false;
    }

    private EdgeId findRelatedEdgeId() {
        List result = this.systemContext.getRelationService().findByToAndType(this.tenantId, (EntityId)this.deviceId, "Contains", RelationTypeGroup.EDGE);
        if (result != null && !result.isEmpty()) {
            EntityRelation relationToEdge = (EntityRelation)result.get(0);
            if (relationToEdge.getFrom() != null && relationToEdge.getFrom().getId() != null) {
                log.trace("[{}][{}] found edge [{}] for device", new Object[]{this.tenantId, this.deviceId, relationToEdge.getFrom().getId()});
                return new EdgeId(relationToEdge.getFrom().getId());
            }
            log.trace("[{}][{}] edge relation is empty {}", new Object[]{this.tenantId, this.deviceId, relationToEdge});
        } else {
            log.trace("[{}][{}] device doesn't have any related edge", (Object)this.tenantId, (Object)this.deviceId);
        }
        return null;
    }

    void processRpcRequest(TbActorCtx context, ToDeviceRpcRequestActorMsg msg) {
        int requestId;
        boolean sent;
        boolean persisted;
        long timeout;
        TransportProtos.ToDeviceRpcRequestMsg rpcRequest;
        UUID rpcId;
        ToDeviceRpcRequest request;
        block12: {
            request = msg.getMsg();
            rpcId = request.getId();
            log.debug("[{}][{}] Received RPC request to process ...", (Object)this.deviceId, (Object)rpcId);
            rpcRequest = this.createToDeviceRpcRequestMsg(request);
            timeout = request.getExpirationTime() - System.currentTimeMillis();
            persisted = request.isPersisted();
            if (timeout <= 0L) {
                log.debug("[{}][{}] Ignoring message due to exp time reached, {}", new Object[]{this.deviceId, rpcId, request.getExpirationTime()});
                if (persisted) {
                    this.createRpc(request, RpcStatus.EXPIRED);
                }
                return;
            }
            if (persisted) {
                this.createRpc(request, RpcStatus.QUEUED);
            }
            sent = false;
            requestId = rpcRequest.getRequestId();
            if (this.systemContext.isEdgesEnabled() && this.edgeId != null) {
                log.debug("[{}][{}] device is related to edge: [{}]. Saving RPC request: [{}][{}] to edge queue", new Object[]{this.tenantId, this.deviceId, this.edgeId.getId(), rpcId, requestId});
                try {
                    if (((Boolean)this.systemContext.getEdgeService().isEdgeActiveAsync(this.tenantId, this.edgeId, "active").get()).booleanValue()) {
                        this.saveRpcRequestToEdgeQueue(request, requestId);
                        break block12;
                    }
                    log.error("[{}][{}][{}] Failed to save RPC request to edge queue {}. The Edge is currently offline or unreachable", new Object[]{this.tenantId, this.deviceId, this.edgeId.getId(), request});
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("[{}][{}][{}] Failed to save RPC request to edge queue {}", new Object[]{this.tenantId, this.deviceId, this.edgeId.getId(), request, e});
                }
            } else if (this.isSendNewRpcAvailable()) {
                sent = !this.rpcSubscriptions.isEmpty();
                HashSet syncSessionSet = new HashSet();
                this.rpcSubscriptions.forEach((sessionId, sessionInfo) -> {
                    log.debug("[{}][{}][{}][{}] send RPC request to transport ...", new Object[]{this.deviceId, sessionId, rpcId, requestId});
                    this.sendToTransport(rpcRequest, (UUID)sessionId, sessionInfo.getNodeId());
                    if (TransportProtos.SessionType.SYNC == sessionInfo.getType()) {
                        syncSessionSet.add(sessionId);
                    }
                });
                log.trace("Rpc syncSessionSet [{}] subscription after sent [{}]", syncSessionSet, this.rpcSubscriptions);
                syncSessionSet.forEach(this.rpcSubscriptions::remove);
            }
        }
        if (persisted) {
            ObjectNode response = JacksonUtil.newObjectNode();
            response.put("rpcId", rpcId.toString());
            this.systemContext.getTbCoreDeviceRpcService().processRpcResponseFromDeviceActor(new FromDeviceRpcResponse(rpcId, JacksonUtil.toString((Object)response), null));
        }
        if (!persisted && request.isOneway() && sent) {
            log.debug("[{}] RPC command response sent [{}][{}]!", new Object[]{this.deviceId, rpcId, requestId});
            this.systemContext.getTbCoreDeviceRpcService().processRpcResponseFromDeviceActor(new FromDeviceRpcResponse(rpcId, null, null));
        } else {
            this.registerPendingRpcRequest(context, msg, sent, rpcRequest, timeout);
        }
        String rpcSent = sent ? "sent!" : "NOT sent!";
        log.debug("[{}][{}][{}] RPC request is {}", new Object[]{this.deviceId, rpcId, requestId, rpcSent});
    }

    private boolean isSendNewRpcAvailable() {
        return switch (this.rpcSubmitStrategy) {
            case RpcSubmitStrategy.SEQUENTIAL_ON_ACK_FROM_DEVICE -> this.toDeviceRpcPendingMap.values().stream().filter(md -> !md.isDelivered()).findAny().isEmpty();
            case RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE -> this.toDeviceRpcPendingMap.isEmpty();
            default -> true;
        };
    }

    private void createRpc(ToDeviceRpcRequest request, RpcStatus status) {
        Rpc rpc = new Rpc(new RpcId(request.getId()));
        rpc.setCreatedTime(System.currentTimeMillis());
        rpc.setTenantId(this.tenantId);
        rpc.setDeviceId(this.deviceId);
        rpc.setExpirationTime(request.getExpirationTime());
        rpc.setRequest(JacksonUtil.valueToTree((Object)request));
        rpc.setStatus(status);
        rpc.setAdditionalInfo(this.getAdditionalInfo(request));
        this.systemContext.getTbRpcService().save(this.tenantId, rpc);
    }

    private JsonNode getAdditionalInfo(ToDeviceRpcRequest request) {
        try {
            return JacksonUtil.toJsonNode((String)request.getAdditionalInfo());
        }
        catch (IllegalArgumentException e) {
            log.debug("Failed to parse additional info [{}]", (Object)request.getAdditionalInfo());
            return JacksonUtil.valueToTree((Object)request.getAdditionalInfo());
        }
    }

    private TransportProtos.ToDeviceRpcRequestMsg createToDeviceRpcRequestMsg(ToDeviceRpcRequest request) {
        ToDeviceRpcRequestBody body = request.getBody();
        return TransportProtos.ToDeviceRpcRequestMsg.newBuilder().setRequestId(this.rpcSeq++).setMethodName(body.getMethod()).setParams(body.getParams()).setExpirationTime(request.getExpirationTime()).setRequestIdMSB(request.getId().getMostSignificantBits()).setRequestIdLSB(request.getId().getLeastSignificantBits()).setOneway(request.isOneway()).setPersisted(request.isPersisted()).build();
    }

    void processRpcResponsesFromEdge(FromDeviceRpcResponseActorMsg responseMsg) {
        boolean success;
        log.debug("[{}] Processing RPC command response from edge session", (Object)this.deviceId);
        ToDeviceRpcRequestMetadata requestMd = this.toDeviceRpcPendingMap.remove(responseMsg.getRequestId());
        boolean bl = success = requestMd != null;
        if (success) {
            this.systemContext.getTbCoreDeviceRpcService().processRpcResponseFromDeviceActor(responseMsg.getMsg());
        } else {
            log.debug("[{}] RPC command response [{}] is stale!", (Object)this.deviceId, (Object)responseMsg.getRequestId());
        }
    }

    void processRemoveRpc(RemoveRpcActorMsg msg) {
        UUID rpcId = msg.getRequestId();
        log.debug("[{}][{}] Received remove RPC request ...", (Object)this.deviceId, (Object)rpcId);
        Map.Entry<Integer, ToDeviceRpcRequestMetadata> entry = null;
        for (Map.Entry<Integer, ToDeviceRpcRequestMetadata> e : this.toDeviceRpcPendingMap.entrySet()) {
            if (!e.getValue().getMsg().getMsg().getId().equals(rpcId)) continue;
            entry = e;
            break;
        }
        if (entry != null) {
            Integer requestId = (Integer)entry.getKey();
            if (((ToDeviceRpcRequestMetadata)entry.getValue()).isDelivered()) {
                this.toDeviceRpcPendingMap.remove(requestId);
                if (this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE)) {
                    this.clearAwaitRpcResponseScheduler();
                    this.sendNextPendingRequest(rpcId, requestId, "Removed pending RPC!");
                }
            } else {
                Optional<Map.Entry<Integer, ToDeviceRpcRequestMetadata>> firstRpc = this.getFirstRpc();
                if (firstRpc.isPresent() && requestId.equals(firstRpc.get().getKey())) {
                    this.toDeviceRpcPendingMap.remove(requestId);
                    this.sendNextPendingRequest(rpcId, requestId, "Removed pending RPC!");
                } else {
                    this.toDeviceRpcPendingMap.remove(requestId);
                }
            }
        }
    }

    private void registerPendingRpcRequest(TbActorCtx context, ToDeviceRpcRequestActorMsg msg, boolean sent, TransportProtos.ToDeviceRpcRequestMsg rpcRequest, long timeout) {
        int requestId = rpcRequest.getRequestId();
        UUID rpcId = new UUID(rpcRequest.getRequestIdMSB(), rpcRequest.getRequestIdLSB());
        log.debug("[{}][{}][{}] Registering pending RPC request...", new Object[]{this.deviceId, rpcId, requestId});
        this.toDeviceRpcPendingMap.put(requestId, new ToDeviceRpcRequestMetadata(msg, sent));
        DeviceActorServerSideRpcTimeoutMsg timeoutMsg = new DeviceActorServerSideRpcTimeoutMsg(Integer.valueOf(requestId), timeout);
        this.scheduleMsgWithDelay(context, (TbActorMsg)timeoutMsg, timeoutMsg.getTimeout());
    }

    void processServerSideRpcTimeout(DeviceActorServerSideRpcTimeoutMsg msg) {
        Integer requestId = (Integer)msg.getId();
        ToDeviceRpcRequestMetadata requestMd = this.toDeviceRpcPendingMap.remove(requestId);
        if (requestMd != null) {
            ToDeviceRpcRequest toDeviceRpcRequest = requestMd.getMsg().getMsg();
            UUID rpcId = toDeviceRpcRequest.getId();
            log.debug("[{}][{}][{}] RPC request timeout detected!", new Object[]{this.deviceId, rpcId, requestId});
            if (toDeviceRpcRequest.isPersisted()) {
                this.systemContext.getTbRpcService().save(this.tenantId, new RpcId(rpcId), RpcStatus.EXPIRED, null);
            }
            this.systemContext.getTbCoreDeviceRpcService().processRpcResponseFromDeviceActor(new FromDeviceRpcResponse(rpcId, null, requestMd.isSent() ? RpcError.TIMEOUT : RpcError.NO_ACTIVE_CONNECTION));
            if (!requestMd.isDelivered()) {
                this.sendNextPendingRequest(rpcId, requestId, "Pending RPC timeout detected!");
                return;
            }
            if (this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE)) {
                this.clearAwaitRpcResponseScheduler();
                this.sendNextPendingRequest(rpcId, requestId, "Pending RPC timeout detected!");
            }
        }
    }

    private void sendPendingRequests(UUID sessionId, String nodeId) {
        TransportProtos.SessionType sessionType = this.getSessionType(sessionId);
        if (!this.toDeviceRpcPendingMap.isEmpty()) {
            log.debug("[{}] Pushing {} pending RPC messages to session: [{}]", new Object[]{this.deviceId, sessionId, this.toDeviceRpcPendingMap.size()});
            if (sessionType == TransportProtos.SessionType.SYNC) {
                log.debug("[{}] Cleanup sync RPC session [{}]", (Object)this.deviceId, (Object)sessionId);
                this.rpcSubscriptions.remove(sessionId);
            }
        } else {
            log.debug("[{}] No pending RPC messages for session: [{}]", (Object)this.deviceId, (Object)sessionId);
        }
        HashSet<Integer> sentOneWayIds = new HashSet<Integer>();
        if (this.rpcSequential) {
            this.getFirstRpc().ifPresent(this.processPendingRpc(sessionId, nodeId, sentOneWayIds));
        } else if (sessionType == TransportProtos.SessionType.ASYNC) {
            this.toDeviceRpcPendingMap.entrySet().forEach(this.processPendingRpc(sessionId, nodeId, sentOneWayIds));
        } else {
            this.toDeviceRpcPendingMap.entrySet().stream().findFirst().ifPresent(this.processPendingRpc(sessionId, nodeId, sentOneWayIds));
        }
        sentOneWayIds.stream().filter(id -> !this.toDeviceRpcPendingMap.get(id).getMsg().getMsg().isPersisted()).forEach(this.toDeviceRpcPendingMap::remove);
    }

    private Optional<Map.Entry<Integer, ToDeviceRpcRequestMetadata>> getFirstRpc() {
        if (this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE)) {
            return this.toDeviceRpcPendingMap.entrySet().stream().findFirst().filter(entry -> {
                ToDeviceRpcRequestMetadata md = (ToDeviceRpcRequestMetadata)entry.getValue();
                if (md.isDelivered()) {
                    if (this.awaitRpcResponseFuture == null || this.awaitRpcResponseFuture.isCancelled()) {
                        ToDeviceRpcRequest toDeviceRpcRequest = md.getMsg().getMsg();
                        this.awaitRpcResponseFuture = this.scheduleAwaitRpcResponseFuture(toDeviceRpcRequest.getId(), (Integer)entry.getKey());
                    }
                    return false;
                }
                return true;
            });
        }
        return this.toDeviceRpcPendingMap.entrySet().stream().filter(e -> !((ToDeviceRpcRequestMetadata)e.getValue()).isDelivered()).findFirst();
    }

    private void sendNextPendingRequest(UUID rpcId, int requestId, String logMessage) {
        log.debug("[{}][{}][{}] {} Going to send next pending request ...", new Object[]{this.deviceId, rpcId, requestId, logMessage});
        if (this.rpcSequential) {
            this.rpcSubscriptions.forEach((id, s) -> this.sendPendingRequests((UUID)id, s.getNodeId()));
        }
    }

    private Consumer<Map.Entry<Integer, ToDeviceRpcRequestMetadata>> processPendingRpc(UUID sessionId, String nodeId, Set<Integer> sentOneWayIds) {
        return entry -> {
            ToDeviceRpcRequest request = ((ToDeviceRpcRequestMetadata)entry.getValue()).getMsg().getMsg();
            ToDeviceRpcRequestBody body = request.getBody();
            Integer requestId = (Integer)entry.getKey();
            UUID rpcId = request.getId();
            if (request.isOneway() && !this.rpcSequential) {
                sentOneWayIds.add(requestId);
                this.systemContext.getTbCoreDeviceRpcService().processRpcResponseFromDeviceActor(new FromDeviceRpcResponse(rpcId, null, null));
            }
            TransportProtos.ToDeviceRpcRequestMsg rpcRequest = TransportProtos.ToDeviceRpcRequestMsg.newBuilder().setRequestId(requestId.intValue()).setMethodName(body.getMethod()).setParams(body.getParams()).setExpirationTime(request.getExpirationTime()).setRequestIdMSB(rpcId.getMostSignificantBits()).setRequestIdLSB(rpcId.getLeastSignificantBits()).setOneway(request.isOneway()).setPersisted(request.isPersisted()).build();
            log.debug("[{}][{}][{}][{}] Send pending RPC request to transport ...", new Object[]{this.deviceId, sessionId, rpcId, requestId});
            this.sendToTransport(rpcRequest, sessionId, nodeId);
        };
    }

    void process(TransportToDeviceActorMsgWrapper wrapper) {
        TransportProtos.TransportToDeviceActorMsg msg = wrapper.getMsg();
        TbCallback callback = wrapper.getCallback();
        TransportProtos.SessionInfoProto sessionInfo = msg.getSessionInfo();
        if (msg.hasSessionEvent()) {
            this.processSessionStateMsgs(sessionInfo, msg.getSessionEvent());
        }
        if (msg.hasSubscribeToAttributes()) {
            this.processSubscriptionCommands(sessionInfo, msg.getSubscribeToAttributes());
        }
        if (msg.hasSubscribeToRPC()) {
            this.processSubscriptionCommands(sessionInfo, msg.getSubscribeToRPC());
        }
        if (msg.hasSendPendingRPC()) {
            this.sendPendingRequests(this.getSessionId(sessionInfo), sessionInfo.getNodeId());
        }
        if (msg.hasGetAttributes()) {
            this.handleGetAttributesRequest(sessionInfo, msg.getGetAttributes());
        }
        if (msg.hasToDeviceRPCCallResponse()) {
            this.processRpcResponses(sessionInfo, msg.getToDeviceRPCCallResponse());
        }
        if (msg.hasSubscriptionInfo()) {
            this.handleSessionActivity(sessionInfo, msg.getSubscriptionInfo());
        }
        if (msg.hasClaimDevice()) {
            this.handleClaimDeviceMsg(sessionInfo, msg.getClaimDevice());
        }
        if (msg.hasRpcResponseStatusMsg()) {
            this.processRpcResponseStatus(sessionInfo, msg.getRpcResponseStatusMsg());
        }
        if (msg.hasUplinkNotificationMsg()) {
            this.processUplinkNotificationMsg(sessionInfo, msg.getUplinkNotificationMsg());
        }
        callback.onSuccess();
    }

    private void processUplinkNotificationMsg(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.UplinkNotificationMsg uplinkNotificationMsg) {
        String nodeId = sessionInfo.getNodeId();
        this.sessions.entrySet().stream().filter(kv -> ((SessionInfoMetaData)kv.getValue()).getSessionInfo().getNodeId().equals(nodeId) && (((SessionInfoMetaData)kv.getValue()).isSubscribedToAttributes() || ((SessionInfoMetaData)kv.getValue()).isSubscribedToRPC())).forEach(kv -> {
            TransportProtos.ToTransportMsg msg = TransportProtos.ToTransportMsg.newBuilder().setSessionIdMSB(((UUID)kv.getKey()).getMostSignificantBits()).setSessionIdLSB(((UUID)kv.getKey()).getLeastSignificantBits()).setUplinkNotificationMsg(uplinkNotificationMsg).build();
            this.systemContext.getTbCoreToTransportService().process(((SessionInfoMetaData)kv.getValue()).getSessionInfo().getNodeId(), msg);
        });
    }

    private void handleClaimDeviceMsg(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ClaimDeviceMsg msg) {
        final UUID sessionId = this.getSessionId(sessionInfo);
        final DeviceId deviceId = new DeviceId(new UUID(msg.getDeviceIdMSB(), msg.getDeviceIdLSB()));
        ListenableFuture registrationFuture = this.systemContext.getClaimDevicesService().registerClaimingInfo(this.tenantId, deviceId, msg.getSecretKey(), msg.getDurationMs());
        Futures.addCallback((ListenableFuture)registrationFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                log.debug("[{}][{}] Successfully processed register claiming info request!", (Object)sessionId, (Object)deviceId);
            }

            public void onFailure(Throwable t) {
                log.error("[{}][{}] Failed to process register claiming info request due to: ", new Object[]{sessionId, deviceId, t});
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void reportSessionOpen() {
        this.systemContext.getDeviceStateService().onDeviceConnect(this.tenantId, this.deviceId);
    }

    private void reportSessionClose() {
        this.systemContext.getDeviceStateService().onDeviceDisconnect(this.tenantId, this.deviceId);
    }

    private void handleGetAttributesRequest(final TransportProtos.SessionInfoProto sessionInfo, final TransportProtos.GetAttributeRequestMsg request) {
        final int requestId = request.getRequestId();
        if (request.getOnlyShared()) {
            Futures.addCallback(this.findAllAttributesByScope(AttributeScope.SHARED_SCOPE), (FutureCallback)new FutureCallback<List<AttributeKvEntry>>(){

                public void onSuccess(@Nullable List<AttributeKvEntry> result) {
                    TransportProtos.GetAttributeResponseMsg responseMsg = TransportProtos.GetAttributeResponseMsg.newBuilder().setRequestId(requestId).setSharedStateMsg(true).addAllSharedAttributeList((Iterable)KvProtoUtil.attrToTsKvProtos(result)).setIsMultipleAttributesRequest(request.getSharedAttributeNamesCount() > 1).build();
                    DeviceActorMessageProcessor.this.sendToTransport(responseMsg, sessionInfo);
                }

                public void onFailure(Throwable t) {
                    TransportProtos.GetAttributeResponseMsg responseMsg = TransportProtos.GetAttributeResponseMsg.newBuilder().setError(t.getMessage()).setSharedStateMsg(true).build();
                    DeviceActorMessageProcessor.this.sendToTransport(responseMsg, sessionInfo);
                }
            }, (Executor)MoreExecutors.directExecutor());
        } else {
            Futures.addCallback(this.getAttributesKvEntries(request), (FutureCallback)new FutureCallback<List<List<AttributeKvEntry>>>(){

                public void onSuccess(@Nullable List<List<AttributeKvEntry>> result) {
                    TransportProtos.GetAttributeResponseMsg responseMsg = TransportProtos.GetAttributeResponseMsg.newBuilder().setRequestId(requestId).addAllClientAttributeList((Iterable)KvProtoUtil.attrToTsKvProtos(result.get(0))).addAllSharedAttributeList((Iterable)KvProtoUtil.attrToTsKvProtos(result.get(1))).setIsMultipleAttributesRequest(request.getSharedAttributeNamesCount() + request.getClientAttributeNamesCount() > 1).build();
                    DeviceActorMessageProcessor.this.sendToTransport(responseMsg, sessionInfo);
                }

                public void onFailure(Throwable t) {
                    TransportProtos.GetAttributeResponseMsg responseMsg = TransportProtos.GetAttributeResponseMsg.newBuilder().setError(t.getMessage()).build();
                    DeviceActorMessageProcessor.this.sendToTransport(responseMsg, sessionInfo);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    private ListenableFuture<List<List<AttributeKvEntry>>> getAttributesKvEntries(TransportProtos.GetAttributeRequestMsg request) {
        ListenableFuture<List<AttributeKvEntry>> sharedAttributesFuture;
        ListenableFuture<List<AttributeKvEntry>> clientAttributesFuture;
        if (CollectionUtils.isEmpty((Collection)request.getClientAttributeNamesList()) && CollectionUtils.isEmpty((Collection)request.getSharedAttributeNamesList())) {
            clientAttributesFuture = this.findAllAttributesByScope(AttributeScope.CLIENT_SCOPE);
            sharedAttributesFuture = this.findAllAttributesByScope(AttributeScope.SHARED_SCOPE);
        } else if (!CollectionUtils.isEmpty((Collection)request.getClientAttributeNamesList()) && !CollectionUtils.isEmpty((Collection)request.getSharedAttributeNamesList())) {
            clientAttributesFuture = this.findAttributesByScope(this.toSet((List<String>)request.getClientAttributeNamesList()), AttributeScope.CLIENT_SCOPE);
            sharedAttributesFuture = this.findAttributesByScope(this.toSet((List<String>)request.getSharedAttributeNamesList()), AttributeScope.SHARED_SCOPE);
        } else if (CollectionUtils.isEmpty((Collection)request.getClientAttributeNamesList()) && !CollectionUtils.isEmpty((Collection)request.getSharedAttributeNamesList())) {
            clientAttributesFuture = Futures.immediateFuture(Collections.emptyList());
            sharedAttributesFuture = this.findAttributesByScope(this.toSet((List<String>)request.getSharedAttributeNamesList()), AttributeScope.SHARED_SCOPE);
        } else {
            sharedAttributesFuture = Futures.immediateFuture(Collections.emptyList());
            clientAttributesFuture = this.findAttributesByScope(this.toSet((List<String>)request.getClientAttributeNamesList()), AttributeScope.CLIENT_SCOPE);
        }
        return Futures.allAsList(Arrays.asList(clientAttributesFuture, sharedAttributesFuture));
    }

    private ListenableFuture<List<AttributeKvEntry>> findAllAttributesByScope(AttributeScope scope) {
        return this.systemContext.getAttributesService().findAll(this.tenantId, (EntityId)this.deviceId, scope);
    }

    private ListenableFuture<List<AttributeKvEntry>> findAttributesByScope(Set<String> attributesSet, AttributeScope scope) {
        return this.systemContext.getAttributesService().find(this.tenantId, (EntityId)this.deviceId, scope, attributesSet);
    }

    private Set<String> toSet(List<String> strings) {
        return new HashSet<String>(strings);
    }

    private TransportProtos.SessionType getSessionType(UUID sessionId) {
        return this.sessions.containsKey((Object)sessionId) ? TransportProtos.SessionType.ASYNC : TransportProtos.SessionType.SYNC;
    }

    void processAttributesUpdate(DeviceAttributesEventNotificationMsg msg) {
        if (!this.attributeSubscriptions.isEmpty()) {
            boolean hasNotificationData = false;
            TransportProtos.AttributeUpdateNotificationMsg.Builder notification = TransportProtos.AttributeUpdateNotificationMsg.newBuilder();
            if (msg.isDeleted()) {
                List sharedKeys = msg.getDeletedKeys().stream().filter(key -> "SHARED_SCOPE".equals(key.getScope())).map(AttributeKey::getAttributeKey).collect(Collectors.toList());
                if (!sharedKeys.isEmpty()) {
                    notification.addAllSharedDeleted(sharedKeys);
                    hasNotificationData = true;
                }
            } else if ("SHARED_SCOPE".equals(msg.getScope())) {
                ArrayList attributes = new ArrayList(msg.getValues());
                if (!attributes.isEmpty()) {
                    List sharedUpdated = msg.getValues().stream().map(t -> KvProtoUtil.toTsKvProto((long)t.getLastUpdateTs(), (KvEntry)t)).collect(Collectors.toList());
                    if (!sharedUpdated.isEmpty()) {
                        notification.addAllSharedUpdated(sharedUpdated);
                        hasNotificationData = true;
                    }
                } else {
                    log.debug("[{}] No public shared side attributes changed!", (Object)this.deviceId);
                }
            }
            if (hasNotificationData) {
                TransportProtos.AttributeUpdateNotificationMsg finalNotification = notification.build();
                this.attributeSubscriptions.forEach((key, value) -> this.sendToTransport(finalNotification, (UUID)key, value.getNodeId()));
            }
        } else {
            log.debug("[{}] No registered attributes subscriptions to process!", (Object)this.deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRpcResponses(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToDeviceRpcResponseMsg responseMsg) {
        block12: {
            int requestId;
            UUID sessionId;
            block11: {
                boolean hasError;
                boolean delivered;
                UUID rpcId;
                block10: {
                    boolean success;
                    sessionId = this.getSessionId(sessionInfo);
                    log.debug("[{}][{}] Processing RPC command response: {}", new Object[]{this.deviceId, sessionId, responseMsg});
                    requestId = responseMsg.getRequestId();
                    ToDeviceRpcRequestMetadata requestMd = this.toDeviceRpcPendingMap.remove(requestId);
                    boolean bl = success = requestMd != null;
                    if (!success) break block11;
                    ToDeviceRpcRequest toDeviceRequestMsg = requestMd.getMsg().getMsg();
                    rpcId = toDeviceRequestMsg.getId();
                    delivered = requestMd.isDelivered();
                    hasError = StringUtils.isNotEmpty((String)responseMsg.getError());
                    try {
                        JsonNode response;
                        String payload = hasError ? responseMsg.getError() : responseMsg.getPayload();
                        this.systemContext.getTbCoreDeviceRpcService().processRpcResponseFromDeviceActor(new FromDeviceRpcResponse(rpcId, payload, null));
                        if (!toDeviceRequestMsg.isPersisted()) break block10;
                        RpcStatus status = hasError ? RpcStatus.FAILED : RpcStatus.SUCCESSFUL;
                        try {
                            response = JacksonUtil.toJsonNode((String)payload);
                        }
                        catch (IllegalArgumentException e) {
                            response = JacksonUtil.newObjectNode().put("error", payload);
                        }
                        this.systemContext.getTbRpcService().save(this.tenantId, new RpcId(rpcId), status, response);
                    }
                    catch (Throwable throwable) {
                        if (this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE)) {
                            this.clearAwaitRpcResponseScheduler();
                            String errorResponse = hasError ? "error response" : "response";
                            String rpcState = delivered ? "" : "undelivered ";
                            this.sendNextPendingRequest(rpcId, requestId, String.format("Received %s for %sRPC!", errorResponse, rpcState));
                        } else if (!delivered) {
                            String errorResponse = hasError ? "error response" : "response";
                            this.sendNextPendingRequest(rpcId, requestId, String.format("Received %s for undelivered RPC!", errorResponse));
                        }
                        throw throwable;
                    }
                }
                if (this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE)) {
                    this.clearAwaitRpcResponseScheduler();
                    errorResponse = hasError ? "error response" : "response";
                    String rpcState = delivered ? "" : "undelivered ";
                    this.sendNextPendingRequest(rpcId, requestId, String.format("Received %s for %sRPC!", errorResponse, rpcState));
                } else if (!delivered) {
                    errorResponse = hasError ? "error response" : "response";
                    this.sendNextPendingRequest(rpcId, requestId, String.format("Received %s for undelivered RPC!", errorResponse));
                }
                break block12;
            }
            log.debug("[{}][{}][{}] RPC command response is stale!", new Object[]{this.deviceId, sessionId, requestId});
        }
    }

    private void processRpcResponseStatus(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToDeviceRpcResponseStatusMsg responseMsg) {
        UUID rpcId = new UUID(responseMsg.getRequestIdMSB(), responseMsg.getRequestIdLSB());
        RpcStatus status = RpcStatus.valueOf((String)responseMsg.getStatus());
        UUID sessionId = this.getSessionId(sessionInfo);
        int requestId = responseMsg.getRequestId();
        log.debug("[{}][{}][{}][{}] Processing RPC command response status: [{}]", new Object[]{this.deviceId, sessionId, rpcId, requestId, status});
        ToDeviceRpcRequestMetadata md = this.toDeviceRpcPendingMap.get(requestId);
        if (md != null) {
            ToDeviceRpcRequest toDeviceRpcRequest = md.getMsg().getMsg();
            boolean persisted = toDeviceRpcRequest.isPersisted();
            boolean oneWayRpc = toDeviceRpcRequest.isOneway();
            ObjectNode response = null;
            if (status.equals((Object)RpcStatus.DELIVERED)) {
                if (oneWayRpc) {
                    this.toDeviceRpcPendingMap.remove(requestId);
                    if (this.rpcSequential) {
                        FromDeviceRpcResponse fromDeviceRpcResponse = new FromDeviceRpcResponse(rpcId, null, null);
                        this.systemContext.getTbCoreDeviceRpcService().processRpcResponseFromDeviceActor(fromDeviceRpcResponse);
                    }
                } else {
                    md.setDelivered(true);
                    if (this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE)) {
                        this.awaitRpcResponseFuture = this.scheduleAwaitRpcResponseFuture(rpcId, requestId);
                    }
                }
            } else if (status.equals((Object)RpcStatus.TIMEOUT)) {
                Integer maxRpcRetries = toDeviceRpcRequest.getRetries();
                maxRpcRetries = maxRpcRetries == null ? this.systemContext.getMaxRpcRetries() : Math.min(maxRpcRetries, this.systemContext.getMaxRpcRetries());
                if (maxRpcRetries <= md.getRetries()) {
                    if (this.closeTransportSessionOnRpcDeliveryTimeout) {
                        md.setRetries(0);
                        status = RpcStatus.QUEUED;
                        this.notifyTransportAboutSessionsCloseAndDumpSessions(TransportSessionCloseReason.RPC_DELIVERY_TIMEOUT);
                    } else {
                        this.toDeviceRpcPendingMap.remove(requestId);
                        status = RpcStatus.FAILED;
                        response = JacksonUtil.newObjectNode().put("error", "There was a Timeout and all retry attempts have been exhausted. Retry attempts set: " + maxRpcRetries);
                    }
                } else {
                    md.setRetries(md.getRetries() + 1);
                }
            }
            if (persisted) {
                this.systemContext.getTbRpcService().save(this.tenantId, new RpcId(rpcId), status, (JsonNode)response);
            }
            if (this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE) && status.equals((Object)RpcStatus.DELIVERED) && !oneWayRpc) {
                return;
            }
            if (!status.equals((Object)RpcStatus.SENT)) {
                this.sendNextPendingRequest(rpcId, requestId, String.format("RPC was %s!", status.name().toLowerCase()));
            }
        } else {
            log.warn("[{}][{}][{}][{}] RPC has already been removed from pending map.", new Object[]{this.deviceId, sessionId, rpcId, requestId});
        }
    }

    private void processSubscriptionCommands(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SubscribeToAttributeUpdatesMsg subscribeCmd) {
        UUID sessionId = this.getSessionId(sessionInfo);
        if (subscribeCmd.getUnsubscribe()) {
            log.debug("[{}] Canceling attributes subscription for session: [{}]", (Object)this.deviceId, (Object)sessionId);
            this.attributeSubscriptions.remove(sessionId);
        } else {
            SessionInfoMetaData sessionMD = (SessionInfoMetaData)this.sessions.get((Object)sessionId);
            if (sessionMD == null) {
                sessionMD = new SessionInfoMetaData(new SessionInfo(subscribeCmd.getSessionType(), sessionInfo.getNodeId()));
            }
            sessionMD.setSubscribedToAttributes(true);
            log.debug("[{}] Registering attributes subscription for session: [{}]", (Object)this.deviceId, (Object)sessionId);
            this.attributeSubscriptions.put(sessionId, sessionMD.getSessionInfo());
            this.dumpSessions();
        }
    }

    private UUID getSessionId(TransportProtos.SessionInfoProto sessionInfo) {
        return new UUID(sessionInfo.getSessionIdMSB(), sessionInfo.getSessionIdLSB());
    }

    private void processSubscriptionCommands(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SubscribeToRPCMsg subscribeCmd) {
        UUID sessionId = this.getSessionId(sessionInfo);
        if (subscribeCmd.getUnsubscribe()) {
            log.debug("[{}] Canceling RPC subscription for session: [{}]", (Object)this.deviceId, (Object)sessionId);
            this.rpcSubscriptions.remove(sessionId);
            this.clearAwaitRpcResponseScheduler();
        } else {
            SessionInfoMetaData sessionMD = (SessionInfoMetaData)this.sessions.get((Object)sessionId);
            if (sessionMD == null) {
                sessionMD = new SessionInfoMetaData(new SessionInfo(subscribeCmd.getSessionType(), sessionInfo.getNodeId()));
            }
            sessionMD.setSubscribedToRPC(true);
            this.rpcSubscriptions.put(sessionId, sessionMD.getSessionInfo());
            log.debug("[{}] Registered RPC subscription for session: [{}] Going to check for pending requests ...", (Object)this.deviceId, (Object)sessionId);
            this.sendPendingRequests(sessionId, sessionInfo.getNodeId());
            this.dumpSessions();
        }
    }

    private void processSessionStateMsgs(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SessionEventMsg msg) {
        UUID sessionId = this.getSessionId(sessionInfo);
        Objects.requireNonNull(sessionId);
        if (msg.getEvent() == TransportProtos.SessionEvent.OPEN) {
            if (this.sessions.containsKey((Object)sessionId)) {
                log.debug("[{}][{}] Received duplicate session open event.", (Object)this.deviceId, (Object)sessionId);
                return;
            }
            log.debug("[{}] Processing new session: [{}] Current sessions size: {}", new Object[]{this.deviceId, sessionId, this.sessions.size()});
            this.sessions.put((Object)sessionId, (Object)new SessionInfoMetaData(new SessionInfo(TransportProtos.SessionType.ASYNC, sessionInfo.getNodeId())));
            if (this.sessions.size() == 1) {
                this.reportSessionOpen();
            }
            this.systemContext.getDeviceStateService().onDeviceActivity(this.tenantId, this.deviceId, System.currentTimeMillis());
            this.dumpSessions();
        } else if (msg.getEvent() == TransportProtos.SessionEvent.CLOSED) {
            log.debug("[{}][{}] Canceling subscriptions for closed session.", (Object)this.deviceId, (Object)sessionId);
            this.sessions.remove((Object)sessionId);
            this.attributeSubscriptions.remove(sessionId);
            this.rpcSubscriptions.remove(sessionId);
            this.clearAwaitRpcResponseScheduler();
            if (this.sessions.isEmpty()) {
                this.reportSessionClose();
            }
            this.dumpSessions();
        }
    }

    private ScheduledFuture<?> scheduleAwaitRpcResponseFuture(UUID rpcId, int requestId) {
        return this.scheduler.schedule(() -> {
            ToDeviceRpcRequestMetadata md = this.toDeviceRpcPendingMap.remove(requestId);
            if (md == null) {
                return;
            }
            this.sendNextPendingRequest(rpcId, requestId, "RPC was removed from pending map due to await timeout on response from device!");
            ToDeviceRpcRequest toDeviceRpcRequest = md.getMsg().getMsg();
            if (toDeviceRpcRequest.isPersisted()) {
                ObjectNode responseAwaitTimeout = JacksonUtil.newObjectNode().put("error", "There was a timeout awaiting for RPC response from device.");
                this.systemContext.getTbRpcService().save(this.tenantId, new RpcId(rpcId), RpcStatus.FAILED, (JsonNode)responseAwaitTimeout);
            }
        }, this.systemContext.getRpcResponseTimeout(), TimeUnit.MILLISECONDS);
    }

    private void clearAwaitRpcResponseScheduler() {
        if (this.rpcSubmitStrategy.equals((Object)RpcSubmitStrategy.SEQUENTIAL_ON_RESPONSE_FROM_DEVICE) && this.awaitRpcResponseFuture != null) {
            this.awaitRpcResponseFuture.cancel(true);
        }
    }

    private void handleSessionActivity(TransportProtos.SessionInfoProto sessionInfoProto, TransportProtos.SubscriptionInfoProto subscriptionInfo) {
        UUID sessionId = this.getSessionId(sessionInfoProto);
        Objects.requireNonNull(sessionId);
        SessionInfoMetaData sessionMD = (SessionInfoMetaData)this.sessions.get((Object)sessionId);
        if (sessionMD != null) {
            sessionMD.setLastActivityTime(subscriptionInfo.getLastActivityTime());
            sessionMD.setSubscribedToAttributes(subscriptionInfo.getAttributeSubscription());
            sessionMD.setSubscribedToRPC(subscriptionInfo.getRpcSubscription());
            if (subscriptionInfo.getAttributeSubscription()) {
                this.attributeSubscriptions.putIfAbsent(sessionId, sessionMD.getSessionInfo());
            }
            if (subscriptionInfo.getRpcSubscription()) {
                this.rpcSubscriptions.putIfAbsent(sessionId, sessionMD.getSessionInfo());
            }
        }
        this.systemContext.getDeviceStateService().onDeviceActivity(this.tenantId, this.deviceId, subscriptionInfo.getLastActivityTime());
        if (sessionMD != null) {
            this.dumpSessions();
        }
    }

    void processCredentialsUpdate(TbActorMsg msg) {
        if (((DeviceCredentialsUpdateNotificationMsg)msg).getDeviceCredentials().getCredentialsType() == DeviceCredentialsType.LWM2M_CREDENTIALS) {
            this.sessions.forEach((k, v) -> this.notifyTransportAboutDeviceCredentialsUpdate((UUID)k, (SessionInfoMetaData)v, ((DeviceCredentialsUpdateNotificationMsg)msg).getDeviceCredentials()));
        } else {
            this.notifyTransportAboutSessionsCloseAndDumpSessions(TransportSessionCloseReason.CREDENTIALS_UPDATED);
        }
    }

    private void notifyTransportAboutSessionsCloseAndDumpSessions(TransportSessionCloseReason transportSessionCloseReason) {
        this.sessions.forEach((sessionId, sessionMd) -> this.notifyTransportAboutClosedSession((UUID)sessionId, (SessionInfoMetaData)sessionMd, transportSessionCloseReason));
        this.attributeSubscriptions.clear();
        this.rpcSubscriptions.clear();
        this.dumpSessions();
    }

    private void notifyTransportAboutClosedSessionMaxSessionsLimit(UUID sessionId, SessionInfoMetaData sessionMd) {
        this.attributeSubscriptions.remove(sessionId);
        this.rpcSubscriptions.remove(sessionId);
        this.notifyTransportAboutClosedSession(sessionId, sessionMd, TransportSessionCloseReason.MAX_CONCURRENT_SESSIONS_LIMIT_REACHED);
    }

    private void notifyTransportAboutClosedSession(UUID sessionId, SessionInfoMetaData sessionMd, TransportSessionCloseReason transportSessionCloseReason) {
        log.debug("{} sessionId: [{}] sessionMd: [{}]", new Object[]{transportSessionCloseReason.getLogMessage(), sessionId, sessionMd});
        TransportProtos.SessionCloseNotificationProto sessionCloseNotificationProto = TransportProtos.SessionCloseNotificationProto.newBuilder().setMessage(transportSessionCloseReason.getNotificationMessage()).setReason(TransportProtos.SessionCloseReason.forNumber((int)transportSessionCloseReason.getProtoNumber())).build();
        TransportProtos.ToTransportMsg msg = TransportProtos.ToTransportMsg.newBuilder().setSessionIdMSB(sessionId.getMostSignificantBits()).setSessionIdLSB(sessionId.getLeastSignificantBits()).setSessionCloseNotification(sessionCloseNotificationProto).build();
        this.systemContext.getTbCoreToTransportService().process(sessionMd.getSessionInfo().getNodeId(), msg);
    }

    void notifyTransportAboutDeviceCredentialsUpdate(UUID sessionId, SessionInfoMetaData sessionMd, DeviceCredentials deviceCredentials) {
        TransportProtos.ToTransportUpdateCredentialsProto.Builder notification = TransportProtos.ToTransportUpdateCredentialsProto.newBuilder();
        notification.addCredentialsId(deviceCredentials.getCredentialsId());
        notification.addCredentialsValue(deviceCredentials.getCredentialsValue());
        TransportProtos.ToTransportMsg msg = TransportProtos.ToTransportMsg.newBuilder().setSessionIdMSB(sessionId.getMostSignificantBits()).setSessionIdLSB(sessionId.getLeastSignificantBits()).setToTransportUpdateCredentialsNotification(notification).build();
        this.systemContext.getTbCoreToTransportService().process(sessionMd.getSessionInfo().getNodeId(), msg);
    }

    void processNameOrTypeUpdate(DeviceNameOrTypeUpdateMsg msg) {
        this.deviceName = msg.getDeviceName();
        this.deviceType = msg.getDeviceType();
        this.defaultMetaData = new TbMsgMetaData();
        this.defaultMetaData.putValue("deviceName", this.deviceName);
        this.defaultMetaData.putValue("deviceType", this.deviceType);
    }

    void processEdgeUpdate(DeviceEdgeUpdateMsg msg) {
        log.trace("[{}] Processing edge update {}", (Object)this.deviceId, (Object)msg);
        this.edgeId = msg.getEdgeId();
    }

    private void sendToTransport(TransportProtos.GetAttributeResponseMsg responseMsg, TransportProtos.SessionInfoProto sessionInfo) {
        TransportProtos.ToTransportMsg msg = TransportProtos.ToTransportMsg.newBuilder().setSessionIdMSB(sessionInfo.getSessionIdMSB()).setSessionIdLSB(sessionInfo.getSessionIdLSB()).setGetAttributesResponse(responseMsg).build();
        this.systemContext.getTbCoreToTransportService().process(sessionInfo.getNodeId(), msg);
    }

    private void sendToTransport(TransportProtos.AttributeUpdateNotificationMsg notificationMsg, UUID sessionId, String nodeId) {
        TransportProtos.ToTransportMsg msg = TransportProtos.ToTransportMsg.newBuilder().setSessionIdMSB(sessionId.getMostSignificantBits()).setSessionIdLSB(sessionId.getLeastSignificantBits()).setAttributeUpdateNotification(notificationMsg).build();
        this.systemContext.getTbCoreToTransportService().process(nodeId, msg);
    }

    private void sendToTransport(TransportProtos.ToDeviceRpcRequestMsg rpcMsg, UUID sessionId, String nodeId) {
        TransportProtos.ToTransportMsg msg = TransportProtos.ToTransportMsg.newBuilder().setSessionIdMSB(sessionId.getMostSignificantBits()).setSessionIdLSB(sessionId.getLeastSignificantBits()).setToDeviceRequest(rpcMsg).build();
        this.systemContext.getTbCoreToTransportService().process(nodeId, msg);
    }

    private void saveRpcRequestToEdgeQueue(ToDeviceRpcRequest msg, Integer requestId) {
        ObjectNode body = JacksonUtil.newObjectNode();
        body.put("requestId", requestId);
        body.put("requestUUID", msg.getId().toString());
        body.put("oneway", msg.isOneway());
        body.put("expirationTime", msg.getExpirationTime());
        body.put("method", msg.getBody().getMethod());
        body.put("params", msg.getBody().getParams());
        body.put("persisted", msg.isPersisted());
        body.put("retries", msg.getRetries());
        body.put("additionalInfo", msg.getAdditionalInfo());
        EdgeEvent edgeEvent = EdgeUtils.constructEdgeEvent((TenantId)this.tenantId, (EdgeId)this.edgeId, (EdgeEventType)EdgeEventType.DEVICE, (EdgeEventActionType)EdgeEventActionType.RPC_CALL, (EntityId)this.deviceId, (JsonNode)body);
        this.systemContext.getClusterService().onEdgeHighPriorityMsg(new EdgeHighPriorityMsg(this.tenantId, edgeEvent));
    }

    void restoreSessions() {
        TransportProtos.DeviceSessionsCacheEntry sessionsDump;
        if (this.systemContext.isLocalCacheType()) {
            return;
        }
        log.debug("[{}] Restoring sessions from cache", (Object)this.deviceId);
        try {
            sessionsDump = this.systemContext.getDeviceSessionCacheService().get(this.deviceId);
        }
        catch (Exception e) {
            log.warn("[{}] Failed to decode device sessions from cache", (Object)this.deviceId);
            return;
        }
        if (sessionsDump.getSessionsCount() == 0) {
            log.debug("[{}] No session information found", (Object)this.deviceId);
            return;
        }
        for (TransportProtos.SessionSubscriptionInfoProto sessionSubscriptionInfoProto : sessionsDump.getSessionsList()) {
            TransportProtos.SessionInfoProto sessionInfoProto = sessionSubscriptionInfoProto.getSessionInfo();
            UUID sessionId = this.getSessionId(sessionInfoProto);
            SessionInfo sessionInfo = new SessionInfo(TransportProtos.SessionType.ASYNC, sessionInfoProto.getNodeId());
            TransportProtos.SubscriptionInfoProto subInfo = sessionSubscriptionInfoProto.getSubscriptionInfo();
            SessionInfoMetaData sessionMD = new SessionInfoMetaData(sessionInfo, subInfo.getLastActivityTime());
            this.sessions.put((Object)sessionId, (Object)sessionMD);
            if (subInfo.getAttributeSubscription()) {
                this.attributeSubscriptions.put(sessionId, sessionInfo);
                sessionMD.setSubscribedToAttributes(true);
            }
            if (subInfo.getRpcSubscription()) {
                this.rpcSubscriptions.put(sessionId, sessionInfo);
                sessionMD.setSubscribedToRPC(true);
            }
            log.debug("[{}] Restored session: {}", (Object)this.deviceId, (Object)sessionMD);
        }
        log.debug("[{}] Restored sessions: {}, RPC subscriptions: {}, attribute subscriptions: {}", new Object[]{this.deviceId, this.sessions.size(), this.rpcSubscriptions.size(), this.attributeSubscriptions.size()});
    }

    private void dumpSessions() {
        if (this.systemContext.isLocalCacheType()) {
            return;
        }
        log.debug("[{}] Dumping sessions: {}, RPC subscriptions: {}, attribute subscriptions: {} to cache", new Object[]{this.deviceId, this.sessions.size(), this.rpcSubscriptions.size(), this.attributeSubscriptions.size()});
        ArrayList sessionsList = new ArrayList(this.sessions.size());
        this.sessions.forEach((uuid, sessionMD) -> {
            if (sessionMD.getSessionInfo().getType() == TransportProtos.SessionType.SYNC) {
                return;
            }
            SessionInfo sessionInfo = sessionMD.getSessionInfo();
            TransportProtos.SubscriptionInfoProto subscriptionInfoProto = TransportProtos.SubscriptionInfoProto.newBuilder().setLastActivityTime(sessionMD.getLastActivityTime()).setAttributeSubscription(sessionMD.isSubscribedToAttributes()).setRpcSubscription(sessionMD.isSubscribedToRPC()).build();
            TransportProtos.SessionInfoProto sessionInfoProto = TransportProtos.SessionInfoProto.newBuilder().setSessionIdMSB(uuid.getMostSignificantBits()).setSessionIdLSB(uuid.getLeastSignificantBits()).setNodeId(sessionInfo.getNodeId()).build();
            sessionsList.add(TransportProtos.SessionSubscriptionInfoProto.newBuilder().setSessionInfo(sessionInfoProto).setSubscriptionInfo(subscriptionInfoProto).build());
            log.debug("[{}] Dumping session: {}", (Object)this.deviceId, sessionMD);
        });
        this.systemContext.getDeviceSessionCacheService().put(this.deviceId, TransportProtos.DeviceSessionsCacheEntry.newBuilder().addAllSessions(sessionsList).build());
    }

    void init(TbActorCtx ctx) {
        PageData<Rpc> pageData;
        PageLink pageLink = new PageLink(1024, 0, null, new SortOrder("createdTime"));
        do {
            pageData = this.systemContext.getTbRpcService().findAllByDeviceIdAndStatus(this.tenantId, this.deviceId, RpcStatus.QUEUED, pageLink);
            pageData.getData().forEach(rpc -> {
                ToDeviceRpcRequest msg = (ToDeviceRpcRequest)JacksonUtil.convertValue((Object)rpc.getRequest(), ToDeviceRpcRequest.class);
                long timeout = rpc.getExpirationTime() - System.currentTimeMillis();
                if (timeout <= 0L) {
                    rpc.setStatus(RpcStatus.EXPIRED);
                    this.systemContext.getTbRpcService().save(this.tenantId, (Rpc)rpc);
                } else {
                    this.registerPendingRpcRequest(ctx, new ToDeviceRpcRequestActorMsg(this.systemContext.getServiceId(), msg), false, this.createToDeviceRpcRequestMsg(msg), timeout);
                }
            });
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
    }

    void checkSessionsTimeout() {
        long expTime = System.currentTimeMillis() - this.systemContext.getSessionInactivityTimeout();
        ArrayList<UUID> expiredIds = null;
        for (Map.Entry kv : this.sessions.entrySet()) {
            if (((SessionInfoMetaData)kv.getValue()).getLastActivityTime() >= expTime) continue;
            UUID id = (UUID)kv.getKey();
            if (expiredIds == null) {
                expiredIds = new ArrayList<UUID>(1);
            }
            expiredIds.add(id);
        }
        if (expiredIds != null) {
            int removed = 0;
            for (UUID id : expiredIds) {
                SessionInfoMetaData session = (SessionInfoMetaData)this.sessions.remove((Object)id);
                this.rpcSubscriptions.remove(id);
                this.attributeSubscriptions.remove(id);
                if (session == null) continue;
                ++removed;
                this.notifyTransportAboutClosedSession(id, session, TransportSessionCloseReason.SESSION_TIMEOUT);
            }
            if (removed != 0) {
                this.dumpSessions();
            }
        }
    }
}

