/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.update;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.data.EdgeUpgradeMessage;
import org.thingsboard.server.common.data.UpdateMessage;
import org.thingsboard.server.common.data.notification.rule.trigger.NewPlatformVersionTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.instructions.EdgeInstallInstructionsService;
import org.thingsboard.server.service.edge.instructions.EdgeUpgradeInstructionsService;
import org.thingsboard.server.service.update.UpdateService;

@Service
@TbCoreComponent
public class DefaultUpdateService
implements UpdateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUpdateService.class);
    private static final String INSTANCE_ID_FILE = ".instance_id";
    private static final String UPDATE_SERVER_BASE_URL = "https://updates.thingsboard.io";
    private static final String PLATFORM_PARAM = "platform";
    private static final String VERSION_PARAM = "version";
    private static final String INSTANCE_ID_PARAM = "instanceId";
    @Value(value="${updates.enabled}")
    private boolean updatesEnabled;
    @Autowired(required=false)
    private BuildProperties buildProperties;
    @Autowired
    private NotificationRuleProcessor notificationRuleProcessor;
    @Autowired(required=false)
    private EdgeInstallInstructionsService edgeInstallInstructionsService;
    @Autowired(required=false)
    private EdgeUpgradeInstructionsService edgeUpgradeInstructionsService;
    private final ScheduledExecutorService scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"tb-update-service");
    private ScheduledFuture<?> checkUpdatesFuture = null;
    private final RestTemplate restClient = new RestTemplate();
    private UpdateMessage updateMessage;
    private String platform;
    private String version;
    private UUID instanceId = null;
    Runnable checkUpdatesRunnable = () -> {
        try {
            EdgeUpgradeMessage edgeUpgradeMessage;
            ObjectNode edgeRequest;
            String edgePlatformVersion;
            log.trace("Executing check update method for instanceId [{}], platform [{}] and version [{}]", new Object[]{this.instanceId, this.platform, this.version});
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ObjectNode request = JacksonUtil.newObjectNode();
            request.put(PLATFORM_PARAM, this.platform);
            request.put(VERSION_PARAM, this.version);
            request.put(INSTANCE_ID_PARAM, this.instanceId.toString());
            UpdateMessage prevUpdateMessage = this.updateMessage;
            this.updateMessage = (UpdateMessage)this.restClient.postForObject("https://updates.thingsboard.io/api/v2/thingsboard/updates", (Object)new HttpEntity((Object)request.toString(), (MultiValueMap)headers), UpdateMessage.class, new Object[0]);
            if (this.updateMessage != null && this.updateMessage.isUpdateAvailable() && !this.updateMessage.equals((Object)prevUpdateMessage)) {
                this.notificationRuleProcessor.process((NotificationRuleTrigger)NewPlatformVersionTrigger.builder().updateInfo(this.updateMessage).build());
            }
            if ((edgePlatformVersion = (String)this.restClient.postForObject("https://updates.thingsboard.io/api/v1/edge/installMapping", (Object)new HttpEntity((Object)(edgeRequest = JacksonUtil.newObjectNode().put(VERSION_PARAM, this.version)).toString(), (MultiValueMap)headers), String.class, new Object[0])) != null) {
                this.edgeInstallInstructionsService.setPlatformEdgeVersion(edgePlatformVersion);
                this.edgeUpgradeInstructionsService.setPlatformEdgeVersion(edgePlatformVersion);
            }
            if ((edgeUpgradeMessage = (EdgeUpgradeMessage)this.restClient.postForObject("https://updates.thingsboard.io/api/v1/edge/upgradeMapping", (Object)new HttpEntity((Object)edgeRequest.toString(), (MultiValueMap)headers), EdgeUpgradeMessage.class, new Object[0])) != null) {
                this.edgeUpgradeInstructionsService.updateInstructionMap(edgeUpgradeMessage.getEdgeVersions());
            }
        }
        catch (Exception e) {
            log.trace(e.getMessage());
        }
    };

    @AfterStartUp(order=11)
    public void init() {
        this.version = this.buildProperties != null ? this.buildProperties.getVersion() : "unknown";
        this.updateMessage = new UpdateMessage(false, this.version, "", "", "https://thingsboard.io/docs/reference/releases", "https://thingsboard.io/docs/reference/releases");
        if (this.updatesEnabled) {
            try {
                this.platform = System.getProperty(PLATFORM_PARAM, "unknown");
                this.instanceId = this.parseInstanceId();
                this.checkUpdatesFuture = this.scheduler.scheduleAtFixedRate(this.checkUpdatesRunnable, 0L, 1L, TimeUnit.HOURS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private UUID parseInstanceId() throws IOException {
        byte[] data;
        UUID result = null;
        Path instanceIdPath = Paths.get(INSTANCE_ID_FILE, new String[0]);
        if (instanceIdPath.toFile().exists() && (data = Files.readAllBytes(instanceIdPath)).length > 0) {
            try {
                result = UUID.fromString(new String(data));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = UUID.randomUUID();
            Files.write(instanceIdPath, result.toString().getBytes(), new OpenOption[0]);
        }
        return result;
    }

    @PreDestroy
    private void destroy() {
        try {
            if (this.checkUpdatesFuture != null) {
                this.checkUpdatesFuture.cancel(true);
            }
            this.scheduler.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UpdateMessage checkUpdates() {
        return this.updateMessage;
    }
}

