/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl;

import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.alarm.AlarmDao;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.action.EntityActionService;

@TbCoreComponent
@Service
public class AlarmsCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmsCleanUpService.class);
    @Value(value="${sql.ttl.alarms.removal_batch_size}")
    private Integer removalBatchSize;
    private final TenantService tenantService;
    private final AlarmDao alarmDao;
    private final AlarmService alarmService;
    private final EntityActionService entityActionService;
    private final PartitionService partitionService;
    private final TbTenantProfileCache tenantProfileCache;

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.alarms.checking_interval})}", fixedDelayString="${sql.ttl.alarms.checking_interval}")
    public void cleanUp() {
        PageDataIterable tenants = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenantsIds(arg_0), 10000);
        for (TenantId tenantId : tenants) {
            try {
                this.cleanUp(tenantId);
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to clean up alarms by ttl for tenant {}", (Object)tenantId, (Object)e);
            }
        }
    }

    private void cleanUp(TenantId tenantId) {
        PageData toRemove;
        if (!this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)tenantId).isMyPartition()) {
            return;
        }
        Optional tenantProfileConfiguration = this.tenantProfileCache.get(tenantId).getProfileConfiguration();
        if (tenantProfileConfiguration.isEmpty() || ((DefaultTenantProfileConfiguration)tenantProfileConfiguration.get()).getAlarmsTtlDays() == 0) {
            return;
        }
        long ttl = TimeUnit.DAYS.toMillis(((DefaultTenantProfileConfiguration)tenantProfileConfiguration.get()).getAlarmsTtlDays());
        long expirationTime = System.currentTimeMillis() - ttl;
        PageLink removalBatchRequest = new PageLink(this.removalBatchSize.intValue(), 0);
        long totalRemoved = 0L;
        HashSet<String> typesToRemove = new HashSet<String>();
        do {
            toRemove = this.alarmDao.findAlarmsIdsByEndTsBeforeAndTenantId(Long.valueOf(expirationTime), tenantId, removalBatchRequest);
            for (AlarmId alarmId : toRemove.getData()) {
                AlarmInfo alarm = this.alarmService.delAlarm(tenantId, alarmId, false).getAlarm();
                if (alarm == null) continue;
                this.entityActionService.pushEntityActionToRuleEngine(alarm.getOriginator(), (HasName)alarm, tenantId, null, ActionType.ALARM_DELETE, null, new Object[0]);
                ++totalRemoved;
                typesToRemove.add(alarm.getType());
            }
        } while (toRemove.hasNext());
        this.alarmService.delAlarmTypes(tenantId, typesToRemove);
        if (totalRemoved > 0L) {
            this.getLogger().info("Removed {} outdated alarm(s) for tenant {} older than {}", new Object[]{totalRemoved, tenantId, new Date(expirationTime)});
        }
    }

    Logger getLogger() {
        return log;
    }

    @ConstructorProperties(value={"tenantService", "alarmDao", "alarmService", "entityActionService", "partitionService", "tenantProfileCache"})
    @Generated
    public AlarmsCleanUpService(TenantService tenantService, AlarmDao alarmDao, AlarmService alarmService, EntityActionService entityActionService, PartitionService partitionService, TbTenantProfileCache tenantProfileCache) {
        this.tenantService = tenantService;
        this.alarmDao = alarmDao;
        this.alarmService = alarmService;
        this.entityActionService = entityActionService;
        this.partitionService = partitionService;
        this.tenantProfileCache = tenantProfileCache;
    }
}

