/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.transport.msg;

import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.aware.DeviceAwareMsg;
import org.thingsboard.server.common.msg.aware.TenantAwareMsg;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.gen.transport.TransportProtos;

public class TransportToDeviceActorMsgWrapper
implements TbActorMsg,
DeviceAwareMsg,
TenantAwareMsg,
Serializable {
    private static final long serialVersionUID = 7191333353202935941L;
    private final TenantId tenantId;
    private final DeviceId deviceId;
    private final TransportProtos.TransportToDeviceActorMsg msg;
    private final TbCallback callback;

    public TransportToDeviceActorMsgWrapper(TransportProtos.TransportToDeviceActorMsg msg, TbCallback callback) {
        this.msg = msg;
        this.callback = callback;
        this.tenantId = TenantId.fromUUID((UUID)new UUID(msg.getSessionInfo().getTenantIdMSB(), msg.getSessionInfo().getTenantIdLSB()));
        this.deviceId = new DeviceId(new UUID(msg.getSessionInfo().getDeviceIdMSB(), msg.getSessionInfo().getDeviceIdLSB()));
    }

    public MsgType getMsgType() {
        return MsgType.TRANSPORT_TO_DEVICE_ACTOR_MSG;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public TransportProtos.TransportToDeviceActorMsg getMsg() {
        return this.msg;
    }

    @Generated
    public TbCallback getCallback() {
        return this.callback;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransportToDeviceActorMsgWrapper)) {
            return false;
        }
        TransportToDeviceActorMsgWrapper other = (TransportToDeviceActorMsgWrapper)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        TransportProtos.TransportToDeviceActorMsg this$msg = this.getMsg();
        TransportProtos.TransportToDeviceActorMsg other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        TbCallback this$callback = this.getCallback();
        TbCallback other$callback = other.getCallback();
        return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransportToDeviceActorMsgWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        TransportProtos.TransportToDeviceActorMsg $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        TbCallback $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransportToDeviceActorMsgWrapper(tenantId=" + String.valueOf(this.getTenantId()) + ", deviceId=" + String.valueOf(this.getDeviceId()) + ", msg=" + String.valueOf(this.getMsg()) + ", callback=" + String.valueOf(this.getCallback()) + ")";
    }
}

