/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.AttributesDeleteRequest;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.DeviceStateManager;
import org.thingsboard.rule.engine.api.RuleEngineTelemetryService;
import org.thingsboard.rule.engine.api.TimeseriesDeleteRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.AttributesSaveResult;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TimeseriesSaveResult;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.kv.TsKvLatestRemovingResult;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.rule.engine.DeviceAttributesEventNotificationMsg;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.util.KvUtils;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.cf.CalculatedFieldQueueService;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.subscription.TbSubscriptionUtils;
import org.thingsboard.server.service.telemetry.AbstractSubscriptionService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultTelemetrySubscriptionService
extends AbstractSubscriptionService
implements TelemetrySubscriptionService,
RuleEngineTelemetryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTelemetrySubscriptionService.class);
    private final AttributesService attrService;
    private final TimeseriesService tsService;
    private final TbEntityViewService tbEntityViewService;
    private final TbApiUsageReportClient apiUsageClient;
    private final TbApiUsageStateService apiUsageStateService;
    private final CalculatedFieldQueueService calculatedFieldQueueService;
    private final DeviceStateManager deviceStateManager;
    private ExecutorService tsCallBackExecutor;
    @Value(value="${sql.ts.value_no_xss_validation:false}")
    private boolean valueNoXssValidation;
    @Value(value="${sql.ts.callback_thread_pool_size:12}")
    private int callbackThreadPoolSize;

    public DefaultTelemetrySubscriptionService(AttributesService attrService, TimeseriesService tsService, @Lazy TbEntityViewService tbEntityViewService, TbApiUsageReportClient apiUsageClient, TbApiUsageStateService apiUsageStateService, CalculatedFieldQueueService calculatedFieldQueueService, DeviceStateManager deviceStateManager) {
        this.attrService = attrService;
        this.tsService = tsService;
        this.tbEntityViewService = tbEntityViewService;
        this.apiUsageClient = apiUsageClient;
        this.apiUsageStateService = apiUsageStateService;
        this.calculatedFieldQueueService = calculatedFieldQueueService;
        this.deviceStateManager = deviceStateManager;
    }

    @PostConstruct
    public void initExecutor() {
        super.initExecutor();
        this.tsCallBackExecutor = ThingsBoardExecutors.newWorkStealingPool((int)this.callbackThreadPoolSize, (String)"ts-service-ts-callback");
    }

    protected String getExecutorPrefix() {
        return "ts";
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.tsCallBackExecutor != null) {
            this.tsCallBackExecutor.shutdownNow();
        }
        super.shutdownExecutor();
    }

    public void saveTimeseries(TimeseriesSaveRequest request) {
        boolean sysTenant;
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        this.checkInternalEntity(entityId);
        boolean bl = sysTenant = TenantId.SYS_TENANT_ID.equals((Object)tenantId) || tenantId == null;
        if (sysTenant || !request.getStrategy().saveTimeseries() || this.apiUsageStateService.getApiUsageState(tenantId).isDbStorageEnabled()) {
            KvUtils.validate((List)request.getEntries(), (boolean)this.valueNoXssValidation);
            ListenableFuture future = this.saveTimeseriesInternal(request);
            if (request.getStrategy().saveTimeseries()) {
                Futures.addCallback((ListenableFuture)future, (FutureCallback)this.getApiUsageCallback(tenantId, request.getCustomerId(), sysTenant), (Executor)this.tsCallBackExecutor);
            }
        } else {
            request.getCallback().onFailure((Throwable)new RuntimeException("DB storage writes are disabled due to API limits!"));
        }
    }

    public ListenableFuture<TimeseriesSaveResult> saveTimeseriesInternal(TimeseriesSaveRequest request) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        TimeseriesSaveRequest.Strategy strategy = request.getStrategy();
        ListenableFuture resultFuture = strategy.saveTimeseries() && strategy.saveLatest() ? this.tsService.save(tenantId, entityId, request.getEntries(), request.getTtl()) : (strategy.saveLatest() ? this.tsService.saveLatest(tenantId, entityId, request.getEntries()) : (strategy.saveTimeseries() ? this.tsService.saveWithoutLatest(tenantId, entityId, request.getEntries(), request.getTtl()) : Futures.immediateFuture((Object)TimeseriesSaveResult.EMPTY)));
        this.addMainCallback(resultFuture, result -> {
            if (strategy.processCalculatedFields()) {
                this.calculatedFieldQueueService.pushRequestToQueue(request, result, request.getCallback());
            } else {
                request.getCallback().onSuccess(null);
            }
        }, t -> request.getCallback().onFailure(t));
        if (strategy.sendWsUpdate()) {
            this.addWsCallback(resultFuture, success -> this.onTimeSeriesUpdate(tenantId, entityId, request.getEntries()));
        }
        if (strategy.saveLatest() && entityId.getEntityType().isOneOf(new EntityType[]{EntityType.DEVICE, EntityType.ASSET})) {
            this.addMainCallback(resultFuture, __ -> this.copyLatestToEntityViews(tenantId, entityId, request.getEntries()));
        }
        return resultFuture;
    }

    public void saveAttributes(AttributesSaveRequest request) {
        this.checkInternalEntity(request.getEntityId());
        this.saveAttributesInternal(request);
    }

    public ListenableFuture<AttributesSaveResult> saveAttributesInternal(AttributesSaveRequest request) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        AttributesSaveRequest.Strategy strategy = request.getStrategy();
        ListenableFuture resultFuture = strategy.saveAttributes() ? this.attrService.save(tenantId, entityId, request.getScope(), request.getEntries()) : Futures.immediateFuture((Object)AttributesSaveResult.EMPTY);
        this.addMainCallback(resultFuture, result -> {
            if (strategy.processCalculatedFields()) {
                this.calculatedFieldQueueService.pushRequestToQueue(request, result, request.getCallback());
            } else {
                request.getCallback().onSuccess(null);
            }
        }, t -> request.getCallback().onFailure(t));
        if (DefaultTelemetrySubscriptionService.shouldSendSharedAttributesUpdatedNotification((AttributesSaveRequest)request)) {
            this.addMainCallback(resultFuture, success -> this.clusterService.pushMsgToCore((ToDeviceActorNotificationMsg)DeviceAttributesEventNotificationMsg.onUpdate((TenantId)tenantId, (DeviceId)new DeviceId(entityId.getId()), (String)"SHARED_SCOPE", (List)request.getEntries()), null));
        }
        if (DefaultTelemetrySubscriptionService.shouldCheckForInactivityTimeoutUpdates((AttributesSaveRequest)request)) {
            DefaultTelemetrySubscriptionService.findNewInactivityTimeout((List)request.getEntries()).ifPresent(newInactivityTimeout -> this.addMainCallback(resultFuture, success -> this.deviceStateManager.onDeviceInactivityTimeoutUpdate(tenantId, new DeviceId(entityId.getId()), newInactivityTimeout.longValue(), TbCallback.EMPTY)));
        }
        if (strategy.sendWsUpdate()) {
            this.addWsCallback(resultFuture, success -> this.onAttributesUpdate(tenantId, entityId, request.getScope().name(), request.getEntries()));
        }
        return resultFuture;
    }

    private static boolean shouldSendSharedAttributesUpdatedNotification(AttributesSaveRequest request) {
        return request.getStrategy().saveAttributes() && DefaultTelemetrySubscriptionService.shouldSendSharedAttributesNotification((EntityId)request.getEntityId(), (AttributeScope)request.getScope(), (boolean)request.isNotifyDevice());
    }

    private static boolean shouldCheckForInactivityTimeoutUpdates(AttributesSaveRequest request) {
        return request.getStrategy().saveAttributes() && request.getEntityId().getEntityType() == EntityType.DEVICE && request.getScope() == AttributeScope.SERVER_SCOPE;
    }

    private static Optional<Long> findNewInactivityTimeout(List<AttributeKvEntry> entries) {
        return entries.stream().filter(entry -> Objects.equals("inactivityTimeout", entry.getKey())).max(Comparator.comparing(HasVersion::getVersion, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparingLong(AttributeKvEntry::getLastUpdateTs)).map(DefaultTelemetrySubscriptionService::parseAsLong);
    }

    private static long parseAsLong(KvEntry kve) {
        try {
            return Long.parseLong(kve.getValueAsString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void deleteAttributes(AttributesDeleteRequest request) {
        this.checkInternalEntity(request.getEntityId());
        this.deleteAttributesInternal(request);
    }

    public void deleteAttributesInternal(AttributesDeleteRequest request) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        ListenableFuture deleteFuture = this.attrService.removeAll(tenantId, entityId, request.getScope(), request.getKeys());
        this.addMainCallback(deleteFuture, result -> this.calculatedFieldQueueService.pushRequestToQueue(request, result, request.getCallback()), t -> request.getCallback().onFailure(t));
        if (DefaultTelemetrySubscriptionService.shouldSendSharedAttributesDeletedNotification((AttributesDeleteRequest)request)) {
            this.addMainCallback(deleteFuture, success -> this.clusterService.pushMsgToCore((ToDeviceActorNotificationMsg)DeviceAttributesEventNotificationMsg.onDelete((TenantId)tenantId, (DeviceId)new DeviceId(entityId.getId()), (String)"SHARED_SCOPE", (List)request.getKeys()), null));
        }
        if (DefaultTelemetrySubscriptionService.inactivityTimeoutDeleted((AttributesDeleteRequest)request)) {
            this.addMainCallback(deleteFuture, success -> this.deviceStateManager.onDeviceInactivityTimeoutUpdate(tenantId, new DeviceId(entityId.getId()), 0L, TbCallback.EMPTY));
        }
        this.addWsCallback(deleteFuture, success -> this.onAttributesDelete(tenantId, entityId, request.getScope().name(), request.getKeys()));
    }

    private static boolean shouldSendSharedAttributesDeletedNotification(AttributesDeleteRequest request) {
        return DefaultTelemetrySubscriptionService.shouldSendSharedAttributesNotification((EntityId)request.getEntityId(), (AttributeScope)request.getScope(), (boolean)request.isNotifyDevice());
    }

    private static boolean shouldSendSharedAttributesNotification(EntityId entityId, AttributeScope scope, boolean notifyDevice) {
        return entityId.getEntityType() == EntityType.DEVICE && scope == AttributeScope.SHARED_SCOPE && notifyDevice;
    }

    private static boolean inactivityTimeoutDeleted(AttributesDeleteRequest request) {
        return request.getEntityId().getEntityType() == EntityType.DEVICE && request.getScope() == AttributeScope.SERVER_SCOPE && request.getKeys().stream().anyMatch(key -> Objects.equals("inactivityTimeout", key));
    }

    public void deleteTimeseries(TimeseriesDeleteRequest request) {
        this.checkInternalEntity(request.getEntityId());
        this.deleteTimeseriesInternal(request);
    }

    public void deleteTimeseriesInternal(TimeseriesDeleteRequest request) {
        if (CollectionUtils.isNotEmpty((Collection)request.getKeys())) {
            ListenableFuture deleteFuture;
            if (request.getDeleteHistoryQueries() == null) {
                deleteFuture = this.tsService.removeLatest(request.getTenantId(), request.getEntityId(), (Collection)request.getKeys());
            } else {
                deleteFuture = this.tsService.remove(request.getTenantId(), request.getEntityId(), request.getDeleteHistoryQueries());
                this.addWsCallback(deleteFuture, result -> this.onTimeSeriesDelete(request.getTenantId(), request.getEntityId(), request.getKeys(), result));
            }
            DonAsynchron.withCallback((ListenableFuture)deleteFuture, result -> this.calculatedFieldQueueService.pushRequestToQueue(request, request.getKeys(), this.getCalculatedFieldCallback(request.getCallback(), request.getKeys())), (Consumer)DefaultTelemetrySubscriptionService.safeCallback((FutureCallback)this.getCalculatedFieldCallback(request.getCallback(), request.getKeys())), (Executor)this.tsCallBackExecutor);
        } else {
            ListenableFuture deleteFuture = this.tsService.removeAllLatest(request.getTenantId(), request.getEntityId());
            DonAsynchron.withCallback((ListenableFuture)deleteFuture, result -> this.calculatedFieldQueueService.pushRequestToQueue(request, request.getKeys(), this.getCalculatedFieldCallback(request.getCallback(), result)), (Consumer)DefaultTelemetrySubscriptionService.safeCallback((FutureCallback)this.getCalculatedFieldCallback(request.getCallback(), request.getKeys())), (Executor)this.tsCallBackExecutor);
        }
    }

    private void copyLatestToEntityViews(TenantId tenantId, EntityId entityId, List<TsKvEntry> ts) {
        Futures.addCallback((ListenableFuture)this.tbEntityViewService.findEntityViewsByTenantIdAndEntityIdAsync(tenantId, entityId), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
    }

    private void onAttributesUpdate(TenantId tenantId, EntityId entityId, String scope, List<AttributeKvEntry> attributes) {
        this.forwardToSubscriptionManagerService(tenantId, entityId, subscriptionManagerService -> subscriptionManagerService.onAttributesUpdate(tenantId, entityId, scope, attributes, TbCallback.EMPTY), () -> TbSubscriptionUtils.toAttributesUpdateProto((TenantId)tenantId, (EntityId)entityId, (String)scope, (List)attributes));
    }

    private void onAttributesDelete(TenantId tenantId, EntityId entityId, String scope, List<String> keys) {
        this.forwardToSubscriptionManagerService(tenantId, entityId, subscriptionManagerService -> subscriptionManagerService.onAttributesDelete(tenantId, entityId, scope, keys, TbCallback.EMPTY), () -> TbSubscriptionUtils.toAttributesDeleteProto((TenantId)tenantId, (EntityId)entityId, (String)scope, (List)keys));
    }

    private void onTimeSeriesUpdate(TenantId tenantId, EntityId entityId, List<TsKvEntry> ts) {
        this.forwardToSubscriptionManagerService(tenantId, entityId, subscriptionManagerService -> subscriptionManagerService.onTimeSeriesUpdate(tenantId, entityId, ts, TbCallback.EMPTY), () -> TbSubscriptionUtils.toTimeseriesUpdateProto((TenantId)tenantId, (EntityId)entityId, (List)ts));
    }

    private void onTimeSeriesDelete(TenantId tenantId, EntityId entityId, List<String> keys, List<TsKvLatestRemovingResult> ts) {
        this.forwardToSubscriptionManagerService(tenantId, entityId, subscriptionManagerService -> {
            ArrayList updated = new ArrayList();
            ArrayList deleted = new ArrayList();
            ts.stream().filter(Objects::nonNull).forEach(res -> {
                if (res.isRemoved()) {
                    if (res.getData() != null) {
                        updated.add(res.getData());
                    } else {
                        deleted.add(res.getKey());
                    }
                }
            });
            subscriptionManagerService.onTimeSeriesUpdate(tenantId, entityId, updated, TbCallback.EMPTY);
            subscriptionManagerService.onTimeSeriesDelete(tenantId, entityId, deleted, TbCallback.EMPTY);
        }, () -> TbSubscriptionUtils.toTimeseriesDeleteProto((TenantId)tenantId, (EntityId)entityId, (List)keys));
    }

    private <S> void addMainCallback(ListenableFuture<S> saveFuture, FutureCallback<Void> callback) {
        if (callback == null) {
            return;
        }
        this.addMainCallback(saveFuture, result -> callback.onSuccess(null), arg_0 -> callback.onFailure(arg_0));
    }

    private <S> void addMainCallback(ListenableFuture<S> saveFuture, Consumer<S> onSuccess) {
        this.addMainCallback(saveFuture, onSuccess, null);
    }

    private <S> void addMainCallback(ListenableFuture<S> saveFuture, Consumer<S> onSuccess, Consumer<Throwable> onFailure) {
        DonAsynchron.withCallback(saveFuture, onSuccess, onFailure, (Executor)this.tsCallBackExecutor);
    }

    private void checkInternalEntity(EntityId entityId) {
        if (EntityType.API_USAGE_STATE.equals((Object)entityId.getEntityType())) {
            throw new RuntimeException("Can't update API Usage State!");
        }
    }

    private FutureCallback<TimeseriesSaveResult> getApiUsageCallback(TenantId tenantId, CustomerId customerId, boolean sysTenant) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private FutureCallback<Void> getCalculatedFieldCallback(FutureCallback<List<String>> originalCallback, List<String> keys) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

