/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.IntervalType;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.telemetry.TbTelemetryService;

@Service
public class DefaultTbTelemetryService
implements TbTelemetryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbTelemetryService.class);
    private final TimeseriesService tsService;
    private final AccessValidator accessValidator;

    public ListenableFuture<List<TsKvEntry>> getTimeseries(EntityId entityId, List<String> keys, Long startTs, Long endTs, IntervalType intervalType, Long interval, String timeZone, Integer limit, Aggregation agg, String orderBy, Boolean useStrictDataTypes, SecurityUser currentUser) {
        SettableFuture future = SettableFuture.create();
        this.accessValidator.validate(currentUser, Operation.READ_TELEMETRY, entityId, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        return future;
    }

    @ConstructorProperties(value={"tsService", "accessValidator"})
    @Generated
    public DefaultTbTelemetryService(TimeseriesService tsService, AccessValidator accessValidator) {
        this.tsService = tsService;
        this.accessValidator = accessValidator;
    }
}

