/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StopWatch;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.TbStopWatch;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.EntityExportSettings;
import org.thingsboard.server.common.data.sync.ie.EntityImportResult;
import org.thingsboard.server.common.data.sync.ie.EntityImportSettings;
import org.thingsboard.server.common.data.sync.vc.AutoCommitSettings;
import org.thingsboard.server.common.data.sync.vc.BranchInfo;
import org.thingsboard.server.common.data.sync.vc.EntityDataDiff;
import org.thingsboard.server.common.data.sync.vc.EntityDataInfo;
import org.thingsboard.server.common.data.sync.vc.EntityLoadError;
import org.thingsboard.server.common.data.sync.vc.EntityTypeLoadResult;
import org.thingsboard.server.common.data.sync.vc.EntityVersion;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.data.sync.vc.VcUtils;
import org.thingsboard.server.common.data.sync.vc.VersionCreationResult;
import org.thingsboard.server.common.data.sync.vc.VersionLoadResult;
import org.thingsboard.server.common.data.sync.vc.VersionedEntityInfo;
import org.thingsboard.server.common.data.sync.vc.request.create.AutoVersionCreateConfig;
import org.thingsboard.server.common.data.sync.vc.request.create.ComplexVersionCreateRequest;
import org.thingsboard.server.common.data.sync.vc.request.create.EntityTypeVersionCreateConfig;
import org.thingsboard.server.common.data.sync.vc.request.create.SingleEntityVersionCreateRequest;
import org.thingsboard.server.common.data.sync.vc.request.create.SyncStrategy;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateConfig;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateRequest;
import org.thingsboard.server.common.data.sync.vc.request.load.EntityTypeVersionLoadConfig;
import org.thingsboard.server.common.data.sync.vc.request.load.EntityTypeVersionLoadRequest;
import org.thingsboard.server.common.data.sync.vc.request.load.SingleEntityVersionLoadRequest;
import org.thingsboard.server.common.data.sync.vc.request.load.VersionLoadConfig;
import org.thingsboard.server.common.data.sync.vc.request.load.VersionLoadRequest;
import org.thingsboard.server.common.data.util.ThrowingRunnable;
import org.thingsboard.server.dao.DaoUtil;
import org.thingsboard.server.dao.exception.DeviceCredentialsValidationException;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.TbLogEntityActionService;
import org.thingsboard.server.service.executors.VersionControlExecutor;
import org.thingsboard.server.service.sync.ie.EntitiesExportImportService;
import org.thingsboard.server.service.sync.ie.exporting.ExportableEntitiesService;
import org.thingsboard.server.service.sync.ie.importing.impl.MissingEntityException;
import org.thingsboard.server.service.sync.vc.DefaultEntitiesVersionControlService;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;
import org.thingsboard.server.service.sync.vc.GitVersionControlQueueService;
import org.thingsboard.server.service.sync.vc.LoadEntityException;
import org.thingsboard.server.service.sync.vc.VersionControlTaskCacheEntry;
import org.thingsboard.server.service.sync.vc.autocommit.TbAutoCommitSettingsService;
import org.thingsboard.server.service.sync.vc.data.CommitGitRequest;
import org.thingsboard.server.service.sync.vc.data.ComplexEntitiesExportCtx;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;
import org.thingsboard.server.service.sync.vc.data.EntityTypeExportCtx;
import org.thingsboard.server.service.sync.vc.data.ReimportTask;
import org.thingsboard.server.service.sync.vc.data.SimpleEntitiesExportCtx;
import org.thingsboard.server.service.sync.vc.repository.TbRepositorySettingsService;

@Service
@TbCoreComponent
public class DefaultEntitiesVersionControlService
implements EntitiesVersionControlService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEntitiesVersionControlService.class);
    private final TbRepositorySettingsService repositorySettingsService;
    private final TbAutoCommitSettingsService autoCommitSettingsService;
    private final GitVersionControlQueueService gitServiceQueue;
    private final EntitiesExportImportService exportImportService;
    private final ExportableEntitiesService exportableEntitiesService;
    private final TbLogEntityActionService logEntityActionService;
    private final TransactionTemplate transactionTemplate;
    private final TbTransactionalCache<UUID, VersionControlTaskCacheEntry> taskCache;
    private final VersionControlExecutor executor;

    public ListenableFuture<UUID> saveEntitiesVersion(User user, VersionCreateRequest request) {
        VcUtils.checkBranchName((String)request.getBranch());
        ListenableFuture pendingCommit = this.gitServiceQueue.prepareCommit(user, request);
        DonAsynchron.withCallback((ListenableFuture)pendingCommit, commit -> {
            this.cachePut(commit.getTxId(), new VersionCreationResult());
            try {
                ListenableFuture resultFuture = Futures.transformAsync((ListenableFuture)Futures.allAsList((Iterable)(switch (1.$SwitchMap$org$thingsboard$server$common$data$sync$vc$request$create$VersionCreateRequestType[request.getType().ordinal()]) {
                    case 1 -> {
                        SimpleEntitiesExportCtx ctx = new SimpleEntitiesExportCtx(user, commit, (SingleEntityVersionCreateRequest)request);
                        this.handleSingleEntityRequest(ctx);
                        yield ctx;
                    }
                    case 2 -> {
                        SimpleEntitiesExportCtx ctx = new ComplexEntitiesExportCtx(user, commit, (ComplexVersionCreateRequest)request);
                        this.handleComplexRequest((ComplexEntitiesExportCtx)ctx);
                        yield ctx;
                    }
                    default -> throw new RuntimeException("Unsupported request type: " + String.valueOf(request.getType()));
                }).getFutures()), f -> this.gitServiceQueue.push(commit), (Executor)this.executor);
                DonAsynchron.withCallback((ListenableFuture)resultFuture, result -> this.cachePut(commit.getTxId(), result), e -> this.processCommitError(user, request, commit, e), (Executor)this.executor);
            }
            catch (Exception e2) {
                this.processCommitError(user, request, commit, (Throwable)e2);
            }
        }, t -> log.debug("[{}] Failed to prepare the commit: {}", new Object[]{user.getId(), request, t}));
        return Futures.transform((ListenableFuture)pendingCommit, CommitGitRequest::getTxId, (Executor)MoreExecutors.directExecutor());
    }

    public VersionCreationResult getVersionCreateStatus(User user, UUID requestId) throws ThingsboardException {
        return (VersionCreationResult)this.getStatus(user, requestId, VersionControlTaskCacheEntry::getExportResult);
    }

    public VersionLoadResult getVersionLoadStatus(User user, UUID requestId) throws ThingsboardException {
        return (VersionLoadResult)this.getStatus(user, requestId, VersionControlTaskCacheEntry::getImportResult);
    }

    private <T> T getStatus(User user, UUID requestId, Function<VersionControlTaskCacheEntry, T> getter) throws ThingsboardException {
        TbCacheValueWrapper cacheEntry = this.taskCache.get((Serializable)requestId);
        if (cacheEntry == null || cacheEntry.get() == null) {
            log.debug("[{}] No cache record: {}", (Object)requestId, (Object)cacheEntry);
            throw new ThingsboardException("Task execution timed-out", ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        VersionControlTaskCacheEntry entry = (VersionControlTaskCacheEntry)cacheEntry.get();
        log.trace("[{}] Cache get: {}", (Object)requestId, (Object)entry);
        T result = getter.apply(entry);
        if (result == null) {
            throw new ThingsboardException("Invalid task", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return result;
    }

    private void handleSingleEntityRequest(SimpleEntitiesExportCtx ctx) throws Exception {
        ctx.add(this.saveEntityData((EntitiesExportCtx)ctx, ((SingleEntityVersionCreateRequest)ctx.getRequest()).getEntityId()));
    }

    private void handleComplexRequest(ComplexEntitiesExportCtx parentCtx) {
        ComplexVersionCreateRequest request = (ComplexVersionCreateRequest)parentCtx.getRequest();
        request.getEntityTypes().forEach((entityType, config) -> {
            EntityTypeExportCtx ctx = new EntityTypeExportCtx((EntitiesExportCtx)parentCtx, config, request.getSyncStrategy(), entityType);
            if (ctx.isOverwrite()) {
                ctx.add(this.gitServiceQueue.deleteAll(ctx.getCommit(), entityType));
            }
            if (config.isAllEntities()) {
                DaoUtil.processInBatches(pageLink -> this.exportableEntitiesService.findEntitiesIdsByTenantId(ctx.getTenantId(), entityType, pageLink), (int)100, entityId -> {
                    try {
                        ctx.add(this.saveEntityData((EntitiesExportCtx)ctx, entityId));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            } else {
                for (UUID entityId2 : config.getEntityIds()) {
                    try {
                        ctx.add(this.saveEntityData((EntitiesExportCtx)ctx, EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)entityId2)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    private ListenableFuture<Void> saveEntityData(EntitiesExportCtx<?> ctx, EntityId entityId) throws Exception {
        EntityExportData entityData = this.exportImportService.exportEntity(ctx, entityId);
        return this.gitServiceQueue.addToCommit(ctx.getCommit(), entityData);
    }

    public ListenableFuture<PageData<EntityVersion>> listEntityVersions(TenantId tenantId, String branch, EntityId externalId, PageLink pageLink) throws Exception {
        return this.gitServiceQueue.listVersions(tenantId, branch, externalId, pageLink);
    }

    public ListenableFuture<PageData<EntityVersion>> listEntityTypeVersions(TenantId tenantId, String branch, EntityType entityType, PageLink pageLink) throws Exception {
        return this.gitServiceQueue.listVersions(tenantId, branch, entityType, pageLink);
    }

    public ListenableFuture<PageData<EntityVersion>> listVersions(TenantId tenantId, String branch, PageLink pageLink) throws Exception {
        return this.gitServiceQueue.listVersions(tenantId, branch, pageLink);
    }

    public ListenableFuture<List<VersionedEntityInfo>> listEntitiesAtVersion(TenantId tenantId, String versionId, EntityType entityType) throws Exception {
        return this.gitServiceQueue.listEntitiesAtVersion(tenantId, versionId, entityType);
    }

    public ListenableFuture<List<VersionedEntityInfo>> listAllEntitiesAtVersion(TenantId tenantId, String versionId) throws Exception {
        return this.gitServiceQueue.listEntitiesAtVersion(tenantId, versionId);
    }

    public UUID loadEntitiesVersion(User user, VersionLoadRequest request) throws Exception {
        EntitiesImportCtx ctx = new EntitiesImportCtx(UUID.randomUUID(), user, request.getVersionId());
        this.cachePut(ctx.getRequestId(), VersionLoadResult.empty());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$sync$vc$request$load$VersionLoadRequestType[request.getType().ordinal()]) {
            case 1: {
                SingleEntityVersionLoadRequest versionLoadRequest = (SingleEntityVersionLoadRequest)request;
                ctx.setRollbackOnError(true);
                VersionLoadConfig config = versionLoadRequest.getConfig();
                ListenableFuture future = this.gitServiceQueue.getEntity(user.getTenantId(), request.getVersionId(), versionLoadRequest.getExternalEntityId());
                DonAsynchron.withCallback((ListenableFuture)future, entityData -> this.load(ctx, request, c -> this.loadSingleEntity(c, config, entityData)), e -> this.processLoadError(ctx, e), (Executor)this.executor);
                break;
            }
            case 2: {
                EntityTypeVersionLoadRequest versionLoadRequest = (EntityTypeVersionLoadRequest)request;
                ctx.setRollbackOnError(versionLoadRequest.isRollbackOnError());
                this.executor.submit(() -> this.load(ctx, request, c -> this.loadMultipleEntities(c, versionLoadRequest)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported version load request");
            }
        }
        return ctx.getRequestId();
    }

    private <R> VersionLoadResult load(EntitiesImportCtx ctx, VersionLoadRequest request, Function<EntitiesImportCtx, VersionLoadResult> loadFunction) {
        try {
            VersionLoadResult result;
            if (ctx.isRollbackOnError()) {
                result = (VersionLoadResult)this.transactionTemplate.execute(status -> {
                    try {
                        return (VersionLoadResult)loadFunction.apply(ctx);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                for (ThrowingRunnable eventCallback : ctx.getEventCallbacks()) {
                    eventCallback.run();
                }
            } else {
                result = loadFunction.apply(ctx);
            }
            result.setDone(true);
            return this.cachePut(ctx.getRequestId(), result);
        }
        catch (LoadEntityException e) {
            return this.cachePut(ctx.getRequestId(), this.onError(e.getExternalId(), e.getCause()));
        }
        catch (Throwable e) {
            log.info("[{}] Failed to process request [{}] due to: ", new Object[]{ctx.getTenantId(), request, e});
            return this.cachePut(ctx.getRequestId(), VersionLoadResult.error((EntityLoadError)EntityLoadError.runtimeError((Throwable)e)));
        }
    }

    private VersionLoadResult loadSingleEntity(EntitiesImportCtx ctx, VersionLoadConfig config, EntityExportData entityData) {
        try {
            ctx.setSettings(EntityImportSettings.builder().updateRelations(config.isLoadRelations()).saveAttributes(config.isLoadAttributes()).saveCredentials(config.isLoadCredentials()).saveCalculatedFields(config.isLoadCalculatedFields()).findExistingByName(false).build());
            ctx.setFinalImportAttempt(true);
            EntityImportResult importResult = this.exportImportService.importEntity(ctx, entityData);
            this.exportImportService.saveReferencesAndRelations(ctx);
            return VersionLoadResult.success((EntityTypeLoadResult)EntityTypeLoadResult.builder().entityType(importResult.getEntityType()).created(importResult.getOldEntity() == null ? 1 : 0).updated(importResult.getOldEntity() != null ? 1 : 0).deleted(0).build());
        }
        catch (Exception e) {
            throw new LoadEntityException(entityData.getExternalId(), (Throwable)e);
        }
    }

    private VersionLoadResult loadMultipleEntities(EntitiesImportCtx ctx, EntityTypeVersionLoadRequest request) {
        TbStopWatch sw = TbStopWatch.create((String)"before");
        List entityTypes = request.getEntityTypes().keySet().stream().sorted(this.exportImportService.getEntityTypeComparatorForImport()).toList();
        for (EntityType entityType2 : entityTypes) {
            log.debug("[{}] Loading {} entities", (Object)ctx.getTenantId(), (Object)entityType2);
            sw.startNew("Entities " + entityType2.name());
            ctx.setSettings(this.getEntityImportSettings(request, entityType2));
            this.importEntities(ctx, entityType2);
        }
        sw.startNew("Reimport");
        this.reimport(ctx);
        this.persistToCache(ctx);
        sw.startNew("Remove Others");
        request.getEntityTypes().keySet().stream().filter(entityType -> ((EntityTypeVersionLoadConfig)request.getEntityTypes().get(entityType)).isRemoveOtherEntities()).sorted(this.exportImportService.getEntityTypeComparatorForImport().reversed()).forEach(entityType -> this.removeOtherEntities(ctx, entityType));
        sw.startNew("References and Relations");
        this.exportImportService.saveReferencesAndRelations(ctx);
        sw.stop();
        for (StopWatch.TaskInfo task : sw.getTaskInfo()) {
            log.debug("[{}] Executed: {} in {}ms", new Object[]{ctx.getTenantId(), task.getTaskName(), task.getTimeMillis()});
        }
        log.debug("[{}] Total time: {}ms", (Object)ctx.getTenantId(), (Object)sw.getTotalTimeMillis());
        return VersionLoadResult.success(new ArrayList(ctx.getResults().values()));
    }

    private EntityImportSettings getEntityImportSettings(EntityTypeVersionLoadRequest request, EntityType entityType) {
        EntityTypeVersionLoadConfig config = (EntityTypeVersionLoadConfig)request.getEntityTypes().get(entityType);
        return EntityImportSettings.builder().updateRelations(config.isLoadRelations()).saveAttributes(config.isLoadAttributes()).saveCredentials(config.isLoadCredentials()).saveCalculatedFields(config.isLoadCalculatedFields()).findExistingByName(config.isFindExistingEntityByName()).build();
    }

    private void importEntities(EntitiesImportCtx ctx, EntityType entityType) {
        List entityDataList;
        int limit = 100;
        int offset = 0;
        do {
            try {
                entityDataList = (List)this.gitServiceQueue.getEntities(ctx.getTenantId(), ctx.getVersionId(), entityType, offset, limit).get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            log.debug("[{}] Loading {} entities pack ({})", new Object[]{ctx.getTenantId(), entityType, entityDataList.size()});
            for (EntityExportData entityData : entityDataList) {
                EntityImportResult importResult;
                EntityExportData reimportBackup = (EntityExportData)JacksonUtil.clone((Object)entityData);
                try {
                    importResult = this.exportImportService.importEntity(ctx, entityData);
                }
                catch (Exception e) {
                    throw new LoadEntityException(entityData.getExternalId(), (Throwable)e);
                }
                this.registerResult(ctx, entityType, importResult);
                if (!importResult.isUpdatedAllExternalIds()) {
                    ctx.getToReimport().put(entityData.getEntity().getExternalId(), new ReimportTask(reimportBackup, ctx.getSettings()));
                    continue;
                }
                ctx.getImportedEntities().computeIfAbsent(entityType, t -> new HashSet()).add((EntityId)importResult.getSavedEntity().getId());
            }
            this.persistToCache(ctx);
            log.debug("Imported {} pack ({}) for tenant {}", new Object[]{entityType, entityDataList.size(), ctx.getTenantId()});
            offset += limit;
        } while (entityDataList.size() == limit);
    }

    private void reimport(EntitiesImportCtx ctx) {
        ctx.setFinalImportAttempt(true);
        ctx.getToReimport().forEach((externalId, task) -> {
            try {
                EntityExportData entityData = task.getData();
                EntityImportSettings settings = task.getSettings();
                ctx.setSettings(settings);
                EntityImportResult importResult = this.exportImportService.importEntity(ctx, entityData);
                ctx.getImportedEntities().computeIfAbsent(externalId.getEntityType(), t -> new HashSet()).add((EntityId)importResult.getSavedEntity().getId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void removeOtherEntities(EntitiesImportCtx ctx, EntityType entityType) {
        PageDataIterable entities = new PageDataIterable(link -> this.exportableEntitiesService.findEntitiesIdsByTenantId(ctx.getTenantId(), entityType, link), 100);
        HashSet<EntityId> toRemove = new HashSet<EntityId>();
        for (EntityId entityId : entities) {
            if (ctx.getImportedEntities().get(entityType) != null && ((Set)ctx.getImportedEntities().get(entityType)).contains(entityId)) continue;
            toRemove.add(entityId);
        }
        for (EntityId entityId : toRemove) {
            ExportableEntity entity = (ExportableEntity)this.exportableEntitiesService.findEntityById(entityId);
            this.exportableEntitiesService.removeById(ctx.getTenantId(), entityId);
            ThrowingRunnable callback = () -> this.logEntityActionService.logEntityAction(ctx.getTenantId(), (EntityId)entity.getId(), (HasName)entity, null, ActionType.DELETED, ctx.getUser(), new Object[0]);
            if (ctx.isRollbackOnError()) {
                ctx.addEventCallback(callback);
            } else {
                try {
                    callback.run();
                }
                catch (ThingsboardException e) {
                    throw new RuntimeException(e);
                }
            }
            ctx.registerDeleted(entityType);
        }
        this.persistToCache(ctx);
    }

    private VersionLoadResult onError(EntityId externalId, Throwable e) {
        return this.analyze(e, externalId).orElse(VersionLoadResult.error((EntityLoadError)EntityLoadError.runtimeError((Throwable)e, (EntityId)externalId)));
    }

    private Optional<VersionLoadResult> analyze(Throwable e, EntityId externalId) {
        if (e == null) {
            return Optional.empty();
        }
        if (e instanceof DeviceCredentialsValidationException) {
            return Optional.of(VersionLoadResult.error((EntityLoadError)EntityLoadError.credentialsError((EntityId)externalId)));
        }
        if (e instanceof MissingEntityException) {
            return Optional.of(VersionLoadResult.error((EntityLoadError)EntityLoadError.referenceEntityError((EntityId)externalId, (EntityId)((MissingEntityException)e).getEntityId())));
        }
        return this.analyze(e.getCause(), externalId);
    }

    public ListenableFuture<EntityDataDiff> compareEntityDataToVersion(User user, EntityId entityId, String versionId) {
        HasId entity = this.exportableEntitiesService.findEntityByTenantIdAndId(user.getTenantId(), entityId);
        if (!(entity instanceof ExportableEntity)) {
            throw new IllegalArgumentException("Unsupported entity type");
        }
        EntityId externalId = ((ExportableEntity)entity).getExternalId();
        if (externalId == null) {
            externalId = entityId;
        }
        return Futures.transform((ListenableFuture)this.gitServiceQueue.getEntity(user.getTenantId(), versionId, externalId), otherVersion -> {
            EntityExportData currentVersion;
            SimpleEntitiesExportCtx ctx = new SimpleEntitiesExportCtx(user, null, null, EntityExportSettings.builder().exportRelations(otherVersion.hasRelations()).exportAttributes(otherVersion.hasAttributes()).exportCredentials(otherVersion.hasCredentials()).exportCalculatedFields(otherVersion.hasCalculatedFields()).build());
            try {
                currentVersion = this.exportImportService.exportEntity((EntitiesExportCtx)ctx, entityId);
            }
            catch (ThingsboardException e) {
                throw new RuntimeException(e);
            }
            return new EntityDataDiff(currentVersion.sort(), otherVersion.sort());
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<EntityDataInfo> getEntityDataInfo(User user, EntityId entityId, String versionId) {
        return Futures.transform((ListenableFuture)this.gitServiceQueue.getEntity(user.getTenantId(), versionId, entityId), entity -> new EntityDataInfo(entity.hasRelations(), entity.hasAttributes(), entity.hasCredentials(), entity.hasCalculatedFields()), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<BranchInfo>> listBranches(TenantId tenantId) {
        return this.gitServiceQueue.listBranches(tenantId);
    }

    public RepositorySettings getVersionControlSettings(TenantId tenantId) {
        return this.repositorySettingsService.get(tenantId);
    }

    public ListenableFuture<RepositorySettings> saveVersionControlSettings(TenantId tenantId, RepositorySettings versionControlSettings) {
        VcUtils.checkBranchName((String)versionControlSettings.getDefaultBranch());
        RepositorySettings restoredSettings = this.repositorySettingsService.restore(tenantId, versionControlSettings);
        try {
            ListenableFuture future = this.gitServiceQueue.initRepository(tenantId, restoredSettings);
            return Futures.transform((ListenableFuture)future, f -> this.repositorySettingsService.save(tenantId, restoredSettings), (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            log.debug("{} Failed to init repository: {}", new Object[]{tenantId, versionControlSettings, e});
            throw new RuntimeException("Failed to init repository!", e);
        }
    }

    public ListenableFuture<Void> deleteVersionControlSettings(TenantId tenantId) {
        log.debug("[{}] Deleting version control settings", (Object)tenantId);
        this.repositorySettingsService.delete(tenantId);
        return this.gitServiceQueue.clearRepository(tenantId);
    }

    public ListenableFuture<Void> checkVersionControlAccess(TenantId tenantId, RepositorySettings settings) throws ThingsboardException {
        VcUtils.checkBranchName((String)settings.getDefaultBranch());
        settings = this.repositorySettingsService.restore(tenantId, settings);
        try {
            return this.gitServiceQueue.testRepository(tenantId, settings);
        }
        catch (Exception e) {
            throw new ThingsboardException(String.format("Unable to access repository: %s", this.getCauseMessage(e)), ThingsboardErrorCode.GENERAL);
        }
    }

    public ListenableFuture<UUID> autoCommit(User user, EntityId entityId) {
        RepositorySettings repositorySettings = this.repositorySettingsService.get(user.getTenantId());
        if (repositorySettings == null || repositorySettings.isReadOnly()) {
            return Futures.immediateFuture(null);
        }
        AutoCommitSettings autoCommitSettings = this.autoCommitSettingsService.get(user.getTenantId());
        if (autoCommitSettings == null) {
            return Futures.immediateFuture(null);
        }
        EntityType entityType = entityId.getEntityType();
        AutoVersionCreateConfig autoCommitConfig = (AutoVersionCreateConfig)autoCommitSettings.get((Object)entityType);
        if (autoCommitConfig == null) {
            return Futures.immediateFuture(null);
        }
        SingleEntityVersionCreateRequest vcr = new SingleEntityVersionCreateRequest();
        String autoCommitBranchName = autoCommitConfig.getBranch();
        if (StringUtils.isEmpty((CharSequence)autoCommitBranchName)) {
            autoCommitBranchName = StringUtils.isNotEmpty((CharSequence)repositorySettings.getDefaultBranch()) ? repositorySettings.getDefaultBranch() : "auto-commits";
        }
        vcr.setBranch(autoCommitBranchName);
        vcr.setVersionName("auto-commit at " + String.valueOf(Instant.ofEpochSecond(System.currentTimeMillis() / 1000L)));
        vcr.setEntityId(entityId);
        vcr.setConfig((VersionCreateConfig)autoCommitConfig);
        return this.saveEntitiesVersion(user, (VersionCreateRequest)vcr);
    }

    public ListenableFuture<UUID> autoCommit(User user, EntityType entityType, List<UUID> entityIds) {
        RepositorySettings repositorySettings = this.repositorySettingsService.get(user.getTenantId());
        if (repositorySettings == null || repositorySettings.isReadOnly()) {
            return Futures.immediateFuture(null);
        }
        AutoCommitSettings autoCommitSettings = this.autoCommitSettingsService.get(user.getTenantId());
        if (autoCommitSettings == null) {
            return Futures.immediateFuture(null);
        }
        AutoVersionCreateConfig autoCommitConfig = (AutoVersionCreateConfig)autoCommitSettings.get((Object)entityType);
        if (autoCommitConfig == null) {
            return Futures.immediateFuture(null);
        }
        String autoCommitBranchName = autoCommitConfig.getBranch();
        if (StringUtils.isEmpty((CharSequence)autoCommitBranchName)) {
            autoCommitBranchName = StringUtils.isNotEmpty((CharSequence)repositorySettings.getDefaultBranch()) ? repositorySettings.getDefaultBranch() : "auto-commits";
        }
        ComplexVersionCreateRequest vcr = new ComplexVersionCreateRequest();
        vcr.setBranch(autoCommitBranchName);
        vcr.setVersionName("auto-commit at " + String.valueOf(Instant.ofEpochSecond(System.currentTimeMillis() / 1000L)));
        vcr.setSyncStrategy(SyncStrategy.MERGE);
        EntityTypeVersionCreateConfig vcrConfig = new EntityTypeVersionCreateConfig();
        vcrConfig.setEntityIds(entityIds);
        vcr.setEntityTypes(Collections.singletonMap(entityType, vcrConfig));
        return this.saveEntitiesVersion(user, (VersionCreateRequest)vcr);
    }

    private String getCauseMessage(Exception e) {
        String message = e.getCause() != null && StringUtils.isNotEmpty((CharSequence)e.getCause().getMessage()) ? e.getCause().getMessage() : e.getMessage();
        return message;
    }

    private void registerResult(EntitiesImportCtx ctx, EntityType entityType, EntityImportResult<?> importResult) {
        if (importResult.isCreated()) {
            ctx.registerResult(entityType, true);
        } else if (importResult.isUpdated() || importResult.isUpdatedRelatedEntities()) {
            ctx.registerResult(entityType, false);
        }
    }

    private void processCommitError(User user, VersionCreateRequest request, CommitGitRequest commit, Throwable e) {
        log.debug("[{}] Failed to prepare the commit: {}", new Object[]{user.getId(), request, e});
        this.cachePut(commit.getTxId(), new VersionCreationResult(e.getMessage()));
    }

    private void processLoadError(EntitiesImportCtx ctx, Throwable e) {
        log.debug("[{}] Failed to load the commit: {}", new Object[]{ctx.getRequestId(), ctx.getVersionId(), e});
        this.cachePut(ctx.getRequestId(), VersionLoadResult.error((EntityLoadError)EntityLoadError.runtimeError((Throwable)e)));
    }

    private void cachePut(UUID requestId, VersionCreationResult result) {
        this.taskCache.put((Serializable)requestId, (Serializable)VersionControlTaskCacheEntry.newForExport((VersionCreationResult)result));
    }

    private VersionLoadResult cachePut(UUID requestId, VersionLoadResult result) {
        log.trace("[{}] Cache put: {}", (Object)requestId, (Object)result);
        this.taskCache.put((Serializable)requestId, (Serializable)VersionControlTaskCacheEntry.newForImport((VersionLoadResult)result));
        return result;
    }

    private void persistToCache(EntitiesImportCtx ctx) {
        this.cachePut(ctx.getRequestId(), VersionLoadResult.success(new ArrayList(ctx.getResults().values())));
    }

    @ConstructorProperties(value={"repositorySettingsService", "autoCommitSettingsService", "gitServiceQueue", "exportImportService", "exportableEntitiesService", "logEntityActionService", "transactionTemplate", "taskCache", "executor"})
    @Generated
    public DefaultEntitiesVersionControlService(TbRepositorySettingsService repositorySettingsService, TbAutoCommitSettingsService autoCommitSettingsService, GitVersionControlQueueService gitServiceQueue, EntitiesExportImportService exportImportService, ExportableEntitiesService exportableEntitiesService, TbLogEntityActionService logEntityActionService, TransactionTemplate transactionTemplate, TbTransactionalCache<UUID, VersionControlTaskCacheEntry> taskCache, VersionControlExecutor executor) {
        this.repositorySettingsService = repositorySettingsService;
        this.autoCommitSettingsService = autoCommitSettingsService;
        this.gitServiceQueue = gitServiceQueue;
        this.exportImportService = exportImportService;
        this.exportableEntitiesService = exportableEntitiesService;
        this.logEntityActionService = logEntityActionService;
        this.transactionTemplate = transactionTemplate;
        this.taskCache = taskCache;
        this.executor = executor;
    }
}

