/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.OtaPackageExportData;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class OtaPackageImportService
extends BaseEntityImportService<OtaPackageId, OtaPackage, OtaPackageExportData> {
    private final OtaPackageService otaPackageService;

    protected void setOwner(TenantId tenantId, OtaPackage otaPackage, BaseEntityImportService.IdProvider idProvider) {
        otaPackage.setTenantId(tenantId);
    }

    protected OtaPackage prepare(EntitiesImportCtx ctx, OtaPackage otaPackage, OtaPackage oldOtaPackage, OtaPackageExportData exportData, BaseEntityImportService.IdProvider idProvider) {
        otaPackage.setDeviceProfileId((DeviceProfileId)idProvider.getInternalId((EntityId)otaPackage.getDeviceProfileId()));
        return otaPackage;
    }

    protected OtaPackage findExistingEntity(EntitiesImportCtx ctx, OtaPackage otaPackage, BaseEntityImportService.IdProvider idProvider) {
        OtaPackage existingOtaPackage = (OtaPackage)super.findExistingEntity(ctx, (ExportableEntity)otaPackage, idProvider);
        if (existingOtaPackage == null && ctx.isFindExistingByName()) {
            existingOtaPackage = this.otaPackageService.findOtaPackageByTenantIdAndTitleAndVersion(ctx.getTenantId(), otaPackage.getTitle(), otaPackage.getVersion());
        }
        return existingOtaPackage;
    }

    protected OtaPackage deepCopy(OtaPackage otaPackage) {
        return new OtaPackage(otaPackage);
    }

    protected OtaPackage saveOrUpdate(EntitiesImportCtx ctx, OtaPackage otaPackage, OtaPackageExportData exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        if (otaPackage.hasUrl()) {
            OtaPackageInfo info = new OtaPackageInfo((OtaPackageInfo)otaPackage);
            return new OtaPackage(this.otaPackageService.saveOtaPackageInfo(info, info.hasUrl()));
        }
        return this.otaPackageService.saveOtaPackage(otaPackage);
    }

    public EntityType getEntityType() {
        return EntityType.OTA_PACKAGE;
    }

    @ConstructorProperties(value={"otaPackageService"})
    @Generated
    public OtaPackageImportService(OtaPackageService otaPackageService) {
        this.otaPackageService = otaPackageService;
    }
}

