/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class EntityViewImportService
extends BaseEntityImportService<EntityViewId, EntityView, EntityExportData<EntityView>> {
    private final EntityViewService entityViewService;
    @Lazy
    @Autowired
    private TbEntityViewService tbEntityViewService;

    protected void setOwner(TenantId tenantId, EntityView entityView, BaseEntityImportService.IdProvider idProvider) {
        entityView.setTenantId(tenantId);
        entityView.setCustomerId((CustomerId)idProvider.getInternalId((EntityId)entityView.getCustomerId()));
    }

    protected EntityView prepare(EntitiesImportCtx ctx, EntityView entityView, EntityView old, EntityExportData<EntityView> exportData, BaseEntityImportService.IdProvider idProvider) {
        entityView.setEntityId(idProvider.getInternalId(entityView.getEntityId()));
        return entityView;
    }

    protected EntityView saveOrUpdate(EntitiesImportCtx ctx, EntityView entityView, EntityExportData<EntityView> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        return this.entityViewService.saveEntityView(entityView);
    }

    protected void onEntitySaved(User user, EntityView savedEntityView, EntityView oldEntityView) throws ThingsboardException {
        this.tbEntityViewService.updateEntityViewAttributes(user.getTenantId(), savedEntityView, oldEntityView, user);
        super.onEntitySaved(user, (ExportableEntity)savedEntityView, (ExportableEntity)oldEntityView);
    }

    protected EntityView deepCopy(EntityView entityView) {
        return new EntityView(entityView);
    }

    protected void cleanupForComparison(EntityView e) {
        super.cleanupForComparison((ExportableEntity)e);
        if (e.getCustomerId() != null && e.getCustomerId().isNullUid()) {
            e.setCustomerId(null);
        }
    }

    public EntityType getEntityType() {
        return EntityType.ENTITY_VIEW;
    }

    @ConstructorProperties(value={"entityViewService"})
    @Generated
    public EntityViewImportService(EntityViewService entityViewService) {
        this.entityViewService = entityViewService;
    }
}

