/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class DeviceProfileImportService
extends BaseEntityImportService<DeviceProfileId, DeviceProfile, EntityExportData<DeviceProfile>> {
    private final DeviceProfileService deviceProfileService;

    protected void setOwner(TenantId tenantId, DeviceProfile deviceProfile, BaseEntityImportService.IdProvider idProvider) {
        deviceProfile.setTenantId(tenantId);
    }

    protected DeviceProfile prepare(EntitiesImportCtx ctx, DeviceProfile deviceProfile, DeviceProfile old, EntityExportData<DeviceProfile> exportData, BaseEntityImportService.IdProvider idProvider) {
        deviceProfile.setDefaultRuleChainId((RuleChainId)idProvider.getInternalId((EntityId)deviceProfile.getDefaultRuleChainId()));
        deviceProfile.setDefaultEdgeRuleChainId((RuleChainId)idProvider.getInternalId((EntityId)deviceProfile.getDefaultEdgeRuleChainId()));
        deviceProfile.setDefaultDashboardId((DashboardId)idProvider.getInternalId((EntityId)deviceProfile.getDefaultDashboardId()));
        deviceProfile.setFirmwareId((OtaPackageId)idProvider.getInternalId((EntityId)deviceProfile.getFirmwareId(), false));
        deviceProfile.setSoftwareId((OtaPackageId)idProvider.getInternalId((EntityId)deviceProfile.getSoftwareId(), false));
        return deviceProfile;
    }

    protected DeviceProfile saveOrUpdate(EntitiesImportCtx ctx, DeviceProfile deviceProfile, EntityExportData<DeviceProfile> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        boolean toUpdate;
        boolean bl = toUpdate = ctx.isFinalImportAttempt() || ctx.getCurrentImportResult().isUpdatedAllExternalIds();
        if (toUpdate) {
            deviceProfile.setFirmwareId((OtaPackageId)idProvider.getInternalId((EntityId)deviceProfile.getFirmwareId()));
            deviceProfile.setSoftwareId((OtaPackageId)idProvider.getInternalId((EntityId)deviceProfile.getSoftwareId()));
        }
        DeviceProfile saved = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        if (toUpdate) {
            this.importCalculatedFields(ctx, (ExportableEntity)saved, exportData, idProvider);
        }
        return saved;
    }

    protected void onEntitySaved(User user, DeviceProfile savedDeviceProfile, DeviceProfile oldDeviceProfile) {
        this.logEntityActionService.logEntityAction(savedDeviceProfile.getTenantId(), (EntityId)savedDeviceProfile.getId(), (HasName)savedDeviceProfile, null, oldDeviceProfile == null ? ActionType.ADDED : ActionType.UPDATED, user, new Object[0]);
    }

    protected DeviceProfile deepCopy(DeviceProfile deviceProfile) {
        return new DeviceProfile(deviceProfile);
    }

    protected void cleanupForComparison(DeviceProfile deviceProfile) {
        super.cleanupForComparison((ExportableEntity)deviceProfile);
    }

    public EntityType getEntityType() {
        return EntityType.DEVICE_PROFILE;
    }

    @ConstructorProperties(value={"deviceProfileService"})
    @Generated
    public DeviceProfileImportService(DeviceProfileService deviceProfileService) {
        this.deviceProfileService = deviceProfileService;
    }
}

