/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.customer.CustomerDao;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class CustomerImportService
extends BaseEntityImportService<CustomerId, Customer, EntityExportData<Customer>> {
    private final CustomerService customerService;
    private final CustomerDao customerDao;

    protected void setOwner(TenantId tenantId, Customer customer, BaseEntityImportService.IdProvider idProvider) {
        customer.setTenantId(tenantId);
    }

    protected Customer prepare(EntitiesImportCtx ctx, Customer customer, Customer old, EntityExportData<Customer> exportData, BaseEntityImportService.IdProvider idProvider) {
        if (customer.isPublic()) {
            Customer publicCustomer = this.customerService.findOrCreatePublicCustomer(ctx.getTenantId());
            publicCustomer.setExternalId(customer.getExternalId());
            return publicCustomer;
        }
        return customer;
    }

    protected Customer saveOrUpdate(EntitiesImportCtx ctx, Customer customer, EntityExportData<Customer> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        if (!customer.isPublic()) {
            return this.customerService.saveCustomer(customer);
        }
        return this.customerDao.save(ctx.getTenantId(), customer);
    }

    protected Customer deepCopy(Customer customer) {
        return new Customer(customer);
    }

    public EntityType getEntityType() {
        return EntityType.CUSTOMER;
    }

    @ConstructorProperties(value={"customerService", "customerDao"})
    @Generated
    public CustomerImportService(CustomerService customerService, CustomerDao customerDao) {
        this.customerService = customerService;
        this.customerDao = customerDao;
    }
}

