/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.ie.importing.impl.DashboardImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class DashboardExportService
extends BaseEntityExportService<DashboardId, Dashboard, EntityExportData<Dashboard>> {
    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, Dashboard dashboard, EntityExportData<Dashboard> exportData) {
        if (CollectionUtils.isNotEmpty((Collection)dashboard.getAssignedCustomers())) {
            dashboard.getAssignedCustomers().forEach(customerInfo -> customerInfo.setCustomerId((CustomerId)this.getExternalIdOrElseInternal(ctx, (EntityId)customerInfo.getCustomerId())));
        }
        for (JsonNode entityAlias : dashboard.getEntityAliasesConfig()) {
            this.replaceUuidsRecursively(ctx, entityAlias, Set.of("id"), null);
        }
        for (JsonNode widgetConfig : dashboard.getWidgetsConfig()) {
            this.replaceUuidsRecursively(ctx, JacksonUtil.getSafely((JsonNode)widgetConfig, (String[])new String[]{"config", "actions"}), Collections.emptySet(), DashboardImportService.WIDGET_CONFIG_PROCESSED_FIELDS_PATTERN);
        }
    }

    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.DASHBOARD);
    }
}

