/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.Dao;
import org.thingsboard.server.dao.ExportableEntityDao;
import org.thingsboard.server.dao.entity.EntityDaoService;
import org.thingsboard.server.dao.entity.EntityServiceRegistry;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.sync.ie.exporting.ExportableEntitiesService;

@Service
@TbCoreComponent
public class DefaultExportableEntitiesService
implements ExportableEntitiesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultExportableEntitiesService.class);
    private final Map<EntityType, Dao<?>> daos = new HashMap();
    private final EntityServiceRegistry entityServiceRegistry;
    private final AccessControlService accessControlService;

    public <E extends ExportableEntity<I>, I extends EntityId> E findEntityByTenantIdAndExternalId(TenantId tenantId, I externalId) {
        EntityType entityType = externalId.getEntityType();
        Dao dao = this.getDao(entityType);
        ExportableEntity entity = null;
        if (dao instanceof ExportableEntityDao) {
            ExportableEntityDao exportableEntityDao = (ExportableEntityDao)dao;
            entity = exportableEntityDao.findByTenantIdAndExternalId(tenantId.getId(), externalId.getId());
        }
        if (entity == null || !this.belongsToTenant(entity, tenantId)) {
            return null;
        }
        return (E)entity;
    }

    public <E extends HasId<I>, I extends EntityId> E findEntityByTenantIdAndId(TenantId tenantId, I id) {
        HasId entity = this.findEntityById(id);
        if (entity == null || !this.belongsToTenant(entity, tenantId)) {
            return null;
        }
        return (E)entity;
    }

    public <E extends HasId<I>, I extends EntityId> E findEntityById(I id) {
        EntityType entityType = id.getEntityType();
        Dao dao = this.getDao(entityType);
        if (dao == null) {
            throw new IllegalArgumentException("Unsupported entity type " + String.valueOf(entityType));
        }
        return (E)((HasId)dao.findById(TenantId.SYS_TENANT_ID, id.getId()));
    }

    public <E extends ExportableEntity<I>, I extends EntityId> E findEntityByTenantIdAndName(TenantId tenantId, EntityType entityType, String name) {
        Dao dao = this.getDao(entityType);
        ExportableEntity entity = null;
        if (dao instanceof ExportableEntityDao) {
            ExportableEntityDao exportableEntityDao = (ExportableEntityDao)dao;
            try {
                entity = exportableEntityDao.findByTenantIdAndName(tenantId.getId(), name);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (entity == null || !this.belongsToTenant(entity, tenantId)) {
            return null;
        }
        return (E)entity;
    }

    public <E extends ExportableEntity<I>, I extends EntityId> E findDefaultEntityByTenantId(TenantId tenantId, EntityType entityType) {
        ExportableEntityDao dao = this.getExportableEntityDao(entityType);
        if (dao == null) {
            return null;
        }
        return (E)dao.findDefaultEntityByTenantId(tenantId.getId());
    }

    public <E extends ExportableEntity<I>, I extends EntityId> PageData<E> findEntitiesByTenantId(TenantId tenantId, EntityType entityType, PageLink pageLink) {
        ExportableEntityDao dao = this.getExportableEntityDao(entityType);
        if (dao == null) {
            return PageData.emptyPageData();
        }
        return dao.findByTenantId(tenantId.getId(), pageLink);
    }

    public <I extends EntityId> PageData<I> findEntitiesIdsByTenantId(TenantId tenantId, EntityType entityType, PageLink pageLink) {
        ExportableEntityDao dao = this.getExportableEntityDao(entityType);
        if (dao == null) {
            return PageData.emptyPageData();
        }
        return dao.findIdsByTenantId(tenantId.getId(), pageLink);
    }

    public <I extends EntityId> I getExternalIdByInternal(I internalId) {
        ExportableEntityDao dao = this.getExportableEntityDao(internalId.getEntityType());
        if (dao == null) {
            return null;
        }
        return (I)dao.getExternalIdByInternal(internalId);
    }

    private boolean belongsToTenant(HasId<? extends EntityId> entity, TenantId tenantId) {
        return tenantId.equals((Object)((HasTenantId)entity).getTenantId());
    }

    public <I extends EntityId> void removeById(TenantId tenantId, I id) {
        EntityType entityType = id.getEntityType();
        EntityDaoService entityService = this.entityServiceRegistry.getServiceByEntityType(entityType);
        entityService.deleteEntity(tenantId, id, false);
    }

    private <I extends EntityId, E extends ExportableEntity<I>> ExportableEntityDao<I, E> getExportableEntityDao(EntityType entityType) {
        Dao dao = this.getDao(entityType);
        if (dao instanceof ExportableEntityDao) {
            return (ExportableEntityDao)dao;
        }
        return null;
    }

    private <E> Dao<E> getDao(EntityType entityType) {
        return (Dao)this.daos.get(entityType);
    }

    @Autowired
    private void setDaos(Collection<Dao<?>> daos) {
        daos.forEach(dao -> {
            if (dao.getEntityType() != null) {
                this.daos.put(dao.getEntityType(), dao);
            }
        });
    }

    @ConstructorProperties(value={"entityServiceRegistry", "accessControlService"})
    @Generated
    public DefaultExportableEntitiesService(EntityServiceRegistry entityServiceRegistry, AccessControlService accessControlService) {
        this.entityServiceRegistry = entityServiceRegistry;
        this.accessControlService = accessControlService;
    }
}

