/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.EntityImportResult;
import org.thingsboard.server.common.data.util.ThrowingRunnable;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.TbLogEntityActionService;
import org.thingsboard.server.service.sync.ie.EntitiesExportImportService;
import org.thingsboard.server.service.sync.ie.exporting.EntityExportService;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.ie.exporting.impl.DefaultEntityExportService;
import org.thingsboard.server.service.sync.ie.importing.EntityImportService;
import org.thingsboard.server.service.sync.ie.importing.impl.MissingEntityException;
import org.thingsboard.server.service.sync.vc.LoadEntityException;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class DefaultEntitiesExportImportService
implements EntitiesExportImportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEntitiesExportImportService.class);
    private final Map<EntityType, EntityExportService<?, ?, ?>> exportServices = new HashMap();
    private final Map<EntityType, EntityImportService<?, ?, ?>> importServices = new HashMap();
    private final RelationService relationService;
    private final RateLimitService rateLimitService;
    private final TbLogEntityActionService logEntityActionService;
    protected static final List<EntityType> SUPPORTED_ENTITY_TYPES = List.of(EntityType.CUSTOMER, EntityType.RULE_CHAIN, EntityType.TB_RESOURCE, EntityType.DASHBOARD, EntityType.ASSET_PROFILE, EntityType.ASSET, EntityType.DEVICE_PROFILE, EntityType.OTA_PACKAGE, EntityType.DEVICE, EntityType.ENTITY_VIEW, EntityType.WIDGET_TYPE, EntityType.WIDGETS_BUNDLE, EntityType.NOTIFICATION_TEMPLATE, EntityType.NOTIFICATION_TARGET, EntityType.NOTIFICATION_RULE, EntityType.AI_MODEL);

    public <E extends ExportableEntity<I>, I extends EntityId> EntityExportData<E> exportEntity(EntitiesExportCtx<?> ctx, I entityId) throws ThingsboardException {
        if (!this.rateLimitService.checkRateLimit(LimitedApi.ENTITY_EXPORT, ctx.getTenantId())) {
            throw new ThingsboardException("Rate limit for entities export is exceeded", ThingsboardErrorCode.TOO_MANY_REQUESTS);
        }
        EntityType entityType = entityId.getEntityType();
        EntityExportService exportService = this.getExportService(entityType);
        return exportService.getExportData(ctx, entityId);
    }

    public <E extends ExportableEntity<I>, I extends EntityId> EntityImportResult<E> importEntity(EntitiesImportCtx ctx, EntityExportData<E> exportData) throws ThingsboardException {
        if (!this.rateLimitService.checkRateLimit(LimitedApi.ENTITY_IMPORT, ctx.getTenantId())) {
            throw new ThingsboardException("Rate limit for entities import is exceeded", ThingsboardErrorCode.TOO_MANY_REQUESTS);
        }
        if (exportData.getEntity() == null || exportData.getEntity().getId() == null) {
            throw new DataValidationException("Invalid entity data");
        }
        EntityType entityType = exportData.getEntityType();
        EntityImportService importService = this.getImportService(entityType);
        EntityImportResult importResult = importService.importEntity(ctx, exportData);
        ctx.putInternalId(exportData.getExternalId(), (EntityId)importResult.getSavedEntity().getId());
        ctx.addReferenceCallback(exportData.getExternalId(), importResult.getSaveReferencesCallback());
        if (ctx.isRollbackOnError()) {
            ctx.addEventCallback(importResult.getSendEventsCallback());
        } else {
            importResult.getSendEventsCallback().run();
        }
        return importResult;
    }

    public void saveReferencesAndRelations(EntitiesImportCtx ctx) throws ThingsboardException {
        for (Map.Entry callbackEntry : ctx.getReferenceCallbacks().entrySet()) {
            EntityId externalId = (EntityId)callbackEntry.getKey();
            ThrowingRunnable saveReferencesCallback = (ThrowingRunnable)callbackEntry.getValue();
            try {
                saveReferencesCallback.run();
            }
            catch (MissingEntityException e) {
                throw new LoadEntityException(externalId, (Throwable)e);
            }
        }
        this.relationService.saveRelations(ctx.getTenantId(), new ArrayList(ctx.getRelations()));
        for (EntityRelation relation : ctx.getRelations()) {
            this.logEntityActionService.logEntityRelationAction(ctx.getTenantId(), null, relation, ctx.getUser(), ActionType.RELATION_ADD_OR_UPDATE, null, new Object[]{relation});
        }
    }

    public Comparator<EntityType> getEntityTypeComparatorForImport() {
        return Comparator.comparing(SUPPORTED_ENTITY_TYPES::indexOf);
    }

    private <I extends EntityId, E extends ExportableEntity<I>, D extends EntityExportData<E>> EntityExportService<I, E, D> getExportService(EntityType entityType) {
        EntityExportService exportService = (EntityExportService)this.exportServices.get(entityType);
        if (exportService == null) {
            throw new IllegalArgumentException("Export for entity type " + String.valueOf(entityType) + " is not supported");
        }
        return exportService;
    }

    private <I extends EntityId, E extends ExportableEntity<I>, D extends EntityExportData<E>> EntityImportService<I, E, D> getImportService(EntityType entityType) {
        EntityImportService importService = (EntityImportService)this.importServices.get(entityType);
        if (importService == null) {
            throw new IllegalArgumentException("Import for entity type " + String.valueOf(entityType) + " is not supported");
        }
        return importService;
    }

    @Autowired
    private void setExportServices(DefaultEntityExportService<?, ?, ?> defaultExportService, Collection<BaseEntityExportService<?, ?, ?>> exportServices) {
        exportServices.stream().sorted(Comparator.comparing(exportService -> exportService.getSupportedEntityTypes().size(), Comparator.reverseOrder())).forEach(exportService -> exportService.getSupportedEntityTypes().forEach(entityType -> this.exportServices.put(entityType, exportService)));
        SUPPORTED_ENTITY_TYPES.forEach(entityType -> this.exportServices.putIfAbsent(entityType, defaultExportService));
    }

    @Autowired
    private void setImportServices(Collection<EntityImportService<?, ?, ?>> importServices) {
        importServices.forEach(entityImportService -> this.importServices.put(entityImportService.getEntityType(), entityImportService));
    }

    @ConstructorProperties(value={"relationService", "rateLimitService", "logEntityActionService"})
    @Generated
    public DefaultEntitiesExportImportService(RelationService relationService, RateLimitService rateLimitService, TbLogEntityActionService logEntityActionService) {
        this.relationService = relationService;
        this.rateLimitService = rateLimitService;
        this.logEntityActionService = logEntityActionService;
    }
}

