/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync;

import jakarta.annotation.PreDestroy;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.GitSyncService;
import org.thingsboard.server.service.sync.vc.GitRepository;

@TbCoreComponent
@Service
public class DefaultGitSyncService
implements GitSyncService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultGitSyncService.class);
    @Value(value="${vc.git.repositories-folder:${java.io.tmpdir}/repositories}")
    private String repositoriesFolder;
    private final ScheduledExecutorService executor = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"git-sync");
    private final Map<String, GitRepository> repositories = new ConcurrentHashMap();
    private final Map<String, Runnable> updateListeners = new ConcurrentHashMap();

    public void registerSync(String key, String repoUri, String branch, long fetchFrequencyMs, Runnable onUpdate) {
        RepositorySettings settings = new RepositorySettings();
        settings.setRepositoryUri(repoUri);
        settings.setDefaultBranch(branch);
        if (onUpdate != null) {
            this.updateListeners.put(key, onUpdate);
        }
        this.executor.execute(() -> this.initRepository(key, settings));
        this.executor.scheduleWithFixedDelay(() -> {
            GitRepository repository = (GitRepository)this.repositories.get(key);
            if (repository == null || !GitRepository.exists((String)repository.getDirectory())) {
                this.initRepository(key, settings);
                return;
            }
            try {
                log.debug("[{}] Fetching repository", (Object)key);
                boolean updated = repository.fetch();
                if (updated) {
                    this.onUpdate(key);
                } else {
                    log.debug("[{}] No changes in the repository", (Object)key);
                }
            }
            catch (Throwable e) {
                log.error("[{}] Failed to fetch repository", (Object)key, (Object)e);
            }
        }, fetchFrequencyMs, fetchFrequencyMs, TimeUnit.MILLISECONDS);
    }

    public List<GitRepository.RepoFile> listFiles(String key, String path, int depth, GitRepository.FileType type) {
        GitRepository repository = this.getRepository(key);
        return repository.listFilesAtCommit(this.getBranchRef(repository), path, depth).stream().filter(file -> type == null || file.type() == type).toList();
    }

    public byte[] getFileContent(String key, String path) {
        GitRepository repository = this.getRepository(key);
        return repository.getFileContentAtCommit(path, this.getBranchRef(repository));
    }

    public String getGithubRawContentUrl(String key, String path) {
        if (path == null) {
            return "";
        }
        RepositorySettings settings = this.getRepository(key).getSettings();
        return StringUtils.removeEnd((String)settings.getRepositoryUri(), (String)".git") + "/blob/" + settings.getDefaultBranch() + "/" + path + "?raw=true";
    }

    private GitRepository getRepository(String key) {
        GitRepository repository = (GitRepository)this.repositories.get(key);
        if (repository != null && !GitRepository.exists((String)repository.getDirectory())) {
            this.initRepository(key, repository.getSettings());
        }
        if ((repository = (GitRepository)this.repositories.get(key)) == null) {
            throw new IllegalStateException(key + " repository is not initialized");
        }
        return repository;
    }

    private void initRepository(String key, RepositorySettings settings) {
        try {
            this.repositories.remove(key);
            Path directory = this.getRepoDirectory(settings);
            GitRepository repository = GitRepository.openOrClone((Path)directory, (RepositorySettings)settings, (boolean)true);
            this.repositories.put(key, repository);
            log.info("[{}] Initialized repository", (Object)key);
            this.onUpdate(key);
        }
        catch (Throwable e) {
            log.error("[{}] Failed to initialize repository with settings {}", new Object[]{key, settings, e});
        }
    }

    private void onUpdate(String key) {
        Runnable listener = (Runnable)this.updateListeners.get(key);
        if (listener != null) {
            log.debug("[{}] Handling repository update", (Object)key);
            try {
                listener.run();
            }
            catch (Throwable e) {
                log.error("[{}] Failed to handle repository update", (Object)key, (Object)e);
            }
        }
    }

    private Path getRepoDirectory(RepositorySettings settings) {
        String name = URI.create(settings.getRepositoryUri()).getPath().replaceAll("[^a-zA-Z]", "");
        return Path.of(this.repositoriesFolder, name);
    }

    private String getBranchRef(GitRepository repository) {
        return "refs/remotes/origin/" + repository.getSettings().getDefaultBranch();
    }

    @PreDestroy
    private void preDestroy() {
        this.executor.shutdownNow();
    }
}

