/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.util.KvProtoUtil;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.subscription.SubscriptionErrorCode;
import org.thingsboard.server.service.subscription.TbEntitySubEvent;
import org.thingsboard.server.service.subscription.TbEntityUpdatesInfo;
import org.thingsboard.server.service.subscription.TbSubscriptionsInfo;
import org.thingsboard.server.service.ws.notification.sub.NotificationRequestUpdate;
import org.thingsboard.server.service.ws.notification.sub.NotificationUpdate;
import org.thingsboard.server.service.ws.notification.sub.NotificationsSubscriptionUpdate;
import org.thingsboard.server.service.ws.telemetry.sub.AlarmSubscriptionUpdate;

/*
 * Exception performing whole class analysis ignored.
 */
public class TbSubscriptionUtils {
    public static TransportProtos.ToCoreMsg toSubEventProto(String serviceId, TbEntitySubEvent event) {
        TransportProtos.SubscriptionMgrMsgProto.Builder msgBuilder = TransportProtos.SubscriptionMgrMsgProto.newBuilder();
        TransportProtos.TbEntitySubEventProto.Builder builder = TransportProtos.TbEntitySubEventProto.newBuilder().setServiceId(serviceId).setSeqNumber(event.getSeqNumber()).setTenantIdMSB(event.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(event.getTenantId().getId().getLeastSignificantBits()).setEntityType(event.getEntityId().getEntityType().name()).setEntityIdMSB(event.getEntityId().getId().getMostSignificantBits()).setEntityIdLSB(event.getEntityId().getId().getLeastSignificantBits()).setType(event.getType().name());
        TbSubscriptionsInfo info = event.getInfo();
        if (info != null) {
            builder.setNotifications(info.notifications).setAlarms(info.alarms).setTsAllKeys(info.tsAllKeys).setAttrAllKeys(info.attrAllKeys);
            if (info.tsKeys != null) {
                builder.addAllTsKeys((Iterable)info.tsKeys);
            }
            if (info.attrKeys != null) {
                builder.addAllAttrKeys((Iterable)info.attrKeys);
            }
        }
        msgBuilder.setSubEvent(builder);
        return TransportProtos.ToCoreMsg.newBuilder().setToSubscriptionMgrMsg(msgBuilder).build();
    }

    public static TransportProtos.ToCoreNotificationMsg toProto(TenantId tenantId, UUID id, int seqNumber, TbEntityUpdatesInfo update) {
        TransportProtos.TbEntitySubEventCallbackProto.Builder updateProto = TransportProtos.TbEntitySubEventCallbackProto.newBuilder().setEntityIdMSB(id.getMostSignificantBits()).setEntityIdLSB(id.getLeastSignificantBits()).setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setSeqNumber(seqNumber).setAttributesUpdateTs(update.attributesUpdateTs).setTimeSeriesUpdateTs(update.timeSeriesUpdateTs);
        return TransportProtos.ToCoreNotificationMsg.newBuilder().setToLocalSubscriptionServiceMsg(TransportProtos.LocalSubscriptionServiceMsgProto.newBuilder().setSubEventCallback(updateProto).build()).build();
    }

    public static TbEntitySubEvent fromProto(TransportProtos.TbEntitySubEventProto proto) {
        ComponentLifecycleEvent event = ComponentLifecycleEvent.valueOf((String)proto.getType());
        TbEntitySubEvent.TbEntitySubEventBuilder builder = TbEntitySubEvent.builder().tenantId(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB()))).seqNumber(proto.getSeqNumber()).entityId(EntityIdFactory.getByTypeAndUuid((String)proto.getEntityType(), (UUID)new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB()))).type(event);
        if (!ComponentLifecycleEvent.DELETED.equals((Object)event)) {
            builder.info(new TbSubscriptionsInfo(proto.getNotifications(), proto.getAlarms(), proto.getTsAllKeys(), proto.getTsKeysCount() > 0 ? new HashSet(proto.getTsKeysList()) : null, proto.getAttrAllKeys(), (Set)(proto.getAttrKeysCount() > 0 ? new HashSet(proto.getAttrKeysList()) : null), proto.getSeqNumber()));
        }
        return builder.build();
    }

    public static AlarmSubscriptionUpdate fromProto(TransportProtos.TbAlarmSubUpdateProto proto) {
        if (proto.getErrorCode() > 0) {
            return new AlarmSubscriptionUpdate(SubscriptionErrorCode.forCode((int)proto.getErrorCode()), proto.getErrorMsg());
        }
        AlarmInfo alarm = (AlarmInfo)JacksonUtil.fromString((String)proto.getAlarm(), AlarmInfo.class);
        return new AlarmSubscriptionUpdate(alarm, proto.getDeleted());
    }

    public static NotificationsSubscriptionUpdate fromProto(TransportProtos.NotificationsSubUpdateProto proto) {
        NotificationsSubscriptionUpdate update;
        if (StringUtils.isNotEmpty((CharSequence)proto.getNotificationUpdate())) {
            NotificationUpdate notificationUpdate = (NotificationUpdate)JacksonUtil.fromString((String)proto.getNotificationUpdate(), NotificationUpdate.class);
            update = new NotificationsSubscriptionUpdate(notificationUpdate);
        } else {
            NotificationRequestUpdate notificationRequestUpdate = (NotificationRequestUpdate)JacksonUtil.fromString((String)proto.getNotificationRequestUpdate(), NotificationRequestUpdate.class);
            update = new NotificationsSubscriptionUpdate(notificationRequestUpdate);
        }
        return update;
    }

    public static TransportProtos.ToCoreNotificationMsg toAlarmSubUpdateToProto(EntityId entityId, AlarmInfo alarmInfo, boolean deleted) {
        TransportProtos.TbAlarmSubUpdateProto.Builder updateProto = TransportProtos.TbAlarmSubUpdateProto.newBuilder().setEntityIdMSB(entityId.getId().getMostSignificantBits()).setEntityIdLSB(entityId.getId().getLeastSignificantBits()).setAlarm(JacksonUtil.toString((Object)alarmInfo)).setDeleted(deleted);
        return TransportProtos.ToCoreNotificationMsg.newBuilder().setToLocalSubscriptionServiceMsg(TransportProtos.LocalSubscriptionServiceMsgProto.newBuilder().setAlarmUpdate(updateProto).build()).build();
    }

    public static TransportProtos.ToCoreNotificationMsg notificationsSubUpdateToProto(EntityId entityId, NotificationsSubscriptionUpdate update) {
        TransportProtos.NotificationsSubUpdateProto.Builder updateProto = TransportProtos.NotificationsSubUpdateProto.newBuilder().setEntityIdMSB(entityId.getId().getMostSignificantBits()).setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        if (update.getNotificationUpdate() != null) {
            updateProto.setNotificationUpdate(JacksonUtil.toString((Object)update.getNotificationUpdate()));
        }
        if (update.getNotificationRequestUpdate() != null) {
            updateProto.setNotificationRequestUpdate(JacksonUtil.toString((Object)update.getNotificationRequestUpdate()));
        }
        return TransportProtos.ToCoreNotificationMsg.newBuilder().setToLocalSubscriptionServiceMsg(TransportProtos.LocalSubscriptionServiceMsgProto.newBuilder().setNotificationsUpdate(updateProto).build()).build();
    }

    public static TransportProtos.ToCoreMsg toTimeseriesUpdateProto(TenantId tenantId, EntityId entityId, List<TsKvEntry> ts) {
        TransportProtos.TbTimeSeriesUpdateProto.Builder builder = TransportProtos.TbTimeSeriesUpdateProto.newBuilder();
        builder.setEntityType(entityId.getEntityType().name());
        builder.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        builder.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        ts.forEach(v -> builder.addData(KvProtoUtil.toTsKvProtoBuilder((long)v.getTs(), (KvEntry)v).build()));
        TransportProtos.SubscriptionMgrMsgProto.Builder msgBuilder = TransportProtos.SubscriptionMgrMsgProto.newBuilder();
        msgBuilder.setTsUpdate(builder);
        return TransportProtos.ToCoreMsg.newBuilder().setToSubscriptionMgrMsg(msgBuilder.build()).build();
    }

    public static TransportProtos.ToCoreMsg toTimeseriesDeleteProto(TenantId tenantId, EntityId entityId, List<String> keys) {
        TransportProtos.TbTimeSeriesDeleteProto.Builder builder = TransportProtos.TbTimeSeriesDeleteProto.newBuilder();
        builder.setEntityType(entityId.getEntityType().name());
        builder.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        builder.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        builder.addAllKeys(keys);
        TransportProtos.SubscriptionMgrMsgProto.Builder msgBuilder = TransportProtos.SubscriptionMgrMsgProto.newBuilder();
        msgBuilder.setTsDelete(builder);
        return TransportProtos.ToCoreMsg.newBuilder().setToSubscriptionMgrMsg(msgBuilder.build()).build();
    }

    public static TransportProtos.ToCoreMsg toAttributesUpdateProto(TenantId tenantId, EntityId entityId, String scope, List<AttributeKvEntry> attributes) {
        TransportProtos.TbAttributeUpdateProto.Builder builder = TransportProtos.TbAttributeUpdateProto.newBuilder();
        builder.setEntityType(entityId.getEntityType().name());
        builder.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        builder.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        builder.setScope(scope);
        attributes.forEach(v -> builder.addData(KvProtoUtil.toTsKvProtoBuilder((long)v.getLastUpdateTs(), (KvEntry)v).build()));
        TransportProtos.SubscriptionMgrMsgProto.Builder msgBuilder = TransportProtos.SubscriptionMgrMsgProto.newBuilder();
        msgBuilder.setAttrUpdate(builder);
        return TransportProtos.ToCoreMsg.newBuilder().setToSubscriptionMgrMsg(msgBuilder.build()).build();
    }

    public static TransportProtos.ToCoreMsg toAttributesDeleteProto(TenantId tenantId, EntityId entityId, String scope, List<String> keys) {
        TransportProtos.TbAttributeDeleteProto.Builder builder = TransportProtos.TbAttributeDeleteProto.newBuilder();
        builder.setEntityType(entityId.getEntityType().name());
        builder.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        builder.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        builder.setScope(scope);
        builder.addAllKeys(keys);
        TransportProtos.SubscriptionMgrMsgProto.Builder msgBuilder = TransportProtos.SubscriptionMgrMsgProto.newBuilder();
        msgBuilder.setAttrDelete(builder);
        return TransportProtos.ToCoreMsg.newBuilder().setToSubscriptionMgrMsg(msgBuilder.build()).build();
    }

    public static EntityId toEntityId(String entityType, long entityIdMSB, long entityIdLSB) {
        return EntityIdFactory.getByTypeAndUuid((String)entityType, (UUID)new UUID(entityIdMSB, entityIdLSB));
    }

    public static TransportProtos.ToCoreMsg toAlarmUpdateProto(TenantId tenantId, EntityId entityId, AlarmInfo alarm) {
        TransportProtos.TbAlarmUpdateProto.Builder builder = TransportProtos.TbAlarmUpdateProto.newBuilder();
        builder.setEntityType(entityId.getEntityType().name());
        builder.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        builder.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        builder.setAlarm(JacksonUtil.toString((Object)alarm));
        TransportProtos.SubscriptionMgrMsgProto.Builder msgBuilder = TransportProtos.SubscriptionMgrMsgProto.newBuilder();
        msgBuilder.setAlarmUpdate(builder);
        return TransportProtos.ToCoreMsg.newBuilder().setToSubscriptionMgrMsg(msgBuilder.build()).build();
    }

    public static TransportProtos.ToCoreMsg toAlarmDeletedProto(TenantId tenantId, EntityId entityId, AlarmInfo alarm) {
        TransportProtos.TbAlarmDeleteProto.Builder builder = TransportProtos.TbAlarmDeleteProto.newBuilder();
        builder.setEntityType(entityId.getEntityType().name());
        builder.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        builder.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        builder.setAlarm(JacksonUtil.toString((Object)alarm));
        TransportProtos.SubscriptionMgrMsgProto.Builder msgBuilder = TransportProtos.SubscriptionMgrMsgProto.newBuilder();
        msgBuilder.setAlarmDelete(builder);
        return TransportProtos.ToCoreMsg.newBuilder().setToSubscriptionMgrMsg(msgBuilder.build()).build();
    }

    public static TransportProtos.ToCoreMsg notificationUpdateToProto(TenantId tenantId, UserId recipientId, NotificationUpdate notificationUpdate) {
        TransportProtos.NotificationUpdateProto updateProto = TransportProtos.NotificationUpdateProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setRecipientIdMSB(recipientId.getId().getMostSignificantBits()).setRecipientIdLSB(recipientId.getId().getLeastSignificantBits()).setUpdate(JacksonUtil.toString((Object)notificationUpdate)).build();
        return TransportProtos.ToCoreMsg.newBuilder().setToSubscriptionMgrMsg(TransportProtos.SubscriptionMgrMsgProto.newBuilder().setNotificationUpdate(updateProto).build()).build();
    }

    public static TransportProtos.ToCoreNotificationMsg notificationRequestUpdateToProto(TenantId tenantId, NotificationRequestUpdate notificationRequestUpdate) {
        TransportProtos.NotificationRequestUpdateProto updateProto = TransportProtos.NotificationRequestUpdateProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setUpdate(JacksonUtil.toString((Object)notificationRequestUpdate)).build();
        return TransportProtos.ToCoreNotificationMsg.newBuilder().setToSubscriptionMgrMsg(TransportProtos.SubscriptionMgrMsgProto.newBuilder().setNotificationRequestUpdate(updateProto).build()).build();
    }

    public static List<TsKvEntry> fromProto(TransportProtos.TbSubUpdateProto proto) {
        ArrayList<TsKvEntry> result = new ArrayList<TsKvEntry>();
        for (TransportProtos.TsValueListProto p : proto.getDataList()) {
            result.addAll(KvProtoUtil.fromTsValueProtoList((String)p.getKey(), (List)p.getTsValueList()));
        }
        return result;
    }

    static TransportProtos.ToCoreNotificationMsg toProto(EntityId entityId, List<TsKvEntry> updates) {
        return TbSubscriptionUtils.toProto((boolean)true, null, (EntityId)entityId, updates);
    }

    static TransportProtos.ToCoreNotificationMsg toProto(String scope, EntityId entityId, List<TsKvEntry> updates) {
        return TbSubscriptionUtils.toProto((boolean)false, (String)scope, (EntityId)entityId, updates);
    }

    static TransportProtos.ToCoreNotificationMsg toProto(boolean timeSeries, String scope, EntityId entityId, List<TsKvEntry> updates) {
        TransportProtos.TbSubUpdateProto.Builder builder = TransportProtos.TbSubUpdateProto.newBuilder();
        builder.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        builder.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        TreeMap<String, List> data = new TreeMap<String, List>();
        for (TsKvEntry tsEntry : updates) {
            data.computeIfAbsent(tsEntry.getKey(), k -> new ArrayList()).add(KvProtoUtil.toTsValueProto((long)tsEntry.getTs(), (KvEntry)tsEntry));
        }
        data.forEach((key, value) -> {
            TransportProtos.TsValueListProto.Builder dataBuilder = TransportProtos.TsValueListProto.newBuilder();
            dataBuilder.setKey(key);
            dataBuilder.addAllTsValue((Iterable)value);
            builder.addData(dataBuilder.build());
        });
        TransportProtos.LocalSubscriptionServiceMsgProto.Builder result = TransportProtos.LocalSubscriptionServiceMsgProto.newBuilder();
        if (timeSeries) {
            result.setTsUpdate(builder);
        } else {
            builder.setScope(scope);
            result.setAttrUpdate(builder);
        }
        return TransportProtos.ToCoreNotificationMsg.newBuilder().setToLocalSubscriptionServiceMsg(result).build();
    }
}

