/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.query.EntityCountQuery;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.service.subscription.SubscriptionServiceStatistics;
import org.thingsboard.server.service.subscription.TbAbstractEntityQuerySubCtx;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.CmdUpdate;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.EntityCountUpdate;

public class TbEntityCountSubCtx
extends TbAbstractEntityQuerySubCtx<EntityCountQuery> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbEntityCountSubCtx.class);
    private volatile int result;

    public TbEntityCountSubCtx(String serviceId, WebSocketService wsService, EntityService entityService, TbLocalSubscriptionService localSubscriptionService, AttributesService attributesService, SubscriptionServiceStatistics stats, WebSocketSessionRef sessionRef, int cmdId) {
        super(serviceId, wsService, entityService, localSubscriptionService, attributesService, stats, sessionRef, cmdId);
    }

    public void fetchData() {
        this.result = (int)this.entityService.countEntitiesByQuery(this.getTenantId(), this.getCustomerId(), this.query);
        this.sendWsMsg((CmdUpdate)new EntityCountUpdate(this.cmdId, this.result));
    }

    protected void update() {
        int newCount = (int)this.entityService.countEntitiesByQuery(this.getTenantId(), this.getCustomerId(), this.query);
        if (newCount != this.result) {
            this.result = newCount;
            this.sendWsMsg((CmdUpdate)new EntityCountUpdate(this.cmdId, this.result));
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

