/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataPageLink;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.common.data.query.EntityData;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.query.EntityDataSortOrder;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.service.subscription.SubscriptionServiceStatistics;
import org.thingsboard.server.service.subscription.TbAbstractDataSubCtx;
import org.thingsboard.server.service.subscription.TbAlarmDataSubCtx;
import org.thingsboard.server.service.subscription.TbAlarmsSubscription;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.AlarmDataUpdate;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.CmdUpdate;
import org.thingsboard.server.service.ws.telemetry.sub.AlarmSubscriptionUpdate;
import org.thingsboard.server.service.ws.telemetry.sub.TelemetrySubscriptionUpdate;

public class TbAlarmDataSubCtx
extends TbAbstractDataSubCtx<AlarmDataQuery> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbAlarmDataSubCtx.class);
    private final AlarmService alarmService;
    private final LinkedHashMap<EntityId, EntityData> entitiesMap;
    private final HashMap<AlarmId, AlarmData> alarmsMap;
    private final int maxEntitiesPerAlarmSubscription;
    private final int maxAlarmQueriesPerRefreshInterval;
    private PageData<AlarmData> alarms;
    private boolean tooManyEntities;
    private int alarmInvocationAttempts;

    public TbAlarmDataSubCtx(String serviceId, WebSocketService wsService, EntityService entityService, TbLocalSubscriptionService localSubscriptionService, AttributesService attributesService, SubscriptionServiceStatistics stats, AlarmService alarmService, WebSocketSessionRef sessionRef, int cmdId, int maxEntitiesPerAlarmSubscription, int maxAlarmQueriesPerRefreshInterval) {
        super(serviceId, wsService, entityService, localSubscriptionService, attributesService, stats, sessionRef, cmdId);
        this.maxEntitiesPerAlarmSubscription = maxEntitiesPerAlarmSubscription;
        this.maxAlarmQueriesPerRefreshInterval = maxAlarmQueriesPerRefreshInterval;
        this.alarmService = alarmService;
        this.entitiesMap = new LinkedHashMap();
        this.alarmsMap = new HashMap();
    }

    public void clearSubscriptions() {
        super.clearSubscriptions();
    }

    public void fetchAlarms() {
        ++this.alarmInvocationAttempts;
        log.trace("[{}] Fetching alarms: {}", (Object)this.cmdId, (Object)this.alarmInvocationAttempts);
        if (this.alarmInvocationAttempts <= this.maxAlarmQueriesPerRefreshInterval) {
            this.doFetchAlarms();
        } else {
            log.trace("[{}] Ignore alarm fetch due to rate limit: [{}] of maximum [{}]", new Object[]{this.cmdId, this.alarmInvocationAttempts, this.maxAlarmQueriesPerRefreshInterval});
        }
    }

    private void doFetchAlarms() {
        AlarmDataUpdate update;
        if (!this.entitiesMap.isEmpty()) {
            long start = System.currentTimeMillis();
            PageData alarms = this.alarmService.findAlarmDataByQueryForEntities(this.getTenantId(), (AlarmDataQuery)this.query, this.getOrderedEntityIds());
            long end = System.currentTimeMillis();
            this.stats.getAlarmQueryInvocationCnt().incrementAndGet();
            this.stats.getAlarmQueryTimeSpent().addAndGet(end - start);
            alarms = this.setAndMergeAlarmsData(alarms);
            update = new AlarmDataUpdate(this.cmdId, alarms, null, (long)this.maxEntitiesPerAlarmSubscription, this.data.getTotalElements());
        } else {
            update = new AlarmDataUpdate(this.cmdId, new PageData(), null, (long)this.maxEntitiesPerAlarmSubscription, this.data.getTotalElements());
        }
        this.sendWsMsg((CmdUpdate)update);
    }

    public void fetchData() {
        this.resetInvocationCounter();
        log.trace("[{}] Fetching data: {}", (Object)this.cmdId, (Object)this.alarmInvocationAttempts);
        super.fetchData();
        this.entitiesMap.clear();
        this.tooManyEntities = this.data.hasNext();
        for (EntityData entityData : this.data.getData()) {
            this.entitiesMap.put(entityData.getEntityId(), entityData);
        }
    }

    public Collection<EntityId> getOrderedEntityIds() {
        return this.entitiesMap.keySet();
    }

    public PageData<AlarmData> setAndMergeAlarmsData(PageData<AlarmData> alarms) {
        this.alarms = alarms;
        for (AlarmData alarmData : alarms.getData()) {
            EntityData entityData;
            EntityId entityId = alarmData.getEntityId();
            if (entityId == null || (entityData = (EntityData)this.entitiesMap.get(entityId)) == null) continue;
            alarmData.getLatest().putAll(entityData.getLatest());
        }
        this.alarmsMap.clear();
        this.alarmsMap.putAll(alarms.getData().stream().collect(Collectors.toMap(Alarm::getId, Function.identity(), (a, b) -> a)));
        return this.alarms;
    }

    public void createLatestValuesSubscriptions(List<EntityKey> keys) {
        super.createLatestValuesSubscriptions(keys);
        this.createAlarmSubscriptions();
    }

    public void createAlarmSubscriptions() {
        AlarmDataPageLink pageLink = (AlarmDataPageLink)((AlarmDataQuery)this.query).getPageLink();
        long startTs = System.currentTimeMillis() - pageLink.getTimeWindow();
        for (EntityData entityData : this.entitiesMap.values()) {
            this.createAlarmSubscriptionForEntity(pageLink, startTs, entityData);
        }
    }

    private void createAlarmSubscriptionForEntity(AlarmDataPageLink pageLink, long startTs, EntityData entityData) {
        int subIdx = this.sessionRef.getSessionSubIdSeq().incrementAndGet();
        this.subToEntityIdMap.put(subIdx, entityData.getEntityId());
        log.trace("[{}][{}][{}] Creating alarms subscription for [{}] with query: {}", new Object[]{this.serviceId, this.cmdId, subIdx, entityData.getEntityId(), pageLink});
        TbAlarmsSubscription subscription = TbAlarmsSubscription.builder().serviceId(this.serviceId).sessionId(this.sessionRef.getSessionId()).subscriptionId(subIdx).tenantId(this.sessionRef.getSecurityCtx().getTenantId()).entityId(entityData.getEntityId()).updateProcessor((sub, update) -> this.sendWsMsg(sub.getSessionId(), update)).ts(startTs).build();
        this.localSubscriptionService.addSubscription((TbSubscription)subscription, this.sessionRef);
    }

    void sendWsMsg(String sessionId, TelemetrySubscriptionUpdate subscriptionUpdate, EntityKeyType keyType, boolean resultToLatestValues) {
        EntityId entityId = (EntityId)this.subToEntityIdMap.get(subscriptionUpdate.getSubscriptionId());
        if (entityId != null) {
            HashMap latestUpdate = new HashMap();
            subscriptionUpdate.getValues().forEach((key, values) -> latestUpdate.put(key, this.getLatest(values)));
            EntityData entityData = (EntityData)this.entitiesMap.get(entityId);
            entityData.getLatest().computeIfAbsent(keyType, tmp -> new HashMap()).putAll(latestUpdate);
            log.trace("[{}][{}][{}][{}] Received subscription update: {}", new Object[]{sessionId, this.cmdId, subscriptionUpdate.getSubscriptionId(), keyType, subscriptionUpdate});
            List update = this.alarmsMap.values().stream().filter((? super T alarm) -> entityId.equals(alarm.getEntityId())).map(alarm -> {
                alarm.getLatest().computeIfAbsent(keyType, tmp -> new HashMap()).putAll(latestUpdate);
                return alarm;
            }).collect(Collectors.toList());
            if (!update.isEmpty()) {
                this.sendWsMsg((CmdUpdate)new AlarmDataUpdate(this.cmdId, null, update, (long)this.maxEntitiesPerAlarmSubscription, this.data.getTotalElements()));
            }
        } else {
            log.trace("[{}][{}][{}][{}] Received stale subscription update: {}", new Object[]{sessionId, this.cmdId, subscriptionUpdate.getSubscriptionId(), keyType, subscriptionUpdate});
        }
    }

    protected Aggregation getCurrentAggregation() {
        return Aggregation.NONE;
    }

    private void sendWsMsg(String sessionId, AlarmSubscriptionUpdate subscriptionUpdate) {
        AlarmInfo alarm = subscriptionUpdate.getAlarm();
        AlarmId alarmId = alarm.getId();
        if (subscriptionUpdate.isAlarmDeleted()) {
            Alarm deleted = (Alarm)this.alarmsMap.remove(alarmId);
            if (deleted != null) {
                this.fetchAlarms();
            }
        } else {
            AlarmData current = (AlarmData)this.alarmsMap.get(alarmId);
            boolean onCurrentPage = current != null;
            boolean matchesFilter = this.filter((Alarm)alarm);
            if (onCurrentPage) {
                if (matchesFilter) {
                    AlarmData updated = new AlarmData(subscriptionUpdate.getAlarm(), current);
                    this.alarmsMap.put(alarmId, updated);
                    this.sendWsMsg((CmdUpdate)new AlarmDataUpdate(this.cmdId, null, Collections.singletonList(updated), (long)this.maxEntitiesPerAlarmSubscription, this.data.getTotalElements()));
                } else {
                    this.fetchAlarms();
                }
            } else if (matchesFilter && ((AlarmDataPageLink)((AlarmDataQuery)this.query).getPageLink()).getPage() == 0) {
                this.fetchAlarms();
            }
        }
    }

    public void cleanupOldAlarms() {
        long expTime = System.currentTimeMillis() - ((AlarmDataPageLink)((AlarmDataQuery)this.query).getPageLink()).getTimeWindow();
        boolean shouldRefresh = false;
        for (AlarmData alarmData : this.alarms.getData()) {
            if (alarmData.getCreatedTime() >= expTime) continue;
            shouldRefresh = true;
            break;
        }
        if (shouldRefresh) {
            this.doFetchAlarms();
        }
    }

    private boolean filter(Alarm alarm) {
        AlarmDataPageLink filter = (AlarmDataPageLink)((AlarmDataQuery)this.query).getPageLink();
        long startTs = System.currentTimeMillis() - filter.getTimeWindow();
        if (alarm.getCreatedTime() < startTs) {
            return false;
        }
        if (filter.getTypeList() != null && !filter.getTypeList().isEmpty() && !filter.getTypeList().contains(alarm.getType())) {
            return false;
        }
        if (filter.getSeverityList() != null && !filter.getSeverityList().isEmpty() && !filter.getSeverityList().contains(alarm.getSeverity())) {
            return false;
        }
        if (filter.getStatusList() != null && !filter.getStatusList().isEmpty()) {
            boolean matches = false;
            for (AlarmSearchStatus status : filter.getStatusList()) {
                switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$AlarmSearchStatus[status.ordinal()]) {
                    case 1: {
                        matches = true;
                        break;
                    }
                    case 2: {
                        matches = alarm.isAcknowledged();
                        break;
                    }
                    case 3: {
                        matches = !alarm.isAcknowledged();
                        break;
                    }
                    case 4: {
                        matches = alarm.isCleared();
                        break;
                    }
                    case 5: {
                        boolean bl = matches = !alarm.isCleared();
                    }
                }
                if (!matches) continue;
                break;
            }
            if (!matches) {
                return false;
            }
        }
        return true;
    }

    public synchronized void checkAndResetInvocationCounter() {
        boolean fetchNeeded = this.alarmInvocationAttempts > this.maxAlarmQueriesPerRefreshInterval;
        this.resetInvocationCounter();
        if (fetchNeeded) {
            this.fetchAlarms();
        } else {
            this.cleanupOldAlarms();
        }
    }

    protected synchronized void doUpdate(Map<EntityId, EntityData> newDataMap) {
        this.resetInvocationCounter();
        this.entitiesMap.clear();
        this.tooManyEntities = this.data.hasNext();
        for (EntityData entityData : this.data.getData()) {
            this.entitiesMap.put(entityData.getEntityId(), entityData);
        }
        this.fetchAlarms();
        ArrayList subIdsToCancel = new ArrayList();
        ArrayList subsToAdd = new ArrayList();
        HashSet currentSubs = new HashSet();
        this.subToEntityIdMap.forEach((subId, entityId) -> {
            if (!newDataMap.containsKey(entityId)) {
                subIdsToCancel.add(subId);
            } else {
                currentSubs.add(entityId);
            }
        });
        log.trace("[{}][{}] Subscriptions that are invalid: {}", new Object[]{this.sessionRef.getSessionId(), this.cmdId, subIdsToCancel});
        subIdsToCancel.forEach(this.subToEntityIdMap::remove);
        List<EntityData> newSubsList = newDataMap.entrySet().stream().filter((? super T entry) -> !currentSubs.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        if (!newSubsList.isEmpty()) {
            List keys = ((AlarmDataQuery)this.query).getLatestValues();
            if (keys != null && !keys.isEmpty()) {
                Map keysByType = this.getEntityKeyByTypeMap(keys);
                newSubsList.forEach(entity -> {
                    log.trace("[{}][{}] Found new subscription for entity: {}", new Object[]{this.sessionRef.getSessionId(), this.cmdId, entity.getEntityId()});
                    subsToAdd.addAll(this.addSubscriptions(entity, keysByType, true, 0L, 0L));
                });
            }
            long startTs = System.currentTimeMillis() - ((AlarmDataPageLink)((AlarmDataQuery)this.query).getPageLink()).getTimeWindow();
            newSubsList.forEach(entity -> this.createAlarmSubscriptionForEntity((AlarmDataPageLink)((AlarmDataQuery)this.query).getPageLink(), startTs, entity));
        }
        subIdsToCancel.forEach(subId -> this.localSubscriptionService.cancelSubscription(this.getTenantId(), this.getSessionId(), subId.intValue()));
        subsToAdd.forEach(subscription -> this.localSubscriptionService.addSubscription(subscription, this.sessionRef));
    }

    private void resetInvocationCounter() {
        this.alarmInvocationAttempts = 0;
    }

    protected EntityDataQuery buildEntityDataQuery() {
        EntityDataSortOrder sortOrder = ((AlarmDataPageLink)((AlarmDataQuery)this.query).getPageLink()).getSortOrder();
        EntityDataSortOrder entitiesSortOrder = sortOrder == null || sortOrder.getKey().getType().equals((Object)EntityKeyType.ALARM_FIELD) ? new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime")) : sortOrder;
        EntityDataPageLink edpl = new EntityDataPageLink(this.maxEntitiesPerAlarmSubscription, 0, null, entitiesSortOrder);
        return new EntityDataQuery(((AlarmDataQuery)this.query).getEntityFilter(), edpl, ((AlarmDataQuery)this.query).getEntityFields(), ((AlarmDataQuery)this.query).getLatestValues(), ((AlarmDataQuery)this.query).getKeyFilters());
    }

    @Generated
    public String toString() {
        return "TbAlarmDataSubCtx(super=" + super.toString() + ", alarmService=" + String.valueOf(this.alarmService) + ", entitiesMap=" + String.valueOf(this.getEntitiesMap()) + ", alarmsMap=" + String.valueOf(this.getAlarmsMap()) + ", maxEntitiesPerAlarmSubscription=" + this.maxEntitiesPerAlarmSubscription + ", maxAlarmQueriesPerRefreshInterval=" + this.maxAlarmQueriesPerRefreshInterval + ", alarms=" + String.valueOf(this.getAlarms()) + ", tooManyEntities=" + this.isTooManyEntities() + ", alarmInvocationAttempts=" + this.alarmInvocationAttempts + ")";
    }

    @Generated
    public LinkedHashMap<EntityId, EntityData> getEntitiesMap() {
        return this.entitiesMap;
    }

    @Generated
    public HashMap<AlarmId, AlarmData> getAlarmsMap() {
        return this.alarmsMap;
    }

    @Generated
    public PageData<AlarmData> getAlarms() {
        return this.alarms;
    }

    @Generated
    public void setAlarms(PageData<AlarmData> alarms) {
        this.alarms = alarms;
    }

    @Generated
    public boolean isTooManyEntities() {
        return this.tooManyEntities;
    }

    @Generated
    public void setTooManyEntities(boolean tooManyEntities) {
        this.tooManyEntities = tooManyEntities;
    }
}

