/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.query.AbstractDataQuery;
import org.thingsboard.server.common.data.query.EntityData;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.TsValue;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.service.subscription.SubscriptionServiceStatistics;
import org.thingsboard.server.service.subscription.TbAbstractDataSubCtx;
import org.thingsboard.server.service.subscription.TbAbstractEntityQuerySubCtx;
import org.thingsboard.server.service.subscription.TbAttributeSubscription;
import org.thingsboard.server.service.subscription.TbAttributeSubscriptionScope;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.subscription.TbTimeSeriesSubscription;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.telemetry.sub.TelemetrySubscriptionUpdate;

public abstract class TbAbstractDataSubCtx<T extends AbstractDataQuery<? extends EntityDataPageLink>>
extends TbAbstractEntityQuerySubCtx<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbAbstractDataSubCtx.class);
    protected final Map<Integer, EntityId> subToEntityIdMap = new ConcurrentHashMap();
    protected PageData<EntityData> data;

    public TbAbstractDataSubCtx(String serviceId, WebSocketService wsService, EntityService entityService, TbLocalSubscriptionService localSubscriptionService, AttributesService attributesService, SubscriptionServiceStatistics stats, WebSocketSessionRef sessionRef, int cmdId) {
        super(serviceId, wsService, entityService, localSubscriptionService, attributesService, stats, sessionRef, cmdId);
    }

    public void fetchData() {
        this.data = this.findEntityData();
    }

    protected PageData<EntityData> findEntityData() {
        PageData result = this.entityService.findEntityDataByQuery(this.getTenantId(), this.getCustomerId(), this.buildEntityDataQuery());
        if (log.isTraceEnabled()) {
            result.getData().forEach(ed -> log.trace("[{}][{}] EntityData: {}", new Object[]{this.getSessionId(), this.getCmdId(), ed}));
        }
        return result;
    }

    public boolean isDynamic() {
        return this.query != null && ((AbstractDataQuery)this.query).getPageLink().isDynamic();
    }

    protected synchronized void update() {
        PageData newData = this.findEntityData();
        Map<Object, Object> oldDataMap = this.data != null && !this.data.getData().isEmpty() ? this.data.getData().stream().collect(Collectors.toMap(EntityData::getEntityId, Function.identity(), (a, b) -> a)) : Collections.emptyMap();
        Map newDataMap = newData.getData().stream().collect(Collectors.toMap(EntityData::getEntityId, Function.identity(), (a, b) -> a));
        if (oldDataMap.size() == newDataMap.size() && oldDataMap.keySet().equals(newDataMap.keySet())) {
            log.trace("[{}][{}] No updates to entity data found", (Object)this.sessionRef.getSessionId(), (Object)this.cmdId);
        } else {
            this.data = newData;
            this.doUpdate(newDataMap);
        }
    }

    protected abstract void doUpdate(Map<EntityId, EntityData> var1);

    protected abstract EntityDataQuery buildEntityDataQuery();

    public List<EntityData> getEntitiesData() {
        return this.data.getData();
    }

    public void clearSubscriptions() {
        this.clearEntitySubscriptions();
        super.clearSubscriptions();
    }

    public void clearEntitySubscriptions() {
        if (this.subToEntityIdMap != null) {
            for (Integer subId : this.subToEntityIdMap.keySet()) {
                this.localSubscriptionService.cancelSubscription(this.getTenantId(), this.getSessionId(), subId.intValue());
            }
            this.subToEntityIdMap.clear();
        }
    }

    public void createLatestValuesSubscriptions(List<EntityKey> keys) {
        this.createSubscriptions(keys, true, 0L, 0L);
    }

    public void createTimeSeriesSubscriptions(Map<EntityData, Map<String, Long>> entityKeyStates, long startTs, long endTs) {
        this.createTimeSeriesSubscriptions(entityKeyStates, startTs, endTs, false);
    }

    public void createTimeSeriesSubscriptions(Map<EntityData, Map<String, Long>> entityKeyStates, long startTs, long endTs, boolean resultToLatestValues) {
        entityKeyStates.forEach((entityData, keyStates) -> {
            int subIdx = this.sessionRef.getSessionSubIdSeq().incrementAndGet();
            this.subToEntityIdMap.put(subIdx, entityData.getEntityId());
            this.localSubscriptionService.addSubscription((TbSubscription)this.createTsSub(entityData, subIdx, false, startTs, endTs, keyStates, resultToLatestValues), this.sessionRef);
        });
    }

    private void createSubscriptions(List<EntityKey> keys, boolean latestValues, long startTs, long endTs) {
        Map keysByType = this.getEntityKeyByTypeMap(keys);
        for (EntityData entityData : this.data.getData()) {
            List entitySubscriptions = this.addSubscriptions(entityData, keysByType, latestValues, startTs, endTs);
            entitySubscriptions.forEach(subscription -> this.localSubscriptionService.addSubscription(subscription, this.sessionRef));
        }
    }

    protected Map<EntityKeyType, List<EntityKey>> getEntityKeyByTypeMap(List<EntityKey> keys) {
        HashMap<EntityKeyType, List<EntityKey>> keysByType = new HashMap<EntityKeyType, List<EntityKey>>();
        keys.forEach(key -> keysByType.computeIfAbsent(key.getType(), k -> new ArrayList()).add(key));
        return keysByType;
    }

    protected List<TbSubscription> addSubscriptions(EntityData entityData, Map<EntityKeyType, List<EntityKey>> keysByType, boolean latestValues, long startTs, long endTs) {
        ArrayList<TbSubscription> subscriptionList = new ArrayList<TbSubscription>();
        keysByType.forEach((keysType, keysList) -> {
            int subIdx = this.sessionRef.getSessionSubIdSeq().incrementAndGet();
            this.subToEntityIdMap.put(subIdx, entityData.getEntityId());
            switch (1.$SwitchMap$org$thingsboard$server$common$data$query$EntityKeyType[keysType.ordinal()]) {
                case 1: {
                    subscriptionList.add(this.createTsSub(entityData, subIdx, keysList, latestValues, startTs, endTs));
                    break;
                }
                case 2: {
                    subscriptionList.add(this.createAttrSub(entityData, subIdx, keysType, TbAttributeSubscriptionScope.CLIENT_SCOPE, keysList));
                    break;
                }
                case 3: {
                    subscriptionList.add(this.createAttrSub(entityData, subIdx, keysType, TbAttributeSubscriptionScope.SHARED_SCOPE, keysList));
                    break;
                }
                case 4: {
                    subscriptionList.add(this.createAttrSub(entityData, subIdx, keysType, TbAttributeSubscriptionScope.SERVER_SCOPE, keysList));
                    break;
                }
                case 5: {
                    subscriptionList.add(this.createAttrSub(entityData, subIdx, keysType, TbAttributeSubscriptionScope.ANY_SCOPE, keysList));
                }
            }
        });
        return subscriptionList;
    }

    private TbSubscription createAttrSub(EntityData entityData, int subIdx, EntityKeyType keysType, TbAttributeSubscriptionScope scope, List<EntityKey> subKeys) {
        Map keyStates = this.buildKeyStats(entityData, keysType, subKeys, true);
        log.trace("[{}][{}][{}] Creating attributes subscription for [{}] with keys: {}", new Object[]{this.serviceId, this.cmdId, subIdx, entityData.getEntityId(), keyStates});
        return TbAttributeSubscription.builder().serviceId(this.serviceId).sessionId(this.sessionRef.getSessionId()).subscriptionId(subIdx).tenantId(this.sessionRef.getSecurityCtx().getTenantId()).entityId(entityData.getEntityId()).updateProcessor((sub, subscriptionUpdate) -> this.sendWsMsg(sub.getSessionId(), subscriptionUpdate, keysType)).queryTs(this.createdTime).allKeys(false).keyStates(keyStates).scope(scope).build();
    }

    private TbSubscription createTsSub(EntityData entityData, int subIdx, List<EntityKey> subKeys, boolean latestValues, long startTs, long endTs) {
        Map keyStates = this.buildKeyStats(entityData, EntityKeyType.TIME_SERIES, subKeys, latestValues);
        if (!latestValues && entityData.getTimeseries() != null) {
            entityData.getTimeseries().forEach((k, v) -> {
                long ts = Arrays.stream(v).map(TsValue::getTs).max(Long::compareTo).orElse(0L);
                log.trace("[{}][{}] Updating key: {} with ts: {}", new Object[]{this.serviceId, this.cmdId, k, ts});
                if (!Aggregation.NONE.equals((Object)this.getCurrentAggregation()) && ts < endTs) {
                    ts = endTs;
                }
                keyStates.put(k, ts);
            });
        }
        return this.createTsSub(entityData, subIdx, latestValues, startTs, endTs, keyStates);
    }

    private TbTimeSeriesSubscription createTsSub(EntityData entityData, int subIdx, boolean latestValues, long startTs, long endTs, Map<String, Long> keyStates) {
        return this.createTsSub(entityData, subIdx, latestValues, startTs, endTs, keyStates, latestValues);
    }

    private TbTimeSeriesSubscription createTsSub(EntityData entityData, int subIdx, boolean latestValues, long startTs, long endTs, Map<String, Long> keyStates, boolean resultToLatestValues) {
        log.trace("[{}][{}][{}] Creating time-series subscription for [{}] with keys: {}", new Object[]{this.serviceId, this.cmdId, subIdx, entityData.getEntityId(), keyStates});
        return TbTimeSeriesSubscription.builder().serviceId(this.serviceId).sessionId(this.sessionRef.getSessionId()).subscriptionId(subIdx).tenantId(this.sessionRef.getSecurityCtx().getTenantId()).entityId(entityData.getEntityId()).updateProcessor((sub, subscriptionUpdate) -> this.sendWsMsg(sub.getSessionId(), subscriptionUpdate, EntityKeyType.TIME_SERIES, resultToLatestValues)).queryTs(this.createdTime).allKeys(false).keyStates(keyStates).latestValues(latestValues).startTime(startTs).endTime(endTs).build();
    }

    private void sendWsMsg(String sessionId, TelemetrySubscriptionUpdate subscriptionUpdate, EntityKeyType keyType) {
        this.sendWsMsg(sessionId, subscriptionUpdate, keyType, true);
    }

    private Map<String, Long> buildKeyStats(EntityData entityData, EntityKeyType keysType, List<EntityKey> subKeys, boolean latestValues) {
        Map currentValues;
        HashMap<String, Long> keyStates = new HashMap<String, Long>();
        subKeys.forEach(key -> keyStates.put(key.getKey(), 0L));
        if (latestValues && entityData.getLatest() != null && (currentValues = (Map)entityData.getLatest().get(keysType)) != null) {
            currentValues.forEach((k, v) -> {
                if (subKeys.contains(new EntityKey(keysType, k))) {
                    log.trace("[{}][{}] Updating key: {} with ts: {}", new Object[]{this.serviceId, this.cmdId, k, v.getTs()});
                    keyStates.put((String)k, v.getTs());
                }
            });
        }
        return keyStates;
    }

    abstract void sendWsMsg(String var1, TelemetrySubscriptionUpdate var2, EntityKeyType var3, boolean var4);

    protected abstract Aggregation getCurrentAggregation();

    @Generated
    public PageData<EntityData> getData() {
        return this.data;
    }
}

