/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.state;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.DeviceStateManager;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.common.SimpleTbQueueCallback;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.service.state.DeviceStateService;

@Service
public class DefaultDeviceStateManager
implements DeviceStateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDeviceStateManager.class);
    private final TbServiceInfoProvider serviceInfoProvider;
    private final PartitionService partitionService;
    private final Optional<DeviceStateService> deviceStateService;
    private final TbClusterService clusterService;

    public void onDeviceConnect(TenantId tenantId, DeviceId deviceId, long connectTime, TbCallback callback) {
        this.forwardToDeviceStateService(tenantId, deviceId, deviceStateService -> {
            log.debug("[{}][{}] Forwarding device connect event to local service. Connect time: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), connectTime});
            deviceStateService.onDeviceConnect(tenantId, deviceId, connectTime);
        }, () -> {
            log.debug("[{}][{}] Sending device connect message to core. Connect time: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), connectTime});
            TransportProtos.DeviceConnectProto deviceConnectMsg = TransportProtos.DeviceConnectProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setLastConnectTime(connectTime).build();
            return TransportProtos.ToCoreMsg.newBuilder().setDeviceConnectMsg(deviceConnectMsg).build();
        }, callback);
    }

    public void onDeviceActivity(TenantId tenantId, DeviceId deviceId, long activityTime, TbCallback callback) {
        this.forwardToDeviceStateService(tenantId, deviceId, deviceStateService -> {
            log.debug("[{}][{}] Forwarding device activity event to local service. Activity time: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), activityTime});
            deviceStateService.onDeviceActivity(tenantId, deviceId, activityTime);
        }, () -> {
            log.debug("[{}][{}] Sending device activity message to core. Activity time: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), activityTime});
            TransportProtos.DeviceActivityProto deviceActivityMsg = TransportProtos.DeviceActivityProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setLastActivityTime(activityTime).build();
            return TransportProtos.ToCoreMsg.newBuilder().setDeviceActivityMsg(deviceActivityMsg).build();
        }, callback);
    }

    public void onDeviceDisconnect(TenantId tenantId, DeviceId deviceId, long disconnectTime, TbCallback callback) {
        this.forwardToDeviceStateService(tenantId, deviceId, deviceStateService -> {
            log.debug("[{}][{}] Forwarding device disconnect event to local service. Disconnect time: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), disconnectTime});
            deviceStateService.onDeviceDisconnect(tenantId, deviceId, disconnectTime);
        }, () -> {
            log.debug("[{}][{}] Sending device disconnect message to core. Disconnect time: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), disconnectTime});
            TransportProtos.DeviceDisconnectProto deviceDisconnectMsg = TransportProtos.DeviceDisconnectProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setLastDisconnectTime(disconnectTime).build();
            return TransportProtos.ToCoreMsg.newBuilder().setDeviceDisconnectMsg(deviceDisconnectMsg).build();
        }, callback);
    }

    public void onDeviceInactivity(TenantId tenantId, DeviceId deviceId, long inactivityTime, TbCallback callback) {
        this.forwardToDeviceStateService(tenantId, deviceId, deviceStateService -> {
            log.debug("[{}][{}] Forwarding device inactivity event to local service. Inactivity time: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), inactivityTime});
            deviceStateService.onDeviceInactivity(tenantId, deviceId, inactivityTime);
        }, () -> {
            log.debug("[{}][{}] Sending device inactivity message to core. Inactivity time: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), inactivityTime});
            TransportProtos.DeviceInactivityProto deviceInactivityMsg = TransportProtos.DeviceInactivityProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setLastInactivityTime(inactivityTime).build();
            return TransportProtos.ToCoreMsg.newBuilder().setDeviceInactivityMsg(deviceInactivityMsg).build();
        }, callback);
    }

    public void onDeviceInactivityTimeoutUpdate(TenantId tenantId, DeviceId deviceId, long inactivityTimeout, TbCallback callback) {
        this.forwardToDeviceStateService(tenantId, deviceId, deviceStateService -> {
            log.debug("[{}][{}] Forwarding device inactivity timeout update to local service. Updated inactivity timeout: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), inactivityTimeout});
            deviceStateService.onDeviceInactivityTimeoutUpdate(tenantId, deviceId, inactivityTimeout);
        }, () -> {
            log.debug("[{}][{}] Sending device inactivity timeout update message to core. Updated inactivity timeout: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), inactivityTimeout});
            TransportProtos.DeviceInactivityTimeoutUpdateProto deviceInactivityTimeoutUpdateMsg = TransportProtos.DeviceInactivityTimeoutUpdateProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setInactivityTimeout(inactivityTimeout).build();
            return TransportProtos.ToCoreMsg.newBuilder().setDeviceInactivityTimeoutUpdateMsg(deviceInactivityTimeoutUpdateMsg).build();
        }, callback);
    }

    private void forwardToDeviceStateService(TenantId tenantId, DeviceId deviceId, Consumer<DeviceStateService> toDeviceStateService, Supplier<TransportProtos.ToCoreMsg> toCore, TbCallback callback) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)deviceId);
        if (this.serviceInfoProvider.isService(ServiceType.TB_CORE) && tpi.isMyPartition() && this.deviceStateService.isPresent()) {
            try {
                toDeviceStateService.accept((DeviceStateService)this.deviceStateService.get());
            }
            catch (Exception e) {
                log.error("[{}][{}] Failed to process device connectivity event.", new Object[]{tenantId.getId(), deviceId.getId(), e});
                callback.onFailure((Throwable)e);
                return;
            }
            callback.onSuccess();
        } else {
            TransportProtos.ToCoreMsg toCoreMsg = toCore.get();
            this.clusterService.pushMsgToCore(tpi, deviceId.getId(), toCoreMsg, (TbQueueCallback)new SimpleTbQueueCallback(__ -> callback.onSuccess(), arg_0 -> ((TbCallback)callback).onFailure(arg_0)));
        }
    }

    @ConstructorProperties(value={"serviceInfoProvider", "partitionService", "deviceStateService", "clusterService"})
    @Generated
    public DefaultDeviceStateManager(TbServiceInfoProvider serviceInfoProvider, PartitionService partitionService, Optional<DeviceStateService> deviceStateService, TbClusterService clusterService) {
        this.serviceInfoProvider = serviceInfoProvider;
        this.partitionService = partitionService;
        this.deviceStateService = deviceStateService;
        this.clusterService = clusterService;
    }
}

