/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sms.smpp;

import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smpp.Connection;
import org.smpp.Session;
import org.smpp.TCPIPConnection;
import org.smpp.TimeoutException;
import org.smpp.WrongSessionStateException;
import org.smpp.pdu.Address;
import org.smpp.pdu.BindReceiver;
import org.smpp.pdu.BindRequest;
import org.smpp.pdu.BindResponse;
import org.smpp.pdu.BindTransciever;
import org.smpp.pdu.BindTransmitter;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.SubmitSMResp;
import org.thingsboard.rule.engine.api.sms.exception.SmsException;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.sms.config.SmppSmsProviderConfiguration;
import org.thingsboard.server.service.sms.AbstractSmsSender;
import org.thingsboard.server.service.sms.smpp.SmppSmsSender;

public class SmppSmsSender
extends AbstractSmsSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmppSmsSender.class);
    protected SmppSmsProviderConfiguration config;
    protected Session smppSession;

    public SmppSmsSender(SmppSmsProviderConfiguration config) {
        if (config.getBindType() == null) {
            config.setBindType(SmppSmsProviderConfiguration.SmppBindType.TX);
        }
        if (StringUtils.isNotEmpty((String)config.getSourceAddress())) {
            if (config.getSourceTon() == null) {
                config.setSourceTon(Byte.valueOf((byte)5));
            }
            if (config.getSourceNpi() == null) {
                config.setSourceNpi(Byte.valueOf((byte)0));
            }
        }
        if (config.getDestinationTon() == null) {
            config.setDestinationTon(Byte.valueOf((byte)5));
        }
        if (config.getDestinationNpi() == null) {
            config.setDestinationNpi(Byte.valueOf((byte)0));
        }
        this.config = config;
        this.smppSession = this.initSmppSession();
    }

    private SmppSmsSender() {
    }

    public int sendSms(String numberTo, String message) throws SmsException {
        try {
            this.checkSmppSession();
            SubmitSM request = new SubmitSM();
            if (StringUtils.isNotEmpty((String)this.config.getServiceType())) {
                request.setServiceType(this.config.getServiceType());
            }
            if (StringUtils.isNotEmpty((String)this.config.getSourceAddress())) {
                request.setSourceAddr(new Address(this.config.getSourceTon().byteValue(), this.config.getSourceNpi().byteValue(), this.config.getSourceAddress()));
            }
            request.setDestAddr(new Address(this.config.getDestinationTon().byteValue(), this.config.getDestinationNpi().byteValue(), this.prepareNumber(numberTo)));
            request.setShortMessage(message);
            request.setDataCoding(Optional.ofNullable(this.config.getCodingScheme()).orElse((byte)0).byteValue());
            request.setReplaceIfPresentFlag((byte)0);
            request.setEsmClass((byte)0);
            request.setProtocolId((byte)0);
            request.setPriorityFlag((byte)0);
            request.setRegisteredDelivery((byte)0);
            request.setSmDefaultMsgId((byte)0);
            SubmitSMResp response = this.smppSession.submit(request);
            log.debug("SMPP submit command status: {}", (Object)response.getCommandStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.countMessageSegments(message);
    }

    private synchronized void checkSmppSession() {
        if (this.smppSession == null || !this.smppSession.isOpened()) {
            this.smppSession = this.initSmppSession();
        }
    }

    protected Session initSmppSession() {
        try {
            TCPIPConnection connection = new TCPIPConnection(this.config.getHost(), this.config.getPort().intValue());
            Session session = new Session((Connection)connection);
            BindTransmitter bindRequest = switch (1.$SwitchMap$org$thingsboard$server$common$data$sms$config$SmppSmsProviderConfiguration$SmppBindType[this.config.getBindType().ordinal()]) {
                case 1 -> new BindTransmitter();
                case 2 -> new BindReceiver();
                case 3 -> new BindTransciever();
                default -> throw new UnsupportedOperationException("Unsupported bind type " + String.valueOf(this.config.getBindType()));
            };
            bindRequest.setSystemId(this.config.getSystemId());
            bindRequest.setPassword(this.config.getPassword());
            bindRequest.setInterfaceVersion(switch (this.config.getProtocolVersion()) {
                case "3.3" -> -51;
                case "3.4" -> 52;
                default -> throw new UnsupportedOperationException("Unsupported SMPP version: " + this.config.getProtocolVersion());
            });
            if (StringUtils.isNotEmpty((String)this.config.getSystemType())) {
                bindRequest.setSystemType(this.config.getSystemType());
            }
            if (StringUtils.isNotEmpty((String)this.config.getAddressRange())) {
                bindRequest.setAddressRange(this.config.getDestinationTon().byteValue(), this.config.getDestinationNpi().byteValue(), this.config.getAddressRange());
            }
            BindResponse bindResponse = session.bind((BindRequest)bindRequest);
            log.debug("SMPP bind response: {}", (Object)bindResponse.debugString());
            if (bindResponse.getCommandStatus() != 0) {
                throw new IllegalStateException("Error status when binding: " + bindResponse.getCommandStatus());
            }
            return session;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to establish SMPP session: " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    private String prepareNumber(String number) {
        if (this.config.getDestinationTon() == 1) {
            return StringUtils.removeStart((String)number, (String)"+");
        }
        return number;
    }

    public void destroy() {
        try {
            this.smppSession.unbind();
            this.smppSession.close();
        }
        catch (IOException | TimeoutException | WrongSessionStateException | PDUException e) {
            throw new RuntimeException(e);
        }
    }
}

