/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.session;

import java.io.Serializable;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.session.DeviceSessionCacheService;

@Service
@TbCoreComponent
public class DefaultDeviceSessionCacheService
implements DeviceSessionCacheService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDeviceSessionCacheService.class);
    @Autowired
    protected TbTransactionalCache<DeviceId, TransportProtos.DeviceSessionsCacheEntry> cache;

    public TransportProtos.DeviceSessionsCacheEntry get(DeviceId deviceId) {
        log.debug("[{}] Fetching session data from cache", (Object)deviceId);
        return (TransportProtos.DeviceSessionsCacheEntry)this.cache.getAndPutInTransaction((Serializable)deviceId, () -> TransportProtos.DeviceSessionsCacheEntry.newBuilder().addAllSessions(Collections.emptyList()).build(), false);
    }

    public TransportProtos.DeviceSessionsCacheEntry put(DeviceId deviceId, TransportProtos.DeviceSessionsCacheEntry sessions) {
        log.debug("[{}] Pushing session data to cache: {}", (Object)deviceId, (Object)sessions);
        this.cache.put((Serializable)deviceId, (Serializable)sessions);
        return sessions;
    }
}

