/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.LengthRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.RuleResult;
import org.passay.WhitespaceRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserCredentialsId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.model.SecuritySettings;
import org.thingsboard.server.common.data.security.model.UserPasswordPolicy;
import org.thingsboard.server.common.data.security.model.mfa.PlatformTwoFaSettings;
import org.thingsboard.server.dao.audit.AuditLogService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.settings.SecuritySettingsService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.security.auth.rest.RestAuthenticationDetails;
import org.thingsboard.server.service.security.exception.UserPasswordExpiredException;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.system.SystemSecurityService;
import org.thingsboard.server.utils.MiscUtils;
import ua_parser.Client;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultSystemSecurityService
implements SystemSecurityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemSecurityService.class);
    private final AdminSettingsService adminSettingsService;
    private final BCryptPasswordEncoder encoder;
    private final UserService userService;
    private final MailService mailService;
    private final AuditLogService auditLogService;
    private final SecuritySettingsService securitySettingsService;

    public void validateUserCredentials(TenantId tenantId, UserCredentials userCredentials, String username, String password) throws AuthenticationException {
        if (!this.encoder.matches((CharSequence)password, userCredentials.getPassword())) {
            int failedLoginAttempts = this.userService.increaseFailedLoginAttempts(tenantId, userCredentials.getUserId());
            SecuritySettings securitySettings = this.securitySettingsService.getSecuritySettings();
            if (securitySettings.getMaxFailedLoginAttempts() != null && securitySettings.getMaxFailedLoginAttempts() > 0 && failedLoginAttempts > securitySettings.getMaxFailedLoginAttempts() && userCredentials.isEnabled()) {
                this.lockAccount(userCredentials.getUserId(), username, securitySettings.getUserLockoutNotificationEmail(), securitySettings.getMaxFailedLoginAttempts());
                throw new LockedException("Authentication Failed. Username was locked due to security policy.");
            }
            throw new BadCredentialsException("Authentication Failed. Username or Password not valid.");
        }
        if (!userCredentials.isEnabled()) {
            throw new DisabledException("User is not active");
        }
        this.userService.resetFailedLoginAttempts(tenantId, userCredentials.getUserId());
        SecuritySettings securitySettings = this.securitySettingsService.getSecuritySettings();
        if (DefaultSystemSecurityService.isPositiveInteger((Integer)securitySettings.getPasswordPolicy().getPasswordExpirationPeriodDays()) && userCredentials.getCreatedTime() + TimeUnit.DAYS.toMillis(securitySettings.getPasswordPolicy().getPasswordExpirationPeriodDays().intValue()) < System.currentTimeMillis()) {
            userCredentials = this.userService.requestExpiredPasswordReset(tenantId, (UserCredentialsId)userCredentials.getId());
            throw new UserPasswordExpiredException("User password expired!", userCredentials.getResetToken());
        }
    }

    public void validateTwoFaVerification(SecurityUser securityUser, boolean verificationSuccess, PlatformTwoFaSettings twoFaSettings) {
        TenantId tenantId = securityUser.getTenantId();
        UserId userId = securityUser.getId();
        if (verificationSuccess) {
            this.userService.resetFailedLoginAttempts(tenantId, userId);
            return;
        }
        int failedVerificationAttempts = this.userService.increaseFailedLoginAttempts(tenantId, userId);
        Integer maxVerificationFailures = twoFaSettings.getMaxVerificationFailuresBeforeUserLockout();
        if (maxVerificationFailures != null && maxVerificationFailures > 0 && failedVerificationAttempts >= maxVerificationFailures) {
            this.userService.setUserCredentialsEnabled(TenantId.SYS_TENANT_ID, userId, false);
            SecuritySettings securitySettings = this.securitySettingsService.getSecuritySettings();
            this.lockAccount(userId, securityUser.getEmail(), securitySettings.getUserLockoutNotificationEmail(), maxVerificationFailures);
            throw new LockedException("User account was locked due to exceeded 2FA verification attempts");
        }
    }

    private void lockAccount(UserId userId, String username, String userLockoutNotificationEmail, Integer maxFailedLoginAttempts) {
        this.userService.setUserCredentialsEnabled(TenantId.SYS_TENANT_ID, userId, false);
        if (StringUtils.isNotBlank((String)userLockoutNotificationEmail)) {
            try {
                this.mailService.sendAccountLockoutEmail(username, userLockoutNotificationEmail, maxFailedLoginAttempts);
            }
            catch (ThingsboardException e) {
                log.warn("Can't send email regarding user account [{}] lockout to provided email [{}]", new Object[]{username, userLockoutNotificationEmail, e});
            }
        }
    }

    public void validatePassword(String password, UserCredentials userCredentials) throws DataValidationException {
        SecuritySettings securitySettings = this.securitySettingsService.getSecuritySettings();
        UserPasswordPolicy passwordPolicy = securitySettings.getPasswordPolicy();
        this.validatePasswordByPolicy(password, passwordPolicy);
        if (userCredentials != null && DefaultSystemSecurityService.isPositiveInteger((Integer)passwordPolicy.getPasswordReuseFrequencyDays())) {
            long passwordReuseFrequencyTs = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(passwordPolicy.getPasswordReuseFrequencyDays().intValue());
            JsonNode additionalInfo = userCredentials.getAdditionalInfo();
            if (additionalInfo instanceof ObjectNode && additionalInfo.has("userPasswordHistory")) {
                JsonNode userPasswordHistoryJson = additionalInfo.get("userPasswordHistory");
                Map userPasswordHistoryMap = (Map)JacksonUtil.convertValue((Object)userPasswordHistoryJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                for (Map.Entry entry : userPasswordHistoryMap.entrySet()) {
                    if (!this.encoder.matches((CharSequence)password, (String)entry.getValue()) || Long.parseLong((String)entry.getKey()) <= passwordReuseFrequencyTs) continue;
                    throw new DataValidationException("Password was already used for the last " + passwordPolicy.getPasswordReuseFrequencyDays() + " days");
                }
            }
        }
    }

    public void validatePasswordByPolicy(String password, UserPasswordPolicy passwordPolicy) {
        PasswordData passwordData;
        PasswordValidator validator;
        RuleResult result;
        ArrayList<Object> passwordRules = new ArrayList<Object>();
        Integer maximumLength = passwordPolicy.getMaximumLength();
        Integer minLengthBound = passwordPolicy.getMinimumLength();
        int maxLengthBound = maximumLength != null && maximumLength > passwordPolicy.getMinimumLength() ? maximumLength : Integer.MAX_VALUE;
        passwordRules.add(new LengthRule(minLengthBound.intValue(), maxLengthBound));
        if (DefaultSystemSecurityService.isPositiveInteger((Integer)passwordPolicy.getMinimumUppercaseLetters())) {
            passwordRules.add(new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, passwordPolicy.getMinimumUppercaseLetters().intValue()));
        }
        if (DefaultSystemSecurityService.isPositiveInteger((Integer)passwordPolicy.getMinimumLowercaseLetters())) {
            passwordRules.add(new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, passwordPolicy.getMinimumLowercaseLetters().intValue()));
        }
        if (DefaultSystemSecurityService.isPositiveInteger((Integer)passwordPolicy.getMinimumDigits())) {
            passwordRules.add(new CharacterRule((CharacterData)EnglishCharacterData.Digit, passwordPolicy.getMinimumDigits().intValue()));
        }
        if (DefaultSystemSecurityService.isPositiveInteger((Integer)passwordPolicy.getMinimumSpecialCharacters())) {
            passwordRules.add(new CharacterRule((CharacterData)EnglishCharacterData.Special, passwordPolicy.getMinimumSpecialCharacters().intValue()));
        }
        if (passwordPolicy.getAllowWhitespaces() != null && !passwordPolicy.getAllowWhitespaces().booleanValue()) {
            passwordRules.add(new WhitespaceRule());
        }
        if (!(result = (validator = new PasswordValidator(passwordRules)).validate(passwordData = new PasswordData(password))).isValid()) {
            String message = String.join((CharSequence)"\n", validator.getMessages(result));
            throw new DataValidationException(message);
        }
    }

    public String getBaseUrl(TenantId tenantId, CustomerId customerId, HttpServletRequest httpServletRequest) {
        String baseUrl = null;
        AdminSettings generalSettings = this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, "general");
        JsonNode prohibitDifferentUrl = generalSettings.getJsonValue().get("prohibitDifferentUrl");
        if (prohibitDifferentUrl != null && prohibitDifferentUrl.asBoolean() || httpServletRequest == null) {
            baseUrl = generalSettings.getJsonValue().get("baseUrl").asText();
        }
        if (StringUtils.isEmpty(baseUrl) && httpServletRequest != null) {
            baseUrl = MiscUtils.constructBaseUrl((HttpServletRequest)httpServletRequest);
        }
        return baseUrl;
    }

    public void logLoginAction(User user, Object authenticationDetails, ActionType actionType, Exception e) {
        this.logLoginAction(user, authenticationDetails, actionType, null, e);
    }

    public void logLoginAction(User user, Object authenticationDetails, ActionType actionType, String provider, Exception e) {
        String clientAddress = "Unknown";
        Object browser = "Unknown";
        Object os = "Unknown";
        String device = "Unknown";
        if (authenticationDetails instanceof RestAuthenticationDetails) {
            RestAuthenticationDetails details = (RestAuthenticationDetails)authenticationDetails;
            clientAddress = details.getClientAddress();
            if (details.getUserAgent() != null) {
                Client userAgent = details.getUserAgent();
                if (userAgent.userAgent != null) {
                    browser = userAgent.userAgent.family;
                    if (userAgent.userAgent.major != null) {
                        browser = (String)browser + " " + userAgent.userAgent.major;
                        if (userAgent.userAgent.minor != null) {
                            browser = (String)browser + "." + userAgent.userAgent.minor;
                            if (userAgent.userAgent.patch != null) {
                                browser = (String)browser + "." + userAgent.userAgent.patch;
                            }
                        }
                    }
                }
                if (userAgent.os != null) {
                    os = userAgent.os.family;
                    if (userAgent.os.major != null) {
                        os = (String)os + " " + userAgent.os.major;
                        if (userAgent.os.minor != null) {
                            os = (String)os + "." + userAgent.os.minor;
                            if (userAgent.os.patch != null) {
                                os = (String)os + "." + userAgent.os.patch;
                                if (userAgent.os.patchMinor != null) {
                                    os = (String)os + "." + userAgent.os.patchMinor;
                                }
                            }
                        }
                    }
                }
                if (userAgent.device != null) {
                    device = userAgent.device.family;
                }
            }
        }
        if (actionType == ActionType.LOGIN && e == null) {
            this.userService.updateLastLoginTs(user.getTenantId(), user.getId());
        }
        this.auditLogService.logEntityAction(user.getTenantId(), user.getCustomerId(), user.getId(), user.getName(), (EntityId)user.getId(), null, actionType, e, new Object[]{clientAddress, browser, os, device, provider});
    }

    private static boolean isPositiveInteger(Integer val) {
        return val != null && val > 0;
    }

    @ConstructorProperties(value={"adminSettingsService", "encoder", "userService", "mailService", "auditLogService", "securitySettingsService"})
    @Generated
    public DefaultSystemSecurityService(AdminSettingsService adminSettingsService, BCryptPasswordEncoder encoder, UserService userService, MailService mailService, AuditLogService auditLogService, SecuritySettingsService securitySettingsService) {
        this.adminSettingsService = adminSettingsService;
        this.encoder = encoder;
        this.userService = userService;
        this.mailService = mailService;
        this.auditLogService = auditLogService;
        this.securitySettingsService = securitySettingsService;
    }
}

