/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.rest;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.service.security.auth.MfaAuthenticationToken;
import org.thingsboard.server.service.security.auth.mfa.config.TwoFaConfigManager;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;

@Component(value="defaultAuthenticationSuccessHandler")
public class RestAwareAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private final JwtTokenFactory tokenFactory;
    private final TwoFaConfigManager twoFaConfigManager;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        SecurityUser securityUser = (SecurityUser)authentication.getPrincipal();
        JwtPair tokenPair = new JwtPair();
        if (authentication instanceof MfaAuthenticationToken) {
            int preVerificationTokenLifetime = this.twoFaConfigManager.getPlatformTwoFaSettings(securityUser.getTenantId(), true).flatMap(settings -> Optional.ofNullable(settings.getTotalAllowedTimeForVerification()).filter(time -> time > 0)).orElse((int)TimeUnit.MINUTES.toSeconds(30L));
            tokenPair.setToken(this.tokenFactory.createPreVerificationToken(securityUser, Integer.valueOf(preVerificationTokenLifetime)).getToken());
            tokenPair.setRefreshToken(null);
            tokenPair.setScope(Authority.PRE_VERIFICATION_TOKEN);
        } else {
            tokenPair = this.tokenFactory.createTokenPair(securityUser);
        }
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)tokenPair);
        this.clearAuthenticationAttributes(request);
    }

    protected final void clearAuthenticationAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("SPRING_SECURITY_LAST_EXCEPTION");
    }

    @ConstructorProperties(value={"tokenFactory", "twoFaConfigManager"})
    @Generated
    public RestAwareAuthenticationSuccessHandler(JwtTokenFactory tokenFactory, TwoFaConfigManager twoFaConfigManager) {
        this.tokenFactory = tokenFactory;
        this.twoFaConfigManager = twoFaConfigManager;
    }
}

