/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.jwt.settings;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.security.model.JwtSettings;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsValidator;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;

@Service
public class DefaultJwtSettingsService
implements JwtSettingsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJwtSettingsService.class);
    private final AdminSettingsService adminSettingsService;
    private final Optional<TbClusterService> tbClusterService;
    private final JwtSettingsValidator jwtSettingsValidator;
    private final Optional<JwtTokenFactory> jwtTokenFactory;
    private volatile JwtSettings jwtSettings = null;

    public JwtSettings saveJwtSettings(JwtSettings jwtSettings) {
        this.jwtSettingsValidator.validate(jwtSettings);
        AdminSettings adminJwtSettings = this.mapJwtToAdminSettings(jwtSettings);
        AdminSettings existedSettings = this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, "jwt");
        if (existedSettings != null) {
            adminJwtSettings.setId((UUIDBased)existedSettings.getId());
        }
        log.info("Saving new JWT admin settings. From this moment, the JWT parameters from YAML and ENV will be ignored");
        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, adminJwtSettings);
        this.tbClusterService.ifPresent(cs -> cs.broadcastEntityStateChangeEvent(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, ComponentLifecycleEvent.UPDATED));
        return this.reloadJwtSettings();
    }

    public JwtSettings reloadJwtSettings() {
        log.trace("Executing reloadJwtSettings");
        JwtSettings settings = this.getJwtSettings(true);
        this.jwtTokenFactory.ifPresent(JwtTokenFactory::reload);
        return settings;
    }

    public JwtSettings getJwtSettings() {
        log.trace("Executing getJwtSettings");
        return this.getJwtSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JwtSettings getJwtSettings(boolean forceReload) {
        if (this.jwtSettings == null || forceReload) {
            DefaultJwtSettingsService defaultJwtSettingsService = this;
            synchronized (defaultJwtSettingsService) {
                if (this.jwtSettings == null || forceReload) {
                    this.jwtSettings = this.getJwtSettingsFromDb();
                }
            }
        }
        return this.jwtSettings;
    }

    private JwtSettings getJwtSettingsFromDb() {
        AdminSettings adminJwtSettings = this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, "jwt");
        return adminJwtSettings != null ? this.mapAdminToJwtSettings(adminJwtSettings) : null;
    }

    private JwtSettings mapAdminToJwtSettings(AdminSettings adminSettings) {
        Objects.requireNonNull(adminSettings, "adminSettings for JWT is null");
        return (JwtSettings)JacksonUtil.treeToValue((JsonNode)adminSettings.getJsonValue(), JwtSettings.class);
    }

    private AdminSettings mapJwtToAdminSettings(JwtSettings jwtSettings) {
        Objects.requireNonNull(jwtSettings, "jwtSettings is null");
        AdminSettings adminJwtSettings = new AdminSettings();
        adminJwtSettings.setTenantId(TenantId.SYS_TENANT_ID);
        adminJwtSettings.setKey("jwt");
        adminJwtSettings.setJsonValue(JacksonUtil.valueToTree((Object)jwtSettings));
        return adminJwtSettings;
    }

    public static boolean isSigningKeyDefault(JwtSettings settings) {
        return "thingsboardDefaultSigningKey".equals(settings.getTokenSigningKey());
    }

    public static boolean validateKeyLength(String key) {
        return Base64.getDecoder().decode(key).length * 8 >= JwtTokenFactory.KEY_LENGTH;
    }

    @ConstructorProperties(value={"adminSettingsService", "tbClusterService", "jwtSettingsValidator", "jwtTokenFactory"})
    @Generated
    public DefaultJwtSettingsService(AdminSettingsService adminSettingsService, Optional<TbClusterService> tbClusterService, JwtSettingsValidator jwtSettingsValidator, Optional<JwtTokenFactory> jwtTokenFactory) {
        this.adminSettingsService = adminSettingsService;
        this.tbClusterService = tbClusterService;
        this.jwtSettingsValidator = jwtSettingsValidator;
        this.jwtTokenFactory = jwtTokenFactory;
    }
}

