/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.jwt;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class SkipPathRequestMatcher
implements RequestMatcher {
    private OrRequestMatcher matchers;
    private RequestMatcher processingMatcher;

    public SkipPathRequestMatcher(List<String> pathsToSkip, String processingPath) {
        Assert.notNull(pathsToSkip, (String)"List of paths to skip is required.");
        List m = pathsToSkip.stream().map(path -> new AntPathRequestMatcher(path)).collect(Collectors.toList());
        this.matchers = new OrRequestMatcher(m);
        this.processingMatcher = new AntPathRequestMatcher(processingPath);
    }

    public boolean matches(HttpServletRequest request) {
        if (this.matchers.matches(request)) {
            return false;
        }
        return this.processingMatcher.matches(request);
    }
}

