/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security;

import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.ApiUsageStateId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.controller.HttpValidationCallback;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.rpc.RpcService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.usagerecord.ApiUsageStateService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.exception.ToErrorResponseEntity;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.ValidationResult;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AccessValidator {
    public static final String ONLY_SYSTEM_ADMINISTRATOR_IS_ALLOWED_TO_PERFORM_THIS_OPERATION = "Only system administrator is allowed to perform this operation!";
    public static final String CUSTOMER_USER_IS_NOT_ALLOWED_TO_PERFORM_THIS_OPERATION = "Customer user is not allowed to perform this operation!";
    public static final String SYSTEM_ADMINISTRATOR_IS_NOT_ALLOWED_TO_PERFORM_THIS_OPERATION = "System administrator is not allowed to perform this operation!";
    public static final String DEVICE_WITH_REQUESTED_ID_NOT_FOUND = "Device with requested id wasn't found!";
    public static final String EDGE_WITH_REQUESTED_ID_NOT_FOUND = "Edge with requested id wasn't found!";
    public static final String ENTITY_VIEW_WITH_REQUESTED_ID_NOT_FOUND = "Entity-view with requested id wasn't found!";
    @Autowired
    protected TenantService tenantService;
    @Autowired
    protected CustomerService customerService;
    @Autowired
    protected UserService userService;
    @Autowired
    protected DeviceService deviceService;
    @Autowired
    protected DeviceProfileService deviceProfileService;
    @Autowired
    protected AssetProfileService assetProfileService;
    @Autowired
    protected AssetService assetService;
    @Autowired
    protected AlarmService alarmService;
    @Autowired
    protected RuleChainService ruleChainService;
    @Autowired
    protected EntityViewService entityViewService;
    @Autowired(required=false)
    protected EdgeService edgeService;
    @Autowired
    protected AccessControlService accessControlService;
    @Autowired
    protected ApiUsageStateService apiUsageStateService;
    @Autowired
    protected ResourceService resourceService;
    @Autowired
    protected OtaPackageService otaPackageService;
    @Autowired
    protected RpcService rpcService;
    private ExecutorService executor;

    @PostConstruct
    public void initExecutor() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"access-validator"));
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public DeferredResult<ResponseEntity> validateEntityAndCallback(SecurityUser currentUser, Operation operation, String entityType, String entityIdStr, ThreeConsumer<DeferredResult<ResponseEntity>, TenantId, EntityId> onSuccess) throws ThingsboardException {
        return this.validateEntityAndCallback(currentUser, operation, entityType, entityIdStr, onSuccess, (result, t) -> AccessValidator.handleError((Throwable)t, (DeferredResult)result, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
    }

    public DeferredResult<ResponseEntity> validateEntityAndCallback(SecurityUser currentUser, Operation operation, String entityType, String entityIdStr, ThreeConsumer<DeferredResult<ResponseEntity>, TenantId, EntityId> onSuccess, BiConsumer<DeferredResult<ResponseEntity>, Throwable> onFailure) throws ThingsboardException {
        return this.validateEntityAndCallback(currentUser, operation, EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr), onSuccess, onFailure);
    }

    public DeferredResult<ResponseEntity> validateEntityAndCallback(SecurityUser currentUser, Operation operation, EntityId entityId, ThreeConsumer<DeferredResult<ResponseEntity>, TenantId, EntityId> onSuccess) throws ThingsboardException {
        return this.validateEntityAndCallback(currentUser, operation, entityId, onSuccess, (result, t) -> AccessValidator.handleError((Throwable)t, (DeferredResult)result, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
    }

    public DeferredResult<ResponseEntity> validateEntityAndCallback(SecurityUser currentUser, Operation operation, EntityId entityId, ThreeConsumer<DeferredResult<ResponseEntity>, TenantId, EntityId> onSuccess, BiConsumer<DeferredResult<ResponseEntity>, Throwable> onFailure) throws ThingsboardException {
        DeferredResult response = new DeferredResult();
        this.validate(currentUser, operation, entityId, (FutureCallback)new HttpValidationCallback(response, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */));
        return response;
    }

    public void validate(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        switch (3.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1: {
                this.validateDevice(currentUser, operation, entityId, callback);
                break;
            }
            case 2: {
                this.validateDeviceProfile(currentUser, operation, entityId, callback);
                break;
            }
            case 3: {
                this.validateAsset(currentUser, operation, entityId, callback);
                break;
            }
            case 4: {
                this.validateAssetProfile(currentUser, operation, entityId, callback);
                break;
            }
            case 5: {
                this.validateRuleChain(currentUser, operation, entityId, callback);
                break;
            }
            case 6: {
                this.validateCustomer(currentUser, operation, entityId, callback);
                break;
            }
            case 7: {
                this.validateTenant(currentUser, operation, entityId, callback);
                break;
            }
            case 8: {
                this.validateTenantProfile(currentUser, operation, entityId, callback);
                break;
            }
            case 9: {
                this.validateUser(currentUser, operation, entityId, callback);
                break;
            }
            case 10: {
                this.validateEntityView(currentUser, operation, entityId, callback);
                break;
            }
            case 11: {
                this.validateEdge(currentUser, operation, entityId, callback);
                break;
            }
            case 12: {
                this.validateApiUsageState(currentUser, operation, entityId, callback);
                break;
            }
            case 13: {
                this.validateResource(currentUser, operation, entityId, callback);
                break;
            }
            case 14: {
                this.validateOtaPackage(currentUser, operation, entityId, callback);
                break;
            }
            case 15: {
                this.validateRpc(currentUser, operation, entityId, callback);
                break;
            }
            default: {
                throw new IllegalStateException("Not Implemented!");
            }
        }
    }

    private void validateDevice(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            Futures.addCallback((ListenableFuture)Futures.immediateFuture((Object)this.deviceService.findDeviceById(currentUser.getTenantId(), new DeviceId(entityId.getId()))), (FutureCallback)this.getCallback(callback, device -> {
                if (device == null) {
                    return ValidationResult.entityNotFound((String)"Device with requested id wasn't found!");
                }
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.DEVICE, operation, entityId, (HasTenantId)device);
                }
                catch (ThingsboardException e) {
                    return ValidationResult.accessDenied((String)e.getMessage());
                }
                return ValidationResult.ok((Object)device);
            }), (Executor)this.executor);
        }
    }

    private void validateRpc(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        ListenableFuture rpcFurure = this.rpcService.findRpcByIdAsync(currentUser.getTenantId(), new RpcId(entityId.getId()));
        Futures.addCallback((ListenableFuture)rpcFurure, (FutureCallback)this.getCallback(callback, rpc -> {
            if (rpc == null) {
                return ValidationResult.entityNotFound((String)"Rpc with requested id wasn't found!");
            }
            try {
                this.accessControlService.checkPermission(currentUser, Resource.RPC, operation, entityId, (HasTenantId)rpc);
            }
            catch (ThingsboardException e) {
                return ValidationResult.accessDenied((String)e.getMessage());
            }
            return ValidationResult.ok((Object)rpc);
        }), (Executor)this.executor);
    }

    private void validateDeviceProfile(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            DeviceProfile deviceProfile = this.deviceProfileService.findDeviceProfileById(currentUser.getTenantId(), new DeviceProfileId(entityId.getId()));
            if (deviceProfile == null) {
                callback.onSuccess((Object)ValidationResult.entityNotFound((String)"Device profile with requested id wasn't found!"));
            } else {
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.DEVICE_PROFILE, operation, entityId, (HasTenantId)deviceProfile);
                }
                catch (ThingsboardException e) {
                    callback.onSuccess((Object)ValidationResult.accessDenied((String)e.getMessage()));
                }
                callback.onSuccess((Object)ValidationResult.ok((Object)deviceProfile));
            }
        }
    }

    private void validateAssetProfile(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            AssetProfile assetProfile = this.assetProfileService.findAssetProfileById(currentUser.getTenantId(), new AssetProfileId(entityId.getId()));
            if (assetProfile == null) {
                callback.onSuccess((Object)ValidationResult.entityNotFound((String)"Asset profile with requested id wasn't found!"));
            } else {
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.ASSET_PROFILE, operation, entityId, (HasTenantId)assetProfile);
                }
                catch (ThingsboardException e) {
                    callback.onSuccess((Object)ValidationResult.accessDenied((String)e.getMessage()));
                }
                callback.onSuccess((Object)ValidationResult.ok((Object)assetProfile));
            }
        }
    }

    private void validateApiUsageState(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            ApiUsageState apiUsageState;
            if (!operation.equals((Object)Operation.READ_TELEMETRY)) {
                callback.onSuccess((Object)ValidationResult.accessDenied((String)"Allowed only READ_TELEMETRY operation!"));
            }
            if ((apiUsageState = this.apiUsageStateService.findApiUsageStateById(currentUser.getTenantId(), new ApiUsageStateId(entityId.getId()))) == null) {
                callback.onSuccess((Object)ValidationResult.entityNotFound((String)"Api Usage State with requested id wasn't found!"));
            } else {
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.API_USAGE_STATE, operation, entityId, (HasTenantId)apiUsageState);
                }
                catch (ThingsboardException e) {
                    callback.onSuccess((Object)ValidationResult.accessDenied((String)e.getMessage()));
                }
                callback.onSuccess((Object)ValidationResult.ok((Object)apiUsageState));
            }
        }
    }

    private void validateOtaPackage(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            OtaPackageInfo otaPackage = this.otaPackageService.findOtaPackageInfoById(currentUser.getTenantId(), new OtaPackageId(entityId.getId()));
            if (otaPackage == null) {
                callback.onSuccess((Object)ValidationResult.entityNotFound((String)"OtaPackage with requested id wasn't found!"));
            } else {
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.OTA_PACKAGE, operation, entityId, (HasTenantId)otaPackage);
                }
                catch (ThingsboardException e) {
                    callback.onSuccess((Object)ValidationResult.accessDenied((String)e.getMessage()));
                }
                callback.onSuccess((Object)ValidationResult.ok((Object)otaPackage));
            }
        }
    }

    private void validateResource(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        ListenableFuture resourceFuture = this.resourceService.findResourceInfoByIdAsync(currentUser.getTenantId(), new TbResourceId(entityId.getId()));
        Futures.addCallback((ListenableFuture)resourceFuture, (FutureCallback)this.getCallback(callback, resource -> {
            if (resource == null) {
                return ValidationResult.entityNotFound((String)"Resource with requested id wasn't found!");
            }
            try {
                this.accessControlService.checkPermission(currentUser, Resource.TB_RESOURCE, operation, entityId, (HasTenantId)resource);
            }
            catch (ThingsboardException e) {
                return ValidationResult.accessDenied((String)e.getMessage());
            }
            return ValidationResult.ok((Object)resource);
        }), (Executor)this.executor);
    }

    private void validateAsset(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            ListenableFuture assetFuture = this.assetService.findAssetByIdAsync(currentUser.getTenantId(), new AssetId(entityId.getId()));
            Futures.addCallback((ListenableFuture)assetFuture, (FutureCallback)this.getCallback(callback, asset -> {
                if (asset == null) {
                    return ValidationResult.entityNotFound((String)"Asset with requested id wasn't found!");
                }
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.ASSET, operation, entityId, (HasTenantId)asset);
                }
                catch (ThingsboardException e) {
                    return ValidationResult.accessDenied((String)e.getMessage());
                }
                return ValidationResult.ok((Object)asset);
            }), (Executor)this.executor);
        }
    }

    private void validateRuleChain(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isCustomerUser()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"Customer user is not allowed to perform this operation!"));
        } else {
            ListenableFuture ruleChainFuture = this.ruleChainService.findRuleChainByIdAsync(currentUser.getTenantId(), new RuleChainId(entityId.getId()));
            Futures.addCallback((ListenableFuture)ruleChainFuture, (FutureCallback)this.getCallback(callback, ruleChain -> {
                if (ruleChain == null) {
                    return ValidationResult.entityNotFound((String)"Rule chain with requested id wasn't found!");
                }
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.RULE_CHAIN, operation, entityId, (HasTenantId)ruleChain);
                }
                catch (ThingsboardException e) {
                    return ValidationResult.accessDenied((String)e.getMessage());
                }
                return ValidationResult.ok((Object)ruleChain);
            }), (Executor)this.executor);
        }
    }

    private void validateRule(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isCustomerUser()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"Customer user is not allowed to perform this operation!"));
        } else {
            ListenableFuture ruleNodeFuture = this.ruleChainService.findRuleNodeByIdAsync(currentUser.getTenantId(), new RuleNodeId(entityId.getId()));
            Futures.addCallback((ListenableFuture)ruleNodeFuture, (FutureCallback)this.getCallback(callback, ruleNodeTmp -> {
                RuleNode ruleNode = ruleNodeTmp;
                if (ruleNode == null) {
                    return ValidationResult.entityNotFound((String)"Rule node with requested id wasn't found!");
                }
                if (ruleNode.getRuleChainId() == null) {
                    return ValidationResult.entityNotFound((String)"Rule chain with requested node id wasn't found!");
                }
                RuleChain ruleChain = this.ruleChainService.findRuleChainById(currentUser.getTenantId(), ruleNode.getRuleChainId());
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.RULE_CHAIN, operation, (EntityId)ruleNode.getRuleChainId(), (HasTenantId)ruleChain);
                }
                catch (ThingsboardException e) {
                    return ValidationResult.accessDenied((String)e.getMessage());
                }
                return ValidationResult.ok((Object)ruleNode);
            }), (Executor)this.executor);
        }
    }

    private void validateCustomer(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            ListenableFuture customerFuture = this.customerService.findCustomerByIdAsync(currentUser.getTenantId(), new CustomerId(entityId.getId()));
            Futures.addCallback((ListenableFuture)customerFuture, (FutureCallback)this.getCallback(callback, customer -> {
                if (customer == null) {
                    return ValidationResult.entityNotFound((String)"Customer with requested id wasn't found!");
                }
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.CUSTOMER, operation, entityId, (HasTenantId)customer);
                }
                catch (ThingsboardException e) {
                    return ValidationResult.accessDenied((String)e.getMessage());
                }
                return ValidationResult.ok((Object)customer);
            }), (Executor)this.executor);
        }
    }

    private void validateTenant(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isCustomerUser()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"Customer user is not allowed to perform this operation!"));
        } else if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.ok(null));
        } else {
            ListenableFuture tenantFuture = this.tenantService.findTenantByIdAsync(currentUser.getTenantId(), TenantId.fromUUID((UUID)entityId.getId()));
            Futures.addCallback((ListenableFuture)tenantFuture, (FutureCallback)this.getCallback(callback, tenant -> {
                if (tenant == null) {
                    return ValidationResult.entityNotFound((String)"Tenant with requested id wasn't found!");
                }
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.TENANT, operation, entityId, (HasTenantId)tenant);
                }
                catch (ThingsboardException e) {
                    return ValidationResult.accessDenied((String)e.getMessage());
                }
                return ValidationResult.ok((Object)tenant);
            }), (Executor)this.executor);
        }
    }

    private void validateTenantProfile(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.ok(null));
        } else {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"Only system administrator is allowed to perform this operation!"));
        }
    }

    private void validateUser(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        ListenableFuture userFuture = this.userService.findUserByIdAsync(currentUser.getTenantId(), new UserId(entityId.getId()));
        Futures.addCallback((ListenableFuture)userFuture, (FutureCallback)this.getCallback(callback, user -> {
            if (user == null) {
                return ValidationResult.entityNotFound((String)"User with requested id wasn't found!");
            }
            try {
                this.accessControlService.checkPermission(currentUser, Resource.USER, operation, entityId, (HasTenantId)user);
            }
            catch (ThingsboardException e) {
                return ValidationResult.accessDenied((String)e.getMessage());
            }
            return ValidationResult.ok((Object)user);
        }), (Executor)this.executor);
    }

    private void validateEntityView(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            ListenableFuture entityViewFuture = this.entityViewService.findEntityViewByIdAsync(currentUser.getTenantId(), new EntityViewId(entityId.getId()));
            Futures.addCallback((ListenableFuture)entityViewFuture, (FutureCallback)this.getCallback(callback, entityView -> {
                if (entityView == null) {
                    return ValidationResult.entityNotFound((String)"Entity-view with requested id wasn't found!");
                }
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.ENTITY_VIEW, operation, entityId, (HasTenantId)entityView);
                }
                catch (ThingsboardException e) {
                    return ValidationResult.accessDenied((String)e.getMessage());
                }
                return ValidationResult.ok((Object)entityView);
            }), (Executor)this.executor);
        }
    }

    private void validateEdge(SecurityUser currentUser, Operation operation, EntityId entityId, FutureCallback<ValidationResult> callback) {
        if (currentUser.isSystemAdmin()) {
            callback.onSuccess((Object)ValidationResult.accessDenied((String)"System administrator is not allowed to perform this operation!"));
        } else {
            ListenableFuture edgeFuture = this.edgeService.findEdgeByIdAsync(currentUser.getTenantId(), new EdgeId(entityId.getId()));
            Futures.addCallback((ListenableFuture)edgeFuture, (FutureCallback)this.getCallback(callback, edge -> {
                if (edge == null) {
                    return ValidationResult.entityNotFound((String)"Edge with requested id wasn't found!");
                }
                try {
                    this.accessControlService.checkPermission(currentUser, Resource.EDGE, operation, entityId, (HasTenantId)edge);
                }
                catch (ThingsboardException e) {
                    return ValidationResult.accessDenied((String)e.getMessage());
                }
                return ValidationResult.ok((Object)edge);
            }), (Executor)this.executor);
        }
    }

    private <T, V> FutureCallback<T> getCallback(FutureCallback<ValidationResult> callback, Function<T, ValidationResult<V>> transformer) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static void handleError(Throwable e, DeferredResult<ResponseEntity> response, HttpStatus defaultErrorStatus) {
        ResponseEntity responseEntity = e instanceof ToErrorResponseEntity ? ((ToErrorResponseEntity)e).toErrorResponseEntity() : (e instanceof IllegalArgumentException || e instanceof IncorrectParameterException || e instanceof DataValidationException ? new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST) : new ResponseEntity((HttpStatusCode)defaultErrorStatus));
        response.setResult((Object)responseEntity);
    }
}

