/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.script;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.ScriptInvokeService;
import org.thingsboard.script.api.TbScriptException;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.service.script.RuleNodeScriptEngine;

/*
 * Exception performing whole class analysis ignored.
 */
public class RuleNodeTbelScriptEngine
extends RuleNodeScriptEngine<TbelInvokeService, Object> {
    public RuleNodeTbelScriptEngine(TenantId tenantId, TbelInvokeService scriptInvokeService, String script, String ... argNames) {
        super(tenantId, (ScriptInvokeService)scriptInvokeService, script, argNames);
    }

    protected Object[] prepareArgs(TbMsg msg) {
        Object[] args = new Object[]{msg.getData() != null ? JacksonUtil.fromString((String)msg.getData(), Object.class) : new HashMap(), new HashMap(msg.getMetaData().getData()), msg.getType()};
        return args;
    }

    protected List<TbMsg> executeUpdateTransform(TbMsg msg, Object result) {
        if (result instanceof Map) {
            Map msgData = (Map)result;
            return Collections.singletonList(RuleNodeTbelScriptEngine.unbindMsg((Map)msgData, (TbMsg)msg));
        }
        if (result instanceof Collection) {
            Collection resultCollection = (Collection)result;
            ArrayList<TbMsg> res = new ArrayList<TbMsg>(resultCollection.size());
            for (Object resObject : resultCollection) {
                if (resObject instanceof Map) {
                    Map msgData = (Map)resObject;
                    res.add(RuleNodeTbelScriptEngine.unbindMsg((Map)msgData, (TbMsg)msg));
                    continue;
                }
                throw this.wrongResultType(resObject);
            }
            return res;
        }
        throw this.wrongResultType(result);
    }

    protected TbMsg executeGenerateTransform(TbMsg prevMsg, Object result) {
        if (result instanceof Map) {
            Map msgData = (Map)result;
            return RuleNodeTbelScriptEngine.unbindMsg((Map)msgData, (TbMsg)prevMsg);
        }
        throw this.wrongResultType(result);
    }

    protected boolean executeFilterTransform(Object result) {
        if (result instanceof Boolean) {
            Boolean b = (Boolean)result;
            return b;
        }
        throw this.wrongResultType(result);
    }

    protected Set<String> executeSwitchTransform(Object result) {
        if (result instanceof String) {
            String str = (String)result;
            return Collections.singleton(str);
        }
        if (result instanceof Collection) {
            Collection resultCollection = (Collection)result;
            HashSet<String> res = new HashSet<String>(resultCollection.size());
            for (Object resObject : resultCollection) {
                if (resObject instanceof String) {
                    String str = (String)resObject;
                    res.add(str);
                    continue;
                }
                throw this.wrongResultType(resObject);
            }
            return res;
        }
        throw this.wrongResultType(result);
    }

    public ListenableFuture<JsonNode> executeJsonAsync(TbMsg msg) {
        return Futures.transform((ListenableFuture)this.executeScriptAsync(msg), JacksonUtil::valueToTree, (Executor)MoreExecutors.directExecutor());
    }

    protected Object convertResult(Object result) {
        return result;
    }

    protected String executeToStringTransform(Object result) {
        String str;
        return result instanceof String ? (str = (String)result) : JacksonUtil.toString((Object)result);
    }

    private static TbMsg unbindMsg(Map msgData, TbMsg msg) {
        String data = null;
        Map<String, String> metadata = null;
        String messageType = null;
        if (msgData.containsKey("msg")) {
            data = JacksonUtil.toString(msgData.get("msg"));
        }
        if (msgData.containsKey("metadata")) {
            Object msgMetadataObj = msgData.get("metadata");
            if (msgMetadataObj instanceof Map) {
                Map msgMetadataObjAsMap = (Map)msgMetadataObj;
                metadata = msgMetadataObjAsMap.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
            } else {
                metadata = (Map<String, String>)JacksonUtil.convertValue(msgMetadataObj, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        if (msgData.containsKey("msgType")) {
            messageType = msgData.get("msgType").toString();
        }
        String newData = data != null ? data : msg.getData();
        TbMsgMetaData newMetadata = metadata != null ? new TbMsgMetaData((Map)metadata) : msg.getMetaData().copy();
        String newMessageType = StringUtils.isNotEmpty((String)messageType) ? messageType : msg.getType();
        return msg.transform().type(newMessageType).metaData(newMetadata).data(newData).build();
    }

    private TbScriptException wrongResultType(Object result) {
        String className = RuleNodeTbelScriptEngine.toClassName((Object)result);
        return new TbScriptException(this.scriptId, TbScriptException.ErrorCode.RUNTIME, null, (Exception)new ClassCastException("Wrong result type: " + className));
    }

    private static String toClassName(Object result) {
        return result != null ? result.getClass().getSimpleName() : "null";
    }
}

