/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.rpc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.common.msg.rpc.RemoveRpcActorMsg;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequest;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequestActorMsg;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.rpc.TbCoreDeviceRpcService;
import org.thingsboard.server.service.rpc.TbRuleEngineDeviceRpcService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
@TbCoreComponent
public class DefaultTbCoreDeviceRpcService
implements TbCoreDeviceRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbCoreDeviceRpcService.class);
    private final DeviceService deviceService;
    private final TbClusterService clusterService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final ActorSystemContext actorContext;
    private final ConcurrentMap<UUID, Consumer<FromDeviceRpcResponse>> localToRuleEngineRpcRequests = new ConcurrentHashMap();
    private final ConcurrentMap<UUID, ToDeviceRpcRequestActorMsg> localToDeviceRpcRequests = new ConcurrentHashMap();
    private Optional<TbRuleEngineDeviceRpcService> tbRuleEngineRpcService;
    private ScheduledExecutorService scheduler;
    private String serviceId;

    public DefaultTbCoreDeviceRpcService(DeviceService deviceService, TbClusterService clusterService, TbServiceInfoProvider serviceInfoProvider, ActorSystemContext actorContext) {
        this.deviceService = deviceService;
        this.clusterService = clusterService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.actorContext = actorContext;
    }

    @Autowired(required=false)
    public void setTbRuleEngineRpcService(Optional<TbRuleEngineDeviceRpcService> tbRuleEngineRpcService) {
        this.tbRuleEngineRpcService = tbRuleEngineRpcService;
    }

    @PostConstruct
    public void initExecutor() {
        this.scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"tb-core-rpc-scheduler");
        this.serviceId = this.serviceInfoProvider.getServiceId();
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public void processRestApiRpcRequest(ToDeviceRpcRequest request, Consumer<FromDeviceRpcResponse> responseConsumer, SecurityUser currentUser) {
        log.trace("[{}][{}] Processing REST API call to rule engine [{}]", new Object[]{request.getTenantId(), request.getId(), request.getDeviceId()});
        UUID requestId = request.getId();
        this.localToRuleEngineRpcRequests.put(requestId, responseConsumer);
        this.sendRpcRequestToRuleEngine(request, currentUser);
        this.scheduleToRuleEngineTimeout(request, requestId);
    }

    public void processRpcResponseFromRuleEngine(FromDeviceRpcResponse response) {
        log.trace("[{}] Received response to server-side RPC request from rule engine: [{}]", (Object)response.getId(), (Object)response);
        UUID requestId = response.getId();
        Consumer consumer = (Consumer)this.localToRuleEngineRpcRequests.remove(requestId);
        if (consumer != null) {
            consumer.accept(response);
        } else {
            log.trace("[{}] Unknown or stale rpc response received [{}]", (Object)requestId, (Object)response);
        }
    }

    public void forwardRpcRequestToDeviceActor(ToDeviceRpcRequestActorMsg rpcMsg) {
        ToDeviceRpcRequest request = rpcMsg.getMsg();
        log.trace("[{}][{}] Processing local rpc call to device actor [{}]", new Object[]{request.getTenantId(), request.getId(), request.getDeviceId()});
        UUID requestId = request.getId();
        this.localToDeviceRpcRequests.put(requestId, rpcMsg);
        this.actorContext.tellWithHighPriority((TbActorMsg)rpcMsg);
        this.scheduleToDeviceTimeout(request, requestId);
    }

    public void processRpcResponseFromDeviceActor(FromDeviceRpcResponse response) {
        log.trace("[{}] Received response to server-side RPC request from device actor.", (Object)response.getId());
        UUID requestId = response.getId();
        ToDeviceRpcRequestActorMsg request = (ToDeviceRpcRequestActorMsg)this.localToDeviceRpcRequests.remove(requestId);
        if (request != null) {
            this.sendRpcResponseToTbRuleEngine(request.getServiceId(), response);
        } else {
            log.trace("[{}] Unknown or stale rpc response received [{}]", (Object)requestId, (Object)response);
        }
    }

    public void processRemoveRpc(RemoveRpcActorMsg removeRpcMsg) {
        log.trace("[{}][{}] Processing remove RPC [{}]", new Object[]{removeRpcMsg.getTenantId(), removeRpcMsg.getRequestId(), removeRpcMsg.getDeviceId()});
        this.actorContext.tellWithHighPriority((TbActorMsg)removeRpcMsg);
    }

    private void sendRpcResponseToTbRuleEngine(String originServiceId, FromDeviceRpcResponse response) {
        if (this.serviceId.equals(originServiceId)) {
            if (this.tbRuleEngineRpcService.isPresent()) {
                ((TbRuleEngineDeviceRpcService)this.tbRuleEngineRpcService.get()).processRpcResponseFromDevice(response);
            } else {
                log.warn("Failed to find tbCoreRpcService for local service. Possible duplication of serviceIds.");
            }
        } else {
            this.clusterService.pushNotificationToRuleEngine(originServiceId, response, null);
        }
    }

    private void sendRpcRequestToRuleEngine(ToDeviceRpcRequest msg, SecurityUser currentUser) {
        Device device;
        ObjectNode entityNode = JacksonUtil.newObjectNode();
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("requestUUID", msg.getId().toString());
        metaData.putValue("originServiceId", this.serviceId);
        metaData.putValue("expirationTime", Long.toString(msg.getExpirationTime()));
        metaData.putValue("oneway", Boolean.toString(msg.isOneway()));
        metaData.putValue("persistent", Boolean.toString(msg.isPersisted()));
        if (msg.getRetries() != null) {
            metaData.putValue("retries", msg.getRetries().toString());
        }
        if ((device = this.deviceService.findDeviceById(msg.getTenantId(), msg.getDeviceId())) != null) {
            metaData.putValue("deviceName", device.getName());
            metaData.putValue("deviceType", device.getType());
        }
        entityNode.put("method", msg.getBody().getMethod());
        entityNode.put("params", msg.getBody().getParams());
        entityNode.put("additionalInfo", msg.getAdditionalInfo());
        try {
            TbMsg tbMsg = TbMsg.newMsg().type(TbMsgType.RPC_CALL_FROM_SERVER_TO_DEVICE).originator((EntityId)msg.getDeviceId()).customerId((CustomerId)Optional.ofNullable(currentUser).map(User::getCustomerId).orElse(null)).copyMetaData(metaData).dataType(TbMsgDataType.JSON).data(JacksonUtil.toString((Object)entityNode)).build();
            this.clusterService.pushMsgToRuleEngine(msg.getTenantId(), (EntityId)msg.getDeviceId(), tbMsg, null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void scheduleToRuleEngineTimeout(ToDeviceRpcRequest request, UUID requestId) {
        long timeout = Math.max(0L, request.getExpirationTime() - System.currentTimeMillis()) + TimeUnit.SECONDS.toMillis(1L);
        log.trace("[{}] processing to rule engine request.", (Object)requestId);
        this.scheduler.schedule(() -> {
            log.trace("[{}] timeout for processing to rule engine request.", (Object)requestId);
            Consumer consumer = (Consumer)this.localToRuleEngineRpcRequests.remove(requestId);
            if (consumer != null) {
                consumer.accept(new FromDeviceRpcResponse(requestId, null, RpcError.TIMEOUT));
            }
        }, timeout, TimeUnit.MILLISECONDS);
    }

    private void scheduleToDeviceTimeout(ToDeviceRpcRequest request, UUID requestId) {
        long timeout = Math.max(0L, request.getExpirationTime() - System.currentTimeMillis()) + TimeUnit.SECONDS.toMillis(1L);
        log.trace("[{}] processing to device request.", (Object)requestId);
        this.scheduler.schedule(() -> {
            log.trace("[{}] timeout for to device request.", (Object)requestId);
            this.localToDeviceRpcRequests.remove(requestId);
        }, timeout, TimeUnit.MILLISECONDS);
    }
}

