/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TbPackProcessingContext<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbPackProcessingContext.class);
    private final AtomicInteger pendingCount;
    private final CountDownLatch processingTimeoutLatch;
    private final ConcurrentMap<UUID, T> ackMap;
    private final ConcurrentMap<UUID, T> failedMap;

    public TbPackProcessingContext(CountDownLatch processingTimeoutLatch, ConcurrentMap<UUID, T> ackMap, ConcurrentMap<UUID, T> failedMap) {
        this.processingTimeoutLatch = processingTimeoutLatch;
        this.pendingCount = new AtomicInteger(ackMap.size());
        this.ackMap = ackMap;
        this.failedMap = failedMap;
    }

    public boolean await(long packProcessingTimeout, TimeUnit milliseconds) throws InterruptedException {
        return this.processingTimeoutLatch.await(packProcessingTimeout, milliseconds);
    }

    public void onSuccess(UUID id) {
        boolean empty = false;
        Object msg = this.ackMap.remove(id);
        if (msg != null) {
            boolean bl = empty = this.pendingCount.decrementAndGet() == 0;
        }
        if (empty) {
            this.processingTimeoutLatch.countDown();
        } else if (log.isTraceEnabled()) {
            log.trace("Items left: {}", (Object)this.ackMap.size());
            for (Object t : this.ackMap.values()) {
                log.trace("left item: {}", t);
            }
        }
    }

    public void onFailure(UUID id, Throwable t) {
        boolean empty = false;
        Object msg = this.ackMap.remove(id);
        if (msg != null) {
            empty = this.pendingCount.decrementAndGet() == 0;
            this.failedMap.put(id, msg);
            if (log.isTraceEnabled()) {
                log.trace("Items left: {}", (Object)this.ackMap.size());
                for (Object v : this.ackMap.values()) {
                    log.trace("left item: {}", v);
                }
            }
        }
        if (empty) {
            this.processingTimeoutLatch.countDown();
        }
    }

    public ConcurrentMap<UUID, T> getAckMap() {
        return this.ackMap;
    }

    public ConcurrentMap<UUID, T> getFailedMap() {
        return this.failedMap;
    }
}

