/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import java.util.AbstractMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.RuleNodeId;

public class TbMsgProfilerInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbMsgProfilerInfo.class);
    private final UUID msgId;
    private AtomicLong totalProcessingTime = new AtomicLong();
    private Lock stateLock = new ReentrantLock();
    private RuleNodeId currentRuleNodeId;
    private long stateChangeTime;

    public TbMsgProfilerInfo(UUID msgId) {
        this.msgId = msgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(RuleNodeId ruleNodeId) {
        long currentTime = System.currentTimeMillis();
        this.stateLock.lock();
        try {
            this.currentRuleNodeId = ruleNodeId;
            this.stateChangeTime = currentTime;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long onEnd(RuleNodeId ruleNodeId) {
        long currentTime = System.currentTimeMillis();
        this.stateLock.lock();
        try {
            if (ruleNodeId.equals((Object)this.currentRuleNodeId)) {
                long processingTime = currentTime - this.stateChangeTime;
                this.stateChangeTime = currentTime;
                this.totalProcessingTime.addAndGet(processingTime);
                this.currentRuleNodeId = null;
                long l = processingTime;
                return l;
            }
            log.trace("[{}] Invalid sequence of rule node processing detected. Expected [{}] but was [{}]", new Object[]{this.msgId, this.currentRuleNodeId, ruleNodeId});
            long l = 0L;
            return l;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<UUID, Long> onTimeout() {
        long currentTime = System.currentTimeMillis();
        this.stateLock.lock();
        try {
            if (this.currentRuleNodeId != null && this.stateChangeTime > 0L) {
                long timeoutTime = currentTime - this.stateChangeTime;
                this.totalProcessingTime.addAndGet(timeoutTime);
                AbstractMap.SimpleEntry<UUID, Long> simpleEntry = new AbstractMap.SimpleEntry<UUID, Long>(this.currentRuleNodeId.getId(), timeoutTime);
                return simpleEntry;
            }
        }
        finally {
            this.stateLock.unlock();
        }
        return null;
    }
}

