/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.data.queue.QueueConfig;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.resource.TbResourceDataCache;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.MainQueueConsumerManager;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.util.TbRuleEngineComponent;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.queue.TbRuleEngineConsumerService;
import org.thingsboard.server.service.queue.processing.AbstractPartitionBasedConsumerService;
import org.thingsboard.server.service.queue.ruleengine.TbRuleEngineConsumerContext;
import org.thingsboard.server.service.queue.ruleengine.TbRuleEngineQueueConsumerManager;
import org.thingsboard.server.service.rpc.TbRuleEngineDeviceRpcService;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;

@Service
@TbRuleEngineComponent
public class DefaultTbRuleEngineConsumerService
extends AbstractPartitionBasedConsumerService<TransportProtos.ToRuleEngineNotificationMsg>
implements TbRuleEngineConsumerService {
    private final TbRuleEngineConsumerContext ctx;
    private final QueueService queueService;
    private final TbRuleEngineDeviceRpcService tbDeviceRpcService;
    private final ConcurrentMap<QueueKey, TbRuleEngineQueueConsumerManager> consumers = new ConcurrentHashMap();

    public DefaultTbRuleEngineConsumerService(TbRuleEngineConsumerContext ctx, ActorSystemContext actorContext, TbRuleEngineDeviceRpcService tbDeviceRpcService, QueueService queueService, TbDeviceProfileCache deviceProfileCache, TbAssetProfileCache assetProfileCache, TbResourceDataCache tbResourceDataCache, TbTenantProfileCache tenantProfileCache, TbApiUsageStateService apiUsageStateService, PartitionService partitionService, ApplicationEventPublisher eventPublisher, JwtSettingsService jwtSettingsService, CalculatedFieldCache calculatedFieldCache) {
        super(actorContext, tenantProfileCache, deviceProfileCache, assetProfileCache, tbResourceDataCache, calculatedFieldCache, apiUsageStateService, partitionService, eventPublisher, jwtSettingsService);
        this.ctx = ctx;
        this.tbDeviceRpcService = tbDeviceRpcService;
        this.queueService = queueService;
    }

    protected void onStartUp() {
        List queues = this.queueService.findAllQueues();
        for (Queue configuration : queues) {
            if (!this.partitionService.isManagedByCurrentService(configuration.getTenantId())) continue;
            QueueKey queueKey = new QueueKey(ServiceType.TB_RULE_ENGINE, configuration);
            this.createConsumer(queueKey, configuration);
        }
    }

    protected void onPartitionChangeEvent(PartitionChangeEvent event) {
        event.getNewPartitions().forEach((queueKey, partitions) -> {
            TbRuleEngineQueueConsumerManager consumer;
            if ("CalculatedFields".equals(queueKey.getQueueName()) || "CalculatedFieldStates".equals(queueKey.getQueueName())) {
                return;
            }
            if (this.partitionService.isManagedByCurrentService(queueKey.getTenantId()) && (consumer = this.getConsumer(queueKey).orElseGet(() -> {
                Queue config = this.queueService.findQueueByTenantIdAndName(queueKey.getTenantId(), queueKey.getQueueName());
                if (config == null) {
                    if (!partitions.isEmpty()) {
                        this.log.error("[{}] Queue configuration is missing", queueKey, (Object)new RuntimeException("stacktrace"));
                    }
                    return null;
                }
                return this.createConsumer(queueKey, config);
            })) != null) {
                consumer.update(partitions);
            }
        });
        this.consumers.keySet().stream().collect(Collectors.groupingBy(QueueKey::getTenantId)).forEach((tenantId, queueKeys) -> {
            if (!this.partitionService.isManagedByCurrentService(tenantId)) {
                queueKeys.forEach(queueKey -> this.removeConsumer(queueKey).ifPresent(MainQueueConsumerManager::stop));
            }
        });
    }

    protected void stopConsumers() {
        super.stopConsumers();
        this.consumers.values().forEach(MainQueueConsumerManager::stop);
        this.consumers.values().forEach(MainQueueConsumerManager::awaitStop);
    }

    protected ServiceType getServiceType() {
        return ServiceType.TB_RULE_ENGINE;
    }

    protected String getPrefix() {
        return "tb-rule-engine";
    }

    protected long getNotificationPollDuration() {
        return this.ctx.getPollDuration();
    }

    protected long getNotificationPackProcessingTimeout() {
        return this.ctx.getPackProcessingTimeout();
    }

    protected int getMgmtThreadPoolSize() {
        return this.ctx.getMgmtThreadPoolSize();
    }

    protected TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createNotificationsConsumer() {
        return this.ctx.getQueueFactory().createToRuleEngineNotificationsMsgConsumer();
    }

    protected void handleNotification(UUID id, TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg> msg, TbCallback callback) {
        TransportProtos.ToRuleEngineNotificationMsg nfMsg = (TransportProtos.ToRuleEngineNotificationMsg)msg.getValue();
        if (nfMsg.hasComponentLifecycle()) {
            this.handleComponentLifecycleMsg(id, ProtoUtils.fromProto((TransportProtos.ComponentLifecycleMsgProto)nfMsg.getComponentLifecycle()));
            callback.onSuccess();
        } else if (nfMsg.hasFromDeviceRpcResponse()) {
            TransportProtos.FromDeviceRPCResponseProto proto = nfMsg.getFromDeviceRpcResponse();
            RpcError error = proto.getError() > 0 ? RpcError.values()[proto.getError()] : null;
            FromDeviceRpcResponse response = new FromDeviceRpcResponse(new UUID(proto.getRequestIdMSB(), proto.getRequestIdLSB()), proto.getResponse(), error);
            this.tbDeviceRpcService.processRpcResponseFromDevice(response);
            callback.onSuccess();
        } else if (nfMsg.getQueueUpdateMsgsCount() > 0) {
            this.updateQueues(nfMsg.getQueueUpdateMsgsList());
            callback.onSuccess();
        } else if (nfMsg.getQueueDeleteMsgsCount() > 0) {
            this.deleteQueues(nfMsg.getQueueDeleteMsgsList());
            callback.onSuccess();
        } else {
            this.log.trace("Received notification with missing handler");
            callback.onSuccess();
        }
    }

    private void updateQueues(List<TransportProtos.QueueUpdateMsg> queueUpdateMsgs) {
        for (TransportProtos.QueueUpdateMsg queueUpdateMsg : queueUpdateMsgs) {
            this.log.info("Received queue update msg: [{}]", (Object)queueUpdateMsg);
            TenantId tenantId = TenantId.fromUUID((UUID)new UUID(queueUpdateMsg.getTenantIdMSB(), queueUpdateMsg.getTenantIdLSB()));
            if (!this.partitionService.isManagedByCurrentService(tenantId)) continue;
            QueueId queueId = new QueueId(new UUID(queueUpdateMsg.getQueueIdMSB(), queueUpdateMsg.getQueueIdLSB()));
            String queueName = queueUpdateMsg.getQueueName();
            QueueKey queueKey = new QueueKey(ServiceType.TB_RULE_ENGINE, queueName, tenantId);
            Queue queue = this.queueService.findQueueById(tenantId, queueId);
            this.getConsumer(queueKey).ifPresentOrElse(consumer -> consumer.update((QueueConfig)queue), () -> this.createConsumer(queueKey, queue));
        }
        this.partitionService.updateQueues(queueUpdateMsgs);
        this.partitionService.recalculatePartitions(this.ctx.getServiceInfoProvider().getServiceInfo(), new ArrayList(this.partitionService.getOtherServices(ServiceType.TB_RULE_ENGINE)));
    }

    private void deleteQueues(List<TransportProtos.QueueDeleteMsg> queueDeleteMsgs) {
        for (TransportProtos.QueueDeleteMsg queueDeleteMsg : queueDeleteMsgs) {
            this.log.info("Received queue delete msg: [{}]", (Object)queueDeleteMsg);
            TenantId tenantId = TenantId.fromUUID((UUID)new UUID(queueDeleteMsg.getTenantIdMSB(), queueDeleteMsg.getTenantIdLSB()));
            QueueKey queueKey = new QueueKey(ServiceType.TB_RULE_ENGINE, queueDeleteMsg.getQueueName(), tenantId);
            this.removeConsumer(queueKey).ifPresent(consumer -> consumer.delete(true));
        }
        this.partitionService.removeQueues(queueDeleteMsgs);
        this.partitionService.recalculatePartitions(this.ctx.getServiceInfoProvider().getServiceInfo(), new ArrayList(this.partitionService.getOtherServices(ServiceType.TB_RULE_ENGINE)));
    }

    @EventListener
    public void handleComponentLifecycleEvent(ComponentLifecycleMsg event) {
        if (event.getEntityId().getEntityType() == EntityType.TENANT && event.getEvent() == ComponentLifecycleEvent.DELETED) {
            List<QueueKey> toRemove = this.consumers.keySet().stream().filter(queueKey -> queueKey.getTenantId().equals((Object)event.getTenantId())).toList();
            toRemove.forEach(queueKey -> this.removeConsumer(queueKey).ifPresent(consumer -> consumer.delete(false)));
        }
    }

    private Optional<TbRuleEngineQueueConsumerManager> getConsumer(QueueKey queueKey) {
        return Optional.ofNullable((TbRuleEngineQueueConsumerManager)this.consumers.get(queueKey));
    }

    private TbRuleEngineQueueConsumerManager createConsumer(QueueKey queueKey, Queue queue) {
        TbRuleEngineQueueConsumerManager consumer = TbRuleEngineQueueConsumerManager.create().ctx(this.ctx).queueKey(queueKey).consumerExecutor(this.consumersExecutor).scheduler(this.scheduler).taskExecutor(this.mgmtExecutor).build();
        this.consumers.put(queueKey, consumer);
        consumer.init((QueueConfig)queue);
        return consumer;
    }

    private Optional<TbRuleEngineQueueConsumerManager> removeConsumer(QueueKey queueKey) {
        return Optional.ofNullable((TbRuleEngineQueueConsumerManager)this.consumers.remove(queueKey));
    }

    @Scheduled(fixedDelayString="${queue.rule-engine.stats.print-interval-ms}")
    public void printStats() {
        if (this.ctx.isStatsEnabled()) {
            long ts = System.currentTimeMillis();
            this.consumers.values().forEach(manager -> manager.printStats(ts));
        }
    }
}

