/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.partition;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;

public abstract class AbstractPartitionBasedService<T extends EntityId>
extends TbApplicationEventListener<PartitionChangeEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPartitionBasedService.class);
    protected final ConcurrentMap<TopicPartitionInfo, Set<T>> partitionedEntities = new ConcurrentHashMap();
    protected final ConcurrentMap<TopicPartitionInfo, List<ListenableFuture<?>>> partitionedFetchTasks = new ConcurrentHashMap();
    final Queue<Set<TopicPartitionInfo>> subscribeQueue = new ConcurrentLinkedQueue();
    @Autowired
    protected PartitionService partitionService;
    protected ListeningScheduledExecutorService scheduledExecutor;

    protected abstract String getServiceName();

    protected abstract String getSchedulerExecutorName();

    protected abstract Map<TopicPartitionInfo, List<ListenableFuture<?>>> onAddedPartitions(Set<TopicPartitionInfo> var1);

    protected abstract void cleanupEntityOnPartitionRemoval(T var1);

    public Set<T> getPartitionedEntities(TopicPartitionInfo tpi) {
        return (Set)this.partitionedEntities.get(tpi);
    }

    protected void init() {
        this.scheduledExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)this.getSchedulerExecutorName()));
    }

    protected ServiceType getServiceType() {
        return ServiceType.TB_CORE;
    }

    protected void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
    }

    protected void onTbApplicationEvent(PartitionChangeEvent partitionChangeEvent) {
        log.debug("onTbApplicationEvent, processing event: {}", (Object)partitionChangeEvent);
        this.subscribeQueue.add(partitionChangeEvent.getCorePartitions());
        this.scheduledExecutor.submit(() -> this.pollInitStateFromDB());
    }

    protected boolean filterTbApplicationEvent(PartitionChangeEvent event) {
        return event.getServiceType() == this.getServiceType();
    }

    protected void pollInitStateFromDB() {
        Set partitions = this.getLatestPartitions();
        if (partitions == null) {
            log.debug("Nothing to do. Partitions are empty.");
            return;
        }
        this.initStateFromDB(partitions);
    }

    private void initStateFromDB(Set<TopicPartitionInfo> partitions) {
        try {
            log.info("[{}] CURRENT PARTITIONS: {}", (Object)this.getServiceName(), this.partitionedEntities.keySet());
            log.info("[{}] NEW PARTITIONS: {}", (Object)this.getServiceName(), partitions);
            HashSet<TopicPartitionInfo> addedPartitions = new HashSet<TopicPartitionInfo>(partitions);
            addedPartitions.removeAll(this.partitionedEntities.keySet());
            log.info("[{}] ADDED PARTITIONS: {}", (Object)this.getServiceName(), addedPartitions);
            HashSet removedPartitions = new HashSet(this.partitionedEntities.keySet());
            removedPartitions.removeAll(partitions);
            log.info("[{}] REMOVED PARTITIONS: {}", (Object)this.getServiceName(), removedPartitions);
            boolean partitionListChanged = false;
            for (TopicPartitionInfo partition : removedPartitions) {
                List fetchTasks;
                Set entities = (Set)this.partitionedEntities.remove(partition);
                if (entities != null) {
                    entities.forEach(arg_0 -> this.cleanupEntityOnPartitionRemoval(arg_0));
                }
                if ((fetchTasks = (List)this.partitionedFetchTasks.remove(partition)) != null) {
                    fetchTasks.forEach(f -> f.cancel(false));
                }
                partitionListChanged = true;
            }
            this.onRepartitionEvent();
            addedPartitions.forEach(tpi -> this.partitionedEntities.computeIfAbsent(tpi, key -> ConcurrentHashMap.newKeySet()));
            if (!addedPartitions.isEmpty()) {
                Map fetchTasks = this.onAddedPartitions(addedPartitions);
                if (fetchTasks != null && !fetchTasks.isEmpty()) {
                    this.partitionedFetchTasks.putAll(fetchTasks);
                }
                partitionListChanged = true;
            }
            if (partitionListChanged) {
                ArrayList partitionFetchFutures = new ArrayList();
                this.partitionedFetchTasks.values().forEach(partitionFetchFutures::addAll);
                DonAsynchron.withCallback((ListenableFuture)Futures.allAsList(partitionFetchFutures), t -> this.logPartitions(), arg_0 -> this.logFailure(arg_0));
            }
        }
        catch (Throwable t2) {
            log.warn("[{}] Failed to init entities state from DB", (Object)this.getServiceName(), (Object)t2);
        }
    }

    private void logFailure(Throwable e) {
        if (e instanceof CancellationException) {
            log.trace("Partition fetch task error", e);
        } else {
            log.error("Partition fetch task error", e);
        }
    }

    private void logPartitions() {
        log.info("[{}] Managing following partitions:", (Object)this.getServiceName());
        this.partitionedEntities.forEach((tpi, entities) -> log.info("[{}][{}]: {} entities", new Object[]{this.getServiceName(), tpi.getFullTopicName(), entities.size()}));
    }

    protected void onRepartitionEvent() {
    }

    private Set<TopicPartitionInfo> getLatestPartitions() {
        log.debug("getLatestPartitionsFromQueue, queue size {}", (Object)this.subscribeQueue.size());
        Set partitions = null;
        while (!this.subscribeQueue.isEmpty()) {
            partitions = (Set)this.subscribeQueue.poll();
            log.debug("polled from the queue partitions {}", (Object)partitions);
        }
        log.debug("getLatestPartitionsFromQueue, partitions {}", partitions);
        return partitions;
    }
}

