/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.notification.info.RuleEngineComponentLifecycleEventNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.RuleEngineComponentLifecycleEventTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.notification.rule.trigger.config.RuleEngineComponentLifecycleEventNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class RuleEngineComponentLifecycleEventTriggerProcessor
implements NotificationRuleTriggerProcessor<RuleEngineComponentLifecycleEventTrigger, RuleEngineComponentLifecycleEventNotificationRuleTriggerConfig> {
    private final PartitionService partitionService;

    public boolean matchesFilter(RuleEngineComponentLifecycleEventTrigger trigger, RuleEngineComponentLifecycleEventNotificationRuleTriggerConfig triggerConfig) {
        boolean onlyFailures;
        Set<ComponentLifecycleEvent> trackedEvents;
        if (CollectionUtils.isNotEmpty((Collection)triggerConfig.getRuleChains()) && !triggerConfig.getRuleChains().contains(trigger.getRuleChainId().getId())) {
            return false;
        }
        if (!this.partitionService.isMyPartition(ServiceType.TB_RULE_ENGINE, trigger.getTenantId(), trigger.getComponentId())) {
            return false;
        }
        EntityType componentType = trigger.getComponentId().getEntityType();
        if (componentType == EntityType.RULE_CHAIN) {
            trackedEvents = triggerConfig.getRuleChainEvents();
            onlyFailures = triggerConfig.isOnlyRuleChainLifecycleFailures();
        } else if (componentType == EntityType.RULE_NODE && triggerConfig.isTrackRuleNodeEvents()) {
            trackedEvents = triggerConfig.getRuleNodeEvents();
            onlyFailures = triggerConfig.isOnlyRuleNodeLifecycleFailures();
        } else {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)trackedEvents)) {
            trackedEvents = Set.of(ComponentLifecycleEvent.STARTED, ComponentLifecycleEvent.UPDATED, ComponentLifecycleEvent.STOPPED);
        }
        if (!trackedEvents.contains(trigger.getEventType())) {
            return false;
        }
        if (onlyFailures) {
            return trigger.getError() != null;
        }
        return true;
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(RuleEngineComponentLifecycleEventTrigger trigger) {
        return RuleEngineComponentLifecycleEventNotificationInfo.builder().ruleChainId(trigger.getRuleChainId()).ruleChainName(trigger.getRuleChainName()).componentId(trigger.getComponentId()).componentName(trigger.getComponentName()).action(trigger.getEventType() == ComponentLifecycleEvent.STARTED ? "start" : (trigger.getEventType() == ComponentLifecycleEvent.UPDATED ? "update" : (trigger.getEventType() == ComponentLifecycleEvent.STOPPED ? "stop" : null))).eventType(trigger.getEventType()).error(this.getErrorMsg(trigger.getError())).build();
    }

    private String getErrorMsg(Throwable error) {
        if (error == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        return StringUtils.abbreviate((String)ExceptionUtils.getStackTrace((Throwable)error), (int)200);
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.RULE_ENGINE_COMPONENT_LIFECYCLE_EVENT;
    }

    @ConstructorProperties(value={"partitionService"})
    @Generated
    public RuleEngineComponentLifecycleEventTriggerProcessor(PartitionService partitionService) {
        this.partitionService = partitionService;
    }
}

